/*
 * @iqstratIO.java Version 1.0 10/05/2007
 *
 * Copyright (c) 2007 Kansas Geological Survey
 * 1930 Constant Avenue, Lawrence, Kansas, 66047, U.S.A.
 * All Rights Reserved.
 */

package iqstrat.io;

import java.io.*;
import java.awt.*;
import javax.swing.*;

import iqstrat.io.ReadIQSTRATXMLFile;
import iqstrat.io.WriteIQSTRATXMLFile;

/** Class iqstratIO
 *  <p> This class will manage the iqstrat data file location
 *
 *  @version 1.1 10/05/2007
 *  @author  John R. Victorine
 */

public class iqstratIO
{
  public static final String IQSTRAT_XML  = "IQSTRAT_DATA.xml";
  public static final String IQSTRAT_DATA = "IQSTRAT_DATA";
  public static final String TEMPORARY    = "temp";

  /*========================================================================*
   * ------------------------- DIRECTORY METHODS ---------------------------*
   *========================================================================*/

  /** Method exists()
   * <p> This method will check to see if the IQSTRAT XML File exists.
   * @return bValue = true if file exists and false if it does not
   */

  public static boolean exists()
  {
    boolean bValue = false;

    try
    {
      File p = new File( kgs.io.kgsIOUser.getHomeDir() );

      if (p.exists())
      {
        try
        {
          File pNew = new File(p, IQSTRAT_XML);
          if (pNew.exists())
          {
            bValue = true;
          }
        }
        catch (Exception e)
        {
          e.printStackTrace();
          String sError = new String("iqstratIO().exists-2\n " + e.toString());
          JOptionPane.showMessageDialog(
              (Component) null, sError, "ERROR", JOptionPane.ERROR_MESSAGE);
        }
      }
    }
    catch (Exception e)
    {
      e.printStackTrace();
      String sError = new String("iqstratIO().exists\n " +  e.toString());
      JOptionPane.showMessageDialog(
          (Component) null, sError, "ERROR", JOptionPane.ERROR_MESSAGE);
    }

    return (bValue);
  }

  /** Method mkDir()
   * <p> This method will make the IQSTRAT Data Directory in the user home
   *     directory and create a xml file of the location.
   */

  public static void mkDir()
  {
    try
    {
      File p = new File( kgs.io.kgsIOUser.getHomeDir() );

      if (p.exists())
      {
        try
        {
          File pNew = new File(p, IQSTRAT_DATA);
          if (!pNew.exists())
          {
            pNew.mkdir();
            write( pNew.getCanonicalPath() );

            File pTemp = new File(pNew, TEMPORARY);
            pTemp.mkdir();
          }
          else
          {
            File pTemp = new File(pNew, TEMPORARY);
            if (!pTemp.exists())
              pTemp.mkdir();
          }
        }
        catch (Exception e)
        {
          e.printStackTrace();
          String sError = new String("iqstratIO().mkDir-2\n " + e.toString());
          JOptionPane.showMessageDialog(
              (Component) null, sError, "ERROR", JOptionPane.ERROR_MESSAGE);
        }
      }
    }
    catch (Exception e)
    {
      e.printStackTrace();
      String sError = new String("iqstratIO().mkDir\n " +  e.toString());
      JOptionPane.showMessageDialog(
          (Component) null, sError, "ERROR", JOptionPane.ERROR_MESSAGE);
    }
  }

  /*========================================================================*
   * ---------------------------- GET METHODS ------------------------------*
   *========================================================================*/

  /** Method getPath()
   * <p> This method will check to see if the headers Information XML File exists.
   * @param  sKEY  = Primary Key of data defined by user
   * @return sPath = The path to the Header Record
   */

  public static String getPath()
  {
    String sPath = kgs.io.kgsIOUser.getHomeDir() + "\\" + IQSTRAT_DATA;

    return (sPath);
  }

  /*========================================================================*
   * ----------------------------- IO METHODS ------------------------------*
   *========================================================================*/

  /** Method save()
   * <p> This method will force a creation of the IQSTRAT Directory & XML
   */

  public static void save() { mkDir(); }

  /** Method read()
   * <p> This method will read the IQSTRAT Login XML File that is on the User's
   *     PC for the Email and Password so the user does not have to enter the
   *     text every time they want to use the IQSTRAT Web Site.
   * @return sData = The IQSTRAT Data Path
   */

  public static String read()
  {
    String sData = "";                            // IQSTRAT Data Path
    String sDir  = kgs.io.kgsIOUser.getHomeDir(); // Get the Home Directory Path
    String sPath = sDir+"\\"+IQSTRAT_XML;         // Build Path to IQSTRAT XML

    if (exists())
    {
      ReadIQSTRATXMLFile pRead =
          new ReadIQSTRATXMLFile(iqstrat.io.ReadIQSTRATXMLFile.FILE);
      sData = pRead.Process(sPath);
    }

    return (sData);
  }

  /** Method write()
   * <p> This method will write the User XML File to the User's PC.
   * @param sPath = The iqstrat data path
   */

  public static void write(String sPath)
  {
    WriteIQSTRATXMLFile pXML =
        new WriteIQSTRATXMLFile(kgs.io.kgsIOUser.getHomeDir(),
                                IQSTRAT_XML,
                                sPath);
  }
}