/*
 * @iqstratTracksTable.java Version 1.1 03/11/2009
 *
 * Copyright (c) 2009 Kansas Geological Survey
 * 1930 Constant Avenue, Lawrence, Kansas, 66047, U.S.A.
 * All Rights Reserved.
 */

package iqstrat.gui;

import java.awt.*;
import java.awt.event.*;
import java.lang.*;
import javax.swing.*;
import javax.swing.border.*;
import javax.swing.event.*;
import javax.swing.table.*;

import gui.guiTable;

/** Class iqstratTracksTable
 *  <p> This Class will display the Headers Status Table.
 *
 *  @version 1.1 03/11/2009
 *  @author  John R. Victorine
 */

public class iqstratTracksTable
{
  private int      iRows     = 0;
  private int      iColumns  = 1;
  private String   sColumn[] = {"Plot Tracks"};
  private Object   oData[][] = null;
  private guiTable pTable    = null;

  private int      iChange   = 0;
  private int      iTracks[] = null;

  /** Constructor iqstratTracksTable()
   *  <p> This is the Constructor for this class.
   *  @param iTracks = Array of Plot Track Identifiers
   */

  public iqstratTracksTable( int iTracks[] )
  {
    this.iTracks = iTracks;

    populateList();

    if (iRows > 0)
      pTable = new guiTable(0, iRows, iColumns, sColumn, oData);
    else
      pTable = new guiTable(0, iColumns, sColumn);

    if (iChange == 0)
      iRows = 0;

    if (iRows > 0)
      pTable.setSelectedRow(0);
  }

  /** Method close()
   * <p> This method will force Java to clean memory
   */

  public void close()
  {
    sColumn = null;
    oData   = null;
    pTable  = null;
    iTracks = null;
  }

  /** Method populateList
   *  <p> This method will load the Data Array for the guiTable.
   */

  void populateList()
  {
    iChange     = 0;
    iRows       = 1;
    oData       = new Object[iRows][iColumns];
    oData[0][0] = new String("");

    if (iTracks != null)
    {
      if (iTracks.length > 0)
      {
        iRows   = iTracks.length;
        iChange = 1;
        oData   = new Object[iRows][iColumns];

        for (int i=0; i<iRows; i++)
        {
          if (iTracks[i] != -1)
            oData[i][0] =
              new String(iqstrat.iqstratTracksStruct.TRACK[
                         iTracks[i]][iqstrat.iqstratTracksStruct._DESCRIPTION]);
        }
      }
    }
  }

  /* ===================================================================== *
   * -------------------------- SET METHODS ------------------------------ *
   * ===================================================================== */

  /** Method setData( int iTracks[] )
   * <p> This method will load the selected tracks data into the table
   * @param iTracks = array of selected tracks
   */

  public void setData( int iTracks[] )
  {
    this.iTracks = iTracks;

    populateList();

    pTable.reload(iRows, oData);

    if (iChange == 0)
      iRows = 0;

    if (iRows > 0)
      pTable.setSelectedRow(0);
  }

  /** Method setSelectedRow( int iRow )
   *  <p> This method will return the selected row.
   *  @param iRow - Selected Row.
   */

  public void setSelectedRow( int iRow ) { pTable.setSelectedRow( iRow ); }

  /* ===================================================================== *
   * -------------------------- GET METHODS ------------------------------ *
   * ===================================================================== */

  /** Method getSelectedRow()
   *  <p> This method will return the selected row.
   *  @return iSelectedRow - Selected Row.
   */

  public int getSelectedRow() { return (pTable.getSelectedRow()); }

  /** Method getTotalRows()
   *  <p> This method will return the total number of rows.
   *  @return iRows - Total Rows.
   */

  public int getTotalRows() { return (iRows); }

  /** Method getData()
   * <p> This method will load the selected tracks data into the table
   * @return iTracks = array of selected tracks
   */

  public int[] getData() { return (iTracks); }

  /** Method getScrollPane()
   *  <p> This method will return the scroll pane.
   *  @return jScrollPane - Scroll Pane containing the Table.
   */

  public JScrollPane getScrollPane() { return (pTable.getScrollPane()); }
}
