/*
 * @iqstratStatusTable.java Version 1.1 10/14/2007
 *
 * Copyright (c) 2007 Kansas Geological Survey
 * 1930 Constant Avenue, Lawrence, Kansas, 66047, U.S.A.
 * All Rights Reserved.
 */

package iqstrat.gui;

import java.awt.*;
import java.awt.event.*;
import java.lang.*;
import javax.swing.*;
import javax.swing.border.*;
import javax.swing.event.*;
import javax.swing.table.*;

import gui.guiTable;

/** Class iqstratStatusTable
 *  <p> This Class will display the Headers Status Table.
 *
 *  @version 1.1 10/14/2007
 *  @author  John R. Victorine
 */

public class iqstratStatusTable
{
  private int      iRows     = 0;
  private int      iColumns  = 2;
  private String   sColumn[] = {"Mnemonic", "Description"};
  private Object   oData[][];
  private guiTable pTable    = null;

  /** Constructor iqstratStatusTable()
   *  <p> This is the Constructor for this class.
   */

  public iqstratStatusTable()
  {
    populateList();

    if (iRows > 0)
      pTable = new guiTable(0, iRows, iColumns, sColumn, oData);
    else
      pTable = new guiTable(0, iColumns, sColumn);

    pTable.resizeColumn(0, 10);

    if (iRows > 0)
      pTable.setSelectedRow(0);
  }

  /** Method populateList
   *  <p> This method will load the Data Array for the guiTable.
   */

  void populateList()
  {
    iRows = 0;
    oData = new Object[iqstrat.iqstratStatusStruct.TOTAL][2];

    for (int i=0; i<iqstrat.iqstratStatusStruct.TOTAL; i++)
    {
      oData[i][0] = new String(iqstrat.iqstratStatusStruct.STATUS[i][0]);
      oData[i][1] = new String(iqstrat.iqstratStatusStruct.STATUS[i][1]);

      iRows++;
    }
  }

  /* ===================================================================== *
   * -------------------------- GET METHODS ------------------------------ *
   * ===================================================================== */

  /** Method getSelectedRow()
   *  <p> This method will return the selected row.
   *  @return iSelectedRow - Selected Row.
   */

  public int getSelectedRow() { return (pTable.getSelectedRow()); }

  /** Method getTotalRows()
   *  <p> This method will return the total number of rows.
   *  @return iRows - Total Rows.
   */

  public int getTotalRows() { return (iRows); }

  /** Method getScrollPane()
   *  <p> This method will return the scroll pane.
   *  @return jScrollPane - Scroll Pane containing the Table.
   */

  public JScrollPane getScrollPane() { return (pTable.getScrollPane()); }
}
