/*
 * @iqstratStatusFrame.java Version 1.1 10/14/2007
 *
 * Copyright (c) 2007 Kansas Geological Survey
 * 1930 Constant Avenue, Lawrence, Kansas, 66047, U.S.A.
 * All Rights Reserved.
 */

package iqstrat.gui;

import java.awt.*;
import java.awt.event.*;
import java.util.Observable;
import javax.swing.*;
import javax.swing.event.*;

import iqstrat.gui.iqstratStatusTable;

/** Class iqstratStatusFrame
 *  <p> This Class will allow the user to select the status of the data
 *
 *  @version 1.1 10/14/2007
 *  @author  John R. Victorine
 */

public class iqstratStatusFrame extends JFrame implements ActionListener
{
  private Observable notifier = null;       // Observable notifier

  private iqstratStatusTable pTable = null;

  private String sMnemonic    = "";
  private String sDescription = "";

  private JButton btnSelect = new JButton();
  private JButton btnCancel = new JButton();

  /** Constructor iqstratStatusFrame()
   *  <p> This is the Constructor for this class.
   *  @param notifier = Observable notifier
   */

  public iqstratStatusFrame(Observable notifier)
  {
    try
    {
      this.notifier = notifier;

      jbInit();
    }
    catch(Exception e)
    {
      e.printStackTrace();
    }
  }

  /** METHOD jbInit()
   *  <p> This Method will create the Frame for this class.
   *  @throws Exception
   */

  private void jbInit() throws Exception
  {
    JPanel pnlButtons  = new JPanel();
    JPanel pnl         = new JPanel();
    JScrollPane scroll = new JScrollPane();

    this.setTitle("Select Status of Data");
    this.getContentPane().setLayout(new BorderLayout());

    pnlButtons.setBorder(BorderFactory.createEtchedBorder());

    btnSelect.setFont(new java.awt.Font("Dialog", 1, 11));
    btnSelect.setText("Select");
    btnSelect.addActionListener(this);

    btnCancel.setFont(new java.awt.Font("Dialog", 1, 11));
    btnCancel.setText("Cancel");
    btnCancel.addActionListener(this);

    pnl.setLayout(new BorderLayout());

    pTable = new iqstratStatusTable();
    scroll = pTable.getScrollPane();

    // Attach Widgets to frame

    this.getContentPane().add(pnlButtons, BorderLayout.SOUTH);
    pnlButtons.add(btnSelect,      null);
    pnlButtons.add(btnCancel,      null);

    this.getContentPane().add(pnl, BorderLayout.CENTER);
    pnl.add(scroll,                BorderLayout.CENTER);

    // Display the Frame

    this.setSize(new Dimension(450, 560));
    Dimension d = Toolkit.getDefaultToolkit().getScreenSize();
    this.setLocation((d.width - this.getSize().width) / 2,
                     (d.height - this.getSize().height) / 2);

    this.setResizable(true);
    this.setVisible(true);
  }

  /* ===================================================================== *
   * -------------------------- GET METHODS ------------------------------ *
   * ===================================================================== */

  /** Method getMnemonic()
   * <p> This method will return the Mnemonic of the Status
   * @return sMnemonic = the mnemonic of the status
   */

  public String getMnemonic() { return (sMnemonic); }

  /** Method getDescription()
   * <p> This method will return the Description of the Status
   * @return sDescription = the Description of the status
   */

  public String getDescription() { return (sDescription); }

  /* ===================================================================== *
   * ---------------------------- ACTIONS -------------------------------- *
   * ===================================================================== */

  /** Method select()
   * <p> This method will close this dialog and all other dialogs opened by
   *     this dialog
   */

  private void select()
  {
    sMnemonic    =
        iqstrat.iqstratStatusStruct.STATUS[pTable.getSelectedRow()][0];
    sDescription =
        iqstrat.iqstratStatusStruct.STATUS[pTable.getSelectedRow()][1];

    notifier.notifyObservers(new String("Status Selected"));
  }

  /** Method close()
   * <p> This method will close this dialog and all other dialogs opened by
   *     this dialog
   */

  public void close()
  {
    notifier     = null;       // Observable notifier
    pTable       = null;
    sMnemonic    = null;
    sDescription = null;
    btnSelect    = null;
    btnCancel    = null;

    dispose();
  }

  /** METHOD actionPerformed()
   *  <p> This Method will handle all the actions within the Frame.
   *  @param event - Action Event
   */

  public void actionPerformed(ActionEvent event)
  {
    if (event.getSource() == btnSelect) { select(); }
    if (event.getSource() == btnCancel) { close(); }
  }
}