/*
 * @iqstratStartFrame.java Version 1.1 05/05/2011
 *
 * Copyright (c) 2011 Kansas Geological Survey
 * 1930 Constant Avenue, Lawrence, Kansas, 66047, U.S.A.
 * All Rights Reserved.
 */

package iqstrat.gui;

import java.util.Observer;
import java.util.Observable;
import java.awt.*;
import java.awt.image.*;
import java.awt.event.*;
import javax.swing.*;
import javax.swing.border.*;

import cmn.cmnStruct;			            // Global Common Data Structure
import cmn.cmnLASFileListStruct;            // LAS File List Data Structure
import cmn.cmnLASFileStruct;                // LAS File Data Structure

import iqstrat.iqstratStruct;               // Global IQSTRAT Data Structure
import iqstrat.iqstratControlStruct;        // Plot Control Data Structure
import iqstrat.iqstratHeadersStruct;        // Headers Data Structure
import iqstrat.iqstratShaleListStruct;      // Shale Level List Data Structure
import iqstrat.iqstratRemarkListStruct;     // Geologist Descriptions List Data Strucutre
import iqstrat.gui.iqstratNotesCSVFrame;    // Geologist Descriptions CSV Dialog
import iqstrat.gui.iqstratControlPlotFrame; // Control Plot Dialog

import kgs.gui.kgsSearchKGSFrame;           // KGS Search KGS Well Data Dialog
import kgs.gui.kgsBrineFrame;               // Brine Data KGS Frame
import kgs.gui.kgsMeasSectFrame;            // KGS Search KGS Measured Sections Dialog
import kgs.kgsMeasSectStruct;               // Measured Section Data Structure
import kgs.kgsMeasSectListStruct;           // Measured Section List Data Structure

import las3.las3ListStruct;                  // LAS 3.0 List Data Structure
import las3.las3Struct;                      // LAS 3.0 Data Structure
import las.lasFileDataStruct;               // LAS File Data Structure
import las3.io.las3Read;                     // Read LAS 3.0 File

import horizon.regions.regionsListStruct;   // Perforations List Data Structure
import horizon.strat.stratListStruct;       // Stratigraphic Units List Data Structure
import horizon.seq.seqListStruct;           // Sequence Stratigraphy List Structure
import horizon.gui.regionsMapCSVFrame;      // Import Tops Data CSV File

import horizon.env.envListStruct;           // Depositional Environment List Structure
//import horizon.env.gui.envMapCSVFrame;      // Import Dep Environment Data CSV File

import horizon.env.envListStruct;           // Dep Envrionment List DataStructure
import horizon.bio.bioStratListStruct;      // Bio Stratigraphy List Data Structure

import brine.brineListStruct;               // Brine Data List Structure
import brine.brineStruct;                   // Brine Data Structure
import brine.gui.brineMapCSVFrame;          // Import Brine Data CSV File

import rock.rockDataStruct;                 // Rock Data Structure
import rock.rockDataListStruct;             // Rock Data List Data Structure
import rock.rockImagesListStruct;           // Rock Image List Data Structure
import rock.fossil.fossilListStruct;        // Fossil List Data Structure
import rock.sedimentary.sedimentaryListStruct; // Sed Structure List Data Structure
import rock.phi.phiListStruct;              // Porosity List Data Structure
import rock.color.rockColorListStruct;      // Rock Color List Data Structure
import rock.gui.rockMapCSVFrame;            // Import Measured Rock Data CSV File

import lith.lithology.lithologyListStruct;  // Rock Lithology List Data Structure
import lith.texture.textureListStruct;      // Rock Texture List Data Structure
import lith.texture.textureStruct;          // Rock Texture Data Structure
import lith.rock.rockColumnListStruct;      // Rock Column Data List Structure

/** Class iqstratStartFrame
 *  <p> This Class Starting Panel for this web application
 *
 *  @version 1.1 05/05/2011
 *  @author  John R. Victorine
 */

public class iqstratStartFrame extends JFrame implements ActionListener, Observer
{
  // Input Variables

  private iqstratStruct  stStruct = null;  // Global IQSTRAT Data Structure

  // Global Variables

  private Observable     notifier = null;  // Observables Object

  private int            iAction  = -1;   // The type of search indicator
  private int            iWait    = 0;

  // -- Load Profile Data Frames

  public static final int _PC           = iqstrat.iqstratPlotLoad._PC;
  public static final int _KGS          = iqstrat.iqstratPlotLoad._KGS;
  public static final int _NOTES        = iqstrat.iqstratPlotLoad._NOTES;
  public static final int _STRAT_UNIT   = iqstrat.iqstratPlotLoad._STRAT_UNIT;
  public static final int _LAS_3_FILE   = iqstrat.iqstratPlotLoad._LAS_3_FILE;
  public static final int _ROCK_ENTRY   = iqstrat.iqstratPlotLoad._ROCK_ENTRY;
  public static final int _TOPS_ENTRY   = iqstrat.iqstratPlotLoad._TOPS_ENTRY;
  public static final int _CONVERT      = iqstrat.iqstratPlotLoad._CONVERT;

  public static final int _MEAS_SECT    = iqstrat.iqstratPlotLoad._MEAS_SECT;
  public static final int _GEO_REPORT   = iqstrat.iqstratPlotLoad._GEO_REPORT;
  public static final int _GR_SHALE     = iqstrat.iqstratPlotLoad._GR_SHALE;
  public static final int _ROCK_DATA    = iqstrat.iqstratPlotLoad._ROCK_DATA;
  public static final int _BRINE_DATA   = iqstrat.iqstratPlotLoad._BRINE_DATA;
  public static final int _DEP_ENV_DATA = iqstrat.iqstratPlotLoad._DEP_ENV_DATA;

//  private envMapCSVFrame       pMapDepEnv    = null; // Import Dep Environment CSV File
  private regionsMapCSVFrame   pMapRegions   = null; // Import Tops Data CSV File
  private rockMapCSVFrame      pMapRockData  = null; // Import Rock Data CSV File
  private iqstratNotesCSVFrame pNotesFile    = null; // Import Geo-Data CSV File
  private brineMapCSVFrame     pMapBrineData = null; // Import Brine Data CSV File

  private kgsSearchKGSFrame    pKGS          = null; // Search KGS Database for Data
  private kgsBrineFrame        pKGSBrine     = null; // Search KGS Brine Database
  private kgsMeasSectFrame     pMeasSect     = null; // Search KGS Measured Sections

  private las3Read             p3            = null; // Read LAS 3 File for Data

  private iqstratControlPlotFrame pControl   = null; // Profile Plot Control Frame

  // -- Type of data

  public static final int _HEADERS     = 0;  // Headers Data

  // -- LAS File & Geological Data

  public static final int _LAS3        = 1;  // LAS File Data
  public static final int _LAS         = 2;  // LAS File Data
  public static final int _ROCK        = 3;  // Rock Data
  public static final int _ROCK_IMAGES = 4;  // Rock Images

  // -- Horizon Data

  public static final int _TOPS        = 5;  // Tops Data
  public static final int _SEQ_STRAT   = 6;  // Sequence Stratigraphy
  public static final int _PERFORATION = 7;  // Perforations

  public static final int _DEP_ENV     = 19; // Depositional Environment

  public static final int _BIO_STRAT   = 18; // Bio Stratigraphy

  // -- Brine Data

  public static final int _BRINE       = 17; // Brine Data

  // -- Rock Observational & Computed Data

  public static final int _ROCK_COLUMN = 20; // Rock Column Data

  public static final int _LITHOLOGY   = 8;  // Rock Lithology
  public static final int _TEXTURE     = 9;  // Rock Texture
  public static final int _ROCK_PHI    = 10; // Rock Porosity
  public static final int _SED_STRUCT  = 11; // Sedimentary Structure
  public static final int _FOSSILS     = 12; // Fossils
  public static final int _ROCK_COLOR  = 13; // Rock Color
  public static final int _REMARKS     = 14; // Remarks/Comments

  // -- Misc Computation Type Tracks

  public static final int _PFEFFER     = 15;  // Perforations
  public static final int _SHALE       = 16;  // Shale Gamma Ray Levels

  // .. Plot Control

  private iqstratControlStruct    stControl     = new iqstratControlStruct();

  // .. Header Information Data Structure

  private iqstratHeadersStruct    stHeader      = null; // Header Data Structure

  // .. LAS Data

  private int                     MAX_LOG       = 3;
  private int                     iLog          = 0;
  private lasFileDataStruct       stLog[]       = null; // LAS File Data Struct
  private cmnLASFileListStruct    stFiles       = null; // LAS File Info List Structure

  private lasFileDataStruct       stLAS         = null; // LAS File Data Struct
  private iqstratShaleListStruct  stShale       = null; // Shale List Structure

  // .. Horizons Data

  private stratListStruct         stStrat       = null; // Tops List Data
  private seqListStruct           stSequence    = null; // Sequence Strat List
  private regionsListStruct       stOther       = null; // DST & Perforations
  private envListStruct           stDepEnv      = null; // Depositional Environment
  private bioStratListStruct      stBio         = null; // Bio Stratigraphy Data

  // .. Brine Data

  private brineListStruct         stBrine       = null; // Brine Data

  // .. Rock Data

  private rockDataListStruct      stCore        = null; // Measured Rock Data
  private rockImagesListStruct    stImages      = null; // Rock Image Data
  private lithologyListStruct     stLithology   = null; // Rock Column
  private textureListStruct       stTexture     = null; // Rock Texture
  private phiListStruct           stPHI         = null; // Porosity type struct
  private fossilListStruct        stFossil      = null; // Fossil List struct
  private sedimentaryListStruct   stSedimentary = null; // Sed Struct Data
  private rockColorListStruct     stRockColor   = null; // Rock Color Data
  private iqstratRemarkListStruct stRemarks     = null; // Remarks Data

  private kgsMeasSectListStruct   stKGSMeas     = null; // Measured Sections
  private rockColumnListStruct    stColumn      = null; // Rock Column Data List

  // Global Panel Widgets

  // -- Top Panel Widgets

  //private JButton   btn     = null;
  private JButton   btnKGS  = null;  // KGS Icon - No Action
  private JButton   btnKGS1 = null;  // KGS Well Data
  private JButton   btnKGS3 = null;  // Brine Data
  private JButton   btnKGS2 = null;  // KGS Measured Sections
  private JButton   btnPC   = null;  // PC Icon  - No Action
  private JButton   btnPC1  = null;  // Log ASCII Stadard File
  private JButton   btnPC2  = null;  // Tops CSV File
  private JButton   btnPC3  = null;  // Rock CSV File
  private JButton   btnPC4  = null;  // Geologist Report
  private JButton   btnPC5  = null;  // Brine CSV File
//  private JButton   btnPC6  = null;  // Dep Environment CSV File

  private JLabel lblLASFile1 = new JLabel();
  private JLabel lblLASFile2 = new JLabel();
  private JLabel lblLASFile3 = new JLabel();

  // -- LAS Filename Widgets

  private JTextField txtLAS1   = new JTextField(); // 1st LAS File
  private JTextField txtLAS2   = new JTextField(); // 2nd LAS File
  private JTextField txtLAS3   = new JTextField(); // 3rd LAS File

  // -- ASCII Filename Widgets

  private JTextField txtASCII1 = new JTextField(); // Tops CSV File
  private JTextField txtASCII2 = new JTextField(); // Rock CSV File
  private JTextField txtASCII3 = new JTextField(); // Geo-Report File
  private JTextField txtASCII4 = new JTextField(); // Brine CSV File
  private JTextField txtASCII5 = new JTextField(); // Dep Environment CSV File
  private JTextField txtASCII6 = new JTextField(); // Fossil Genera CSV File

  // -- Data Loaded Panel Widgets

  private static final int _LABEL   = 0;  // Table Header
  private static final int _LAS_R   = 1;  // Log Data Types
  private static final int _PERF_R  = 2;  // Perforation Data Types
  private static final int _TOPS_R  = 3;  // Tops Data Types
  private static final int _SEQ_R   = 4;  // Sequence Stratigraphy Data Types
  private static final int _ENV_R   = 5;  // Depositional Environment Data Types
  private static final int _LABEL2  = 6;  // Table Header
  private static final int _ROCK_R  = 7;  // Rock Data Types
  private static final int _IMAGE_R = 8;  // Rock Image Data Types
  private static final int _GEO_R   = 9;  // Geologist Report Data Types
  private static final int _BRINE_R = 10; // Brine Data Types
  private static final int _BIO_R   = 11; // Fossil Genera Data Types

  private static final int _NO_C    = 1;  // NO Data Column
  private static final int _LAS_3C  = 2;  // LAS File
  private static final int _LAS_C   = 3;  // LAS File
  private static final int _CSV_C   = 4;  // CSV File
  private static final int _KGS_C   = 5;  // KGS Database

  private static final String EMPTY = "....";
  private static final String NO    = " NO ";
  private static final String YES   = "YES ";

  private static final int _TOTAL = 12;
  private static final int _COLS  = 6;

  private static final int _TABLE_ROW = 6;
  private String ARRAY_TEXT[][] = {
    { "Data Type               ",  "    ", "3.0 ", "LAS ", "CSV ", "KGS " },
    { "Log Data                ",  " NO ", "....", "....", "....", "...." },
    { "Perforations            ",  " NO ", "....", "....", "....", "...." },
    { "Tops Data               ",  " NO ", "....", "....", "....", "...." },
    { "Sequence Stratigraphy   ",  " NO ", "....", "....", "....", "...." },
    { "Depositional Environment",  " NO ", "....", "....", "....", "...." },
    { "Data Type               ",  "    ", "3.0 ", "LAS ", "CSV ", "KGS " },
    { "Rock Measured Data      ",  " NO ", "....", "....", "....", "...." },
    { "Rock Images             ",  " NO ", "....", "....", "....", "...." },
    { "Geologist Report        ",  " NO ", "....", "....", "....", "...." },
    { "Brine Data              ",  " NO ", "....", "....", "....", "...." },
    { "Bio-Stratigraphy        ",  " NO ", "....", "....", "....", "...." },
  };

  private JLabel lblWait  = new JLabel();

  private JLabel lbl[][]  = null;

  // -- Base Panel Widgets

  private JRadioButton rbALL   = new JRadioButton(); // All Plot Tracks
  private JRadioButton rbLAS   = new JRadioButton(); // LAS Plot Track
  private JRadioButton rbTOP   = new JRadioButton(); // Horizon Plot Track
  private JRadioButton rbROCK  = new JRadioButton(); // Rock Data Plot Track
  private JRadioButton rbGEO   = new JRadioButton(); // Geologist Report Plot Track

  private JButton btnContinue  = new JButton();
  private JButton btnClear     = new JButton();
  private JButton btnExit      = new JButton();

  /** Constructor iqstratStartFrame( iqstratStruct stStruct )
   *  <p> This is the Constructor for this class.
   *  @param stStruct = Global IQSTRAT Data Structure
   */

  public iqstratStartFrame( iqstratStruct stStruct )
  {
    try
    {
      this.stStruct = stStruct;

      stFiles        = new cmnLASFileListStruct();
      stFiles.stItem = new cmnLASFileStruct[MAX_LOG];
      stLog          = new lasFileDataStruct[MAX_LOG];

      for (int i=0; i<MAX_LOG; i++)
      {
        stFiles.stItem[i] = new cmnLASFileStruct();
        stLog[i]          = new lasFileDataStruct();
	  }

      jbInit();
    }
    catch(Exception ex)
    {
      ex.printStackTrace();
    }
  }

  /** METHOD jbInit()
   *  <p> This Method will create the Panel for this class.
   *  @throws Exception
   */

  private void jbInit() throws Exception
  {
    JPanel panel          = new JPanel();
    JScrollPane scroll    = new JScrollPane();

    JPanel pnlTop         = new JPanel();
    JPanel pnlKGS         = new JPanel();
    JPanel pnlKGSicon     = new JPanel();
    JPanel pnlKGSCenter   = new JPanel();
    JPanel pnlKGSicon1    = new JPanel();
    JPanel pnlKGSicon2    = new JPanel();
    JPanel pnlKGSicon3    = new JPanel();
    JPanel pnlKGSicon4    = new JPanel();
    JPanel pnlPC          = new JPanel();
    JPanel pnlPCicon      = new JPanel();
    JPanel pnlPCCenter    = new JPanel();
    JPanel pnlPCicon1     = new JPanel();
    JPanel pnlPCicon2     = new JPanel();
    JPanel pnlPCicon3     = new JPanel();
    JPanel pnlPCicon4     = new JPanel();
    JPanel pnlPCicon5     = new JPanel();
//    JPanel pnlPCicon6     = new JPanel();

    JPanel pnlCenter      = new JPanel();
    JPanel pnlCenterTop   = new JPanel();
    JPanel pnlCenterTop1  = new JPanel();
    JPanel pnlCenterTop2  = new JPanel();

    JPanel pnlLAS         = new JPanel();
    JPanel pnlLASCenter   = new JPanel();
    JPanel pnlLASFile1    = new JPanel();
    JPanel pnlLASFile2    = new JPanel();
    JPanel pnlLASFile3    = new JPanel();

    JLabel lblLAS         = new JLabel();

    JPanel pnlASCII       = new JPanel();
    JPanel pnlASCIICenter = new JPanel();
    JPanel pnlASCIIFile1  = new JPanel();
    JPanel pnlASCIIFile2  = new JPanel();
    JPanel pnlASCIIFile3  = new JPanel();
    JPanel pnlASCIIFile4  = new JPanel();
    JPanel pnlASCIIFile5  = new JPanel();
    JPanel pnlASCIIFile6  = new JPanel();

    JLabel lblASCII       = new JLabel();
    JLabel lblASCIIFile1  = new JLabel();
    JLabel lblASCIIFile2  = new JLabel();
    JLabel lblASCIIFile3  = new JLabel();
    JLabel lblASCIIFile4  = new JLabel();
    JLabel lblASCIIFile5  = new JLabel();
    JLabel lblASCIIFile6  = new JLabel();

    JPanel pnlTable       = new JPanel();
    JPanel pnlTable1      = new JPanel();
    JPanel pnlTable2      = new JPanel();

    JPanel pnl[]          = null;
    JPanel pnlE[]         = null;
    JPanel pnlC[]         = null;

    JPanel pnlBase        = new JPanel();
    JPanel pnlWait        = new JPanel();
    JPanel pnlBase1       = new JPanel();
    JPanel pnlBase2       = new JPanel();

    ButtonGroup group     = new ButtonGroup();

    TitledBorder titledBorderTop = new TitledBorder(
        new EtchedBorder(EtchedBorder.RAISED,
                         Color.white,
                         new Color(165, 163, 151)),
        "Data Source");
    titledBorderTop.setTitleFont(new java.awt.Font("Dialog", 1, 14));

    TitledBorder titledBorderKGS = new TitledBorder(
        BorderFactory.createEtchedBorder(Color.white, new Color(165, 163, 151)),
        "KGS (Database & Server)");
    titledBorderKGS.setTitleFont(new java.awt.Font("Dialog", 1, 11));

    TitledBorder titledBorderKGSIcon = new TitledBorder(
        BorderFactory.createEmptyBorder(),  "KGS Data");
    titledBorderKGSIcon.setTitleJustification(TitledBorder.CENTER);
    titledBorderKGSIcon.setTitleFont(new java.awt.Font("Dialog", 1, 11));

    TitledBorder titledBorderKGS1 = new TitledBorder(
        BorderFactory.createEmptyBorder(), "Well Data");
    titledBorderKGS1.setTitleJustification(TitledBorder.CENTER);
    titledBorderKGS1.setTitleFont(new java.awt.Font("Dialog", 1, 11));

    TitledBorder titledBorderKGS3 = new TitledBorder(
        BorderFactory.createEmptyBorder(),  "Brine Data");
    titledBorderKGS3.setTitleJustification(TitledBorder.CENTER);
    titledBorderKGS3.setTitleFont(new java.awt.Font("Dialog", 1, 11));

    TitledBorder titledBorderKGS2 = new TitledBorder(
        BorderFactory.createEmptyBorder(),  "Measured Sections");
    titledBorderKGS2.setTitleJustification(TitledBorder.CENTER);
    titledBorderKGS2.setTitleFont(new java.awt.Font("Dialog", 1, 11));

    TitledBorder titledBorderPC = new TitledBorder(
        BorderFactory.createEtchedBorder(Color.white, new Color(165, 163, 151)),
        "PC (ASCII Data Files)");
    titledBorderPC.setTitleFont(new java.awt.Font("Dialog", 1, 11));

    TitledBorder titledBorderPCIcon = new TitledBorder(
        BorderFactory.createEmptyBorder(),  "PC Data");
    titledBorderPCIcon.setTitleJustification(TitledBorder.CENTER);
    titledBorderPCIcon.setTitleFont(new java.awt.Font("Dialog", 1, 11));

    TitledBorder titledBorderPC1 = new TitledBorder(
        BorderFactory.createEmptyBorder(),  "Ver 2.0 & 3.0");
    titledBorderPC1.setTitleJustification(TitledBorder.CENTER);
    titledBorderPC1.setTitleFont(new java.awt.Font("Dialog", 1, 11));

    TitledBorder titledBorderPC2 = new TitledBorder(
        BorderFactory.createEmptyBorder(),  "Tops CSV");
    titledBorderPC2.setTitleJustification(TitledBorder.CENTER);
    titledBorderPC2.setTitleFont(new java.awt.Font("Dialog", 1, 11));

    TitledBorder titledBorderPC3 = new TitledBorder(
        BorderFactory.createEmptyBorder(),  "Rock Data CSV");
    titledBorderPC3.setTitleJustification(TitledBorder.CENTER);
    titledBorderPC3.setTitleFont(new java.awt.Font("Dialog", 1, 11));

    TitledBorder titledBorderPC4 = new TitledBorder(
        BorderFactory.createEmptyBorder(),  "Geologist Report");
    titledBorderPC4.setTitleJustification(TitledBorder.CENTER);
    titledBorderPC4.setTitleFont(new java.awt.Font("Dialog", 1, 11));

    TitledBorder titledBorderPC5 = new TitledBorder(
        BorderFactory.createEmptyBorder(),  "Brine Data CSV");
    titledBorderPC5.setTitleJustification(TitledBorder.CENTER);
    titledBorderPC5.setTitleFont(new java.awt.Font("Dialog", 1, 11));

    TitledBorder titledBorderPC6 = new TitledBorder(
        BorderFactory.createEmptyBorder(),  "Environment CSV");
    titledBorderPC6.setTitleJustification(TitledBorder.CENTER);
    titledBorderPC6.setTitleFont(new java.awt.Font("Dialog", 1, 11));

    TitledBorder titledBorderCenter = new TitledBorder(
        new EtchedBorder(EtchedBorder.RAISED,
                         Color.white,
                         new Color(165, 163, 151)),
        "Data Loaded");
    titledBorderCenter.setTitleFont(new java.awt.Font("Dialog", 1, 14));

    TitledBorder titledBorderFile = new TitledBorder(
        BorderFactory.createEtchedBorder(Color.white, new Color(165, 163, 151)),
        "Data Source Filenames:");
    titledBorderFile.setTitleFont(new java.awt.Font("Dialog", 1, 11));

    TitledBorder titledBorderLAS = new TitledBorder(
        BorderFactory.createEtchedBorder(Color.white, new Color(165, 163, 151)),
        "Log ASCII Standard (LAS) Files:");
    titledBorderLAS.setTitleFont(new java.awt.Font("Dialog", 1, 11));

    TitledBorder titledBorderASCII = new TitledBorder(
        BorderFactory.createEtchedBorder(Color.white, new Color(165, 163, 151)),
        "PC ASCII Files:");
    titledBorderASCII.setTitleFont(new java.awt.Font("Dialog", 1, 11));

    TitledBorder titledBorderBase = new TitledBorder(
        new EtchedBorder(EtchedBorder.RAISED,
                         Color.white,
                         new Color(165, 163, 151)),
        "Profile Plot Presentation:");
    titledBorderBase.setTitleFont(new java.awt.Font("Dialog", 1, 14));

    // Create an Observable

    notifier = new iqstratStartFrameObservable();

    // Add this Dialog to the notifier as observer

    notifier.addObserver(this);

    // Build Panel

    this.setTitle( "Load Data" );
    this.getContentPane().setLayout( new BorderLayout() );
    this.getContentPane().setBackground(Color.white);

    panel.setLayout( new BorderLayout() );
    panel.setPreferredSize(new Dimension(650, 800));
    panel.setBackground(Color.white);

    // Top Panel

    pnlTop.setBorder( titledBorderTop );
    pnlTop.setLayout( new GridLayout(2,1) );
    pnlTop.setBackground(Color.white);
    pnlTop.setPreferredSize( new Dimension(10, 280) );

    // -- KGS Data Source

    pnlKGS.setBackground(Color.white);
    pnlKGS.setLayout( new BorderLayout() );

    // .. KGS ICON Panel

    pnlKGSicon.setBorder( titledBorderKGSIcon );
    pnlKGSicon.setBackground(Color.white);

    btnKGS = new JButton( createImageIcon( cmn.cmnStruct.KGS_DATA ) );
    btnKGS.setBackground(Color.white);
    btnKGS.setPreferredSize( new Dimension(64, 64) );
    btnKGS.addActionListener( this );

    pnlKGSicon1.setBackground(Color.white);

    pnlKGSicon2.setBackground(Color.white);
    pnlKGSicon2.setBorder( titledBorderKGS1 );

    btnKGS1 = new JButton( createImageIcon( cmn.cmnStruct.WELL_DATA ) );
    btnKGS1.setBackground(Color.white);
    btnKGS1.setPreferredSize( new Dimension(64, 64) );
    btnKGS1.addActionListener( this );

    pnlKGSicon3.setBackground(Color.white);
    pnlKGSicon3.setBorder( titledBorderKGS3 );

    btnKGS3 = new JButton( createImageIcon( cmn.cmnStruct.BRINE_DATA ) );
    btnKGS3.setBackground(Color.white);
    btnKGS3.setPreferredSize( new Dimension(64, 64) );
    btnKGS3.addActionListener( this );

    pnlKGSicon4.setBackground(Color.white);
    pnlKGSicon4.setBorder( titledBorderKGS2 );

    btnKGS2 = new JButton( createImageIcon( cmn.cmnStruct.MEAS_DATA ) );
    btnKGS2.setBackground(Color.white);
    btnKGS2.setPreferredSize( new Dimension(64, 64) );
    btnKGS2.addActionListener( this );

    // .. KGS Center Panel

    pnlKGSCenter.setBackground(Color.white);
    pnlKGSCenter.setBorder( titledBorderKGS );
    pnlKGSCenter.setLayout( new GridLayout() );

    // -- PC Data Source

    pnlPC.setBackground(Color.white);
    pnlPC.setLayout( new BorderLayout() );

    // .. PC ICON Panel

    pnlPCicon.setBackground(Color.white);
    pnlPCicon.setBorder( titledBorderPCIcon );

    btnPC = new JButton( createImageIcon( cmn.cmnStruct.PC_DATA ) );
    btnPC.setBackground(Color.white);
    btnPC.setPreferredSize( new Dimension(64, 64) );
    btnPC.addActionListener( this );

    // .. PC Center Panel

    pnlPCCenter.setBackground(Color.white);
    pnlPCCenter.setBorder( titledBorderPC );
    pnlPCCenter.setLayout( new GridLayout() );

    // .. .. Log ASCII Standard version 2.0 or 3.0 Files Button Panel

    pnlPCicon1.setBackground(Color.white);
    pnlPCicon1.setBorder( titledBorderPC1 );

    btnPC1 = new JButton( createImageIcon( cmn.cmnStruct.LAS_FILE ) );
    btnPC1.setBackground(Color.white);
    btnPC1.setPreferredSize( new Dimension(64, 64) );
    btnPC1.addActionListener( this );

    // .. .. Tops CSV File Data Button Panel

    pnlPCicon2.setBackground(Color.white);
    pnlPCicon2.setBorder( titledBorderPC2 );

    btnPC2 = new JButton( createImageIcon( cmn.cmnStruct.HORIZONS ) );
    btnPC2.setBackground(Color.white);
    btnPC2.setPreferredSize( new Dimension(64, 64) );
    btnPC2.addActionListener( this );

    // .. .. Measured Rock CSV File Data Button Panel

    pnlPCicon3.setBackground(Color.white);
    pnlPCicon3.setBorder( titledBorderPC3 );

    btnPC3 = new JButton( createImageIcon( cmn.cmnStruct.ROCK_DATA ) );
    btnPC3.setBackground(Color.white);
    btnPC3.setPreferredSize( new Dimension(64, 64) );
    btnPC3.addActionListener( this );

    // .. .. Geologist Report Button Panel

    pnlPCicon4.setBackground(Color.white);
    pnlPCicon4.setBorder( titledBorderPC4 );

    btnPC4 = new JButton( createImageIcon( cmn.cmnStruct.ROCK_TEXT ) );
    btnPC4.setBackground(Color.white);
    btnPC4.setPreferredSize( new Dimension(64, 64) );
    btnPC4.addActionListener( this );

    // .. .. Brine CSV File Data Button Panel

    pnlPCicon5.setBackground(Color.white);
    pnlPCicon5.setBorder( titledBorderPC5 );

    btnPC5 = new JButton( createImageIcon( cmn.cmnStruct.BRINE_DATA ) );
    btnPC5.setBackground(Color.white);
    btnPC5.setPreferredSize( new Dimension(64, 64) );
    btnPC5.addActionListener( this );

    // .. .. Depositional Environment CSV File Data Button Panel

//    pnlPCicon6.setBackground(Color.white);
//    pnlPCicon6.setBorder( titledBorderPC6 );

//    btnPC6 = new JButton( createImageIcon( cmn.cmnStruct.BRINE_DATA ) );
//    btnPC6 = new JButton();
//    btnPC6.setBackground(Color.white);
//    btnPC6.setPreferredSize( new Dimension(64, 64) );
//    btnPC6.addActionListener( this );

    // Center Panel

    pnlCenter.setBorder( titledBorderCenter );
    pnlCenter.setLayout( new BorderLayout() );
    pnlCenter.setBackground(Color.white);
    pnlCenter.setPreferredSize( new Dimension(64, 64) );

    // -- Center Top Panel

    pnlCenterTop.setBorder( titledBorderFile );
    pnlCenterTop.setBackground(Color.white);
//    pnlCenterTop.setLayout( new BorderLayout() );
    pnlCenterTop.setLayout( new GridLayout(2,1) );
//    pnlCenterTop.setPreferredSize( new Dimension(10, 160) );

    // .. LAS Filenames

    pnlCenterTop1.setLayout( new BorderLayout() );
    pnlCenterTop1.setBackground(Color.white);

    // .. .. LAS Label Panel

    pnlLAS.setBackground(Color.white);

    lblLAS.setHorizontalAlignment(SwingConstants.LEFT);
    lblLAS.setFont(new java.awt.Font("Monospaced", 1, 11));
    lblLAS.setBackground(Color.white);
    lblLAS.setText("LAS:   ");

    pnlLASCenter.setBorder(titledBorderLAS);
    pnlLASCenter.setLayout( new GridLayout(3,1) );
    pnlLASCenter.setBackground(Color.white);

    // .. .. .. LAS File 1 Panel

    pnlLASFile1.setLayout( new BorderLayout() );
    pnlLASFile1.setBackground(Color.white);

    lblLASFile1.setHorizontalAlignment(SwingConstants.LEFT);
    lblLASFile1.setFont(new java.awt.Font("Monospaced", 1, 11));
    lblLASFile1.setBackground(Color.white);
    lblLASFile1.setText("1: ");

    txtLAS1.setFont(new java.awt.Font("Dialog", 1, 11));
    txtLAS1.setEditable(false);
    txtLAS1.setForeground(Color.blue);
    txtLAS1.setBackground(Color.white);
    txtLAS1.setText("");

    // .. .. .. LAS File 2 Panel

    pnlLASFile2.setLayout( new BorderLayout() );
    pnlLASFile2.setBackground(Color.white);

    lblLASFile2.setHorizontalAlignment(SwingConstants.LEFT);
    lblLASFile2.setFont(new java.awt.Font("Monospaced", 1, 11));
    lblLASFile2.setBackground(Color.white);
    lblLASFile2.setText("2: ");

    txtLAS2.setFont(new java.awt.Font("Dialog", 1, 11));
    txtLAS2.setEditable(false);
    txtLAS2.setForeground(Color.blue);
    txtLAS2.setBackground(Color.white);
    txtLAS2.setText("");

    // .. .. .. LAS File 3 Panel

    pnlLASFile3.setLayout( new BorderLayout() );
    pnlLASFile3.setBackground(Color.white);

    lblLASFile3.setHorizontalAlignment(SwingConstants.LEFT);
    lblLASFile3.setFont(new java.awt.Font("Monospaced", 1, 11));
    lblLASFile3.setBackground(Color.white);
    lblLASFile3.setText("3: ");

    txtLAS3.setFont(new java.awt.Font("Dialog", 1, 11));
    txtLAS3.setEditable(false);
    txtLAS3.setForeground(Color.blue);
    txtLAS3.setBackground(Color.white);
    txtLAS3.setText("");

    // .. ASCII Filenames

    pnlCenterTop2.setLayout( new BorderLayout() );
    pnlCenterTop2.setBackground(Color.white);

    // .. .. ASCII Label Panel

    pnlASCII.setBackground(Color.white);

    lblASCII.setHorizontalAlignment(SwingConstants.LEFT);
    lblASCII.setFont(new java.awt.Font("Monospaced", 1, 11));
    lblASCII.setBackground(Color.white);
    lblASCII.setText("ASCII: ");

    pnlASCIICenter.setBorder(titledBorderASCII);
    pnlASCIICenter.setLayout( new GridLayout(3,2) );
    pnlASCIICenter.setBackground(Color.white);

    // .. .. .. ASCII File 1 Panel

    pnlASCIIFile1.setLayout( new BorderLayout() );
    pnlASCIIFile1.setBackground(Color.white);

    lblASCIIFile1.setHorizontalAlignment(SwingConstants.LEFT);
    lblASCIIFile1.setFont(new java.awt.Font("Monospaced", 1, 11));
    lblASCIIFile1.setBackground(Color.white);
    lblASCIIFile1.setText("Tops CSV:   ");

    txtASCII1.setFont(new java.awt.Font("Dialog", 0, 11));
    txtASCII1.setEditable(false);
    txtASCII1.setBackground(Color.white);
    txtASCII1.setText("");

    // .. .. .. ASCII File 2 Panel

    pnlASCIIFile2.setLayout( new BorderLayout() );
    pnlASCIIFile2.setBackground(Color.white);

    lblASCIIFile2.setHorizontalAlignment(SwingConstants.LEFT);
    lblASCIIFile2.setFont(new java.awt.Font("Monospaced", 1, 11));
    lblASCIIFile2.setBackground(Color.white);
    lblASCIIFile2.setText(" Core CSV:  ");

    txtASCII2.setFont(new java.awt.Font("Dialog", 0, 11));
    txtASCII2.setEditable(false);
    txtASCII2.setBackground(Color.white);
    txtASCII2.setText("");

    // .. .. .. ASCII File 3 Panel

    pnlASCIIFile3.setLayout( new BorderLayout() );
    pnlASCIIFile3.setBackground(Color.white);

    lblASCIIFile3.setHorizontalAlignment(SwingConstants.LEFT);
    lblASCIIFile3.setFont(new java.awt.Font("Monospaced", 1, 11));
    lblASCIIFile3.setBackground(Color.white);
    lblASCIIFile3.setText(" Geo-Report:");

    txtASCII3.setFont(new java.awt.Font("Dialog", 0, 11));
    txtASCII3.setEditable(false);
    txtASCII3.setBackground(Color.white);
    txtASCII3.setText("");

    // .. .. .. ASCII File 4 Panel

    pnlASCIIFile4.setLayout( new BorderLayout() );
    pnlASCIIFile4.setBackground(Color.white);

    lblASCIIFile4.setHorizontalAlignment(SwingConstants.LEFT);
    lblASCIIFile4.setFont(new java.awt.Font("Monospaced", 1, 11));
    lblASCIIFile4.setBackground(Color.white);
    lblASCIIFile4.setText(" Brine CSV: ");

    txtASCII4.setFont(new java.awt.Font("Dialog", 0, 11));
    txtASCII4.setEditable(false);
    txtASCII4.setBackground(Color.white);
    txtASCII4.setText("");

    // .. .. .. ASCII File 5 Panel

    pnlASCIIFile5.setLayout( new BorderLayout() );
    pnlASCIIFile5.setBackground(Color.white);

    lblASCIIFile5.setHorizontalAlignment(SwingConstants.LEFT);
    lblASCIIFile5.setFont(new java.awt.Font("Monospaced", 1, 11));
    lblASCIIFile5.setBackground(Color.white);
    lblASCIIFile5.setText("Environment:");

    txtASCII5.setFont(new java.awt.Font("Dialog", 0, 11));
    txtASCII5.setEditable(false);
    txtASCII5.setBackground(Color.white);
    txtASCII5.setText("");

    // .. .. .. ASCII File 6 Panel

    pnlASCIIFile6.setLayout( new BorderLayout() );
    pnlASCIIFile6.setBackground(Color.white);

    lblASCIIFile6.setHorizontalAlignment(SwingConstants.LEFT);
    lblASCIIFile6.setFont(new java.awt.Font("Monospaced", 1, 11));
    lblASCIIFile6.setBackground(Color.white);
    lblASCIIFile6.setText("Genera CSV: ");

    txtASCII6.setFont(new java.awt.Font("Dialog", 0, 11));
    txtASCII6.setEditable(false);
    txtASCII6.setBackground(Color.white);
    txtASCII6.setText("");

    // -- Center Table Panel

    pnlTable.setLayout( new GridLayout() );
    pnlTable.setBackground(Color.white);

    pnlTable1.setLayout( new GridLayout(6,1) );
    pnlTable1.setBackground(Color.white);

    pnlTable2.setLayout( new GridLayout(6,1) );
    pnlTable2.setBackground(Color.white);

    pnl  = new JPanel[_TOTAL];
    pnlE = new JPanel[_TOTAL];
    pnlC = new JPanel[_TOTAL];
    lbl  = new JLabel[_TOTAL][6];

    for (int i= 0; i<_TOTAL; i++)
    {
	  pnl[i] = new JPanel();
      pnl[i].setLayout( new BorderLayout() );
      pnl[i].setBackground(Color.white);

//	    pnlE[i] = new JPanel();
//      pnlE[i].setLayout( new BorderLayout() );
//      pnlE[i].setBackground(Color.white);

	  pnlE[i] = new JPanel();
      pnlE[i].setBackground(Color.white);

	  pnlC[i] = new JPanel();
      pnlC[i].setLayout( new GridLayout() );
      pnlC[i].setBackground(Color.white);

      for (int j=0; j<_COLS; j++)
      {
		lbl[i][j] = new JLabel();
        lbl[i][j].setHorizontalAlignment(SwingConstants.LEFT);
        lbl[i][j].setFont(new java.awt.Font("Monospaced", 1, 11));
        lbl[i][j].setBackground(Color.white);
        lbl[i][j].setText( ARRAY_TEXT[i][j] );

        if (j>0)
        {
          pnlC[i].add( lbl[i][j], null );
		}
		else
		{
          pnlE[i].add( lbl[i][0], null );
		}
      }

      pnl[i].add( pnlE[i],    BorderLayout.WEST );
      pnl[i].add( pnlC[i],    BorderLayout.CENTER );

      if (i<_TABLE_ROW)
      {
        pnlTable1.add( pnl[i],  null );
      }
      else
      {
        pnlTable2.add( pnl[i],  null );
	  }
	}

    // Base Panel

    pnlBase.setLayout( new BorderLayout() );
    pnlBase.setBackground(Color.white);

//    pnlWait.setLayout( new BorderLayout() );
    pnlWait.setBackground(Color.white);

    lblWait.setHorizontalAlignment(SwingConstants.LEFT);
    lblWait.setFont(new java.awt.Font("Dialog", 1, 14));
    lblWait.setBackground(Color.white);
    lblWait.setForeground(Color.red);
    lblWait.setText("");

    pnlBase1.setBorder( titledBorderBase );
    pnlBase1.setBackground(Color.white);

    rbALL.setFont(new java.awt.Font("Monospaced", 1, 11));
    rbALL.setHorizontalAlignment(SwingConstants.LEFT);
    rbALL.setBackground(new Color( 255, 255, 255 ));
    rbALL.setText( "All Plot Tracks" );
    rbALL.addActionListener(this);

    rbLAS.setFont(new java.awt.Font("Monospaced", 1, 11));
    rbLAS.setHorizontalAlignment(SwingConstants.LEFT);
    rbLAS.setBackground(new Color( 255, 255, 255 ));
    rbLAS.setText( "LAS Log Data" );
    rbLAS.addActionListener(this);

    rbTOP.setFont(new java.awt.Font("Monospaced", 1, 11));
    rbTOP.setHorizontalAlignment(SwingConstants.LEFT);
    rbTOP.setBackground(new Color( 255, 255, 255 ));
    rbTOP.setText( "Horizon Data" );
    rbTOP.addActionListener(this);

    rbROCK.setFont(new java.awt.Font("Monospaced", 1, 11));
    rbROCK.setHorizontalAlignment(SwingConstants.LEFT);
    rbROCK.setBackground(new Color( 255, 255, 255 ));
    rbROCK.setText( "Rock Data" );
    rbROCK.addActionListener(this);

    rbGEO.setFont(new java.awt.Font("Monospaced", 1, 11));
    rbGEO.setSelected(true);
    rbGEO.setHorizontalAlignment(SwingConstants.LEFT);
    rbGEO.setBackground(new Color( 255, 255, 255 ));
    rbGEO.setText( "Geologist Report Data" );
    rbGEO.addActionListener(this);

    pnlBase2.setBackground(Color.white);
//    pnlBase2.setLayout( new GridLayout() );

    btnContinue.setFont(new java.awt.Font("Dialog", 1, 11));
    btnContinue.setPreferredSize( new Dimension(120, 25) );
    btnContinue.setText("Continue");
    btnContinue.addActionListener(this);

    btnClear.setFont(new java.awt.Font("Dialog", 1, 11));
    btnClear.setPreferredSize( new Dimension(120, 25) );
    btnClear.setText("Clear");
    btnClear.addActionListener(this);

    btnExit.setFont(new java.awt.Font("Dialog", 1, 11));
    btnExit.setPreferredSize( new Dimension(120, 25) );
    btnExit.setText("Exit");
    btnExit.addActionListener(this);

    // Add Widgets to Panel

    this.getContentPane().add( scroll,  BorderLayout.CENTER );
    scroll.getViewport().add( panel,    null);

//    this.getContentPane().add( pnlTop,  BorderLayout.NORTH );
    panel.add( pnlTop,                  BorderLayout.NORTH );
    pnlTop.add( pnlKGS,                 null );
    pnlKGS.add( pnlKGSicon,             BorderLayout.WEST );
    pnlKGSicon.add( btnKGS,             null );
    pnlKGS.add( pnlKGSCenter,           BorderLayout.CENTER );
//    pnlKGSCenter.add( pnlKGSicon1,      null );
    pnlKGSCenter.add( pnlKGSicon2,      null );
    pnlKGSicon2.add( btnKGS1,           null );
    pnlKGSCenter.add( pnlKGSicon3,      null );
    pnlKGSicon3.add( btnKGS3,           null );
    pnlKGSCenter.add( pnlKGSicon4,      null );
    pnlKGSicon4.add( btnKGS2,           null );

    pnlTop.add( pnlPC,                  null );
    pnlPC.add( pnlPCicon,               BorderLayout.WEST );
    pnlPCicon.add( btnPC,               null );
    pnlPC.add( pnlPCCenter,             BorderLayout.CENTER );
    pnlPCCenter.add( pnlPCicon1,        null );
    pnlPCicon1.add( btnPC1,             null );
    pnlPCCenter.add( pnlPCicon2,        null );
    pnlPCicon2.add( btnPC2,             null );
//    pnlPCCenter.add( pnlPCicon6,        null );
//    pnlPCicon6.add( btnPC6,             null );
    pnlPCCenter.add( pnlPCicon5,        null );
    pnlPCicon5.add( btnPC5,             null );
    pnlPCCenter.add( pnlPCicon3,        null );
    pnlPCicon3.add( btnPC3,             null );
    pnlPCCenter.add( pnlPCicon4,        null );
    pnlPCicon4.add( btnPC4,             null );

//    this.getContentPane().add( pnlCenter, BorderLayout.CENTER );
    panel.add( pnlCenter,               BorderLayout.CENTER );
    pnlCenter.add( pnlCenterTop,        BorderLayout.NORTH );

//    pnlCenterTop.add( pnlCenterTop1,    BorderLayout.CENTER );
    pnlCenterTop.add( pnlCenterTop1,    null );
    pnlCenterTop1.add( pnlLASCenter,    BorderLayout.CENTER );

    pnlLASCenter.add( pnlLASFile1,      null );
    pnlLASFile1.add(  lblLASFile1,      BorderLayout.WEST );
    pnlLASFile1.add(  txtLAS1,          BorderLayout.CENTER );

    pnlLASCenter.add( pnlLASFile2,      null );
    pnlLASFile2.add(  lblLASFile2,      BorderLayout.WEST );
    pnlLASFile2.add(  txtLAS2,          BorderLayout.CENTER );

    pnlLASCenter.add( pnlLASFile3,      null );
    pnlLASFile3.add(  lblLASFile3,      BorderLayout.WEST );
    pnlLASFile3.add(  txtLAS3,          BorderLayout.CENTER );

    pnlCenterTop.add( pnlCenterTop2,    null );
    pnlCenterTop2.add( pnlASCIICenter,  BorderLayout.CENTER );

    pnlASCIICenter.add( pnlASCIIFile1,  null );
    pnlASCIIFile1.add( lblASCIIFile1,   BorderLayout.WEST );
    pnlASCIIFile1.add( txtASCII1,       BorderLayout.CENTER );

    pnlASCIICenter.add( pnlASCIIFile2,  null );
    pnlASCIIFile2.add( lblASCIIFile2,   BorderLayout.WEST );
    pnlASCIIFile2.add( txtASCII2,       BorderLayout.CENTER );

    pnlASCIICenter.add( pnlASCIIFile5,  null );
    pnlASCIIFile5.add( lblASCIIFile5,   BorderLayout.WEST );
    pnlASCIIFile5.add( txtASCII5,       BorderLayout.CENTER );

    pnlASCIICenter.add( pnlASCIIFile4,  null );
    pnlASCIIFile4.add( lblASCIIFile4,   BorderLayout.WEST );
    pnlASCIIFile4.add( txtASCII4,       BorderLayout.CENTER );

    pnlASCIICenter.add( pnlASCIIFile6,  null );
    pnlASCIIFile6.add( lblASCIIFile6,   BorderLayout.WEST );
    pnlASCIIFile6.add( txtASCII6,       BorderLayout.CENTER );

    pnlASCIICenter.add( pnlASCIIFile3,  null );
    pnlASCIIFile3.add( lblASCIIFile3,   BorderLayout.WEST );
    pnlASCIIFile3.add( txtASCII3,       BorderLayout.CENTER );

    pnlCenter.add( pnlTable,            BorderLayout.CENTER );
    pnlTable.add( pnlTable1,            BorderLayout.CENTER );
    pnlTable.add( pnlTable2,            BorderLayout.CENTER );

//    this.getContentPane().add( pnlBase, BorderLayout.SOUTH );
    panel.add( pnlBase,                 BorderLayout.SOUTH );
//    pnlBase.add( pnlBase1,              BorderLayout.NORTH );
    pnlBase.add( pnlWait,               BorderLayout.NORTH );
    pnlWait.add( lblWait,               BorderLayout.CENTER );

    pnlBase.add( pnlBase1,              BorderLayout.CENTER );
    pnlBase1.add( rbALL,                null );
    pnlBase1.add( rbLAS,                null );
    pnlBase1.add( rbTOP,                null );
    pnlBase1.add( rbROCK,               null );
    pnlBase1.add( rbGEO,                null );

    group.add( rbALL );
    group.add( rbLAS );
    group.add( rbTOP );
    group.add( rbROCK );
    group.add( rbGEO );

    pnlBase.add( pnlBase2,              BorderLayout.SOUTH );
    pnlBase2.add( btnContinue,          null );
    pnlBase2.add( btnClear,             null );
    pnlBase2.add( btnExit,              null );

    setButtons();

    // Display the Frame

//    this.setSize(new Dimension(700, 820));
    Dimension d = Toolkit.getDefaultToolkit().getScreenSize();
    int iScreenHigh  = d.height-50;
    if (iScreenHigh < 850)
      this.setSize(new Dimension(700, iScreenHigh));
    else
      this.setSize(new Dimension(700, 850));
    this.setLocation((d.width - this.getSize().width) / 2,
                     (d.height - this.getSize().height) / 2);

    this.setResizable(true);
    this.setVisible(true);
  }

  /** METHOD createImageIcon()
   *  <p> This Method will create the Frame for this class.
   *  @param path = the path to the image
   *  @return image icon
   */

  protected ImageIcon createImageIcon(String path)
  {
    java.net.URL imgURL = getClass().getResource(path);
    ImageIcon    image  = null;

    if (imgURL != null)
    {
      image = new ImageIcon(imgURL);
    }
    else
    {
       System.err.println("Couldn't find file: " + path);
    }

    return (image);
  }

  /* ===================================================================== *
   * -------------------------- GET METHODS ------------------------------ *
   * ===================================================================== */

  /** Method getLAS()
   * <p> These methods will return the LAS File Data Structure
   * @return stLAS = LAS File Data Structure
   */

  public lasFileDataStruct getLAS()
  {
	int    i,j;
	int    iRows  = 0;
	double dStart = 0.0;
	double dEnd   = 0.0;
	double dStep  = 0.0;
	double dNull  = -999.25;
	int    iTemp  = 0;
	double dStp   = 0.0;
    las3ListStruct st3 = null;

	if (iLog > 0)
	{
      if (iLog == 1)
      {
 	    stLAS = las.lasFileDataUtility.copy( stLog[0] );
  	  }
  	  else
  	  {
        stLAS = new lasFileDataStruct();

	    for (i=0; i<iLog; i++)
	    {
          dStep  = stLog[i].depthStep;
          if (dStep > stLog[i].depthStep)
          {
            dStep  = stLog[i].depthStep;
		  }

		  if (stLog[i].iLogs > 0)
		  {
		    for (j=0; j<stLog[i].iLogs; j++)
		      st3 = las3.las3Utility.add( stLog[i].stLAS3[j], st3 );
	      }
        }

	    for (i=0; i<iLog; i++)
	    {
		  if (i==0)
		  {
		    dStart = stLog[i].depthStart;
		    dEnd   = stLog[i].depthEnd;
		    dStep  = stLog[i].depthStep;
		    dNull  = stLog[i].dNull;

            stLAS = las.lasFileDataUtility.copyHeader( stLog[i], stLAS );
		  }

		  if (dStart > stLog[i].depthStart)
		    dStart = stLog[i].depthStart;

          if (dEnd < stLog[i].depthEnd)
		    dEnd   = stLog[i].depthEnd;

          if (dStep > stLog[i].depthStep)
          {
            dStep  = stLog[i].depthStep;
		  }
	    }

        iTemp  = (int) dStart;
        dStart = (double) iTemp;

        iTemp  = 1 + (int) dEnd;
        dEnd   = (double) iTemp;

        dStp = 0.5;
        if (dStep < 0.5)
          dStp = 0.25;
        if (dStep < 0.25)
          dStp = 0.1;

        dStep = dStp;
	    iRows = (int) ( Math.abs(dEnd - dStart) / dStep ) + 1;

        stLAS.depthStart = dStart;
        stLAS.depthEnd   = dEnd;
        stLAS.depthStep  = dStep;

        stLAS = las3.las3LoadLogData.initData( iRows, stLAS );

	    for (i=0; i<iLog; i++)
	    {
          stLAS = las3.las3LoadLogData.mergeLogData( stLog[i], stLAS );
	    }
	  }
    }

    if (stLAS != null)
      stLAS.stList = iqstrat.iqstratShaleUtility.copyList( stShale );

    if (st3 != null)
    {
	  if (st3.iCount > 0)
	  {
	    if (stLAS != null)
	    {
		  stLAS.stLAS3 = new las3Struct[st3.iCount];
		  stLAS.iLogs  = st3.iCount;
		  for (i=0; i<st3.iCount; i++)
		  {
		    stLAS.stLAS3[i] = new las3Struct();
		    stLAS.stLAS3[i] = las3.las3Utility.copy( st3.stItem[i] );
		  }
		}
	  }
	}

    return (stLAS);
  }

  /** Method getData()
   * <p> This method will retrieve data
   * @param iLocation = Location of Data being retrieved
   * @param iData     = Data Type being retrieved
   */

  private void getData( int iLocation, int iData)
  {
	int i=0;
    double diff   = 0.0;
    double depth1 = 0.0;
    double depth2 = 0.0;

    switch (iData)
    {
      case _HEADERS:    // Headers Data
        stHeader = iqstrat.iqstratHeadersUtility.copy(
            iqstrat.iqstratPlotLoad.getHeader(
              iLocation, pKGS, pKGSBrine, pNotesFile, p3 ));
        break;

      case _LAS3:       // LAS 3 File Data
        break;

      case _LAS:   // LAS File Data
        if (stFiles == null)
        {
          stFiles        = new cmnLASFileListStruct();
          stFiles.stItem = new cmnLASFileStruct[MAX_LOG];
          stLog          = new lasFileDataStruct[MAX_LOG];

          for (i=0; i<MAX_LOG; i++)
          {
            stFiles.stItem[i] = new cmnLASFileStruct();
            stLog[i]          = new lasFileDataStruct();
          }
		}

        if (iLog < MAX_LOG)
        {
          stLog[iLog] = las.lasFileDataUtility.copy(
	    	              iqstrat.iqstratPlotLoad.getLAS(
                            iLocation,  pKGS, pNotesFile, p3 ));

          stFiles.stItem[iLog].iType = util.utilFileIO.DIRECTORY;
          if (stLog[iLog].sReadMethod.equals("URL"))
            stFiles.stItem[iLog].iType = util.utilFileIO.URL_FILE;

          stFiles.stItem[iLog].sDirectory = new String( stLog[iLog].sDirectory );
          stFiles.stItem[iLog].sFilename  = new String( stLog[iLog].sFilename );
          stFiles.stItem[iLog].sVersion   = new String( stLog[iLog].sVersion );

          stFiles.stItem[iLog].dNull      = stLog[iLog].dNull;
          stFiles.stItem[iLog].depthStart = stLog[iLog].depthStart;
          stFiles.stItem[iLog].depthEnd   = stLog[iLog].depthEnd;
          stFiles.stItem[iLog].depthStep  = stLog[iLog].depthStep;

//las.lasFileDataUtility.print(stLog[iLog]);
          iLog++;
          stFiles.iCount = iLog;
	    }
        break;

      case _SHALE:  // Shale gamma ray limits
        iqstratShaleListStruct stShl = null; // Shale List Structure

        stShl = iqstrat.iqstratShaleUtility.copyList(
                    iqstrat.iqstratPlotLoad.getShale(
                      iLocation, pKGS, p3 ));

        if (stShl != null)
        {
		  for (i=0; i<stShl.iCount; i++)
		  {
		    stShale = iqstrat.iqstratShaleUtility.add( stShale, stShl.stItem[i] );
		  }
		}
        break;

      case _BRINE:
        stBrine = brine.brineUtility.copyList(
			        iqstrat.iqstratPlotLoad.getBrine(
                       iLocation, pMapBrineData, pKGSBrine, p3 ));
        break;

      case _ROCK:       // Rock Data
        int iSamples = 0;
        int icnt     = 0;
        rockDataListStruct  stC[] = null; // Measured Rock Data

        stC    = new rockDataListStruct[2];
        stC[0] = new rockDataListStruct();
        stC[1] = new rockDataListStruct();

        if (stCore != null)
        {
		  stC[0] = rock.rockDataUtility.copyList( stCore );
		  icnt++;

          stC[1] = rock.rockDataUtility.copyList(
                   iqstrat.iqstratPlotLoad.getRock(
                     iLocation, pMapRockData, pKGS, p3 ));

          if (stC[1] != null)
          {
            icnt++;

            for (i=0; i<icnt; i++)
            {
              iSamples = iSamples + stC[i].iCount;
            }

            if (iSamples > 0)
            {
              stCore        = new rockDataListStruct();
              stCore.stItem = new rockDataStruct[iSamples];
              stCore.iCount = iSamples;

              for (i=0; i<iSamples; i++)
              {
                stCore.stItem[i] = new rockDataStruct();
              }
            }

            for (i=0; i<icnt; i++)
            {
              stCore = las3.las3LoadCoreData.mergeCoreData( stC[i], stCore );
            }
	      }
		}
		else
		{
          stCore = rock.rockDataUtility.copyList(
                   iqstrat.iqstratPlotLoad.getRock(
                     iLocation, pMapRockData, pKGS, p3 ));
	    }

        for (i=0; i<2; i++)
        {
		  if (stC[i] != null)
            stC[i].delete();
          stC[i] = null;
	    }
        stC = null;

        if (stCore != null)
        {
          if ((stCore._LITHO > -1) || (stCore._ENV > -1))
          {
            getData( _ROCK_DATA, _REMARKS );    // Remarks/Comments/Notes
            if (stRemarks != null)
            {
              if (stRemarks.iCount > 0) getGeoReportData();
            }
          }
        }
        break;

      case _ROCK_IMAGES: // Rock Images
        stImages = rock.rockImagesUtility.copyList(
                     iqstrat.iqstratPlotLoad.getImages(
                       iLocation, pKGS, pNotesFile, p3 ));
        break;

      case _TOPS:       // Tops Data
        stratListStruct  stT = null; // Tops List Data

        stT = horizon.strat.stratUtility.copyList(
                    iqstrat.iqstratPlotLoad.getTops(
                      iLocation, stStruct, pMapRegions,
                      pKGS, pNotesFile, p3, stKGSMeas ));

	    if (stT != null)
	    {
		  for (i=0; i<stT.iCount; i++)
		  {
		    stStrat = horizon.strat.stratUtility.add( stT.stItem[i], stStrat );
		  }
		}
        break;

      case _SEQ_STRAT:  // Sequence Stratigraphy
        seqListStruct stSq = null; // Sequence Strat List

        stSq = horizon.seq.seqUtility.copyList(
                       iqstrat.iqstratPlotLoad.getSeqStrat(
                         iLocation, pKGS, pNotesFile, p3 ));

	    if (stSq != null)
	    {
		  for (i=0; i<stSq.iCount; i++)
		  {
		    stSequence = horizon.seq.seqUtility.add( stSq.stItem[i], stSequence );
		  }
		}
        break;

      case _DEP_ENV:  // Depositional Environment
        envListStruct stEnv = null;

        stEnv = horizon.env.envUtility.copyList(
                 iqstrat.iqstratPlotLoad.getDepEnv(
					 iLocation, stStruct, p3, stRemarks ));
//					 iLocation, stStruct, pMapDepEnv, p3, stRemarks ));

	    if (stEnv != null)
	    {
		  for (i=0; i<stEnv.iCount; i++)
		  {
		    stDepEnv = horizon.env.envUtility.add( stEnv.stItem[i], stDepEnv );
		  }
		}
        break;

      case _PERFORATION: // Perforations
        regionsListStruct stO = null; // DST & Perforations

        stO = horizon.regions.regionsUtility.copyList(
                  iqstrat.iqstratPlotLoad.getPerf(
                     iLocation, pKGS, pNotesFile, p3 ));

	    if (stO != null)
	    {
		  for (i=0; i<stO.iCount; i++)
		  {
		    stOther = horizon.regions.regionsUtility.add( stO.stItem[i], stOther );
		  }
		}
        break;

      case _PFEFFER:       // PfEFFER Data
        break;

      case _ROCK_COLUMN:
        stColumn = lith.rock.rockColumnUtility.copyList(
			         iqstrat.iqstratPlotLoad.getRockColumn(
						 stStruct, stRemarks ));
        break;

      case _LITHOLOGY:  // Rock Lithology
        stLithology = lith.lithology.lithologyUtility.copyList(
                iqstrat.iqstratPlotLoad.getLithology(
                  iLocation, stStruct, pKGS, pNotesFile, p3, stRemarks ));
        break;

      case _TEXTURE:  // Rock Texture
        stTexture = lith.texture.textureUtility.copyList(
                iqstrat.iqstratPlotLoad.getTexture(
                  iLocation, stStruct, pKGS, pNotesFile, p3, stRemarks ));
        break;

      case _ROCK_PHI:  // Rock Porosity
        stPHI = rock.phi.phiUtility.copyList(
               iqstrat.iqstratPlotLoad.getPorosity(
                 iLocation, stStruct, pKGS, pNotesFile, p3, stRemarks ));
        break;

      case _SED_STRUCT: // Sedimentary Structure
        stSedimentary = rock.sedimentary.sedimentaryUtility.copyList(
                iqstrat.iqstratPlotLoad.getSedStruct(
                  iLocation, stStruct, pKGS, pNotesFile, p3, stRemarks ));
        break;

      case _FOSSILS: // Fossils
        stFossil = rock.fossil.fossilUtility.copyList(
                iqstrat.iqstratPlotLoad.getFossils(
                  iLocation, stStruct, pKGS, pNotesFile, p3, stRemarks ));
        break;

      case _BIO_STRAT: // Bio stratigraphy
        stBio = horizon.bio.bioStratUtility.copyList(
		  iqstrat.iqstratPlotLoad.getGeneraList(
            iLocation, stStruct, pKGS, pNotesFile, p3, stRemarks ));
        break;

      case _ROCK_COLOR: // Rock Color
        stRockColor = rock.color.rockColorUtility.copyList(
                iqstrat.iqstratPlotLoad.getColor(
                  iLocation, stStruct, pKGS, pNotesFile, p3, stRemarks ));
        break;

      case _REMARKS: // Remarks/Comments
        iqstratRemarkListStruct stRe = null; // Remarks Data

        stRe = iqstrat.iqstratRemarkUtility.copyList(
                iqstrat.iqstratPlotLoad.getRemarks(
                  iLocation, stCore, pKGS, pNotesFile, p3, stKGSMeas ));

	    if (stRe != null)
	    {
		  for (i=0; i<stRe.iCount; i++)
		  {
		    stRemarks = iqstrat.iqstratRemarkUtility.add( stRe.stItem[i], stRemarks );
		  }
		}
        break;
    }
  }

  /** Method getMeasuredSections()
   * <p> This method will retrieve the Measured Sections Data and load the data
   *     into the respective data structures
   */

  private void getMeasuredSections()
  {
    kgsMeasSectStruct stData = null;

    closeData(); // Close all previous data structures

    if (pMeasSect != null)
    {
      stData = pMeasSect.getData();

      if (stData != null)
      {
        // Get Header information data from Measured Section

        stHeader = iqstrat.iqstratHeadersUtility.setHeaders(
                       kgs.kgsMeasSectUtility.copy(stData) );
        stHeader.sName = new String( "KGS Measured Section (" +
                                     stHeader.sKID + ")");

        // Get Measured Section Data

        stKGSMeas = kgs.kgsMeasSectUtility.copyList(
                      kgs.io.kgsMeasSectRead.readData( stData.sKID ));

        getData( _MEAS_SECT,  _TOPS );       // Kansas Stratigraphic Units
        getData( _MEAS_SECT,  _REMARKS );    // Comments/Remarks/Descriptions

        getGeoReportData();

        stKGSMeas.delete();
        stKGSMeas = null;
      }

      pMeasSect.close();
      pMeasSect = null;
    }
  }

  /** Method getGeoReport()
   * <p> This method will retrieve the Geologist Report of Core, Outcrop
   *     descriptions, mudreports, etc.
   */

  private void getGeoReport()
  {
    closeOBSData(); // Close all observational data structures

    if (stStrat == null)
    {
      getData( _NOTES, _TOPS );     // Formation Tops
    }
    else if (stStrat.iCount == 0)
    {
      getData( _NOTES, _TOPS );     // Formation Tops
    }

    getData( _NOTES, _REMARKS );    // Remarks/Comments/Notes

    getGeoReportData();

    if (pNotesFile != null)
      pNotesFile.close();
    pNotesFile = null;
  }

  /** Method getGeoReportData()
   * <p> This method will compute the Geologist Report Data tracks if the
   *     tracks are empty
   */

  private void getGeoReportData()
  {
    if (stRemarks != null)
    {
      // Rock Column Lithology
      if (stColumn == null)      getData( _GEO_REPORT, _ROCK_COLUMN );
      // Fossils
      if (stFossil == null)      getData( _GEO_REPORT, _FOSSILS );
      // Bio Stratigraphy
      if (stBio == null)         getData( _GEO_REPORT, _BIO_STRAT );
      // Sedimentary Structures
      if (stSedimentary == null) getData( _GEO_REPORT, _SED_STRUCT );
      // Rock Color
      if (stRockColor == null)   getData( _GEO_REPORT, _ROCK_COLOR );
      // Porosity Type
      if (stPHI == null)         getData( _GEO_REPORT, _ROCK_PHI );
      // Depositional Environment
//      if (stDepEnv == null)      getData( _GEO_REPORT, _DEP_ENV ); // Not Properly Parsing 26 Nov 2012
    }
  }

  /* ===================================================================== *
   * -------------------------- SET METHODS ------------------------------ *
   * ===================================================================== */

  /** Method setButtons()
   *  <p> This method will set the Profile Plot buttons depending on the
   *      selected data.
   */

  private void setButtons()
  {
	int iContinue = 0;

	if ((iLog > 0) && (stCore == null) && (stRemarks == null))
	{
      iAction = cmn.cmnStruct._LAS;
	  rbLAS.setSelected(true);
	}

    if ((iLog == 0) && (stStrat != null) &&
        (stCore == null) && (stRemarks == null))
    {
      iAction = cmn.cmnStruct._TOPS;
      rbTOP.setSelected(true);  // Horizon Plot Track
    }

    if ((iLog == 0) && (stRemarks != null))
    {
	  iAction = cmn.cmnStruct._ROCK;
      rbGEO.setSelected(true);  // Geologist Report Plot Track
    }

    if ((iLog == 0) && ((stCore != null) ||
        ((stCore != null) && (stRemarks != null))))
    {
      iAction = cmn.cmnStruct._CORE;
      rbROCK.setSelected(true);  // Rock Data Plot Track
    }

	if ((iLog > 0) && ((stCore != null) || (stRemarks != null)))
	{
      iAction = cmn.cmnStruct._LAS3;
      rbALL.setSelected(true);  // All Plot Tracks
    }

     btnContinue.setEnabled(false);

     for(int i=0; i<_TOTAL; i++)
     {
	   if ((i != 0) && (i != 6))
	   {
		 if (ARRAY_TEXT[i][1].equals(EMPTY))
		 {
		   iContinue = 1;
		 }
	   }
	 }

	 if (iContinue == 1)
	 {
       btnContinue.setEnabled(true);
	 }
	 else if ((iWait == 0) && (iContinue == 0))
	 {
	   lblWait.setText( "Please select an ICON above to enter Data." );
	 }

     if ((iWait == 0) && (iContinue == 1))
	 {
	   lblWait.setText( "" );
	 }
  }

  /** Method setTable()
   *  <p> This will set the data settings
   */

  private void setTable()
  {
    for (int i=0; i<_TOTAL; i++)
    {
	  for (int j=1; j<_COLS; j++)
	  {
		if ((i!=0) && (i!=_TABLE_ROW))
	    lbl[i][j].setText( ARRAY_TEXT[i][j] );
	    if (ARRAY_TEXT[i][j].equals(YES))
	    {
		  lbl[i][j].setForeground(Color.blue);
		}
	  }
	}
  }

  /** Method setDepthScale()
   *  <p> This method will set the depth range & scale depending
   *      on the data loaded.
   */

  private void setDepthScale()
  {
	double diff = 0.0;

    if (stControl == null)
      stControl = new iqstratControlStruct();

	if (stBrine != null)
	{
      stControl.depthStart = stBrine.depthStart;
      stControl.depthEnd   = stBrine.depthEnd;
	}

    if (stRemarks != null)
    {
      stControl.depthStart = stRemarks.depthStart;
      stControl.depthEnd   = stRemarks.depthEnd;
	}

	if (stCore != null)
	{
      stControl.depthStart = stCore.depthStart;
      stControl.depthEnd   = stCore.depthEnd;
	}

	if (stLAS != null)
	{
      stControl.depthStart = stLAS.depthStart;
      stControl.depthEnd   = stLAS.depthEnd;
	}

    diff = stControl.depthEnd - stControl.depthStart;
    if (diff < 10)
      stControl.iScale = iqstrat.iqstratTracksStruct.SCALE_1;
    else if (diff < 20)
      stControl.iScale = iqstrat.iqstratTracksStruct.SCALE_2;
    else if (diff < 50)
      stControl.iScale = iqstrat.iqstratTracksStruct.SCALE_5;
    else if (diff < 100)
      stControl.iScale = iqstrat.iqstratTracksStruct.SCALE_10;
    else if (diff < 200)
      stControl.iScale = iqstrat.iqstratTracksStruct.SCALE_20;
    else if (diff < 500)
      stControl.iScale = iqstrat.iqstratTracksStruct.SCALE_50;
    else
      stControl.iScale = iqstrat.iqstratTracksStruct.SCALE_100;
  }

  /** Method clear()
   * <p> This method will clear the data structures
   */

  private void clear()
  {
    closeData();

    stFiles        = new cmnLASFileListStruct();
    stFiles.stItem = new cmnLASFileStruct[MAX_LOG];
    stLog          = new lasFileDataStruct[MAX_LOG];

    for (int i=0; i<MAX_LOG; i++)
    {
      stFiles.stItem[i] = new cmnLASFileStruct();
      stLog[i]          = new lasFileDataStruct();
    }

  	txtLAS1.setText( "" );   // LAS File 1
   	txtLAS2.setText( "" );   // LAS File 2
   	txtLAS3.setText( "" );   // LAS File 3

    txtASCII1.setText( "" ); // Tops CSV File
    txtASCII2.setText( "" ); // Rock CSV File
    txtASCII3.setText( "" ); // Geo-Report File
    txtASCII4.setText( "" ); // Brine CSV File
    txtASCII5.setText( "" ); // Depostional Environment CSV File
    txtASCII6.setText( "" ); // Fossil Genera CSV File

    for (int i=0; i<_TOTAL; i++)
    {
	  for (int j=1; j<_COLS; j++)
	  {
		if ((i!=0) && (i!=_TABLE_ROW))
		{
	      if (j == _NO_C)
	      {
			ARRAY_TEXT[i][_NO_C] = new String( NO );
		  }
	      else
	      {
		    ARRAY_TEXT[i][j] = new String( EMPTY );
		  }
	    }
	  }
	}

    iAction = cmn.cmnStruct._ROCK;
    rbGEO.setSelected(true);  // Geologist Report Plot Track

	setTable();
  }

  /* ===================================================================== *
   * ------------------------- SEARCH DIALOGS ---------------------------- *
   * ===================================================================== */

  /** Method search_TOPS()
   * <p> This method will search for a Tops File that is on the user's PC
   */

  private void search_TOPS()
  {
    FileDialog dialog      = null;
    Frame      frameTemp   = new Frame();
    String     sReadMethod = null;
    String     sDirectory  = null;
    String     sFilename   = null;

    dialog = new FileDialog(frameTemp,
             "Select Formation Tops Comma Delimited File from your PC.");
    dialog.setVisible(true);
    frameTemp.setVisible(true);

    // Retrieve LAS File Location

    if ((dialog.getDirectory() != null) && (dialog.getFile() != null))
    {
      sReadMethod = new String("FILE");
      sDirectory  = new String(dialog.getDirectory());
      sFilename   = new String(dialog.getFile());

      txtASCII1.setText( sFilename );

      if (pMapRegions != null)
        pMapRegions.close();
      pMapRegions = null;

      pMapRegions = new regionsMapCSVFrame( notifier,
                                            sReadMethod,
                                            sDirectory,
                                            sFilename );
    }

    // Dispose of Temporary Dialog & Frame

    frameTemp.dispose();
    frameTemp = null;

    dialog.dispose();
    dialog = null;
  }

  /** Method import_DEP_ENV()
   * <p> This method will search for a Tops File that is on the user's PC
   *

  private void import_DEP_ENV()
  {
    FileDialog dialog      = null;
    Frame      frameTemp   = new Frame();
    String     sReadMethod = null;
    String     sDirectory  = null;
    String     sFilename   = null;

    dialog = new FileDialog(frameTemp,
             "Import Depositional Environment Comma Delimited File from your PC.");
    dialog.setVisible(true);
    frameTemp.setVisible(true);

    // Retrieve LAS File Location

    if ((dialog.getDirectory() != null) && (dialog.getFile() != null))
    {
      sReadMethod = new String("FILE");
      sDirectory  = new String(dialog.getDirectory());
      sFilename   = new String(dialog.getFile());

      txtASCII5.setText( sFilename );

      if (pMapDepEnv != null)
        pMapDepEnv.close();
      pMapDepEnv = null;

      pMapDepEnv = new envMapCSVFrame( notifier,
                                       sReadMethod,
                                       sDirectory,
                                       sFilename,
                                       stStruct.stParseDepEnv );
    }

    // Dispose of Temporary Dialog & Frame

    frameTemp.dispose();
    frameTemp = null;

    dialog.dispose();
    dialog = null;
  }

  /** Method search_ROCK_DATA()
   * <p> This method will search for a Rock Data File that is on the user's PC
   */

  private void search_ROCK_DATA()
  {
    FileDialog dialog      = null;
    Frame      frameTemp   = new Frame();
    String     sReadMethod = null;
    String     sDirectory  = null;
    String     sFilename   = null;

    dialog = new FileDialog(frameTemp,
             "Select Rock Data Comma Delimited File from your PC.");
    dialog.setVisible(true);
    frameTemp.setVisible(true);

    // Retrieve LAS File Location

    if ((dialog.getDirectory() != null) && (dialog.getFile() != null))
    {
      sReadMethod = new String("FILE");
      sDirectory  = new String(dialog.getDirectory());
      sFilename   = new String(dialog.getFile());

      txtASCII2.setText( sFilename );

      if (pMapRockData != null)
        pMapRockData.close();
      pMapRockData = null;

      pMapRockData = new rockMapCSVFrame( notifier,
                                          sReadMethod,
                                          sDirectory,
                                          sFilename );
    }

    // Dispose of Temporary Dialog & Frame

    frameTemp.dispose();
    frameTemp = null;

    dialog.dispose();
    dialog = null;
  }

  /** Method search_BRINE_DATA()
   * <p> This method will search for a Brine Data File that is on the user's PC
   */

  private void search_BRINE_DATA()
  {
    FileDialog dialog      = null;
    Frame      frameTemp   = new Frame();
    String     sReadMethod = null;
    String     sDirectory  = null;
    String     sFilename   = null;

    dialog = new FileDialog(frameTemp,
             "Select Brine Data Comma Delimited File from your PC.");
    dialog.setVisible(true);
    frameTemp.setVisible(true);

    // Retrieve LAS File Location

    if ((dialog.getDirectory() != null) && (dialog.getFile() != null))
    {
      sReadMethod = new String("FILE");
      sDirectory  = new String(dialog.getDirectory());
      sFilename   = new String(dialog.getFile());

      txtASCII4.setText( sFilename );

      if (pMapBrineData != null)
        pMapBrineData.close();
      pMapBrineData = null;

      pMapBrineData = new brineMapCSVFrame( notifier,
                                            sReadMethod,
                                            sDirectory,
                                            sFilename );
    }

    // Dispose of Temporary Dialog & Frame

    frameTemp.dispose();
    frameTemp = null;

    dialog.dispose();
    dialog = null;
  }

  /** Method searchNotes()
   * <p> This method will search the User's PC for a Notes file to be parsed
   *     into the rock description data fields
   */

  private void searchNotes()
  {
    FileDialog dialog      = null;
    Frame      frameTemp   = new Frame();
    String     sReadMethod = null;
    String     sDirectory  = null;
    String     sFilename   = null;

    dialog = new FileDialog(frameTemp,
             "Select Geologist Report Delimited File from your PC.");
    dialog.setVisible(true);
    frameTemp.setVisible(true);

    // Retrieve LAS File Location

    if ((dialog.getDirectory() != null) && (dialog.getFile() != null))
    {
      iWait = 1;
	  lblWait.setText( "*** Please Wait -- Loading Geo-Report File Data ***" );

      sReadMethod = new String("FILE");
      sDirectory  = new String(dialog.getDirectory());
      sFilename   = new String(dialog.getFile());

      txtASCII3.setText( sFilename );

      if (pNotesFile != null)
        pNotesFile.close();
      pNotesFile = null;

      pNotesFile = new iqstratNotesCSVFrame(
           notifier, sReadMethod, sDirectory, sFilename, stStruct, stHeader );
    }

    // Dispose of Temporary Dialog & Frame

    frameTemp.dispose();
    frameTemp = null;

    dialog.dispose();
    dialog = null;
  }

  /** Method searchKGS()
   * <p> This method will open the Search PC Dialog to allow the user to
   *     retrieve Digital LAS File & Formation Tops Comma Delimited File
   *     from their PC.
   */

  private void searchKGS()
  {
    if (pKGS != null)
      pKGS.close();
    pKGS = null;

    pKGS = new kgsSearchKGSFrame( stStruct, notifier );
  }

  /** Method searchKGSMeasSect()
   * <p> This method will open the Search PC Dialog to allow the user to
   *     retrieve Digital LAS File & Formation Tops Comma Delimited File
   *     from their PC.
   */

  private void searchKGSMeasSect()
  {
    if (pMeasSect != null)
      pMeasSect.close();
    pMeasSect = null;

    pMeasSect = new kgsMeasSectFrame( notifier );
  }

  /** Method searchKGSBrine ()
   * <p> This method will open the Search PC Dialog to allow the user to
   *     retrieve Digital LAS File & Formation Tops Comma Delimited File
   *     from their PC.
   */

  private void searchKGSBrine()
  {
    if (pKGSBrine != null)
      pKGSBrine.close();
    pKGSBrine = null;

    pKGSBrine = new kgsBrineFrame( notifier );
  }

  /* ===================================================================== *
   * --------------------------- LOAD DATA ------------------------------- *
   * ===================================================================== */

  /** Method loadData()
   * <p> This method will load the data
   */

  private void loadData()
  {
    if (pControl != null)
      pControl.close();
    pControl = null;

    getLAS();
    setDepthScale();

    if (stLAS != null)
      stLAS.delete();
    stLAS  = null; // LAS File Data Structure

    pControl = new iqstratControlPlotFrame( stStruct, iAction );

    if (pControl != null)
    {
      pControl.setData(
              iqstrat.iqstratControlUtility.copy( stControl ),
              iqstrat.iqstratHeadersUtility.transfer( stHeader ),
              // LAS Data
              cmn.cmnLASFileUtility.transfer( stFiles ),
              las.lasFileDataUtility.transfer( getLAS() ),
              iqstrat.iqstratShaleUtility.transfer( stShale ),
              // Horizon Data
              horizon.strat.stratUtility.transfer( stStrat ),
              horizon.seq.seqUtility.transfer( stSequence ),
              horizon.regions.regionsUtility.transfer( stOther ),
              horizon.env.envUtility.transfer( stDepEnv ),
              // Bio Stratigraphy Data
              horizon.bio.bioStratUtility.transfer( stBio ),
              // Brine Data
              brine.brineUtility.transfer( stBrine ),
              // Rock Data
              rock.rockDataUtility.transfer( stCore ),
              rock.rockImagesUtility.transfer( stImages ),
              // Measured Sections / Sample Log Cuttings Reports
              lith.rock.rockColumnUtility.transfer( stColumn ),
//              lith.lithology.lithologyUtility.copyList( stLithology ),
//              lith.texture.textureUtility.copyList( stTexture ),
              rock.phi.phiUtility.transfer( stPHI ),
              rock.fossil.fossilUtility.transfer( stFossil ),
              rock.sedimentary.sedimentaryUtility.transfer( stSedimentary ),
              rock.color.rockColorUtility.transfer( stRockColor ),
              iqstrat.iqstratRemarkUtility.transfer( stRemarks ));

      clear();
    }

    setButtons();

    pControl.setFront();
  }

  /* ===================================================================== *
   * ----------------------------- CLOSE --------------------------------- *
   * ===================================================================== */

  /** Method closeData()
   * <p> This method will clear the data structures
   */

  private void closeData()
  {
	if (iLog > 0)
	{
	  for (int i=0; i<iLog; i++)
	  {
		if (stLog[i] != null)
		  stLog[i].delete();
	    stLog[i] = null;
	  }

	  iLog = 0;
	}

    if (stFiles != null)
      stFiles.delete();
    stFiles = null;       // LAS File Information

    if (stHeader != null)
      stHeader.delete();
    stHeader = null;      // Header Information Data

    // LAS Data

    if (stLAS != null)
      stLAS.delete();
    stLAS  = null;        // LAS File Data Structure

    if (stShale != null)
      stShale.delete();
    stShale = null;       // Shale Gamma Ray Limits

    // Horizons Data

    if (stStrat != null)
      stStrat.delete();
    stStrat = null;       // Stratigraphic Units

    if (stSequence != null)
      stSequence.delete();
    stSequence = null;    // Sequence Stratigraphy

    if (stOther != null)
      stOther.delete();
    stOther = null;       // DST & Perforations

    if (stDepEnv != null)
      stDepEnv.delete();
    stDepEnv      = null; // Depositional Environment

	if (stBio != null)
	  stBio.delete();
	stBio = null;         // Bio Stratigraphy Data

    // Brine Data

    if (stBrine != null)
      stBrine.delete();
    stBrine = null;       // Brine Data

    // Rock Data

    if (stCore != null)
      stCore.delete();
    stCore = null;        // Measured Rock Data List Structure

    if (stImages != null)
      stImages.delete();
    stImages = null;      // Rock Image Data

    if (stLithology != null)
      stLithology.delete();
    stLithology = null;   // Rock Column

    if (stTexture != null)
      stTexture.delete();
    stTexture    = null;  // Rock Texture

    if (stPHI != null)
      stPHI.delete();
    stPHI = null;         // Porosity Track data

    if (stFossil != null)
      stFossil.delete();
    stFossil = null;      // Fossils

    if (stSedimentary != null)
      stSedimentary.delete();
    stSedimentary = null; // Sedimentary Structure

    if (stRockColor != null)
      stRockColor.delete();
    stRockColor = null;   // Rock Color Data

    if (stRemarks != null)
      stRemarks.delete();
    stRemarks = null;     // Remarks

    if (stKGSMeas != null)
      stKGSMeas.delete();
    stKGSMeas = null;     // KGS Measured Sections

    if (stColumn != null)
      stColumn.delete();
    stColumn      = null; // Rock Column Data List
  }

  /** Method closeOBSData()
   * <p> This method will release the well or outcrop data to load a new data
   *     set.
   */

  public void closeOBSData()
  {
    if (stTexture != null)
      stTexture.delete();
    stTexture    = null;    // Rock Texture

    if (stPHI != null)
      stPHI.delete();
    stPHI = null;           // Porosity Track data

    if (stFossil != null)
      stFossil.delete();
    stFossil = null;        // Fossils

	if (stBio != null)
	  stBio.delete();
	stBio = null;       // Bio Stratigraphy Data

    if (stSedimentary != null)
      stSedimentary.delete();
    stSedimentary = null;   // Sedimentary Structure

    if (stRockColor != null)
      stRockColor.delete();
    stRockColor = null; // Rock Color Data

    if (stRemarks != null)
      stRemarks.delete();
    stRemarks = null;       // Remarks

    if (stKGSMeas != null)
      stKGSMeas.delete();
    stKGSMeas = null;      // KGS Measured Sections

    if (stColumn != null)
      stColumn.delete();
    stColumn      = null; // Rock Column Data List
  }

  /** Method close()
   * <p> This method will close all dialogs that are opened by this class.
   */

  public void close()
  {
    // Input Variables

    stStruct = null; // Global IQSTRAT Data Structure

    // Global Variables

    notifier = null; // Observables Object

    // Load Profile Data Frames

    if (p3 != null)
      p3.delete();
    p3 = null;

    if (pMapRegions != null)
      pMapRegions.close();
    pMapRegions = null;

//    if (pMapDepEnv != null)
//      pMapDepEnv.close();
//    pMapDepEnv = null;

    if (pMapRockData != null)
      pMapRockData.close();
    pMapRockData = null;

    if (pMapBrineData != null)
      pMapBrineData.close();
    pMapBrineData = null;

    if (pNotesFile != null)
      pNotesFile.close();
    pNotesFile = null;

    if (pKGS != null)
      pKGS.close();
    pKGS = null;

    if (pMeasSect != null)
      pMeasSect.close();
    pMeasSect = null;

    if (pKGSBrine != null)
      pKGSBrine.close();
    pKGSBrine = null;

    if (pControl != null)
      pControl.close();
    pControl = null;

    // close data

    closeData();

    // Global Panel Widgets

    // -- Top Panel Widgets

    btnKGS      = null;  // KGS Icon - No Action
    btnKGS1     = null;  // KGS Well Data
    btnKGS2     = null;  // KGS Measured Sections

    btnPC       = null;  // PC Icon  - No Action
    btnPC1      = null;  // Log ASCII Stadard File
    btnPC2      = null;  // Tops CSV File
    btnPC3      = null;  // Rock CSV File
    btnPC4      = null;  // Geologist Report
    btnPC5      = null;  // Brine Data CSV File
//    btnPC6      = null;  // Depositional Environment CSV File

    lblLASFile1 = null;
    lblLASFile2 = null;
    lblLASFile3 = null;

    // -- LAS Filename Widgets

    txtLAS1     = null; // 1st LAS File
    txtLAS2     = null; // 2nd LAS File
    txtLAS3     = null; // 3rd LAS File

    // -- ASCII Filename Widgets

    txtASCII1   = null; // Tops CSV File
    txtASCII2   = null; // Rock CSV File
    txtASCII3   = null; // Geo-Report File
    txtASCII4   = null; // Brine CSV File
    txtASCII5   = null; // Depositional Environment CSV File
    txtASCII6   = null; // Fossil Genera CSV File

    // -- Data Loaded Panel Widgets

    ARRAY_TEXT = null;
    lblWait    = null;

    for (int i=0; i<_TOTAL; i++)
    {
	  for (int j=0; j<_COLS; j++)
  	  {
        lbl[i][j]  = null;
      }
    }

    // -- Base Panel Widgets

    rbALL       = null; // All Plot Tracks
    rbLAS       = null; // LAS Plot Track
    rbTOP       = null; // Horizon Plot Track
    rbROCK      = null; // Rock Data Plot Track
    rbGEO       = null; // Geologist Report Plot Track

    btnContinue = null; // Continue
    btnClear    = null; // Clear
    btnExit     = null; // Exit

    dispose();
  }

  /* ===================================================================== *
   * ---------------------------- ACTIONS -------------------------------- *
   * ===================================================================== */

  /** METHOD actionPerformed()
   *  <p> This Method will handle all the actions within the Frame.
   *  @param event - Action Event
   */

  public void actionPerformed(ActionEvent event)
  {
    if (event.getSource() == btnPC1)
    {
      if (p3 != null)
        p3.delete();
      p3 = null;

      p3 = new las3Read( notifier, stStruct );
      p3.getPath();
    }

    if (event.getSource() == btnPC2)  { search_TOPS(); }
    if (event.getSource() == btnPC3)  { search_ROCK_DATA(); }
    if (event.getSource() == btnPC4)  { searchNotes(); }
    if (event.getSource() == btnPC5)  { search_BRINE_DATA(); }
//    if (event.getSource() == btnPC6)  { import_DEP_ENV(); }

    if (event.getSource() == btnKGS1) { searchKGS(); }
    if (event.getSource() == btnKGS3) { searchKGSBrine(); }
    if (event.getSource() == btnKGS2) { searchKGSMeasSect(); }

    if (event.getSource() == rbALL)   { iAction = cmn.cmnStruct._LAS3; }
    if (event.getSource() == rbLAS)   { iAction = cmn.cmnStruct._LAS;  }
    if (event.getSource() == rbTOP)   { iAction = cmn.cmnStruct._TOPS; }
    if (event.getSource() == rbROCK)  { iAction = cmn.cmnStruct._CORE; }
    if (event.getSource() == rbGEO)   { iAction = cmn.cmnStruct._ROCK; }

    if (event.getSource() == btnContinue) { loadData(); } // Load Data
    if (event.getSource() == btnClear)    { clear(); }    // Clear Data
    if (event.getSource() == btnExit)     { close(); }    // Exit

    if ( pKGS       != null) pKGS.toFront();
    if ( pMeasSect  != null) pMeasSect.toFront();
    if ( pNotesFile != null) pNotesFile.toFront();
  }

  /* ===================================================================== *
   * ------------------------ OBSERVER ACTIONS --------------------------- *
   * ===================================================================== */

  /** Method update()
   * <p> This method will handle the Observable Actions
   * @param obj = The Observable making the call
   * @param arg = The returned object
   */

  public void update(Observable obj, Object arg)
  {
	int    j=0;
	int    icnt = -1;
    String sArg = new String( (String) arg);

    /* ------------------------------------------------------------------ *
     * --------------------- LAS LAS File Actions ----------------------- *
     * ------------------------------------------------------------------ */

    if (sArg.equals("KGS LAS File Loaded"))
    {
      getData( _KGS, _HEADERS );
      getData( _KGS, _LAS );
      getData( _KGS, _PERFORATION );

      if (iLog > 0)
      {
     	ARRAY_TEXT[_LAS_R][_NO_C]  = new String( EMPTY );
     	ARRAY_TEXT[_LAS_R][_KGS_C] = new String( YES );

     	if (iLog == 1) { txtLAS1.setText(stFiles.stItem[0].sFilename); }
     	if (iLog == 2) { txtLAS2.setText(stFiles.stItem[1].sFilename); }
     	if (iLog == 3) { txtLAS3.setText(stFiles.stItem[2].sFilename); }
      }

      if (stOther != null)
      {
     	ARRAY_TEXT[_PERF_R][_NO_C]   = new String( EMPTY );
     	ARRAY_TEXT[_PERF_R][_KGS_C]  = new String( YES );
	  }
    }

    /* ------------------------------------------------------------------ *
     * ----------------------- Brine Data Actions ----------------------- *
     * ------------------------------------------------------------------ */

    if (sArg.equals("KGS Brine Loaded"))
    {
      getData( _KGS,        _BRINE );
      getData( _BRINE_DATA, _HEADERS );

      pKGSBrine.close();

      if (stBrine != null)
      {
     	ARRAY_TEXT[_BRINE_R][_NO_C]   = new String( EMPTY );
     	ARRAY_TEXT[_BRINE_R][_KGS_C]  = new String( YES );
	  }
	}

    if (sArg.equals("Brine CSV File Loaded"))
    {
      getData( _PC,  _BRINE );
      if (stHeader != null)
        stBrine = brine.brineUtility.addHeaderData( stHeader, stBrine );

      if (stBrine != null)
      {
     	ARRAY_TEXT[_BRINE_R][_NO_C]   = new String( EMPTY );
     	ARRAY_TEXT[_BRINE_R][_CSV_C]  = new String( YES );
	  }
	}

    /* ------------------------------------------------------------------ *
     * ------------- Depositional Environment Data Actions -------------- *
     * ------------------------------------------------------------------ */
/*
    if (sArg.equals("Dep Environment CSV File Loaded"))
    {
      getData( _PC,  _DEP_ENV );

      if (stDepEnv != null)
      {
//horizon.env.envUtility.print( stDepEnv);
     	ARRAY_TEXT[_ENV_R][_NO_C]   = new String( EMPTY );
     	ARRAY_TEXT[_ENV_R][_CSV_C]  = new String( YES );
	  }
	}
*/
    /* ------------------------------------------------------------------ *
     * ----------------------- Rock Data Actions ------------------------ *
     * ------------------------------------------------------------------ */

    if (sArg.equals("Rock CSV File Loaded"))
    {
      getData( _PC,  _ROCK );

      if (stCore != null)
      {
     	ARRAY_TEXT[_ROCK_R][_NO_C]   = new String( EMPTY );
     	ARRAY_TEXT[_ROCK_R][_CSV_C]  = new String( YES );
      }

      if (stRemarks != null)
      {
     	ARRAY_TEXT[_GEO_R][_NO_C]   = new String( EMPTY );
     	ARRAY_TEXT[_GEO_R][_CSV_C]  = new String( YES );
      }
    }

    if (sArg.equals("KGS Rock Data Loaded"))
    {
      getData( _KGS, _ROCK );

      if (stCore != null)
      {
     	ARRAY_TEXT[_ROCK_R][_NO_C]   = new String( EMPTY );
     	ARRAY_TEXT[_ROCK_R][_KGS_C]  = new String( YES );
      }

      if (stRemarks != null)
      {
     	ARRAY_TEXT[_GEO_R][_NO_C]   = new String( EMPTY );
     	ARRAY_TEXT[_GEO_R][_KGS_C]  = new String( YES );
      }

      if (stDepEnv != null)
      {
     	ARRAY_TEXT[_ENV_R][_NO_C]   = new String( EMPTY );
     	ARRAY_TEXT[_ENV_R][_KGS_C]  = new String( YES );
	  }
    }

    /* ------------------------------------------------------------------ *
     * ---------------------- Rock Image Actions ------------------------ *
     * ------------------------------------------------------------------ */

    if (sArg.equals("Get Core Images"))
    {
  	  getData( _KGS, _ROCK_IMAGES );

      if (stImages != null)
      {
     	ARRAY_TEXT[_IMAGE_R][_NO_C]   = new String( EMPTY );
     	ARRAY_TEXT[_IMAGE_R][_KGS_C]  = new String( YES );
      }
  	}

    /* ------------------------------------------------------------------ *
     * ----------------------- TOPS Track Actions ----------------------- *
     * ------------------------------------------------------------------ */

    if (sArg.equals("TOPS File Loaded"))
    {
      getData( _PC, _TOPS );

      if (stStrat != null)
      {
     	ARRAY_TEXT[_TOPS_R][_NO_C]   = new String( EMPTY );
     	ARRAY_TEXT[_TOPS_R][_CSV_C]  = new String( YES );
      }
    }

    if (sArg.equals("KGS Source Selected"))
    {
      getData( _KGS, _TOPS );

      if (stStrat != null)
      {
     	ARRAY_TEXT[_TOPS_R][_NO_C]   = new String( EMPTY );
     	ARRAY_TEXT[_TOPS_R][_KGS_C]  = new String( YES );
      }
    }

    /* ================================================================== *
     * -------- Parse Comments/Remarks/Notes ASCII File Actions --------- *
     * ================================================================== */

    if (sArg.equals("CSV - Comments"))
    {
      getGeoReport();

      setDepthScale();

      if (stStrat != null)
      {
     	ARRAY_TEXT[_TOPS_R][_NO_C]   = new String( EMPTY );
     	ARRAY_TEXT[_TOPS_R][_CSV_C]  = new String( YES );
      }

      if (stRemarks != null)
      {
     	ARRAY_TEXT[_GEO_R][_NO_C]   = new String( EMPTY );
     	ARRAY_TEXT[_GEO_R][_CSV_C]  = new String( YES );
      }

      if (stBio != null)
      {
        ARRAY_TEXT[_BIO_R][_NO_C]   = new String( EMPTY );
    	ARRAY_TEXT[_BIO_R][_CSV_C]  = new String( YES );
	  }

      if (stDepEnv != null)
      {
     	ARRAY_TEXT[_ENV_R][_NO_C]   = new String( EMPTY );
     	ARRAY_TEXT[_ENV_R][_CSV_C]  = new String( YES );
	  }

      iWait = 0;
    }

    /* ================================================================== *
     * ------------------- Measured Sections Actions -------------------- *
     * ================================================================== */

    if (sArg.equals("KGS Measured Section Loaded"))
    {
      double diff = 0.0;

      getMeasuredSections();

      if (stRemarks != null)
      {
		setDepthScale();

     	ARRAY_TEXT[_GEO_R][_NO_C]   = new String( EMPTY );
     	ARRAY_TEXT[_GEO_R][_KGS_C]  = new String( YES );
      }

      if (stBio != null)
      {
        ARRAY_TEXT[_BIO_R][_NO_C]   = new String( EMPTY );
    	ARRAY_TEXT[_BIO_R][_KGS_C]  = new String( YES );
	  }

      if (stDepEnv != null)
      {
     	ARRAY_TEXT[_ENV_R][_NO_C]   = new String( EMPTY );
     	ARRAY_TEXT[_ENV_R][_KGS_C]  = new String( YES );
	  }
    }

    /* ================================================================== *
     * ------------------- LAS Version 3 Read Actions ------------------- *
     * ================================================================== */

    if (sArg.equals("LAS 3 - Loading Data"))
    {
      iWait = 1;
	  lblWait.setText( "*** Please Wait -- Loading LAS 3.0 File Data ***" );
	}

    if (sArg.equals("LAS 3 - Curves Selected"))
    {
      double d3 = 2.0;

      if (p3 != null)
      {
//        closeOBSData(); // Close all observational data structures

        getData( _LAS_3_FILE, _HEADERS );      // Header Information
        getData( _LAS_3_FILE, _LAS );          // Log Data
        getData( _LAS_3_FILE, _TOPS );         // Formation Tops
        getData( _LAS_3_FILE, _SEQ_STRAT );    // Sequence Stratigraphy
        getData( _LAS_3_FILE, _PERFORATION );  // Perforation
        getData( _LAS_3_FILE, _SHALE );        // Shale Limits

        // Rock Porosity Type

//        getData( _LAS_3_FILE, _ROCK_PHI );     // Rock Porosity Type

        // Depositional Environment Data

        getData( _LAS_3_FILE, _DEP_ENV );      // Depositional Environment

        // Bio-Stratigraphy Data

        getData( _LAS_3_FILE, _BIO_STRAT );    // Bio-Stratigraphy Data

        // Brine Data

        getData( _LAS_3_FILE, _BRINE );
        stBrine = brine.brineUtility.addHeaderData( stHeader, stBrine );

        // Rock Measured & Observational Data

        getData( _LAS_3_FILE, _ROCK );         // Measured Rock Data
        getData( _LAS_3_FILE, _REMARKS );      // Remarks/Comments/Notes

        // Rock Images

    	getData( _LAS_3_FILE, _ROCK_IMAGES );  // Rock Images

        // Other Rock Data

//        getData( _LAS_3_FILE, _LITHOLOGY );    // Rock Lithology
//        getData( _LAS_3_FILE, _TEXTURE );      // Rock Texture
//        getData( _LAS_3_FILE, _FOSSILS );      // Fossils
//        getData( _LAS_3_FILE, _SED_STRUCT );   // Sedimentary Structures
//        getData( _LAS_3_FILE, _ROCK_COLOR );   // Rock Color

        // Compute Rock Image Tracks from Remarks Data

        getGeoReportData();

        // Set the Plot Controls

        stControl = iqstrat.iqstratControlUtility.copy( p3.getControlData() );
        if (stControl == null) stControl = new iqstratControlStruct();
        stControl = iqstrat.iqstratControlUtility.addHeaders(
                      stHeader, stControl );

        // Set Table

        if (iLog > 0)
        {
		  if (cmn.cmnString.isNumeric(stLog[iLog-1].sVersion))
		  {
		    d3 = cmn.cmnString.stringToDouble(stLog[iLog-1].sVersion);
		  }
		}

        if (iLog > 0)
        {
       	  ARRAY_TEXT[_LAS_R][_NO_C]   = new String( EMPTY );

          if (d3 == 3.0)
      	    ARRAY_TEXT[_LAS_R][_LAS_3C] = new String( YES );
          else
      	    ARRAY_TEXT[_LAS_R][_LAS_C]  = new String( YES );

          if (iLog == 1) { txtLAS1.setText(stFiles.stItem[0].sFilename); }
      	  if (iLog == 2) { txtLAS2.setText(stFiles.stItem[1].sFilename); }
     	  if (iLog == 3) { txtLAS3.setText(stFiles.stItem[2].sFilename); }
        }

        if (stImages != null)
        {
       	  ARRAY_TEXT[_IMAGE_R][_NO_C]   = new String( EMPTY );
    	  ARRAY_TEXT[_IMAGE_R][_LAS_3C] = new String( YES );
        }

        if (stOther != null)
        {
       	  ARRAY_TEXT[_PERF_R][_NO_C]   = new String( EMPTY );
    	  ARRAY_TEXT[_PERF_R][_LAS_3C] = new String( YES );
	    }

        if (stStrat != null)
        {
       	  ARRAY_TEXT[_TOPS_R][_NO_C]   = new String( EMPTY );
      	  ARRAY_TEXT[_TOPS_R][_LAS_3C] = new String( YES );
	    }

        if (stSequence != null)
        {
       	  ARRAY_TEXT[_SEQ_R][_NO_C]   = new String( EMPTY );
      	  ARRAY_TEXT[_SEQ_R][_LAS_3C] = new String( YES );
	    }

        if (stBrine != null)
        {
       	  ARRAY_TEXT[_BRINE_R][_NO_C]   = new String( EMPTY );
      	  ARRAY_TEXT[_BRINE_R][_LAS_3C] = new String( YES );
	    }

        if (stCore != null)
        {
       	  ARRAY_TEXT[_ROCK_R][_NO_C]   = new String( EMPTY );
      	  ARRAY_TEXT[_ROCK_R][_LAS_3C] = new String( YES );
	    }

        if (stRemarks != null)
        {
       	  ARRAY_TEXT[_GEO_R][_NO_C]   = new String( EMPTY );
          ARRAY_TEXT[_GEO_R][_LAS_3C] = new String( YES );
	    }

        if (stDepEnv != null)
        {
     	  ARRAY_TEXT[_ENV_R][_NO_C]   = new String( EMPTY );
     	  ARRAY_TEXT[_ENV_R][_LAS_3C] = new String( YES );
	    }

        if (stBio != null)
        {
          ARRAY_TEXT[_BIO_R][_NO_C]   = new String( EMPTY );
     	  ARRAY_TEXT[_BIO_R][_LAS_3C] = new String( YES );
	    }

        iWait = 0;

        p3.delete();
        p3 = null;
      }
    }

	setTable();
	setButtons();
  }
}

/** CLASS iqstratStartFrameObservable()
  *  <p> This Class will handle Observable Actions when action occurs on a
  *      frame or panel
  */

class iqstratStartFrameObservable extends Observable
{
  public void notifyObservers(Object b)
  {
    setChanged();
    super.notifyObservers(b);
  }
}

/*
 *  @version 1.1 05/05/2011
 *  @author  John Victorine
 */
