/*
 * @iqstratStartAppPanel.java Version 1.1 05/05/2011
 *
 * Copyright (c) 2011 Kansas Geological Survey
 * 1930 Constant Avenue, Lawrence, Kansas, 66047, U.S.A.
 * All Rights Reserved.
 */

package iqstrat.gui;

import java.awt.*;
import java.awt.image.*;
import java.awt.event.*;
import javax.swing.*;
import javax.swing.event.*;
import javax.swing.border.*;

import iqstrat.iqstratStruct;
import iqstrat.gui.iqstratStartFrame;

/** Class iqstratStartAppPanel
 *  <p> This Class Starting Panel for this web application
 *
 *  @version 1.1 05/05/2011
 *  @author  John R. Victorine
 */

public class iqstratStartAppPanel extends JPanel implements ActionListener
{
  // Input Variables

  private JFrame         parent   = null;  // Frame calling this panel
  private iqstratStruct  stStruct = null;  // Global IQSTRAT Data Structure

  // Global Variable

  iqstratStartFrame      frame    = null;

  // Global Panel Widgets

  private JButton        btn      = null;
  private JButton        btnExit  = new JButton();

  /** Constructor iqstratStartAppPanel( JFrame parent, iqstratStruct stStruct )
   *  <p> This is the Constructor for this class.
   *  @param parent   = the frame calling this panel
   *  @param stStruct = Global IQSTRAT Data Structure
   */

  public iqstratStartAppPanel( JFrame parent, iqstratStruct stStruct )
  {
    try
    {
      this.parent   = parent;
      this.stStruct = stStruct;

      jbInit();
    }
    catch(Exception ex)
    {
      ex.printStackTrace();
    }
  }

  /** METHOD jbInit()
   *  <p> This Method will create the Panel for this class.
   *  @throws Exception
   */

  private void jbInit() throws Exception
  {
    JPanel pnlCenter = new JPanel();
    JPanel pnlBase   = new JPanel();

    JLabel lbl       = new JLabel();

    // Build Panel

    this.setLayout( new BorderLayout() );
    this.setBackground(Color.white);

    pnlCenter.setLayout( new BorderLayout() );
    pnlCenter.setBackground(Color.white);

    btn = new JButton( createImageIcon( cmn.cmnStruct.PROFILE_APP) ); //WEB_APP ) );
    btn.setBackground(Color.white);
    btn.addActionListener( this );

    lbl.setHorizontalAlignment(SwingConstants.CENTER);
    lbl.setFont(new java.awt.Font("Dialog", 1, 20));
    lbl.setBackground(Color.white);
    lbl.setText("Enter");

    pnlBase.setLayout( new GridLayout() );
    pnlBase.setBackground(Color.white);

    btnExit.setFont(new java.awt.Font("Dialog", 1, 11));
    btnExit.setText("Exit");
    btnExit.addActionListener(this);

    // Add Widgets to Panel

    this.add( pnlCenter,    BorderLayout.CENTER );
    pnlCenter.add( btn,     BorderLayout.CENTER );
    pnlCenter.add( lbl,     BorderLayout.SOUTH );

    if (parent != null)
    {
      this.add( pnlBase,    BorderLayout.SOUTH );
      pnlBase.add( btnExit, null );
    }
  }

  /** METHOD createImageIcon()
   *  <p> This Method will create the Frame for this class.
   *  @param path = the path to the image
   *  @return image icon
   */

  protected ImageIcon createImageIcon(String path)
  {
    java.net.URL imgURL = getClass().getResource(path);
    ImageIcon    image  = null;

    if (imgURL != null)
    {
      image = new ImageIcon(imgURL);
    }
    else
    {
       System.err.println("Couldn't find file: " + path);
    }

    return (image);
  }

  /* ===================================================================== *
   * ---------------------------- ACTIONS -------------------------------- *
   * ===================================================================== */

  /** Method close()
   * <p> This method will close all dialogs that are opened by this class.
   */

  public void close()
  {
    // Input Variables

    stStruct = null;  // Global IQSTRAT Data Structure

    if (frame != null)
      frame.close();
    frame    = null;

    // Global Panel Widgets

    btn      = null;
    btnExit  = null;

    if (parent != null)
    {
      parent.dispose();
      parent = null;

      System.exit(0);
    }
  }

  /** METHOD actionPerformed()
   *  <p> This Method will handle all the actions within the Frame.
   *  @param event - Action Event
   */

  public void actionPerformed(ActionEvent event)
  {
    if (event.getSource() == btn)
    {
      if (frame != null)
        frame.close();
      frame    = null;

      frame = new iqstratStartFrame( stStruct );
	}

    if (event.getSource() == btnExit)
    {
	  close();
	}
  }
}