/*
 * @iqstratShaleListTable.java Version 1.1 10/28/2007
 *
 * Copyright (c) 2007 Kansas Geological Survey
 * 1930 Constant Avenue, Lawrence, Kansas, 66047, U.S.A.
 * All Rights Reserved.
 */

package iqstrat.gui;

import java.awt.*;
import java.lang.*;
import javax.swing.*;
import javax.swing.table.*;

import gui.guiTable;

import iqstrat.iqstratShaleListStruct;
import iqstrat.iqstratShaleStruct;

/** Class iqstratShaleListTable
 *  <p> This Class will display the Formation Tops.
 *
 *  @version 1.1 10/28/2007
 *  @author  John R. Victorine
 */

public class iqstratShaleListTable
{
  private int      iRows     = 0;
  private int      iColumns  = 7;
  private String   sColumn[] = {"Start",
                                "End",
                                "Minimum",
                                "Shaly",
                                "Shale",
                                "Hot Shale",
                                "Maximum"};
  private Object   oData[][] = null;
  private guiTable pTable    = null;

  private iqstratShaleListStruct st      = null;
  private int                    iChange = 0;

  /** Constructor iqstratShaleListTable()
   *  <p> This is the Constructor for this class.
   */

  public iqstratShaleListTable()
  {
    pTable = new guiTable(0, iColumns, sColumn);
  }

  /** Constructor iqstratShaleListTable()
   *  <p> This is the Constructor for this class.
   * @param st     = The Headers List Data Structure
   */

  public iqstratShaleListTable(iqstratShaleListStruct st)
  {
    this.st = st;

    populateList();

    if (iRows > 0)
      pTable = new guiTable(0, iRows, iColumns, sColumn, oData);
    else
      pTable = new guiTable(0, iColumns, sColumn);

    if (iChange == 0)
      iRows = 0;

    if (iRows > 0)
      pTable.setSelectedRow(0);
  }

  /** Method close()
   * <p> This method will set global variables to null in order to force
   *     Java to deallocate memory
   */

  public void close()
  {
    sColumn    = null;
    oData      = null;
    pTable     = null;

    iqstratShaleListStruct st = null;
  }

  /* ===================================================================== *
   * -------------------------- SET METHODS ------------------------------ *
   * ===================================================================== */

  /** Method populateList()
   *  <p> This method will populate the Region List data.
   */

  private void populateList()
  {
    int i      = 0;
    int iCount = 0;

    iChange = 0;
    iRows   = 1;

    oData = new String[1][iColumns];
    for (i=0; i<iColumns; i++)
    {
      oData[0][i] = new String("");
    }

    if (st != null)
    {
      if (st.iCount > 0)
      {
        iChange = 1;
        oData   = new Object[st.iCount][iColumns];
        iCount  = 0;
      }

//      st = iqstrat.iqstratShaleUtility.bubbleSort(st);

      for (i=0; i<st.iCount; i++)
      {
System.out.println("A "+st.stItem[i].sKEY);
        oData[iCount][0] = new Double(st.stItem[i].depthStart); // Starting Depth
        oData[iCount][1] = new Double(st.stItem[i].depthEnd);   // Ending Depth

        oData[iCount][2] = new Double(st.stItem[i].dGammaMin);  // Minimum Gamma Ray Value
        oData[iCount][3] = new Double(st.stItem[i].dShaly);     // Start of Shaly Formation
        oData[iCount][4] = new Double(st.stItem[i].dShale);     // Start of Shale Formation
        oData[iCount][5] = new Double(st.stItem[i].dHotShale);  // Start of Hot Shale Formation
        oData[iCount][6] = new Double(st.stItem[i].dGammaMax);  // Maximum  Gamma Ray Value

        iCount++;
      }

      iRows = iCount;
    }
  }

  /** Method repopulateList()
   *  <p> This method will reload the Region List after adding, deleting from
   *      the formation name list.
   * @param st     = The Regions List Data Structure
   */

  public void repopulateList(iqstratShaleListStruct st)
  {
    this.st = st;

    populateList();

    pTable.reload(iRows, oData);

    if (iChange == 0)
      iRows = 0;

    if (iRows > 0)
      pTable.setSelectedRow(0);
  }

  /* ===================================================================== *
   * -------------------------- GET METHODS ------------------------------ *
   * ===================================================================== */

  /** Method getTotalRows()
   *  <p> This method will return the total rows in the table.
   *  @return Total Number of Rows.
   */

  public int getTotalRows() { return (iRows); }

  /** Method getRow()
   *  <p> This method will return the selected data id in the table.
   *  @return selected data id.
   */

  public int getRow() { return (pTable.getSelectedRow()); }

  /** Method getRowData()
   *  <p> This method will return the Region Data Structure of the
   *      selected row.
   *  @return stData = Region Data Structure.
   */

  public iqstratShaleStruct getRowData()
  {
    iqstratShaleStruct stData = null;

    stData = st.stItem[pTable.getSelectedRow()];

    return (stData);
  }

  /** Method getAllData()
   *  <p> This method will returns the Region List Data Structure.
   *  @return st = Region List Data Structure.
   */

  public iqstratShaleListStruct getAllData() { return (st); }

  /** Method getScrollPane()
   *  <p> This method will return the scroll pane.
   *  @return jScrollPane - Scroll Pane containing the Table.
   */

  public JScrollPane getScrollPane() { return (pTable.getScrollPane()); }
}

/*
 *  @version 1.1 10/28/2007
 *  @author  John Victorine
 */
