/*
 * @iqstratHeadersPanel.java Version 1.1 10/14/2007
 *
 * Copyright (c) 2007 Kansas Geological Survey
 * 1930 Constant Avenue, Lawrence, Kansas, 66047, U.S.A.
 * All Rights Reserved.
 */

package iqstrat.gui;

import java.awt.*;
import java.awt.event.*;
import java.util.Observable;
import javax.swing.*;
import javax.swing.event.*;
import javax.swing.border.*;

import iqstrat.iqstratStruct;
import iqstrat.iqstratHeadersListStruct;
import iqstrat.iqstratHeadersStruct;
import iqstrat.gui.iqstratStatusFrame;

import util.utilLatLongConversion;

/** Class iqstratHeadersPanel
 *  <p> This Class is the lead in to the IQSTRAT Program
 *
 *  @version 1.1 10/14/2007
 *  @author  John R. Victorine
 */

public class iqstratHeadersPanel extends JPanel implements ActionListener
{
  // Variables passed to this panel

  private JFrame        parent   = null;       // Frame calling this panel
  private Observable    notifier = null;       // Observable notifier
  private int           iType    = iqstrat.iqstratHeadersStruct.WELL;
  private iqstratHeadersStruct stData = null;  // Headers Data Structure

  // Global Variables

  private iqstratStatusFrame pStatus = null;

  // Global Widgets

  //  Identifiers

  private JTextField txtKID  = new JTextField();
  private JTextField txtKEY  = new JTextField();
  private JTextField txtName = new JTextField();
  private JTextField txtAPI  = new JTextField();
  private JButton btnStatus  = new JButton();

  // Other Well Information

  private JTextField txtOperator     = new JTextField();
  private JTextField txtOperatorCode = new JTextField();

  private JTextField txtField        = new JTextField();
  private JTextField txtFieldCode    = new JTextField();

  //  Location

  private JTextField txtState     = new JTextField();
  private JTextField txtCounty    = new JTextField();

  private JTextField txtLocation  = new JTextField();

  private JRadioButton rbNorth    = new JRadioButton();
  private JRadioButton rbSouth    = new JRadioButton();
  private JTextField txtTownship  = new JTextField();

  private JRadioButton rbEast     = new JRadioButton();
  private JRadioButton rbWest     = new JRadioButton();
  private JTextField txtRange     = new JTextField();

  private JTextField txtSection   = new JTextField();

  private JButton btnTRS2LLE      = new JButton();

  // XY Position

  private JTextField txtLatitude  = new JTextField();
  private JTextField txtLongitude = new JTextField();
  private JTextField txtUTMx      = new JTextField();
  private JTextField txtUTMy      = new JTextField();
  private JButton btnComputeUTM   = new JButton();
  private JTextField txtUTMZone   = new JTextField();

  // Z Position

  private JTextField txtDepth     = new JTextField();
  private JTextField txtGL        = new JTextField();
  private JTextField txtKB        = new JTextField();
  private JTextField txtDF        = new JTextField();

  // Comments

  private JTextArea txtComments = new JTextArea();

  /** Constructor iqstratHeadersPanel()
   *  <p> This is the Constructor for this class.
   *  @param parent   = the frame calling this panel
   *  @param notifier = Observable notifier
   *  @param iType    = the type of data processed
   *  @param stData   = Headers Data Structure
   */

  public iqstratHeadersPanel( JFrame parent,
                              Observable notifier,
                              int iType,
                              iqstratHeadersStruct stData)
  {
    try
    {
      this.parent   = parent;
      this.notifier = notifier;
      this.iType    = iType;

      if (stData == null)
        stData = new iqstratHeadersStruct();
      this.stData           = stData;
      this.stData.iType     = iType;
      this.stData.sTownship = "S";
      this.stData.sRange    = "E";

      jbInit();
    }
    catch(Exception ex)
    {
      ex.printStackTrace();
    }
  }

  /** METHOD jbInit()
   *  <p> This Method will create the Panel for this class.
   *  @throws Exception
   */

  private void jbInit() throws Exception
  {
    JPanel pnlInfo        = new JPanel();
    JPanel pnlID          = new JPanel();
    JPanel pnlKEY         = new JPanel();
    JPanel pnlKID         = new JPanel();
    JPanel pnlTopC        = new JPanel();
    JPanel pnlName        = new JPanel();
    JPanel pnlAPI         = new JPanel();
    JPanel pnlStatus      = new JPanel();
    JPanel pnl1           = new JPanel();
    JPanel pnlOther       = new JPanel();
    JPanel pnlOperator    = new JPanel();
    JPanel pnlField       = new JPanel();
    JPanel pnlOpCode      = new JPanel();
    JPanel pnlOpName      = new JPanel();
    JPanel pnlFldCode     = new JPanel();
    JPanel pnlFldName     = new JPanel();
    JPanel pnl2           = new JPanel();
    JPanel pnlLocation    = new JPanel();
    JPanel pnlStateCounty = new JPanel();
    JPanel pnlState       = new JPanel();
    JPanel pnlOutcropLoc  = new JPanel();
    JPanel pnlCounty      = new JPanel();
    JPanel pnlTRSTop      = new JPanel();
    JPanel pnlTRS         = new JPanel();
    JPanel pnlTown        = new JPanel();
    JPanel pnlSection     = new JPanel();
    JPanel pnlRange       = new JPanel();
    JPanel pnlTownNo      = new JPanel();
    JPanel pnlTownDir     = new JPanel();
    JPanel pnlRangeDir    = new JPanel();
    JPanel pnlRangeNo     = new JPanel();
    JPanel pnlTRSBase     = new JPanel();
    JPanel pnl3           = new JPanel();
    JPanel pnlXY          = new JPanel();
    JPanel pnlLatLong     = new JPanel();
    JPanel pnlLatitude    = new JPanel();
    JPanel pnlLongitude   = new JPanel();
    JPanel pnlUTM         = new JPanel();
    JPanel pnlUTMx        = new JPanel();
    JPanel pnlUTMy        = new JPanel();
    JPanel pnlUTM1        = new JPanel();
    JPanel pnlZone        = new JPanel();
    JPanel pnl4           = new JPanel();
    JPanel pnlZ           = new JPanel();
    JPanel pnlDepth       = new JPanel();
    JPanel pnlDF          = new JPanel();
    JPanel pnlKB          = new JPanel();
    JPanel pnlGL          = new JPanel();
    JPanel pnlComments    = new JPanel();
    JScrollPane scroll    = new JScrollPane();

    ButtonGroup groupTown  = new ButtonGroup();
    ButtonGroup groupRange = new ButtonGroup();

    //  Identifier

    TitledBorder titledBorderID = new TitledBorder(
        new EtchedBorder(EtchedBorder.RAISED,
                         Color.white,
                         new Color(168, 168, 168)),
        " Identification:");
    titledBorderID.setTitleFont(new java.awt.Font("Dialog", 1, 11));

    TitledBorder titledBorderWell = new TitledBorder(
        BorderFactory.createEtchedBorder(Color.white,new Color(168, 168, 168)),
        " Name:");
    titledBorderWell.setTitleFont(new java.awt.Font("Dialog", 1, 11));

    TitledBorder titledBorderKid = new TitledBorder(
        BorderFactory.createEtchedBorder(Color.white,new Color(168, 168, 168)),
        "KGS Primary Key:");
    titledBorderKid.setTitleFont(new java.awt.Font("Dialog", 1, 11));

    TitledBorder titledBorderKey = new TitledBorder(
        BorderFactory.createEtchedBorder(Color.white,new Color(168, 168, 168)),
        "PC Primary Key:");
    titledBorderKey.setTitleFont(new java.awt.Font("Dialog", 1, 11));

    TitledBorder titledBorderAPI = new TitledBorder(
        BorderFactory.createEtchedBorder(Color.white,new Color(168, 168, 168)),
        "API-Number:");
    titledBorderAPI.setTitleFont(new java.awt.Font("Dialog", 1, 11));

    TitledBorder titledBorderStatus = new TitledBorder(
        BorderFactory.createEtchedBorder(Color.white,new Color(168, 168, 168)),
        "Status:");
    titledBorderStatus.setTitleFont(new java.awt.Font("Dialog", 1, 11));

    // Other Well Information

    TitledBorder titledBorderOther = new TitledBorder(
        new EtchedBorder(EtchedBorder.RAISED,
                         Color.white,
                         new Color(168, 168, 168)),
        "Other Well Information:");
    titledBorderOther.setTitleFont(new java.awt.Font("Dialog", 1, 11));

    TitledBorder titledBorderOpName = new TitledBorder(
        BorderFactory.createEtchedBorder(Color.white,new Color(168, 168, 168)),
        "Operator Name:");
    titledBorderOpName.setTitleFont(new java.awt.Font("Dialog", 1, 11));

    TitledBorder titledBorderOpCode = new TitledBorder(
        BorderFactory.createEtchedBorder(Color.white,new Color(168, 168, 168)),
        "Operator Code:");
    titledBorderOpCode.setTitleFont(new java.awt.Font("Dialog", 1, 11));

    TitledBorder titledBorderFldName = new TitledBorder(
        BorderFactory.createEtchedBorder(Color.white,new Color(168, 168, 168)),
        "Field Name:");
    titledBorderFldName.setTitleFont(new java.awt.Font("Dialog", 1, 11));

    TitledBorder titledBorderFldCode = new TitledBorder(
        BorderFactory.createEtchedBorder(Color.white,new Color(168, 168, 168)),
        "Field Code:");
    titledBorderFldCode.setTitleFont(new java.awt.Font("Dialog", 1, 11));

    //  Location

    TitledBorder titledBorderLoc = new TitledBorder(
        new EtchedBorder(EtchedBorder.RAISED,
                         Color.white,
                         new Color(168, 168, 168)),
        " Location Information:");
    titledBorderLoc.setTitleFont(new java.awt.Font("Dialog", 1, 11));

    TitledBorder titledBorderState = new TitledBorder(
        BorderFactory.createEtchedBorder(Color.white,new Color(168, 168, 168)),
        "State:");
    titledBorderState.setTitleFont(new java.awt.Font("Dialog", 1, 11));

    TitledBorder titledBorderCounty = new TitledBorder(
        BorderFactory.createEtchedBorder(Color.white,new Color(168, 168, 168)),
        "County:");
    titledBorderCounty.setTitleFont(new java.awt.Font("Dialog", 1, 11));

    TitledBorder titledBorderLocation = new TitledBorder(
        BorderFactory.createEtchedBorder(Color.white,new Color(168, 168, 168)),
        "Location:");
    titledBorderLocation.setTitleFont(new java.awt.Font("Dialog", 1, 11));

    TitledBorder titledBorderTownship = new TitledBorder(
        BorderFactory.createEtchedBorder(Color.white,new Color(168, 168, 168)),
        "Township:");
    titledBorderTownship.setTitleFont(new java.awt.Font("Dialog", 1, 11));

    TitledBorder titledBorderRange = new TitledBorder(
        BorderFactory.createEtchedBorder(Color.white,new Color(168, 168, 168)),
        "Range:");
    titledBorderRange.setTitleFont(new java.awt.Font("Dialog", 1, 11));

    TitledBorder titledBorderSection = new TitledBorder(
        BorderFactory.createEtchedBorder(Color.white,new Color(168, 168, 168)),
        "Section:");
    titledBorderSection.setTitleFont(new java.awt.Font("Dialog", 1, 11));

    // XY Position

    TitledBorder titledBorderXY = new TitledBorder(
        new EtchedBorder(EtchedBorder.RAISED,
                         Color.white,
                         new Color(168, 168, 168)),
        "XY Position:");
    titledBorderXY.setTitleFont(new java.awt.Font("Dialog", 1, 11));

    TitledBorder titledBorderLatitude = new TitledBorder(
        BorderFactory.createEtchedBorder(Color.white,new Color(168, 168, 168)),
        "Latitude:");
    titledBorderLatitude.setTitleFont(new java.awt.Font("Dialog", 1, 11));

    TitledBorder titledBorderLongitude = new TitledBorder(
        BorderFactory.createEtchedBorder(Color.white,new Color(168, 168, 168)),
        "Longitude:");
    titledBorderLongitude.setTitleFont(new java.awt.Font("Dialog", 1, 11));

    TitledBorder titledBorderUTMx = new TitledBorder(
        BorderFactory.createEtchedBorder(Color.white,new Color(168, 168, 168)),
        "UTM-X:");
    titledBorderUTMx.setTitleFont(new java.awt.Font("Dialog", 1, 11));

    TitledBorder titledBorderUTMy = new TitledBorder(
        BorderFactory.createEtchedBorder(Color.white,new Color(168, 168, 168)),
        "UTM-Y:");
    titledBorderUTMy.setTitleFont(new java.awt.Font("Dialog", 1, 11));

    TitledBorder titledBorderUTMZone = new TitledBorder(
        BorderFactory.createEtchedBorder(Color.white,new Color(168, 168, 168)),
        "UTM Zone:");
    titledBorderUTMZone.setTitleFont(new java.awt.Font("Dialog", 1, 11));

    // Z Position

    TitledBorder titledBorderZ = new TitledBorder(
        new EtchedBorder(EtchedBorder.RAISED,
                         Color.white,
                         new Color(168, 168, 168)),
        "Z-Position:");
    titledBorderZ.setTitleFont(new java.awt.Font("Dialog", 1, 11));

    TitledBorder titledBorderDepth = new TitledBorder(
        BorderFactory.createEtchedBorder(Color.white,new Color(168, 168, 168)),
        "Depth:");
    titledBorderDepth.setTitleFont(new java.awt.Font("Dialog", 1, 11));

    TitledBorder titledBorderGL = new TitledBorder(
        BorderFactory.createEtchedBorder(Color.white,new Color(168, 168, 168)),
        "Elevation:");
    titledBorderGL.setTitleFont(new java.awt.Font("Dialog", 1, 11));

    TitledBorder titledBorderKB = new TitledBorder(
        BorderFactory.createEtchedBorder(Color.white,new Color(168, 168, 168)),
        "Kelly Bushing:");
    titledBorderKB.setTitleFont(new java.awt.Font("Dialog", 1, 11));

    TitledBorder titledBorderDF = new TitledBorder(
        BorderFactory.createEtchedBorder(Color.white,new Color(168, 168, 168)),
        "Derrick Floor:");
    titledBorderDF.setTitleFont(new java.awt.Font("Dialog", 1, 11));

    // Comments

    TitledBorder titledBorderComments = new TitledBorder(
        new EtchedBorder(EtchedBorder.RAISED,
                         Color.white,
                         new Color(168, 168, 168)),
        "Comments:");
    titledBorderComments.setTitleFont(new java.awt.Font("Dialog", 1, 11));

    this.setLayout(new BorderLayout());
    this.setPreferredSize(new Dimension(400, 800));

    //  Information

    pnlInfo.setBorder(titledBorderID);
    pnlInfo.setLayout(new BorderLayout());

    pnlID.setLayout(new GridLayout());

    // -- KGS Primary Key

    pnlKID.setBorder(titledBorderKid);
    pnlKID.setLayout(new BorderLayout());

    txtKID.setEditable(false);
    txtKID.setText(stData.sKID);
    txtKID.addFocusListener(new iqstratHeadersPanelFocusAdapter(this));

    // -- Key created by User

    pnlKEY.setBorder(titledBorderKey);
    pnlKEY.setLayout(new BorderLayout());

    txtKEY.setEditable(false);
    txtKEY.setText(stData.sKEY);
    txtKEY.addFocusListener(new iqstratHeadersPanelFocusAdapter(this));

    pnlTopC.setLayout(new BorderLayout());

    // -- API-Number

    pnlAPI.setBorder(titledBorderAPI);
    pnlAPI.setLayout(new BorderLayout());

    txtAPI.setText(cmn.cmnString.convertToAPI(stData.sAPI));
    txtAPI.addFocusListener(new iqstratHeadersPanelFocusAdapter(this));

    // --  name

    pnlName.setBorder(titledBorderWell);
    pnlName.setLayout(new BorderLayout());

    txtName.setText(stData.sName);
    txtName.addFocusListener(new iqstratHeadersPanelFocusAdapter(this));

    // --  Status

    pnlStatus.setBorder(titledBorderStatus);
    pnlStatus.setPreferredSize(new Dimension(200, 52));
    pnlStatus.setLayout(new BorderLayout());

    btnStatus.setText(stData.status);
    btnStatus.addActionListener(this);

    pnl1.setLayout(new BorderLayout());

    // Other Well Information

    pnlOther.setBorder(titledBorderOther);
    pnlOther.setLayout(new GridLayout(2,1));

    // -- Operator Name & Code

    pnlOperator.setLayout(new BorderLayout());

    pnlOpName.setBorder(titledBorderOpName);
    pnlOpName.setLayout(new BorderLayout());

    txtOperator.setText(stData.sOperator);
    txtOperator.addFocusListener(new iqstratHeadersPanelFocusAdapter(this));

    pnlOpCode.setBorder(titledBorderOpCode);
    pnlOpCode.setPreferredSize(new Dimension(120, 27));
    pnlOpCode.setLayout(new BorderLayout());

    txtOperatorCode.setEditable(false);
    txtOperatorCode.setText(stData.sOperator_kid);

    // -- Field Name & Code

    pnlField.setLayout(new BorderLayout());

    pnlFldName.setBorder(titledBorderFldName);
    pnlFldName.setLayout(new BorderLayout());

    txtField.setText(stData.sField);
    txtField.addFocusListener(new iqstratHeadersPanelFocusAdapter(this));

    pnlFldCode.setBorder(titledBorderFldCode);
    pnlFldCode.setPreferredSize(new Dimension(120, 27));
    pnlFldCode.setLayout(new BorderLayout());

    txtFieldCode.setEditable(false);
    txtFieldCode.setText(stData.sField_kid);

    //  Location

    pnl2.setLayout(new BorderLayout());

    pnlLocation.setBorder(titledBorderLoc);
    pnlLocation.setLayout(new BorderLayout());

    pnlStateCounty.setLayout(new GridLayout());

    // -- State

    pnlState.setBorder(titledBorderState);
    pnlState.setLayout(new BorderLayout());

    txtState.setText(stData.state);
    txtState.addFocusListener(new iqstratHeadersPanelFocusAdapter(this));

    // -- County

    pnlCounty.setBorder(titledBorderCounty);
    pnlCounty.setLayout(new BorderLayout());

    txtCounty.setText(stData.sCounty);
    txtCounty.addFocusListener(new iqstratHeadersPanelFocusAdapter(this));

    // -- Outcrop Location

    pnlOutcropLoc.setBorder(titledBorderLocation);
    pnlOutcropLoc.setLayout(new BorderLayout());

    txtLocation.setText(stData.sLocation);
    txtLocation.addFocusListener(new iqstratHeadersPanelFocusAdapter(this));

    // --TRS

    pnlTRSTop.setLayout(new BorderLayout());
    pnlTRS.setLayout(new GridLayout());

    // -- Township

    pnlTown.setBorder(titledBorderTownship);
    pnlTown.setLayout(new BorderLayout());

    pnlTownDir.setLayout(new GridLayout());

    rbNorth.setText("N");
    rbNorth.addActionListener(this);

    rbSouth.setSelected(true);
    rbSouth.setText("S");
    rbSouth.addActionListener(this);

    pnlTownNo.setLayout(new BorderLayout());

    txtTownship.setText(""+stData.iTownship);
    txtTownship.setHorizontalAlignment(SwingConstants.TRAILING);
    txtTownship.addFocusListener(new iqstratHeadersPanelFocusAdapter(this));

    // -- Range

    pnlRange.setBorder(titledBorderRange);
    pnlRange.setLayout(new BorderLayout());

    pnlRangeDir.setLayout(new GridLayout());

    rbEast.setSelected(true);
    rbEast.setText("E");
    rbEast.addActionListener(this);

    rbWest.setText("W");
    rbWest.addActionListener(this);

    pnlRangeNo.setLayout(new BorderLayout());

    txtRange.setText(""+stData.iRange);
    txtRange.setHorizontalAlignment(SwingConstants.TRAILING);
    txtRange.addFocusListener(new iqstratHeadersPanelFocusAdapter(this));

    // -- Section

    pnlSection.setBorder(titledBorderSection);
    pnlSection.setLayout(new BorderLayout());

    txtSection.setText(""+stData.iSection);
    txtSection.setColumns(4);
    txtSection.setHorizontalAlignment(SwingConstants.TRAILING);
    txtSection.addFocusListener(new iqstratHeadersPanelFocusAdapter(this));

    // -- TRS to Latitude Longitude Button Panel

    pnlTRSBase.setLayout(new BorderLayout());

    btnTRS2LLE.setFont(new java.awt.Font("Dialog", 1, 11));
    btnTRS2LLE.setBorderPainted(true);
    btnTRS2LLE.setText("Kansas TRS to Latitude, Longitude & Elevation");
    btnTRS2LLE.addActionListener(this);

    // XY Position

    pnl3.setLayout(new BorderLayout());

    pnlXY.setBorder(titledBorderXY);
    pnlXY.setLayout(new BorderLayout());

    pnlLatLong.setLayout(new GridLayout());

    // -- Latitude

    pnlLatitude.setBorder(titledBorderLatitude);
    pnlLatitude.setLayout(new BorderLayout());

    txtLatitude.setText(""+stData.dLatitude);
    txtLatitude.setHorizontalAlignment(SwingConstants.TRAILING);
    txtLatitude.addFocusListener(new iqstratHeadersPanelFocusAdapter(this));

    // -- Longitude

    pnlLongitude.setBorder(titledBorderLongitude);
    pnlLongitude.setLayout(new BorderLayout());

    txtLongitude.setText(""+stData.dLongitude);
    txtLongitude.setHorizontalAlignment(SwingConstants.TRAILING);
    txtLongitude.addFocusListener(new iqstratHeadersPanelFocusAdapter(this));

    // -- UTM

    pnlUTM.setLayout(new GridLayout());

    // -- UTM-X

    pnlUTMx.setBorder(titledBorderUTMx);
    pnlUTMx.setLayout(new BorderLayout());

    txtUTMx.setText(""+stData.dUTMx);
    txtUTMx.setHorizontalAlignment(SwingConstants.TRAILING);
    txtUTMx.addFocusListener(new iqstratHeadersPanelFocusAdapter(this));

    // -- UTM-Y

    pnlUTMy.setBorder(titledBorderUTMy);
    pnlUTMy.setLayout(new BorderLayout());

    txtUTMy.setText(""+stData.dUTMy);
    txtUTMy.setHorizontalAlignment(SwingConstants.TRAILING);
    txtUTMy.addFocusListener(new iqstratHeadersPanelFocusAdapter(this));

    pnlUTM1.setLayout(new BorderLayout());
    pnlUTM1.setPreferredSize(new Dimension(263, 48));

    pnlZone.setBorder(titledBorderUTMZone);
    pnlZone.setPreferredSize(new Dimension(100, 27));
    pnlZone.setLayout(new BorderLayout());

    btnComputeUTM.setFont(new java.awt.Font("Dialog", 1, 11));
    btnComputeUTM.setText("Compute UTM");
    btnComputeUTM.addActionListener(this);

    txtUTMZone.setText(""+stData.dZone);
    txtUTMZone.setHorizontalAlignment(SwingConstants.TRAILING);
    txtUTMZone.addFocusListener(new iqstratHeadersPanelFocusAdapter(this));

    // Z Position

    pnl4.setLayout(new BorderLayout());

    pnlZ.setBorder(titledBorderZ);
    pnlZ.setLayout(new GridLayout());

    // --  Depth

    pnlDepth.setBorder(titledBorderDepth);
    pnlDepth.setLayout(new BorderLayout());

    txtDepth.setText(""+stData.depth);
    txtDepth.setHorizontalAlignment(SwingConstants.TRAILING);
    txtDepth.addFocusListener(new iqstratHeadersPanelFocusAdapter(this));

    // -- Ground Level (Elevation)

    pnlGL.setBorder(titledBorderGL);
    pnlGL.setLayout(new BorderLayout());

    txtGL.setText(""+stData.dGL);
    txtGL.setHorizontalAlignment(SwingConstants.TRAILING);
    txtGL.addFocusListener(new iqstratHeadersPanelFocusAdapter(this));

    // -- Kelly Bushing (Elevation)

    pnlKB.setBorder(titledBorderKB);
    pnlKB.setLayout(new BorderLayout());

    txtKB.setText(""+stData.dKB);
    txtKB.setHorizontalAlignment(SwingConstants.TRAILING);
    txtKB.addFocusListener(new iqstratHeadersPanelFocusAdapter(this));

    // -- Derrick Floor (Elevation)

    pnlDF.setBorder(titledBorderDF);
    pnlDF.setLayout(new BorderLayout());

    txtDF.setText(""+stData.dDF);
    txtDF.setHorizontalAlignment(SwingConstants.TRAILING);
    txtDF.addFocusListener(new iqstratHeadersPanelFocusAdapter(this));

    // Comments

    pnlComments.setBorder(titledBorderComments);
    pnlComments.setLayout(new BorderLayout());

    txtComments.setText(stData.sComments);
    txtComments.setLineWrap(true);
    txtComments.setWrapStyleWord(true);
    txtComments.addFocusListener(new iqstratHeadersPanelFocusAdapter(this));

    // Attach Widgets to Panel

    this.add(pnlInfo,     BorderLayout.NORTH);
    pnlInfo.add(pnlID,    BorderLayout.NORTH);
    pnlID.add(pnlKID,     null);
    pnlKID.add(txtKID,    BorderLayout.CENTER);

    pnlID.add(pnlKEY,     null);
    pnlKEY.add(txtKEY,    BorderLayout.CENTER);

    pnlInfo.add(pnlName,  BorderLayout.SOUTH);
    pnlName.add(txtName,  BorderLayout.NORTH);

    pnlInfo.add(pnlTopC,  BorderLayout.CENTER);

    if (iType == iqstrat.iqstratHeadersStruct.WELL)
    {
      pnlTopC.add(pnlAPI, BorderLayout.CENTER);
      pnlAPI.add(txtAPI,  BorderLayout.CENTER);
    }

    pnlTopC.add(pnlStatus,   BorderLayout.EAST);
    pnlStatus.add(btnStatus, BorderLayout.CENTER);

    this.add(pnl1, BorderLayout.CENTER);
    if (iType == iqstrat.iqstratHeadersStruct.WELL)
    {
      pnl1.add(pnlOther,             BorderLayout.NORTH);
      pnlOther.add(pnlOperator,      null);
      pnlOperator.add(pnlOpCode,     BorderLayout.EAST);
      pnlOpCode.add(txtOperatorCode, BorderLayout.CENTER);
      pnlOperator.add(pnlOpName,     BorderLayout.CENTER);
      pnlOpName.add(txtOperator,     BorderLayout.NORTH);

      pnlOther.add(pnlField,         null);
      pnlField.add(pnlFldCode,       BorderLayout.EAST);
      pnlFldCode.add(txtFieldCode,   BorderLayout.CENTER);
      pnlField.add(pnlFldName,       BorderLayout.CENTER);
      pnlFldName.add(txtField,       BorderLayout.NORTH);
    }

    pnl1.add(pnl2,                  BorderLayout.CENTER);
    pnl2.add(pnlLocation,           BorderLayout.NORTH);

    pnlLocation.add(pnlStateCounty, BorderLayout.NORTH);
    pnlStateCounty.add(pnlState,    null);
    pnlState.add(txtState,          BorderLayout.CENTER);

    pnlStateCounty.add(pnlCounty,   null);
    pnlCounty.add(txtCounty,        BorderLayout.CENTER);

//    if (iType == iqstrat.iqstratHeadersStruct.OUTCROP)
//    {
      pnlLocation.add(pnlOutcropLoc, BorderLayout.CENTER);
      pnlOutcropLoc.add(txtLocation, BorderLayout.CENTER);
//    }

    pnlLocation.add(pnlTRSTop,   BorderLayout.SOUTH);
    pnlTRSTop.add(pnlTRSBase,    BorderLayout.SOUTH);
    pnlTRSBase.add(btnTRS2LLE,  BorderLayout.CENTER);

    pnlTRSTop.add(pnlTRS,        BorderLayout.NORTH);
    pnlTRS.add(pnlTown,          null);
    pnlTown.add(pnlTownNo,       BorderLayout.CENTER);
    pnlTownNo.add(txtTownship,   BorderLayout.CENTER);

    pnlTown.add(pnlTownDir,      BorderLayout.EAST);
    pnlTownDir.add(rbNorth,      null);
    pnlTownDir.add(rbSouth,      null);

    pnlTRS.add(pnlRange,         null);
    pnlRange.add(pnlRangeDir,    BorderLayout.EAST);
    pnlRangeDir.add(rbEast,      null);
    pnlRangeDir.add(rbWest,      null);

    pnlRange.add(pnlRangeNo,     BorderLayout.CENTER);
    pnlRangeNo.add(txtRange,     BorderLayout.CENTER);

    pnlTRS.add(pnlSection,       null);
    pnlSection.add(txtSection,  BorderLayout.EAST);
    pnl2.add(pnl3,               BorderLayout.CENTER);

    pnl3.add(pnlXY,              BorderLayout.NORTH);
    pnlXY.add(pnlLatLong,        BorderLayout.NORTH);
    pnlLatLong.add(pnlLatitude,  null);
    pnlLatitude.add(txtLatitude, BorderLayout.NORTH);

    pnlLatLong.add(pnlLongitude,   null);
    pnlLongitude.add(txtLongitude, BorderLayout.SOUTH);

    pnlXY.add(pnlUTM,            BorderLayout.SOUTH);
    pnlUTM.add(pnlUTMx,          null);
    pnlUTMx.add(txtUTMx,         BorderLayout.NORTH);

    pnlUTM.add(pnlUTMy,          null);
    pnlUTMy.add(txtUTMy,         BorderLayout.CENTER);

    pnlXY.add(pnlUTM1,           BorderLayout.CENTER);
    pnlUTM1.add(pnlZone,         BorderLayout.WEST);
    pnlZone.add(txtUTMZone,      BorderLayout.SOUTH);
    pnlUTM1.add(btnComputeUTM,   BorderLayout.EAST);

    pnl3.add(pnl4,               BorderLayout.CENTER);
    pnl4.add(pnlZ,               BorderLayout.NORTH);

    pnlZ.add(pnlDepth,           null);
    pnlDepth.add(txtDepth,       BorderLayout.CENTER);

    pnlZ.add(pnlGL,              null);
    pnlGL.add(txtGL,             BorderLayout.CENTER);

    if (iType == iqstrat.iqstratHeadersStruct.WELL)
    {
      pnlZ.add(pnlKB,            null);
      pnlKB.add(txtKB,           BorderLayout.CENTER);

      pnlZ.add(pnlDF,            null);
      pnlDF.add(txtDF,           BorderLayout.CENTER);
    }

    pnl4.add(pnlComments,        BorderLayout.CENTER);
    pnlComments.add(scroll,      BorderLayout.CENTER);
    scroll.getViewport().add(txtComments, null);

    groupTown.add(rbNorth);
    groupTown.add(rbSouth);

    groupRange.add(rbEast);
    groupRange.add(rbWest);

  }

  /* ===================================================================== *
   * -------------------------- GET METHODS ------------------------------ *
   * ===================================================================== */

  /** Method getData()
   * <p> This method will return the Headers Data Structure
   * @return stData = the headers data structure
   */

  public iqstratHeadersStruct getData() { return (stData); }

  /** Method getAPI()
   * <p> This method will retrieve the API-Number from the Headers Panel
   * @return API-Number from Panels API-Number Textfield
   */

  public String getAPI() { return (txtAPI.getText()); }

  /** Method getName()
   * <p> This method will retrieve the Name from the Headers Panel
   * @return Name from Panels Name Textfield
   */

  public String getName() { return (txtName.getText()); }

  /** Method getStatus()
   * <p> This method will retrieve the status
   */

  public void getStatus()
  {
    if (pStatus != null)
    {
      stData.status = pStatus.getMnemonic();
      btnStatus.setText(stData.status);

      pStatus.close();
      pStatus = null;
    }
  }

  private void getLatLong()
  {
    iqstratHeadersListStruct stList = null;

    if ((stData.iTownship > 0) && (stData.iRange > 0) && (stData.iSection > 0))
    {
      String sPath = cmn.cmnStruct.KGS_TRS2LL +
          "iTownship=" + stData.iTownship + "&sTownship=" + stData.sTownship +
          "&iRange="   + stData.iRange    + "&sRange="    + stData.sRange    +
          "&iSection=" + stData.iSection;

      stList = iqstrat.io.iqstratIOHeaders.getData(
               iqstrat.io.ReadHeadersXMLFile.URL, sPath);

      if (stList != null)
      {
        if (stList.iCount > 0)
        {
          stData.dLatitude  = stList.stItem[0].dLatitude;
          stData.dLongitude = stList.stItem[0].dLongitude;
          stData.dGL        = stList.stItem[0].dGL;

          txtLatitude.setText(""+stData.dLatitude);
          txtLongitude.setText(""+stData.dLongitude);
          txtGL.setText(""+stData.dGL);
        }

        stList.delete();
        stList = null;
      }
    }
// http://abyss.kgs.ku.edu/pls/abyss/iqstrat.TRS2LL_pkg.getXML?iTownship=19&sTownship=S&iRange=6&sRange=E&iSection=26
  }

  /* ===================================================================== *
   * -------------------------- SET METHODS ------------------------------ *
   * ===================================================================== */

  /** Method setData()
   * <p> This method will set the Headers Data Structure
   * @param stData = the headers data structure
   */

  public void setData(iqstratHeadersStruct stData)
  {
    this.stData = stData;

    txtKID.setText(stData.sKID);        // KGS Primary Key
    txtKEY.setText(stData.sKEY);        // Key created by User
    txtAPI.setText(cmn.cmnString.convertToAPI(stData.sAPI)); // API-Number
    txtName.setText(stData.sName);      // name
    btnStatus.setText(stData.status);   // Status

    // Other Well Information
    // -- Operator Name & Code

    txtOperator.setText(stData.sOperator);
    txtOperatorCode.setText(stData.sOperator_kid);

    // -- Field Name & Code

    txtField.setText(stData.sField);
    txtFieldCode.setText(stData.sField_kid);

    //  Location

    txtState.setText(stData.state);         // State
    txtCounty.setText(stData.sCounty);      // County
    txtLocation.setText(stData.sLocation);  // Outcrop Location

    // --TRS
    // Township

    rbNorth.setSelected(false);
    rbSouth.setSelected(false);
    if (stData.sTownship.equals("S"))
      rbSouth.setSelected(true);
    else
      rbNorth.setSelected(true);

    txtTownship.setText(""+stData.iTownship);

    // Range

    rbWest.setSelected(false);
    rbEast.setSelected(false);
    if (stData.sRange.equals("E"))
      rbEast.setSelected(true);
    else
      rbWest.setSelected(true);

    txtRange.setText(""+stData.iRange);

    // Section

    txtSection.setText(""+stData.iSection);

    // XY Position

    txtLatitude.setText(""+stData.dLatitude);    // -- Latitude
    txtLongitude.setText(""+stData.dLongitude); // -- Longitude

    // -- UTM

    txtUTMx.setText(""+stData.dUTMx);      // UTM-X
    txtUTMy.setText(""+stData.dUTMy);      // UTM-Y
    txtUTMZone.setText(""+stData.dZone);   // UTM Zone

    // Z Position

    txtDepth.setText(""+stData.depth);     // Height or Depth
    txtGL.setText(""+stData.dGL);          // Ground Level (Elevation)
    txtKB.setText(""+stData.dKB);          // Kelly Bushing (Elevation)
    txtDF.setText(""+stData.dDF);          // Derrick Floor (Elevation)

    txtComments.setText(stData.sComments); // Comments
  }

  /* ===================================================================== *
   * -------------------------- COMPUTE UTM ------------------------------ *
   * ===================================================================== */

  /** Method computeWellUTMAction()
   * <p> This method will compute the UTM for a single well based on the
   *     Latitude and Longitude.
   */

  private void computeWellUTMAction()
  {
    utilLatLongConversion pUtil = new utilLatLongConversion(stData.dLatitude,
                                                            stData.dLongitude);

    // Get the UTM Values

    stData.dZone = pUtil.getZone();                                // UTM Zone
    txtUTMZone.setText(""+stData.dZone);

    stData.dUTMx = pUtil.getUTM(util.utilLatLongConversion.UTM_X); // UTM X
    txtUTMx.setText(""+stData.dUTMx);

    stData.dUTMy = pUtil.getUTM(util.utilLatLongConversion.UTM_Y); // UTM Y
    txtUTMy.setText(""+stData.dUTMy);
  }

  /* ===================================================================== *
   * ---------------------------- ACTIONS -------------------------------- *
   * ===================================================================== */

  /** Method close()
   * <p> This method will close this dialog and all other dialogs opened by
   *     this dialog
   */

  public void close()
  {
    stData   = null;  // Headers Data Structure

    txtKID    = null;
    txtKEY    = null;
    txtName   = null;
    txtAPI    = null;
    btnStatus = null;

    // Other Well Information

    txtOperator     = null;
    txtOperatorCode = null;

    txtField        = null;
    txtFieldCode    = null;

    //  Location

    txtState    = null;
    txtCounty   = null;

    rbNorth     = null;
    rbSouth     = null;
    txtTownship = null;

    rbEast      = null;
    rbWest      = null;
    txtRange    = null;

    txtSection  = null;
    btnTRS2LLE  = null;

    // XY Position

    txtLatitude    = null;
    txtLongitude   = null;
    txtUTMx        = null;
    txtUTMy        = null;
    btnComputeUTM  = null;
    txtUTMZone     = null;

    // Z Position

    txtDepth = null;
    txtGL    = null;
    txtKB    = null;
    txtDF    = null;

    if (pStatus != null)
      pStatus.close();
    pStatus = null;

    if (parent != null)
      parent.dispose();
    parent = null;
  }

  /** METHOD actionPerformed()
   *  <p> This Method will handle all the actions within the Frame.
   *  @param event - Action Event
   */

  public void actionPerformed(ActionEvent event)
  {
    if (event.getSource() == btnStatus)
    {
      if (pStatus != null)
        pStatus.close();
      pStatus = null;

      pStatus = new iqstratStatusFrame(notifier);
    }

    if (event.getSource() == btnComputeUTM) { computeWellUTMAction(); }

    if (event.getSource() == rbNorth) { this.stData.sTownship = "N"; }
    if (event.getSource() == rbSouth) { this.stData.sTownship = "S"; }

    if (event.getSource() == rbEast)  { this.stData.sRange    = "E"; }
    if (event.getSource() == rbWest)  { this.stData.sRange    = "W"; }

    if (event.getSource() == btnTRS2LLE) { getLatLong(); }
  }

  /** METHOD focusLost()
   *  <p> This Method will handle the lost focus event for the text fields.
   *  @param e      = Focus Lost Event
   */

  protected void focusLost(FocusEvent e)
  {
    int    iNumeric = 0;
    String sMessage = new String("");
    String sTemp    = new String("");

    // Header Identifier Information

    if (e.getSource() == txtKID)  { stData.sKID  = txtKID.getText();  }
    if (e.getSource() == txtKEY)  { stData.sKEY  = txtKEY.getText();  }
    if (e.getSource() == txtName) { stData.sName = txtName.getText(); }
    if (e.getSource() == txtAPI)
    {
      stData.sAPI  = cmn.cmnString.convertToAPI(txtAPI.getText());
    }

    // Other Well Information

    if (e.getSource()==txtOperator) {stData.sOperator = txtOperator.getText();}
    if (e.getSource() == txtOperatorCode)
    {

    }

    if (e.getSource() == txtField) { stData.sField = txtField.getText(); }
    if (e.getSource() == txtFieldCode)
    {

    }

    //  Location

    if (e.getSource() == txtState)  { stData.state = txtState.getText(); }
    if (e.getSource() == txtCounty) { stData.sCounty = txtCounty.getText(); }
    if (e.getSource()==txtLocation) {stData.sLocation = txtLocation.getText();}

    if (e.getSource() == txtTownship)
    {
      iNumeric = 1;
      sTemp = txtTownship.getText();
      sMessage = new String("Township Value is a Numeric Field");
    }
    if (e.getSource() == txtRange)
    {
      iNumeric = 1;
      sTemp = txtRange.getText();
      sMessage = new String("Range Value is a Numeric Field");
    }
    if (e.getSource() == txtSection)
    {
      iNumeric = 1;
      sTemp = txtSection.getText();
      sMessage = new String("Section Value is a Numeric Field");
    }

    // XY Position

    if (e.getSource() == txtLatitude)
    {
      iNumeric = 1;
      sTemp = txtLatitude.getText();
      sMessage = new String("Latitude Value is a Numeric Field");
    }
    if (e.getSource() == txtLongitude)
    {
      iNumeric = 1;
      sTemp = txtLongitude.getText();
      sMessage = new String("Longitude Value is a Numeric Field");
    }
    if (e.getSource() == txtUTMx)
    {
      iNumeric = 1;
      sTemp = txtUTMx.getText();
      sMessage = new String("UTM x-position Value is a Numeric Field");
    }
    if (e.getSource() == txtUTMy)
    {
      iNumeric = 1;
      sTemp = txtUTMy.getText();
      sMessage = new String("UTM y-position Value is a Numeric Field");
    }
    if (e.getSource() == txtUTMZone)
    {
      iNumeric = 1;
      sTemp = txtUTMZone.getText();
      sMessage = new String("UTM Zone Value is a Numeric Field");
    }

    // Z Position

    if (e.getSource() == txtDepth)
    {
      iNumeric = 1;
      sTemp = txtDepth.getText();
      sMessage = new String("Depth Elevation Value is a Numeric Field");
    }
    if (e.getSource() == txtGL)
    {
      iNumeric = 1;
      sTemp = txtGL.getText();
      sMessage = new String("Ground Level Elevation Value is a Numeric Field");
    }
    if (e.getSource() == txtKB)
    {
      iNumeric = 1;
      sTemp = txtKB.getText();
      sMessage = new String("Kelly Bushing Elevation Value is a Numeric Field");
    }
    if (e.getSource() == txtDF)
    {
      iNumeric = 1;
      sTemp = txtDF.getText();
      sMessage = new String("Derrick Floor Elevation Value is a Numeric Field");
    }

    if (iNumeric == 1)
    {
      if (!cmn.cmnString.isNumeric(sTemp))
      {
        JOptionPane.showMessageDialog((Component) null,
                                       sMessage,
                                       "ERROR",
                                       JOptionPane.ERROR_MESSAGE);
      }
      else
      {
        // Location

        if (e.getSource() == txtTownship)
          stData.iTownship = cmn.cmnString.stringToInt(txtTownship.getText());
        if (e.getSource() == txtRange)
          stData.iRange = cmn.cmnString.stringToInt(txtRange.getText());
        if (e.getSource() == txtSection)
          stData.iSection = cmn.cmnString.stringToInt(txtSection.getText());

        // XY Position

        if (e.getSource() == txtLatitude)
          stData.dLatitude = cmn.cmnString.stringToDouble(txtLatitude.getText());
        if (e.getSource() == txtLongitude)
          stData.dLongitude = cmn.cmnString.stringToDouble(txtLongitude.getText());
        if (e.getSource() == txtUTMx)
          stData.dUTMx = cmn.cmnString.stringToDouble(txtUTMx.getText());
        if (e.getSource() == txtUTMy)
          stData.dUTMy = cmn.cmnString.stringToDouble(txtUTMy.getText());
        if (e.getSource() == txtUTMZone)
          stData.dZone = cmn.cmnString.stringToDouble(txtUTMZone.getText());

        // Z Position

        if (e.getSource() == txtDepth)
          stData.depth = cmn.cmnString.stringToDouble(txtDepth.getText());
        if (e.getSource() == txtGL)
          stData.dGL = cmn.cmnString.stringToDouble(txtGL.getText());
        if (e.getSource() == txtKB)
          stData.dKB = cmn.cmnString.stringToDouble(txtKB.getText());
        if (e.getSource() == txtDF)
          stData.dDF = cmn.cmnString.stringToDouble(txtDF.getText());
      }
    }
  }
}

/** CLASS iqstratHeadersPanelFocusAdapter()
  *  <p> This Method will handle Actions when focus is lost on a textfield
  */

class iqstratHeadersPanelFocusAdapter extends java.awt.event.FocusAdapter
{
  iqstratHeadersPanel adaptee;

  iqstratHeadersPanelFocusAdapter(iqstratHeadersPanel adaptee)
  {
    this.adaptee = adaptee;
  }

  public void focusLost(FocusEvent e) { adaptee.focusLost(e); }
}

/*
 *  @version 1.1 10/14/2007
 *  @author  John Victorine
 */
