/*
 * @iqstratHeadersFrame.java Version 1.1 1/16/2008
 *
 * Copyright (c) 2008 Kansas Geological Survey
 * 1930 Constant Avenue, Lawrence, Kansas, 66047, U.S.A.
 * All Rights Reserved.
 */

package iqstrat.gui;

import java.awt.*;
import java.awt.event.*;
import java.util.Observable;
import javax.swing.*;
import javax.swing.event.*;
import javax.swing.border.*;

import cmn.cmnStruct;

import iqstrat.iqstratHeadersListStruct;
import iqstrat.iqstratHeadersStruct;
import iqstrat.gui.iqstratHeadersPanel;

import kgs.gui.kgsSearchKGSHeadersFrame;

/** Class iqstratHeadersFrame
 *  <p> This Class will allow the user to modify the headers data and search
 *      for data on KGS Database.
 *
 *  @version 1.1 1/16/2008
 *  @author  John R. Victorine
 */

public class iqstratHeadersFrame extends JFrame implements ActionListener
{
  // Input Variables

  private Observable           notifier = null;
  private cmnStruct            stCMN    = null;
  private iqstratHeadersStruct stData   = null; // Well Header Data Struct

  // Global Variables

  private int    iClose    = 0;

  private iqstratHeadersStruct     stNew     = null; // Well Header Data Struct
  private iqstratHeadersPanel      pnlHeader = null; // Well Header Panel Data
  private kgsSearchKGSHeadersFrame pSearch = null; // Well Header Search Frame

  // Global Frame Widgets

  private static final int _ORIGINAL = 0;
  private static final int _SEARCH   = 1;
  private int iSource = _ORIGINAL;

  private JRadioButton rbOriginal = new JRadioButton();
  private JRadioButton rbSearch   = new JRadioButton();

  private JButton      btnSearch  = new JButton();

  private JButton      btnOk      = new JButton();
  private JButton      btnClose   = new JButton();

  /** Constructor iqstratHeadersFrame()
   *  <p> This is the Constructor for this class.
   *  @param stCMN    = Common Global Data Structure
   *  @param notifier = Observable
   *  @param stData   = The Headers List Data Structure
   */

  public iqstratHeadersFrame(cmnStruct stCMN,
                             Observable notifier,
                             iqstratHeadersStruct stData)
  {
    try
    {
      this.stCMN    = stCMN;
      this.notifier = notifier;
      this.stData   = iqstrat.iqstratHeadersUtility.copy(stData);

      jbInit();
    }
    catch(Exception e)
    {
      e.printStackTrace();
    }
  }

  /** METHOD jbInit()
   *  <p> This Method will create the Frame for this class.
   *  @throws Exception
   */

  private void jbInit() throws Exception
  {
    String sTitle             = "KGS Well Data";
    String rbText             = "";
    JPanel pnlButtons         = new JPanel();
    JPanel pnlCenter          = new JPanel();
    JPanel pnlTop             = new JPanel();
    JPanel pnlSource          = new JPanel();
    JPanel pnlIden            = new JPanel();
    JScrollPane scroll        = new JScrollPane();
    ButtonGroup groupData     = new ButtonGroup();

    if (stData != null)
    {
      if (stData.sAPI.length() > 0)
        sTitle = stData.sName + " (" + stData.sAPI + ")";
      else
        sTitle = stData.sName;
    }

    if (sTitle.length() == 0)
      sTitle = new String( "Headers Information" );

    this.setTitle(sTitle);
    this.getContentPane().setLayout(new BorderLayout());

    // Frame Global Buttons Panel

    pnlButtons.setBorder(BorderFactory.createEtchedBorder());

    btnOk.setFont(new java.awt.Font("Dialog", 1, 11));
    btnOk.setPreferredSize(new Dimension(70, 25));
    btnOk.setText("Ok");
    btnOk.addActionListener(this);

    btnClose.setFont(new java.awt.Font("Dialog", 1, 11));
    btnClose.setPreferredSize(new Dimension(70, 25));
    btnClose.setText("Close");
    btnClose.addActionListener(this);

    // Well Header Data Entry Panel

    pnlCenter.setLayout(new BorderLayout());

    pnlHeader = new iqstratHeadersPanel(null,
                                       notifier,
                                       iqstrat.iqstratHeadersStruct.WELL,
                                       stData);

    // Top of Header Information Panel

//    pnlTop.setPreferredSize(new Dimension(10, 190));
    pnlTop.setLayout(new BorderLayout());

    // -- Source of Data Panel

    pnlSource.setLayout(new GridLayout());
    pnlSource.setBorder(BorderFactory.createEtchedBorder());

    rbOriginal.setFont(new java.awt.Font("Dialog", 1, 11));
    rbOriginal.setHorizontalAlignment(SwingConstants.CENTER);
    rbOriginal.setSelected(true);
    rbOriginal.setText("Show Initial Header Data");
    rbOriginal.addActionListener(this);

    rbSearch.setFont(new java.awt.Font("Dialog", 1, 11));
    rbSearch.setHorizontalAlignment(SwingConstants.CENTER);
//    rbSearch.setText("Search for Header Data");
    rbSearch.setText("Show KGS Well Header Data");
    rbSearch.addActionListener(this);

    // -- Search By Panel

//    pnlSearchBy.setLayout(new BorderLayout());
//    pnlSearchBy.setBorder(titledBorderSearch);

    // ---- Sources Panel

//    pnlSources.setLayout(new BorderLayout());

//    rbPC.setFont(new java.awt.Font("Dialog", 1, 11));
//    rbPC.setHorizontalAlignment(SwingConstants.CENTER);
//    rbPC.setSelected(true);
//    rbPC.setText("This PC");
//    rbPC.addActionListener(this);

//    rbKGS.setFont(new java.awt.Font("Dialog", 1, 11));
//    rbKGS.setHorizontalAlignment(SwingConstants.CENTER);
//    rbKGS.setText("KGS Database");
//    rbKGS.addActionListener(this);

//    rbStratDB.setFont(new java.awt.Font("Dialog", 1, 11));
//    rbStratDB.setHorizontalAlignment(SwingConstants.CENTER);
//    rbStratDB.setText("Stratigraphic Database");
//    rbStratDB.addActionListener(this);

    // ---- Search By Text Panel

//    pnlIden.setBorder(titledBorderBy);
    pnlIden.setLayout(new BorderLayout());

//    rbAPI.setFont(new java.awt.Font("Dialog", 1, 11));
//    rbAPI.setSelected(true);
//    rbAPI.setText("API-Number");
//    rbAPI.addActionListener(this);

//    rbText = "Full Well Name";
//    if (stData.iType == iqstrat.iqstratHeadersStruct.OUTCROP)
//      rbText = "Full Outcrop Name";

//    rbName.setFont(new java.awt.Font("Dialog", 1, 11));
//    rbName.setText(rbText);
//    rbName.addActionListener(this);

//    txtSearch.setText(pnlHeader.getAPI());
//    txtSearch.setColumns(20);

    btnSearch.setFont(new java.awt.Font("Dialog", 1, 11));
    btnSearch.setText("Search KGS Database for Well Header Information");
    btnSearch.addActionListener(this);

    // Attach Widgets to Frame

    this.getContentPane().add(pnlTop, BorderLayout.NORTH);
    pnlTop.add(pnlSource,           BorderLayout.NORTH);
    pnlSource.add(rbOriginal,       null);
    pnlSource.add(rbSearch,         null);

//    pnlTop.add(pnlSearchBy,         BorderLayout.CENTER);
//    pnlSearchBy.add(pnlSources,     BorderLayout.CENTER);
//    pnlSources.add(rbPC,            BorderLayout.WEST);
//    pnlSources.add(rbKGS,           BorderLayout.CENTER);
//    pnlSources.add(rbStratDB,       BorderLayout.EAST);

    pnlTop.add(pnlIden,             BorderLayout.SOUTH);
//    pnlIden.add(pnlSearchByButtons, BorderLayout.NORTH);
//    pnlSearchByButtons.add(rbAPI,   null);
//    pnlSearchByButtons.add(rbName,  null);
//    pnlIden.add(txtSearch,          BorderLayout.CENTER);
    pnlIden.add(btnSearch,          BorderLayout.SOUTH);

    setButtons();

    this.getContentPane().add(pnlButtons, BorderLayout.SOUTH);
    pnlButtons.add(btnOk,    null);
    pnlButtons.add(btnClose, null);

    this.getContentPane().add(pnlCenter, BorderLayout.CENTER);
    pnlCenter.add(scroll, BorderLayout.CENTER);
    scroll.getViewport().add(pnlHeader, null);

    groupData.add(rbOriginal);
    groupData.add(rbSearch);

//    groupSource.add(rbPC);
//    groupSource.add(rbKGS);
//    groupSource.add(rbStratDB);

//    groupBy.add(rbAPI);
//    groupBy.add(rbName);

    // Display the Frame

    this.setSize(new Dimension(425, 525));
    Dimension d = Toolkit.getDefaultToolkit().getScreenSize();
    this.setLocation((d.width - this.getSize().width) / 2,
                     (d.height - this.getSize().height) / 2);

//    this.setResizable(false);
    this.setVisible(true);
  }

  /* ===================================================================== *
   * -------------------------- GET METHODS ------------------------------ *
   * ===================================================================== */

  /** Method getWellHeader()
   * <p> This method will return the Well Header Data
   * @return st = Well Header Data Structure
   */

  public iqstratHeadersStruct getWellHeader()
  {
    iqstratHeadersStruct st = null;

    if (pnlHeader != null) st = pnlHeader.getData();

    return (st);
  }

  /** Method getStatus()
   * <p> This method will retrieve the Status from the Status Frame
   */

  public void getStatus()
  {
    if (pnlHeader != null) pnlHeader.getStatus();
  }

  /** Method getData()
   * <p> This method will retrieve the Well Header data and load it into to
   *     well headers panel
   */

  public void getData()
  {
    String sKID  = new String("0");
    String sKEY  = new String("0");

    if (stData != null)
    {
      sKID  = new String(stData.sKID);
      sKEY  = new String(stData.sKEY);
    }

    if (pSearch != null)
    {
      if (stNew != null)
        stNew.delete();
      stNew = null;

      stNew = iqstrat.iqstratHeadersUtility.copy( pSearch.getWellHeader() );

      if (!sKID.equals("0") || !sKEY.equals("0"))
      {
        stNew.sKID  = new String( sKID );
        stNew.sKEY  = new String( sKEY );
      }

      setButtons();

      pSearch.close();
      pSearch = null;
    }
  }

  /* ===================================================================== *
   * -------------------------- SET METHODS ------------------------------ *
   * ===================================================================== */

  /** Method setButtons()
   * <p> This method will set the buttons depending on the data.
   */

  private void setButtons()
  {
    rbSearch.setEnabled(false);

    if (stNew != null)
      rbSearch.setEnabled(true);

    /*
    if ((rbPC != null) && (rbKGS != null) && (rbStratDB != null) &&
        (rbAPI != null) && (rbStratDB != null) &&
        (txtSearch != null) && (btnSearch != null))
    {
      rbPC.setEnabled(false);
      rbKGS.setEnabled(false);
      rbStratDB.setEnabled(false);

      rbAPI.setEnabled(false);
      rbName.setEnabled(false);

      txtSearch.setEnabled(false);
      btnSearch.setEnabled(false);

      if (rbSearch.isSelected())
      {
        rbPC.setEnabled(true);
        if (stCMN.stUser != null)
        {
          if (!stCMN.stUser.sKEY.equals("0"))
          {
            rbKGS.setEnabled(true);
            rbStratDB.setEnabled(true);
          }
        }

        rbAPI.setEnabled(true);
        rbName.setEnabled(true);

        txtSearch.setEnabled(true);
        btnSearch.setEnabled(true);
      }
    }
*/
  }

  /** Method setWellHeader()
   * <p> This method will set the Well Header Data
   * @param st = Well Header Data Structure
   */

  public void setWellHeader(iqstratHeadersStruct st) { pnlHeader.setData(st); }

  /** Method setData()
   * <p> This method will set the Well Header Data depending on the source
   *  @param iSource = the source data identifier
   */

  private void setData(int iSource)
  {
    this.iSource = iSource;

    switch (iSource)
    {
      case _ORIGINAL:
        setWellHeader( stData );
        break;

      case _SEARCH:
        setWellHeader( stNew );
        break;
    }
  }

  /* ===================================================================== *
   * ---------------------------- ACTIONS -------------------------------- *
   * ===================================================================== */

  /** Method search()
   * <p> This method will search a particular source for Header Information
   */

  private void search()
  {
    if (pSearch != null)
      pSearch.close();
    pSearch = null;

    pSearch = new kgsSearchKGSHeadersFrame( stCMN, notifier );
  }

  /** Method search()
   * <p> This method will search a particular source for Header Information
   *

  private void search()
  {
    String                   sText  = "";
    String                   sKEY   = "0";
    String                   sAPI   = "";
    String                   sName  = "";
    iqstratHeadersListStruct stList = null;
    String                   sPath  = "";
    int                      iError = 0;
    String                   sError = "";

    if (stNew != null)
      stNew.delete();
    stNew = null;

    sText = txtSearch.getText();
    if (sText.length() > 0)
    {
      if (rbAPI.isSelected())
        sAPI  = new String(cmn.cmnString.convertToAPI(sText));
      else
        sName = new String(sText);

      switch (iSources)
      {
        case _PC_SOURCE:
          stList = iqstrat.io.iqstratIOHeaders.read_pc();
          sKEY   = iqstrat.iqstratHeadersUtility.exists(stList,
                                                        sAPI,
                                                        "0",
                                                        "0",
                                                        sName);

          if (sKEY.equals("0"))
            iError = -1;
          else
            stList = iqstrat.io.iqstratIOHeaders.read_pcRecord(sKEY);
          break;

        case _KGS_SOURCE:
          switch (iSearchBy)
          {
            case _API_NUMBER:
              sPath = cmn.cmnStruct.KGS_WELL_HEADERS_READ + "sAPI="+sAPI;
              break;

            case _NAME:
              sPath = cmn.cmnStruct.KGS_WELL_HEADERS_READ + "sWell="+sName;
              break;
          }

          stList = iqstrat.io.iqstratIOHeaders.getData(
              iqstrat.io.ReadHeadersXMLFile.URL, sPath);

          break;

        case _STRAT_SOURCE:
          switch (iSearchBy)
          {
            case _API_NUMBER:
              sPath = cmn.cmnStruct.KGS_HEADERS_READ + "sAPI="+sAPI;
              break;

            case _NAME:
              sPath = cmn.cmnStruct.KGS_HEADERS_READ + "sName="+sName;
              break;
          }

          stList = iqstrat.io.iqstratIOHeaders.getData(
              iqstrat.io.ReadHeadersXMLFile.URL, sPath);

          break;
      }

      if (stList != null)
      {
        if (stList.iCount > 0)
        {
          stNew = stList.stItem[0];
        }
        else
          iError = -1;
      }
      else
        iError = -1;

      if (iError == -1)
      {
        JOptionPane.showMessageDialog((Component) null,
                                       "No Data Found",
                                       "ERROR",
                                       JOptionPane.ERROR_MESSAGE);
      }
      else
      {
        if (stNew != null)
        {
          setWellHeader(stNew);
        }
        else
        {
          JOptionPane.showMessageDialog((Component) null,
                                         "No Data Found",
                                         "ERROR",
                                         JOptionPane.ERROR_MESSAGE);
        }
      }
    }
  }
*/

  /** Method ok()
   * <p> This method will transfer the Header Information to the Control dialog
   */

  private void ok()
  {
    notifier.notifyObservers(new String("Change Header Information"));
  }

  /** Method close()
   * <p> This method will set global variables to null in order to force JAVA
   *     to free unwanted memory.
   */

  public void close()
  {
    notifier = null;
    stCMN    = null;
    if (stData != null)
      stData.delete();
    stData   = null;

    if (stNew != null)
      stNew.delete();
    stNew     = null;

    if (pnlHeader != null)
      pnlHeader.close();
    pnlHeader = null;

    if (pSearch != null)
      pSearch.close();
    pSearch = null;

    btnOk      = null;
    btnClose   = null;

    rbOriginal = null;
    rbSearch   = null;

//    rbPC       = null;
//    rbKGS      = null;
//    rbStratDB  = null;

//    rbAPI      = null;
//    rbName     = null;

//    txtSearch  = null;
//    btnSearch  = null;

    iClose      = 1;

    dispose();
  }

  /** METHOD actionPerformed()
   *  <p> This Method will handle all the actions within the Frame.
   *  @param event - Action Event
   */

  public void actionPerformed(ActionEvent event)
  {
    if (event.getSource() == rbOriginal) { setData( _ORIGINAL ); }
    if (event.getSource() == rbSearch)   { setData( _SEARCH ); }

//    if (event.getSource() == rbPC)       { iSources  = _PC_SOURCE; }
//    if (event.getSource() == rbKGS)      { iSources  = _KGS_SOURCE; }
//    if (event.getSource() == rbStratDB)  { iSources  = _STRAT_SOURCE; }

//    if (event.getSource() == rbAPI)
//    {
//      iSearchBy = _API_NUMBER;
//      txtSearch.setText(pnlHeader.getAPI());
//    }
//    if (event.getSource() == rbName)
//    {
//      iSearchBy = _NAME;
//      txtSearch.setText(pnlHeader.getName());
//    }

    if (event.getSource() == btnSearch) { search(); }
    if (event.getSource() == btnOk)     { ok(); }

    if (iClose == 0) setButtons();

    if (event.getSource() == btnClose)  { close(); }
  }
}


/*
 *  @version 1.1 1/16/2008
 *  @author  John Victorine
 */
