/*
 * @iqstratAvailablePanel.java Version 1.1 09/04/2007
 *
 * Copyright (c) 2007 Kansas Geological Survey
 * 1930 Constant Avenue, Lawrence, Kansas, 66047, U.S.A.
 * All Rights Reserved.
 */

package iqstrat.gui;

import java.awt.*;
import java.awt.event.*;
import java.util.Observable;

import javax.swing.*;
import javax.swing.event.*;
import javax.swing.border.*;

import las.lasFileDataStruct;

import horizon.seq.seqListStruct;
import horizon.strat.stratListStruct;
import horizon.bio.bioStratListStruct;
import horizon.env.envListStruct;

import lith.lithology.lithologyListStruct;
import lith.texture.textureListStruct;
import lith.rock.rockColumnListStruct;

import brine.brineListStruct;

//import pfeffer.pfefferDataStruct;

import lith.rock.rockColumnListStruct;

import rock.rockDataListStruct;
import rock.rockImagesListStruct;
import rock.rockFileDataStruct;
import rock.fossil.fossilListStruct;
import rock.sedimentary.sedimentaryListStruct;
import rock.phi.phiListStruct;
import rock.color.rockColorListStruct;
import iqstrat.iqstratRemarkListStruct;

/** Class iqstratAvailablePanel
 *  <p> This Class will build the Available Plot Tracks Panel that will allow
 *      the user to turn on or off any track that can be displayed.
 *
 *  @version 1.1 09/04/2007
 *  @author  John R. Victorine
 */

public class iqstratAvailablePanel extends JPanel implements ActionListener
{
  private Observable notifier = null;

  public static final int OFF = 0;
  public static final int ON  = 1;

  public static final int _SOURCE      = iqstrat.iqstratTracksStruct._SOURCE;
  public static final int _TYPE        = iqstrat.iqstratTracksStruct._TYPE;
  public static final int _DESCRIPTION = iqstrat.iqstratTracksStruct._DESCRIPTION;
  public static final int _STATUS      = iqstrat.iqstratTracksStruct._STATUS;

  public static final int _SRC_LAS     = iqstrat.iqstratTracksStruct._SRC_LAS;
  public static final int _SRC_ROCK    = iqstrat.iqstratTracksStruct._SRC_ROCK;
  public static final int _SRC_TOPS    = iqstrat.iqstratTracksStruct._SRC_TOPS;
  public static final int _SRC_PFEFFER = iqstrat.iqstratTracksStruct._SRC_PFEFFER;
  public static final int _SRC_BRINE   = iqstrat.iqstratTracksStruct._SRC_BRINE;

  public static final int _SRC_ID      = iqstrat.iqstratTracksStruct._SRC_ID;
  public static final int _SRC_COLUMN  = iqstrat.iqstratTracksStruct._SRC_COLUMN;

  public static final int _ALL          = 0;
  public static final int _LAS          = 1;
  public static final int _CORE         = 2;
  public static final int _HORIZON      = 3;
  public static final int _USER_DEFINED = 4;
  public static final int _TOTAL        = 5;

  // Plot Tracks

  // Available Stratigraphic Plot Tracks

  public static final int _NONE                  = iqstrat.iqstratTracksStruct._NONE;
  // Gamma Lithology Track
  public static final int _LITHOLOGY_GR          = iqstrat.iqstratTracksStruct._LITHOLOGY_GR;
  // LAS Like Plot Tracks
  // -- Digital LAS File Tracks
  // .. Reference
  public static final int _LAS_REFERENCE         = iqstrat.iqstratTracksStruct._LAS_REFERENCE;
  // .. Resistivity
  public static final int _LAS_INDUCTION         = iqstrat.iqstratTracksStruct._LAS_INDUCTION;
  public static final int _LAS_MICRO_RESISTIVITY = iqstrat.iqstratTracksStruct._LAS_MICRO_RESISTIVITY;
  public static final int _LAS_RESISTIVITY       = iqstrat.iqstratTracksStruct._LAS_RESISTIVITY;
  public static final int _LAS_LATERLOG          = iqstrat.iqstratTracksStruct._LAS_LATERLOG;
  public static final int _LAS_NORMAL            = iqstrat.iqstratTracksStruct._LAS_NORMAL;
  public static final int _LAS_AHT               = iqstrat.iqstratTracksStruct._LAS_AHT;
  // .. Conductivity
  public static final int _LAS_CONDUCTIVITY      = iqstrat.iqstratTracksStruct._LAS_CONDUCTIVITY;
  // .. Porosity
  public static final int _LAS_LITHO_DENSITY_3   = iqstrat.iqstratTracksStruct._LAS_LITHO_DENSITY_3;
  public static final int _LAS_LITHO_DENSITY     = iqstrat.iqstratTracksStruct._LAS_LITHO_DENSITY;
  public static final int _LAS_SONIC             = iqstrat.iqstratTracksStruct._LAS_SONIC;
  // .. Temperature
  public static final int _LAS_TEMP              = iqstrat.iqstratTracksStruct._LAS_TEMP;
  // .. Permeability
  public static final int _LAS_PERM              = iqstrat.iqstratTracksStruct._LAS_PERM;
  // .. Spectral Gamma Ray
  public static final int _LAS_SPECTRAL_GR       = iqstrat.iqstratTracksStruct._LAS_SPECTRAL_GR;
  public static final int _LAS_SPECTRAL_RATIO    = iqstrat.iqstratTracksStruct._LAS_SPECTRAL_RATIO;
  // .. Computed Data
  public static final int _LAS_RHOMAA_UMAA       = iqstrat.iqstratTracksStruct._LAS_RHOMAA_UMAA;
  public static final int _LAS_RHOMAA_NPHI       = iqstrat.iqstratTracksStruct._LAS_RHOMAA_NPHI;
  public static final int _LAS_RHOMAA_DTMAA      = iqstrat.iqstratTracksStruct._LAS_RHOMAA_DTMAA;
  // .. Unknown Log Curves
  public static final int _LAS_LINEAR            = iqstrat.iqstratTracksStruct._LAS_LINEAR;
  public static final int _LAS_LOG               = iqstrat.iqstratTracksStruct._LAS_LOG;
  // .. Set Counts Limits
  public static final int _LAS_SET_GR_COUNTS     = iqstrat.iqstratTracksStruct._LAS_SET_GR_COUNTS;
  public static final int _LAS_SET_NEUT_COUNTS   = iqstrat.iqstratTracksStruct._LAS_SET_NEUT_COUNTS;
  // .. Colorlith
  public static final int _CLRLITH_RU            = iqstrat.iqstratTracksStruct._CLRLITH_RU;
  public static final int _CLRLITH_RN            = iqstrat.iqstratTracksStruct._CLRLITH_RN;
  public static final int _CLRLITH_RT            = iqstrat.iqstratTracksStruct._CLRLITH_RT;
  // .. Rock Lithology Columns
  public static final int _ROCK_COLUMN           = iqstrat.iqstratTracksStruct._ROCK_COLUMN;
  public static final int _ROCK_COLUMN_PD        = iqstrat.iqstratTracksStruct._ROCK_COLUMN_PD;
  public static final int _ROCK_COLUMN_RT        = iqstrat.iqstratTracksStruct._ROCK_COLUMN_RT;
  // .. Porosity Thin track
  public static final int _THIN_PHI              = iqstrat.iqstratTracksStruct._THIN_PHI;
  // .. Porosity Image Track
  public static final int _POROSITY_IMAGER       = iqstrat.iqstratTracksStruct._POROSITY_IMAGER;
  public static final int _POROSITY_IMAGER_N     = iqstrat.iqstratTracksStruct._POROSITY_IMAGER_N;
  // .. Colorlith Spectral Gamma Ray
  public static final int _CLRLITH_HALL          = iqstrat.iqstratTracksStruct._CLRLITH_HALL;
  public static final int _CLRLITH_SPGR          = iqstrat.iqstratTracksStruct._CLRLITH_SPGR;
  // .. Rock Texture by LAS Curves
  public static final int _LAS_TEXTURE           = iqstrat.iqstratTracksStruct._LAS_TEXTURE;
  // .. Resistivity Image Track
  public static final int _RESISTIVITY_IMAGER    = iqstrat.iqstratTracksStruct._RESISTIVITY_IMAGER;
  public static final int _RESISTIVITY_IMAGER_N  = iqstrat.iqstratTracksStruct._RESISTIVITY_IMAGER_N;
  // PfEFFER Plot Tracks
  public static final int _PFEFFER_RESISTIVITY   = iqstrat.iqstratTracksStruct._PFEFFER_RESISTIVITY;
  public static final int _PFEFFER_POROSITY      = iqstrat.iqstratTracksStruct._PFEFFER_POROSITY;
  public static final int _PFEFFER_2ND_POROSITY  = iqstrat.iqstratTracksStruct._PFEFFER_2ND_POROSITY;
  public static final int _PFEFFER_OTHER         = iqstrat.iqstratTracksStruct._PFEFFER_OTHER;
  public static final int _PFEFFER_FLOW_UNITS    = iqstrat.iqstratTracksStruct._PFEFFER_FLOW_UNITS;
  // Horizon Data Plot Tracks
  public static final int _SEQUENCE_STRAT        = iqstrat.iqstratTracksStruct._SEQUENCE_STRAT;
  public static final int _STRAT_UNITS_A         = iqstrat.iqstratTracksStruct._STRAT_UNITS_A;
  public static final int _DEP_ENVIRONMENT       = iqstrat.iqstratTracksStruct._DEP_ENVIRONMENT;
  // Brine Data Plot Tracks
  // -- Brine Measured Data Tracks
  public static final int _BRINE_STIFF           = iqstrat.iqstratTracksStruct._BRINE_STIFF;
  public static final int _BRINE_COLLINS         = iqstrat.iqstratTracksStruct._BRINE_COLLINS;
  public static final int _BRINE_PIPER           = iqstrat.iqstratTracksStruct._BRINE_PIPER;
  public static final int _BRINE_LAS_CATIONS     = iqstrat.iqstratTracksStruct._BRINE_LAS_CATIONS;
  public static final int _BRINE_LAS_ANIONS      = iqstrat.iqstratTracksStruct._BRINE_LAS_ANIONS;
  // Rock Data Plot Tracks
  // .... Rock Image Tracks
  public static final int _ROCK_BOX              = iqstrat.iqstratTracksStruct._ROCK_BOX;
  public static final int _ROCK_SLAB             = iqstrat.iqstratTracksStruct._ROCK_SLAB;
  public static final int _ROCK_THINSECTION      = iqstrat.iqstratTracksStruct._ROCK_THINSECTION;
  public static final int _ROCK_SEM              = iqstrat.iqstratTracksStruct._ROCK_SEM;
  public static final int _ROCK_IMG_OUTCROP      = iqstrat.iqstratTracksStruct._ROCK_IMG_OUTCROP;
  // .... Rock Measured Data Tracks
//  public static final int _ROCK_LITHOLOGY_GR     = iqstrat.iqstratTracksStruct._ROCK_LITHOLOGY_GR;
  public static final int _ROCK_LAS_CORE_PHI     = iqstrat.iqstratTracksStruct._ROCK_LAS_CORE_PHI;
  public static final int _ROCK_LAS_OUTCROP      = iqstrat.iqstratTracksStruct._ROCK_LAS_OUTCROP;
  public static final int _ROCK_LAS_CORE_K       = iqstrat.iqstratTracksStruct._ROCK_LAS_CORE_K;
  public static final int _ROCK_LAS_PLUG_K       = iqstrat.iqstratTracksStruct._ROCK_LAS_PLUG_K;
  public static final int _ROCK_LAS_SATURATION   = iqstrat.iqstratTracksStruct._ROCK_LAS_SATURATION;
  public static final int _ROCK_LAS_ARCHIE       = iqstrat.iqstratTracksStruct._ROCK_LAS_ARCHIE;
  public static final int _ROCK_LAS_GR           = iqstrat.iqstratTracksStruct._ROCK_LAS_GR;
  public static final int _ROCK_LAS_SPGR         = iqstrat.iqstratTracksStruct._ROCK_LAS_SPGR;
  public static final int _ROCK_LAS_LINEAR       = iqstrat.iqstratTracksStruct._ROCK_LAS_LINEAR;
  public static final int _ROCK_LAS_LOG          = iqstrat.iqstratTracksStruct._ROCK_LAS_LOG;
  // .... Colorlith
//  public static final int _ROCK_COLORLITH        = iqstrat.iqstratTracksStruct._ROCK_COLORLITH;
  // .... Rock Observational Data Tracks
//  public static final int _ROCK_LITHOLOGY        = iqstrat.iqstratTracksStruct._ROCK_LITHOLOGY;
//  public static final int _ROCK_LITHOLOGY_ABREV  = iqstrat.iqstratTracksStruct._ROCK_LITHOLOGY_ABREV;
//  public static final int _ROCK_LITHOLOGY_STRK   = iqstrat.iqstratTracksStruct._ROCK_LITHOLOGY_STRK;
  public static final int _ROCK_MEASURED_SECTION = iqstrat.iqstratTracksStruct._ROCK_MEASURED_SECTION;
  public static final int _ROCK_TEXTURE          = iqstrat.iqstratTracksStruct._ROCK_TEXTURE;
  public static final int _ROCK_GRAIN            = iqstrat.iqstratTracksStruct._ROCK_GRAIN;
  public static final int _ROCK_THIN_PHI         = iqstrat.iqstratTracksStruct._ROCK_THIN_PHI;
  public static final int _ROCK_POROSITY         = iqstrat.iqstratTracksStruct._ROCK_POROSITY;
//  public static final int _ROCK_POROSITY_IMAGER  = iqstrat.iqstratTracksStruct._ROCK_POROSITY_IMAGER;
//  public static final int _ROCK_TEXTURE          = iqstrat.iqstratTracksStruct._ROCK_TEXTURE;
  public static final int _SED_STRUCTURE         = iqstrat.iqstratTracksStruct._SED_STRUCTURE;
  public static final int _ROCK_FOSSILS          = iqstrat.iqstratTracksStruct._ROCK_FOSSILS;
  public static final int _BIO_STRATIGRAPHY      = iqstrat.iqstratTracksStruct._BIO_STRATIGRAPHY;
  public static final int _ROCK_COLOR            = iqstrat.iqstratTracksStruct._ROCK_COLOR;
  public static final int _REMARKS               = iqstrat.iqstratTracksStruct._REMARKS;
  // TOTAL Plot Tracks
  public static final int TOTAL_TRACKS           = iqstrat.iqstratTracksStruct.TOTAL_TRACKS;

  // Profile Action

  public static final int _LASA  = cmn.cmnStruct._LAS;  // LAS File Data Entry & Viewer
  public static final int _TOPS  = cmn.cmnStruct._TOPS; // Horizons Data Entry & Viewer
  public static final int _COREA = cmn.cmnStruct._CORE; // Core Data Data Entry & Viewer
  public static final int _ROCK  = cmn.cmnStruct._ROCK; // Geologist Report Datay & Viewer
  public static final int _LAS3  = cmn.cmnStruct._LAS3; // LAS 3.0 File Viewer
  public static final int _KGS   = cmn.cmnStruct._KGS;  // KGS Data Viewer

  private int iAction = -1;

  // PLOT Track Type Defined

  private int iOHM  = -1;  // Default Resistivity
  private int iPHI  = -1;  // Default Porosity
  private int iTHIN = -1;  // Thin Track Porosity

  // Log Type

  private static final int _LITHO_DENSITY = 0;
  private static final int _RESISTIVITY   = 1;
  private static final int _SONIC         = 2;
  private static final int _SPECTRAL_GR   = 3;
  private static final int _GAMMA_RAY     = 4;
  private static final int _MISC          = 5;

  private String sLogType[]  = { "L", "R", "S", "U", "G", "M" };
  private int    iLogType[]  = { OFF, OFF, OFF, OFF, OFF, OFF };

  private String sDataType[] = { "Brine", "Core", "Images" };
  private int    iDataType[] = { OFF, OFF, OFF };

  private int    iType       = -1;

  // Track Selection

  public static final int _SINGLE = 0;
  public static final int _DOUBLE = 1;

  private int iLAS = _DOUBLE;

  private int          iDisplay    = _ALL;  // Display all radiobuttons

  private int          iTrack      = -1;   // The Track that was altered

  private int          iSelect     = 0;    // Number of tracks selected
  private int          iSelected[] = null; // Tracks selected for view

  // Available Panel Widget Variables

  private int          iRows   = 0;  // Total Number of Rows in Panel
  private int          ilbl    = 0;  // Total Number of Labels
  private int          irb     = 0;  // Total Number of Radio Buttons

  private int          iStart = 0;
  private int          iEnd   = 0;
  private int          iTotal = 0;

  private JRadioButton rbS     = new JRadioButton();
  private JRadioButton rbD     = new JRadioButton();

  private JPanel       panel   = null;
  private JPanel       pnl[]   = null;
  private JLabel       lbl[]   = null; // Array of Labels to group the Tracks by
  private JRadioButton rb[]    = null;

  // Quick Plot Panels

  private static final int _DEFAULT    = 0;
  private static final int _COLORLITH  = 1;
  private static final int _LOG_ONLY   = 2;
  private static final int _GEOREPORT  = 3;

  private static final int _BRINE_DATA = 0;
  private static final int _CORE_DATA  = 1;
  private static final int _IMG_DATA   = 2;

  private static final String s1st[]  = {
	  "Default", "Log/Colorlith", "Log Only", "Georeport" };
  private static final String s2nd[]  = {
	  "Litho/PHI", "Resistivity", "Sonic", "Spectral GR", "Gamma Ray", "Misc" };

  private JRadioButton rb1st[] = null;
  private JRadioButton rb2nd[] = null;
  private JCheckBox    cb[]    = null;

  /** Constructor iqstratAvailablePanel()
   *  <p> This is the Constructor for this class.
   *  @param notifier = Observable
   */

  public iqstratAvailablePanel(Observable notifier)
  {
    try
    {
      this.notifier = notifier;
      jbInit();
    }
    catch(Exception ex)
    {
      ex.printStackTrace();
    }
  }

  /** METHOD jbInit()
   *  <p> This Method will create the Panel for this class.
   *  @throws Exception
   */

  private void jbInit() throws Exception
  {
	int i=0;

    JPanel      pnlTrk   = new JPanel();
    JPanel      pnlBase  = new JPanel();
    JPanel      pnlType  = new JPanel();
    JPanel      pnl1st   = new JPanel();
    JPanel      pnl3rd   = new JPanel();
    JPanel      pnl2nd   = new JPanel();
    JScrollPane scroll   = new JScrollPane();
    ButtonGroup group    = new ButtonGroup();
    ButtonGroup group1st = new ButtonGroup();
    ButtonGroup group2nd = new ButtonGroup();

    TitledBorder titledBorder = new TitledBorder(
        BorderFactory.createEtchedBorder(Color.white,new Color(165, 163, 151)),
        "Default Track Order");
    titledBorder.setTitleFont(new java.awt.Font("Dialog", 1, 11));

    TitledBorder titledTrack = new TitledBorder(
        BorderFactory.createEtchedBorder(Color.white,new Color(165, 163, 151)),
        "Type of LAS Track to Display");
    titledTrack.setTitleFont(new java.awt.Font("Dialog", 1, 11));

    TitledBorder titled1st = new TitledBorder(
        BorderFactory.createEtchedBorder(Color.white,new Color(165, 163, 151)),
        "Plot Track Type");
    titled1st.setTitleFont(new java.awt.Font("Dialog", 1, 11));

    TitledBorder titled2nd = new TitledBorder(
        BorderFactory.createEtchedBorder(Color.white,new Color(165, 163, 151)),
        "Log Data Type");
    titled2nd.setTitleFont(new java.awt.Font("Dialog", 1, 11));

    try
    {
      this.setLayout(new BorderLayout());
      buildPanel();
      panel.setBorder(titledBorder);

      // Type of LAS Track

      pnlTrk.setLayout(new GridLayout());
      pnlTrk.setBorder(titledTrack);

      rbS.setFont(new java.awt.Font("Dialog", 1, 11));
      rbS.setText("Single");
      rbS.addActionListener(this);

      rbD.setFont(new java.awt.Font("Dialog", 1, 11));
      rbD.setSelected(true);
      rbD.setText("Expanded");
      rbD.addActionListener(this);

      // Base Panel

      pnlBase.setLayout(new GridLayout(2,1));

      pnlType.setLayout(new BorderLayout());

      pnl1st.setLayout(new GridLayout(2,2));
      pnl1st.setBorder(titled1st);

      rb1st = new JRadioButton[s1st.length];

      for (i=0; i<s1st.length; i++)
      {
        rb1st[i] = new JRadioButton();
        rb1st[i].setFont(new java.awt.Font("Dialog", 1, 11));
		if (i==0) rb1st[i].setSelected(true);
        rb1st[i].setText( s1st[i] );
        rb1st[i].addActionListener(this);

        pnl1st.add(rb1st[i]);
        group1st.add(rb1st[i]);
	  }

      pnl2nd.setLayout(new GridLayout(2,3));
      pnl2nd.setBorder(titled2nd);

      rb2nd = new JRadioButton[s2nd.length];

      for (i=0; i<s2nd.length; i++)
      {
        rb2nd[i] = new JRadioButton();
        rb2nd[i].setFont(new java.awt.Font("Dialog", 1, 11));
        rb2nd[i].setText( s2nd[i] );
        rb2nd[i].addActionListener(this);

        pnl2nd.add(rb2nd[i]);
        group2nd.add(rb2nd[i]);
	  }

      pnl3rd.setLayout(new GridLayout(3,1));

      cb = new JCheckBox[3];
      for (i=0; i<3; i++)
      {
        cb[i] = new JCheckBox();
        cb[i].setEnabled(false);
        switch (i)
        {
		  case 0:
            cb[i].setText("Brine");
            break;
		  case 1:
            cb[i].setText("Core");
            break;
		  case 2:
            cb[i].setText("Images");
            break;
	    }
        cb[i].addActionListener(this);

        pnl3rd.add(cb[i], null);
	  }

      this.add(pnlTrk, BorderLayout.NORTH);
      pnlTrk.add(rbS, null);
      pnlTrk.add(rbD, null);
      group.add(rbS);
      group.add(rbD);

      this.add(scroll, BorderLayout.CENTER);
      scroll.getViewport().add(panel, null);

      this.add(pnlBase, BorderLayout.SOUTH);
//      pnlBase.add(pnl1st, null);
      pnlBase.add(pnlType, null);
      pnlType.add(pnl1st, BorderLayout.CENTER);
      pnlType.add(pnl3rd, BorderLayout.EAST);
      pnlBase.add(pnl2nd, null);
    }
    catch (Exception e)
    {
      e.printStackTrace();
    }
  }

  /** Method buildPanel()
   * <p> This method will build the Available Tracks Panel
   * @return  panel    = the Available Tracks Panel
   * @throws Exception
   */

  public JPanel buildPanel() throws Exception
  {
    String source = "";
    ButtonGroup group = new ButtonGroup();

    iRows   = iqstrat.iqstratTracksStruct.TOTAL_TRACKS +
              iqstrat.iqstratTracksStruct.TOTAL_SOURCES;

    panel = new JPanel();

    panel.setLayout(new GridLayout(iRows,1));
    panel.setSize(100, iRows*20);

    pnl     = new JPanel[iqstrat.iqstratTracksStruct.TOTAL_SOURCES];
    lbl     = new JLabel[iqstrat.iqstratTracksStruct.TOTAL_SOURCES];
    rb      = new JRadioButton[iqstrat.iqstratTracksStruct.TOTAL_TRACKS];

    for (int i=0; i<iqstrat.iqstratTracksStruct.TOTAL_TRACKS; i++)
    {
      if (!source.equals(iqstrat.iqstratTracksStruct.TRACK[i][_SOURCE]))
      {
        source = iqstrat.iqstratTracksStruct.TRACK[i][_SOURCE];

        pnl[ilbl] = new JPanel();
        pnl[ilbl].setBorder(BorderFactory.createEtchedBorder());

        lbl[ilbl] = new JLabel();
        lbl[ilbl].setFont(new java.awt.Font("Dialog", 1, 11));

        for (int j=0; j<iqstrat.iqstratTracksStruct.TOTAL_SOURCES; j++)
        {
          if (source.equals(iqstrat.iqstratTracksStruct.SOURCE[j][_SRC_ID]))
          {
            lbl[ilbl].setText(iqstrat.iqstratTracksStruct.SOURCE[j][_SRC_COLUMN]);
            pnl[ilbl].setBackground(
                new Color(iqstrat.iqstratTracksStruct.COLORS[j][0],
                          iqstrat.iqstratTracksStruct.COLORS[j][1],
                          iqstrat.iqstratTracksStruct.COLORS[j][2]));
          }
        }
        panel.add(pnl[ilbl], null);
        pnl[ilbl].add(lbl[ilbl], null);
        ilbl++;
      }

      rb[irb] = new JRadioButton();
      rb[irb].setSelected(false);
      rb[irb].setEnabled(false);

      rb[irb].setFont(new java.awt.Font("Dialog", 0, 11));
      rb[irb].setText(iqstrat.iqstratTracksStruct.TRACK[i][_DESCRIPTION]);
      rb[irb].addActionListener(this);

      panel.add(rb[irb], null);
      irb++;
    }

    group.add(rb[_ROCK_MEASURED_SECTION]);
    group.add(rb[_ROCK_TEXTURE]);

    return (panel);
  }

  /* ===================================================================== *
   * -------------------------- SET METHODS ------------------------------ *
   * ===================================================================== */

  /** Method setSelected()
   * <p> This method will set the tracks that should be selected.
   * @param iSelected = Array of selected tracks
   */

  public void setSelected(int iSelected[])
  {
    int i = 0;

    this.iSelected = iSelected;

    for (i=0; i<iqstrat.iqstratTracksStruct.TOTAL_TRACKS; i++)
    {
      rb[i].setSelected(false);
    }

    if (iSelected != null)
    {
      for (i=0; i<iSelected.length; i++)
      {
        if (iSelected[i] > -1)
          rb[iSelected[i]].setSelected(true);
      }
    }
  }

  /** Method setByAction()
   * <p> This method will set the tracks by the Action and data present.
   * @param iAction    = The Type of Profile to display
   * @param stLAS      = LAS File Data Structure
   * @param stSeq      = Sequence Stratigraphy Data List Structure
   * @param stTops     = Stratigraphic Units Data List Structure
   * @param stEnv      = Depositional Environment Data List Structure
   * @param stBrine    = Brine Data List Structure
   * @param stMeasured = Rock Data List Structure
   * @param stImage    = Rock Image Data List Structure
   * @param stColumn   = Rock Column Lithology Data List Structure
   * @param stLith     = Rock Lithology Data List Structure
   * @param stTexture  = Rock Texture Data List Structure
   * @param stPHI      = Porosity Type Data List Structure
   * @param stFossil   = Fossils Data List Structure
   * @param stBio      = Bio-stratigraphy Data List Structure
   * @param stSed      = Sedimentary Structure Data List Structure
   * @param stColor    = Rock Color Data List Structure
   * @param stSed      = Depositional Environment Data List Structure
   * @param stDesc     = Rock Description Data List Structure
   */

  public void setByAction( int                     iAction,
                           lasFileDataStruct       stLAS,
                           seqListStruct           stSeq,
                           stratListStruct         stTops,
                           envListStruct           stEnv,
                           brineListStruct         stBrine,
                           rockDataListStruct      stMeasured,
                           rockImagesListStruct    stImage,
                           rockColumnListStruct    stColumn,
                           lithologyListStruct     stLith,
                           textureListStruct       stTexture,
                           phiListStruct           stPHI,
                           fossilListStruct        stFossil,
                           bioStratListStruct      stBio,
                           sedimentaryListStruct   stSed,
                           rockColorListStruct     stColor,
                           iqstratRemarkListStruct stDesc )
  {
    int i=0;

    this.iAction = iAction;

    iTotal = 0;

    setType( stLAS );
    iType = getType();

    for (i=1; i<4; i++)
    {
	  rb1st[i].setEnabled(true);
	}

    if (stDesc == null)
      rb1st[3].setEnabled(false);
    if (stLAS == null)
    {
      rb1st[1].setEnabled(false);
      rb1st[2].setEnabled(false);
    }

    if (iType != -1)
      rb2nd[iType].setSelected(true);

    for (i=0; i<6; i++)
    {
	  rb2nd[i].setEnabled(true);
	  if (iLogType[i] == OFF)
	    rb2nd[i].setEnabled(false);
	}

    if (stBrine != null)
    {
	  cb[0].setEnabled(true);
	  cb[0].setSelected(true);
	  iDataType[0] = ON;
	}

	if (stMeasured != null)
	{
	  cb[1].setEnabled(true);
	  cb[1].setSelected(true);
	  iDataType[1] = ON;
	}

    if (stImage != null)
    {
	  cb[2].setEnabled(true);
	  cb[2].setSelected(true);
	  iDataType[2] = ON;
	}

    setTrackType( stLAS );
    setLASButtons( stLAS );
    setRockButtons( stMeasured );
    setBrineButtons( stBrine );

    rb[_SEQUENCE_STRAT].setEnabled(true);
    if ((iAction != _ROCK) && (stSeq != null))
    {
	  rb[_SEQUENCE_STRAT].setSelected(true);
	}

    rb[_DEP_ENVIRONMENT].setEnabled(true);
    if (stEnv != null)
    {
	  if (stEnv.iCount > 0)
	  {
        rb[_DEP_ENVIRONMENT].setSelected(true);
	  }
    }

    rb[_STRAT_UNITS_A].setEnabled(true);
    if (stTops != null)
    {
	  if (stTops.iCount > 0)
        rb[_STRAT_UNITS_A].setSelected(true);
    }

    setRockImageButtons( stImage );
    setRockDescButtons( stColumn, stLith, stTexture, stPHI, stFossil,
                        stBio, stSed, stColor, stEnv, stDesc );

    for (i=0; i<TOTAL_TRACKS; i++)
    {
      if (rb[i].isEnabled())
        iTotal++;
    }

    iTotal = iTotal+3;
    panel.removeAll();
    if (iTotal < 13)
      panel.setLayout(new GridLayout(13,1));
    else
      panel.setLayout(new GridLayout(iTotal,1));
    panel.setSize(100, iTotal*20);

    for (i=0; i<TOTAL_TRACKS; i++)
    {
      if ((i == iqstrat.iqstratTracksStruct._LITHOLOGY_GR) &&
          (stLAS != null))
      {
        pnl[iqstrat.iqstratTracksStruct._SRC_LAS].setBackground(
            new Color(iqstrat.iqstratTracksStruct.COLORS[_SRC_LAS][0],
                      iqstrat.iqstratTracksStruct.COLORS[_SRC_LAS][1],
                      iqstrat.iqstratTracksStruct.COLORS[_SRC_LAS][2]));
        lbl[iqstrat.iqstratTracksStruct._SRC_LAS].setText(
            iqstrat.iqstratTracksStruct.SOURCE[_SRC_LAS][_SRC_COLUMN]);

        panel.add(pnl[iqstrat.iqstratTracksStruct._SRC_LAS], null);
        pnl[iqstrat.iqstratTracksStruct._SRC_LAS].add(
            lbl[iqstrat.iqstratTracksStruct._SRC_LAS], null);
      }

//      if ((iAction != _LASA) && (iAction != _TOPS))
      if ((iAction != cmn.cmnStruct._LAS) && (iAction != cmn.cmnStruct._TOPS))
      {
//        if ((i == iqstrat.iqstratTracksStruct._ROCK_SLAB) &&
        if ((i == iqstrat.iqstratTracksStruct._ROCK_BOX) &&
            ((stMeasured != null) || (stImage != null) || (stDesc != null)))
        {
          pnl[iqstrat.iqstratTracksStruct._SRC_ROCK].setBackground(
              new Color(iqstrat.iqstratTracksStruct.COLORS[_SRC_ROCK][0],
                        iqstrat.iqstratTracksStruct.COLORS[_SRC_ROCK][1],
                        iqstrat.iqstratTracksStruct.COLORS[_SRC_ROCK][2]));
          lbl[iqstrat.iqstratTracksStruct._SRC_ROCK].setText(
              iqstrat.iqstratTracksStruct.SOURCE[_SRC_ROCK][_SRC_COLUMN]);

          panel.add(pnl[iqstrat.iqstratTracksStruct._SRC_ROCK], null);
          pnl[iqstrat.iqstratTracksStruct._SRC_ROCK].add(
              lbl[iqstrat.iqstratTracksStruct._SRC_ROCK], null);
        }
      }

      if (i == iqstrat.iqstratTracksStruct._SEQUENCE_STRAT)
      {
        pnl[iqstrat.iqstratTracksStruct._SRC_TOPS].setBackground(
            new Color(iqstrat.iqstratTracksStruct.COLORS[_SRC_TOPS][0],
                      iqstrat.iqstratTracksStruct.COLORS[_SRC_TOPS][1],
                      iqstrat.iqstratTracksStruct.COLORS[_SRC_TOPS][2]));
        lbl[iqstrat.iqstratTracksStruct._SRC_TOPS].setText(
            iqstrat.iqstratTracksStruct.SOURCE[_SRC_TOPS][_SRC_COLUMN]);

        panel.add(pnl[iqstrat.iqstratTracksStruct._SRC_TOPS], null);
        pnl[iqstrat.iqstratTracksStruct._SRC_TOPS].add(
            lbl[iqstrat.iqstratTracksStruct._SRC_TOPS], null);
      }

      if (rb[i].isEnabled())
        panel.add(rb[i], null);
    }

    setButtonColors();

    panel.updateUI();
    this.updateUI();
  }

  /** Method setLASButtons()
   * <p> This method will turn off and disable any LAS Plot Tracks that do not
   *     have the appropriate log curves for that track.
   * @param st = the LAS File Data Structure
   */

  public void setLASButtons( lasFileDataStruct st )
  {
    if (st != null)
    {
	  if (st.iGR > -1)
	  {
        rb[_LITHOLOGY_GR].setEnabled(true);
        if ((iAction == _LASA) || (iAction == _LAS3) || (iAction == _KGS))
          rb[_LITHOLOGY_GR].setSelected(true);
      }

	  if ((st.iGR > -1) || (st.iCGR > -1) || (st.iSP > -1) || (st.iCAL > -1))
	  {
        rb[_LAS_REFERENCE].setEnabled(true);
//        if ((iAction == _LASA) || (iAction == _TOPS) || (iAction == _LAS3) || (iAction == _KGS))
          rb[_LAS_REFERENCE].setSelected(true);
	  }
	}

    if ((st != null) && (iType > -1) &&
        ((iAction == _LASA)  || (iAction == _LAS3) || (iAction == _KGS)))
    {
	  if (st.iGR > -1)
	  {
        rb[_LITHOLOGY_GR].setEnabled(true);
        rb[_LITHOLOGY_GR].setSelected(true);
      }

	  if ((st.iGR > -1) || (st.iCGR > -1) || (st.iSP > -1) || (st.iCAL > -1))
	  {
        rb[_LAS_REFERENCE].setEnabled(true);
        rb[_LAS_REFERENCE].setSelected(true);
	  }

      if ((st.iNPHI > -1) || (st.iRHOB > -1) || (st.iDPHI > -1) || (st.iPE > -1))
      {
        rb[_LAS_LITHO_DENSITY_3].setEnabled(true);
        rb[_LAS_LITHO_DENSITY].setEnabled(true);
      }

      if ((st.iNPHI > -1) && ((st.iRHOB > -1) || (st.iDPHI > -1)))
      {
        if (st.iPE > -1)
        {
          rb[_CLRLITH_RU].setEnabled(true);
          rb[_ROCK_COLUMN].setEnabled(true);
		}
        else
        {
          rb[_CLRLITH_RN].setEnabled(true);
          rb[_ROCK_COLUMN_PD].setEnabled(true);
		}
	  }

      if ((st.iDT > -1) || (st.iSPHI > -1))
      {
        rb[_LAS_SONIC].setEnabled(true);
      }

      if (((st.iDT > -1) || (st.iSPHI > -1)) && ((st.iRHOB > -1) || (st.iDPHI > -1)))
      {
        rb[_CLRLITH_RT].setEnabled(true);
        rb[_ROCK_COLUMN_RT].setEnabled(true);
	  }

      if ((st.iTEMP > -1) || (st.iTEMPDIFF > -1))
      {
	    rb[_LAS_TEMP].setEnabled(true);
	  }

      if (st.iPERM > -1)
      {
		rb[_LAS_PERM].setEnabled(true);
	  }

      if ((st.iNPHI > -1) || (st.iDPHI > -1) || (st.iSPHI > -1))
      {
        rb[_THIN_PHI].setEnabled(true);
        rb[_POROSITY_IMAGER].setEnabled(true);
        rb[_POROSITY_IMAGER_N].setEnabled(true);
	  }

      if ((st.iRES > -1)  || (st.iRMED > -1) ||
          (st.iRDEP > -1) || (st.iRSHAL > -1))
      {
        rb[_LAS_RESISTIVITY].setEnabled(true);
      }

      if ((st.iILD > -1)  || (st.iILM > -1) ||
          (st.iSFLU > -1) || (st.iLL8 > -1))
      {
        rb[_LAS_INDUCTION].setEnabled(true);
      }

      if ((st.iLL > -1) || (st.iMLL > -1) || (st.iLL8 > -1))
      {
        rb[_LAS_LATERLOG].setEnabled(true);
      }

      if ((st.iLN  > -1) || (st.iSN > -1))
      {
        rb[_LAS_NORMAL].setEnabled(true);
	  }

      if ((st.iMNOR > -1) || (st.iMSFL > -1) || (st.iMINV > -1))
      {
        rb[_LAS_MICRO_RESISTIVITY].setEnabled(true);
      }

      if ((st.iAHT10 > -1) || (st.iAHT20 > -1) || (st.iAHT30 > -1) ||
          (st.iAHT60 > -1) || (st.iAHT90 > -1))
      {
        rb[_LAS_AHT].setEnabled(true);
      }

      if ((st.iCOND > -1) || (st.iCILD > -1) || (st.iCILM > -1))
      {
        rb[_LAS_CONDUCTIVITY].setEnabled(true);
      }

      if ((st.iRES > -1)   || (st.iRMED > -1)  ||
          (st.iRDEP > -1)  || (st.iRSHAL > -1) ||
          (st.iILD > -1)   || (st.iILM > -1)   || (st.iSFLU > -1)  ||
          (st.iLL > -1)    || (st.iMLL > -1)   || (st.iLL8 > -1)   ||
          (st.iLN  > -1)   || (st.iSN > -1)    ||
          (st.iMNOR > -1)  || (st.iMSFL > -1)  || (st.iMINV > -1)  ||
          (st.iAHT10 > -1) || (st.iAHT20 > -1) || (st.iAHT30 > -1) ||
          (st.iAHT60 > -1) || (st.iAHT90 > -1) ||
          (st.iCOND > -1)  || (st.iCILD > -1)  || (st.iCILM > -1))
      {
        rb[_RESISTIVITY_IMAGER].setEnabled(true);
        rb[_RESISTIVITY_IMAGER_N].setEnabled(true);
      }

      if (st.iGRN > -1)
      {
        rb[_LAS_SET_GR_COUNTS].setEnabled(true);
      }

      if (st.iNEUT > -1)
      {
        rb[_LAS_SET_NEUT_COUNTS].setEnabled(true);
      }

      if ((st.iNPHI > -1) && ((st.iRHOB > -1) || (st.iDPHI > -1)) && (st.iGR > -1))
      {
        rb[_LAS_TEXTURE].setEnabled(true);
      }

      if ((st.iTh > -1) || (st.iU > -1) || (st.iK > -1))
      {
        rb[_LAS_SPECTRAL_GR].setEnabled(true);
      }

      if ((st.iTh > -1) && (st.iU > -1) && (st.iK > -1))
      {
        rb[_LAS_SPECTRAL_RATIO].setEnabled(true);
        rb[_CLRLITH_SPGR].setEnabled(true);
        rb[_CLRLITH_HALL].setEnabled(true);
      }

      if ((st.iUmaa > -1) && (st.iRhomaa > -1))
      {
        rb[_LAS_RHOMAA_UMAA].setEnabled(true);
      }

      if ((st.iDTmaa > -1) && (st.iRhomaa > -1))
      {
        rb[_LAS_RHOMAA_DTMAA].setEnabled(true);
      }

      if ((st.iNPHI > -1) && (st.iRhomaa > -1))
      {
        rb[_LAS_RHOMAA_NPHI].setEnabled(true);
      }

      if ((st.iLIN_1 > -1) || (st.iLIN_2 > -1) || (st.iLIN_3 > -1) || (st.iLIN_4 > -1))
      {
        rb[_LAS_LINEAR].setEnabled(true);
      }

      if ((st.iLOG_1 > -1) || (st.iLOG_2 > -1) || (st.iLOG_3 > -1) || (st.iLOG_4 > -1))
      {
        rb[_LAS_LOG].setEnabled(true);
      }

      switch (iType)
      {
        case _LITHO_DENSITY:
          rb[_LAS_LITHO_DENSITY].setSelected(true);
//          rb[_LAS_TEXTURE].setSelected(true);

          if (st.iPE > -1)
          {
            rb[_CLRLITH_RU].setSelected(true);
            rb[_ROCK_COLUMN].setSelected(true);
  		  }
          else
          {
            rb[_CLRLITH_RN].setSelected(true);
            rb[_ROCK_COLUMN_PD].setSelected(true);
  		  }

          rb[_THIN_PHI].setSelected(true);
          rb[_POROSITY_IMAGER].setSelected(true);
          rb[_POROSITY_IMAGER_N].setSelected(true);
          break;
        case _RESISTIVITY:
          if ((st.iILD > -1)  || (st.iILM > -1) ||
              (st.iSFLU > -1) || (st.iLL8 > -1))
          {
            rb[_LAS_INDUCTION].setSelected(true);
          }
          else if ((st.iMNOR > -1) || (st.iMSFL > -1) || (st.iMINV > -1))
          {
            rb[_LAS_MICRO_RESISTIVITY].setSelected(true);
          }
          else if ((st.iRES > -1)  || (st.iRMED > -1) ||
                   (st.iRDEP > -1) || (st.iRSHAL > -1))
          {
            rb[_LAS_RESISTIVITY].setSelected(true);
          }
          else if ((st.iAHT10 > -1) || (st.iAHT20 > -1) || (st.iAHT30 > -1) ||
                   (st.iAHT60 > -1) || (st.iAHT90 > -1))
          {
            rb[_LAS_AHT].setSelected(true);
          }
          else if ((st.iLL > -1) || (st.iMLL > -1) || (st.iLL8 > -1))
          {
            rb[_LAS_LATERLOG].setSelected(true);
          }
          else if ((st.iLN  > -1) || (st.iSN > -1))
          {
            rb[_LAS_NORMAL].setSelected(true);
		  }

          if ((st.iCOND > -1) || (st.iCILD > -1) || (st.iCILM > -1))
          {
            rb[_LAS_CONDUCTIVITY].setSelected(true);
          }

          rb[_RESISTIVITY_IMAGER].setSelected(true);
          rb[_RESISTIVITY_IMAGER_N].setSelected(true);
          break;
        case _SONIC:
          rb[_LAS_SONIC].setSelected(true);

          if ((st.iRHOB > -1) || (st.iDPHI > -1))
          {
            rb[_CLRLITH_RT].setSelected(true);
            rb[_ROCK_COLUMN_RT].setSelected(true);
		  }

          iPHI  = las.lasStandardTools._SPHI;
  	      iTHIN = iqstrat.iqstratTracksStruct._THIN_SPHI;

          rb[_THIN_PHI].setSelected(true);
          rb[_POROSITY_IMAGER].setSelected(true);
          rb[_POROSITY_IMAGER_N].setSelected(true);
          break;
        case _SPECTRAL_GR:
          rb[_LAS_SPECTRAL_GR].setSelected(true);
          rb[_LAS_SPECTRAL_RATIO].setSelected(true);
          rb[_CLRLITH_SPGR].setSelected(true);
          rb[_CLRLITH_HALL].setSelected(true);
          break;
        case _GAMMA_RAY:
          break;
	  }
	}
  }

  /** Method setRockButtons()
   * <p> This method will turn off and disable any Rock Plot Tracks that do not
   *     have the appropriate measured rock data curves for that track.
   * @param st = the Rock Data List Structure
   */

  public void setRockButtons( rockDataListStruct st )
  {
//    if ((st != null) &&
//        ((iAction == _CORE)  || (iAction == _LAS3) || (iAction == _KGS)))
    if ((st != null) &&
        ((iAction == cmn.cmnStruct._CORE)  || (iAction == cmn.cmnStruct._LAS3) ||
         (iAction == cmn.cmnStruct._KGS)))
    {
      if ((st._GMCC > -1) || (st._PCORE > -1) || (st._PPLUG > -1) ||
          (st._P800 > -1) || (st._PINSI > -1))
      {
        rb[_ROCK_LAS_CORE_PHI].setSelected(true);
        rb[_ROCK_LAS_CORE_PHI].setEnabled(true);

//        rb[_ROCK_LITHOLOGY_GR].setEnabled(true);
//        rb[_ROCK_COLORLITH].setEnabled(true);
        rb[_ROCK_THIN_PHI].setEnabled(true);
        rb[_ROCK_POROSITY].setEnabled(true);
//        rb[_ROCK_POROSITY_IMAGER].setEnabled(true);
      }

      if ((st._RHOD > -1) || (st._RHOW > -1) || (st._PEFF > -1))
      {
        rb[_ROCK_LAS_OUTCROP].setSelected(true);
        rb[_ROCK_LAS_OUTCROP].setEnabled(true);
      }

      if ((st._KMAX > -1) || (st._K90 > -1) || (st._KVRT > -1))
      {
        rb[_ROCK_LAS_CORE_K].setSelected(true);
        rb[_ROCK_LAS_CORE_K].setEnabled(true);
      }

      if ((st._KPLG > -1)  || (st._KKL > -1) || (st._KINSI > -1) ||
          (st._KKLIN > -1) || (st._KPVRT > -1))
      {
        rb[_ROCK_LAS_PLUG_K].setSelected(true);
        rb[_ROCK_LAS_PLUG_K].setEnabled(true);
      }

      if ((st._SOIL > -1) || (st._SW > -1))
      {
        rb[_ROCK_LAS_SATURATION].setSelected(true);
        rb[_ROCK_LAS_SATURATION].setEnabled(true);
      }

      if ((st._MAMB > -1) || (st._MINSI > -1) ||
          (st._NAMB > -1) || (st._NINSI > -1))
      {
        rb[_ROCK_LAS_ARCHIE].setSelected(true);
        rb[_ROCK_LAS_ARCHIE].setEnabled(true);
      }

      if ((st._GR > -1) || (st._CGR > -1))
      {
        rb[_ROCK_LAS_GR].setSelected(true);
        rb[_ROCK_LAS_GR].setEnabled(true);
      }

      if ((st._TH > -1) || (st._U > -1) || (st._K > -1))
      {
        rb[_ROCK_LAS_SPGR].setSelected(true);
        rb[_ROCK_LAS_SPGR].setEnabled(true);
      }

      if ((st._LIN_1 > -1) || (st._LIN_2 > -1) || (st._LIN_3 > -1) || (st._LIN_4 > -1))
      {
        rb[_ROCK_LAS_LINEAR].setSelected(true);
        rb[_ROCK_LAS_LINEAR].setEnabled(true);
      }

      if ((st._LOG_1 > -1) || (st._LOG_2 > -1) || (st._LOG_3 > -1) || (st._LOG_4 > -1))
      {
        rb[_ROCK_LAS_LOG].setSelected(true);
        rb[_ROCK_LAS_LOG].setEnabled(true);
      }
	}
  }

  /** Method setBrineButtons()
   * <p> This method will turn off and disable any Brine Plot Tracks that do not
   *     have the appropriate brine data curves for that track.
   * @param st = the Brine Data List Structure
   */

  public void setBrineButtons( brineListStruct st )
  {
    if (st != null)
    {
      rb[_BRINE_STIFF].setSelected(true);
      rb[_BRINE_STIFF].setEnabled(true);

      rb[_BRINE_COLLINS].setSelected(true);
      rb[_BRINE_COLLINS].setEnabled(true);

      rb[_BRINE_PIPER].setSelected(true);
      rb[_BRINE_PIPER].setEnabled(true);

      rb[_BRINE_LAS_CATIONS].setSelected(true);
      rb[_BRINE_LAS_CATIONS].setEnabled(true);

      rb[_BRINE_LAS_ANIONS].setSelected(true);
      rb[_BRINE_LAS_ANIONS].setEnabled(true);
	}
  }

  /** Method setRockImageButtons()
   * <p> This method will turn off and disable any Rock Image Plot Tracks that
   *     do not have the appropriate rock images for that track.
   * @param st = the Rock Image List Structure
   */

  public void setRockImageButtons( rockImagesListStruct st )
  {
	if (st != null)
	{
      rb[_ROCK_BOX].setEnabled(true);
      rb[_ROCK_SLAB].setEnabled(true);
      rb[_ROCK_THINSECTION].setEnabled(true);
      rb[_ROCK_SEM].setEnabled(true);
      rb[_ROCK_IMG_OUTCROP].setEnabled(true);

      rb[_ROCK_BOX].setSelected(true);
      rb[_ROCK_SLAB].setSelected(true);
	}
  }

  /** Method setRockDescButtons()
   * <p> This method will set the tracks by the Action and data present.
   * @param stColumn   = Rock Column Lithology Data List Structure
   * @param stLith     = Rock Lithology Data List Structure
   * @param stTexture  = Rock Texture Data List Structure
   * @param stPHI      = Porosity Type Data List Structure
   * @param stFossil   = Fossils Data List Structure
   * @param stBio      = Bio-stratigraphy Data List Structure
   * @param stSed      = Sedimentary Structure Data List Structure
   * @param stColor    = Rock Color Data List Structure
   * @param stEnv      = Depositional Environment List Structure
   * @param stDesc     = Rock Description Data List Structure
   */

  public void setRockDescButtons( rockColumnListStruct    stColumn,
                                  lithologyListStruct     stLith,
                                  textureListStruct       stTexture,
                                  phiListStruct           stPHI,
                                  fossilListStruct        stFossil,
                                  bioStratListStruct      stBio,
                                  sedimentaryListStruct   stSed,
                                  rockColorListStruct     stColor,
                                  envListStruct           stEnv,
	                              iqstratRemarkListStruct st )
  {
	int iPHI = 0;

	if ((iAction == cmn.cmnStruct._CORE) || (iAction == cmn.cmnStruct._ROCK) ||
	    (iAction == cmn.cmnStruct._LAS3) || (iAction == cmn.cmnStruct._KGS))
	{
//      rb[_ROCK_LITHOLOGY].setEnabled(true);
//      if ((stLith != null) || (iAction == cmn.cmnStruct._ROCK))
//      if (stLith != null)
//        rb[_ROCK_LITHOLOGY].setSelected(true);

//      rb[_ROCK_MEASURED_SECTION].setEnabled(true);
//      if (stColumn != null)
//        rb[_ROCK_MEASURED_SECTION].setSelected(true);

      if (stColumn != null)
      {
        rb[_ROCK_MEASURED_SECTION].setEnabled(true);
        rb[_ROCK_MEASURED_SECTION].setSelected(true);

        rb[_ROCK_TEXTURE].setEnabled(true);
        rb[_ROCK_TEXTURE].setSelected(false);

        rb[_ROCK_GRAIN].setEnabled(true);
        rb[_ROCK_GRAIN].setSelected(true);
	  }

      if (stPHI != null)
      {
	    if (stPHI.iCount > 0)
	      iPHI = stPHI.iCount;
	  }

      rb[_ROCK_THIN_PHI].setEnabled(true);
      if (iPHI > 0) // || (iAction == cmn.cmnStruct._ROCK))
        rb[_ROCK_THIN_PHI].setSelected(true);

      rb[_ROCK_POROSITY].setEnabled(true);
      if (iPHI > 0)  // || (iAction == cmn.cmnStruct._ROCK))
        rb[_ROCK_POROSITY].setSelected(true);

//      rb[_ROCK_TEXTURE].setEnabled(true);
//      if ((stTexture != null) || (iAction == cmn.cmnStruct._ROCK))
//      if (stTexture != null)
//        rb[_ROCK_TEXTURE].setSelected(true);

      rb[_SED_STRUCTURE].setEnabled(true);
//      if ((stSed != null) || (iAction == cmn.cmnStruct._ROCK))
      if (stSed != null)
      {
		if (stSed.iCount > 0)
          rb[_SED_STRUCTURE].setSelected(true);
	  }

      rb[_ROCK_FOSSILS].setEnabled(true);
//      if ((stFossil != null) || (iAction == cmn.cmnStruct._ROCK))
      if (stFossil != null)
      {
		if (stFossil.iCount > 0)
          rb[_ROCK_FOSSILS].setSelected(true);
	  }

      rb[_BIO_STRATIGRAPHY].setEnabled(true);
//      if ((stBio != null) || (iAction == cmn.cmnStruct._ROCK))
      if (stBio != null)
        rb[_BIO_STRATIGRAPHY].setSelected(true);

      rb[_ROCK_COLOR].setEnabled(true);
//      if ((stColor != null) || (iAction == cmn.cmnStruct._ROCK))
      if (stColor != null)
        rb[_ROCK_COLOR].setSelected(true);

      rb[_REMARKS].setEnabled(true);
//      if ((st != null) || (iAction == cmn.cmnStruct._ROCK))
      if (st != null)
        rb[_REMARKS].setSelected(true);
	}
  }

  /** Method setNotify()
   * <p> This method will notify Observers that the panel has changed
   */

  public void setNotify()
  {
    if (notifier != null)
      notifier.notifyObservers(new String("Available Track Panel Changed"));
  }

  /** Method setButtonColors()
   * <p> This method will set change the radio button colors if they are
   *     selected.
   */

  private void setButtonColors()
  {
    int i=0;
    int j=0;
    int k=0;
    int iSource = -1;

    for (i=0; i<iqstrat.iqstratTracksStruct.TOTAL_TRACKS; i++)
    {
      for (k=0; k<iqstrat.iqstratTracksStruct.TOTAL_SOURCES; k++)
      {
        if (iqstrat.iqstratTracksStruct.TRACK[i][_SOURCE].equals(
            iqstrat.iqstratTracksStruct.SOURCE[k][_SRC_ID]))
        {
          iSource = k;
        }
      }

      rb[i].setForeground(Color.black);
      rb[i].setBackground(
          new Color(iqstrat.iqstratTracksStruct.COLORS[iSource][0],
                    iqstrat.iqstratTracksStruct.COLORS[iSource][1],
                    iqstrat.iqstratTracksStruct.COLORS[iSource][2]));
      rb[i].setFont(new java.awt.Font("Dialog", 0, 11));

      if (i == iqstrat.iqstratTracksStruct._BIO_STRATIGRAPHY)
      {
        rb[i].setBackground( new Color(
          iqstrat.iqstratTracksStruct.COLORS[iqstrat.iqstratTracksStruct._SRC_BIO][0],
          iqstrat.iqstratTracksStruct.COLORS[iqstrat.iqstratTracksStruct._SRC_BIO][1],
          iqstrat.iqstratTracksStruct.COLORS[iqstrat.iqstratTracksStruct._SRC_BIO][2]));
      }
    }
  }

  /** Method setType()
   * <p> This method will determine the primary type of LAS Plot
   * @param stLAS = the LAS File Data Structure
   */

  private void setType( lasFileDataStruct stLAS )
  {
	if (stLAS != null)
	{
	  iLogType[_MISC] = ON;

      if ((stLAS.iGR != -1) &&
          ((stLAS.iRHOB != -1) || (stLAS.iDPHI != -1)) &&
          (stLAS.iNPHI != -1))
        iLogType[_LITHO_DENSITY] = ON;

      if ((stLAS.iDT != -1) || (stLAS.iSPHI != -1))
        iLogType[_SONIC] = ON;

      if ((stLAS.iTh != -1) && (stLAS.iU != -1) && (stLAS.iK != -1))
        iLogType[_SPECTRAL_GR] = ON;

      if (stLAS.iGR != -1)
        iLogType[_GAMMA_RAY] = ON;

      if ((stLAS.iILD != -1) || (stLAS.iILM != -1))
      {
        iLogType[_RESISTIVITY] = ON;
      }
      else if ((stLAS.iMNOR != -1) || (stLAS.iMINV != -1))
      {
        iLogType[_RESISTIVITY] = ON;
      }
      else if ((stLAS.iAHT10 != -1) || (stLAS.iAHT20 != -1) ||
               (stLAS.iAHT30 != -1) ||
               (stLAS.iAHT60 != -1) || (stLAS.iAHT90 != -1))
      {
        iLogType[_RESISTIVITY] = ON;
      }
      else if ((stLAS.iLL != -1) || (stLAS.iMLL != -1) || (stLAS.iLL8 != -1))
      {
        iLogType[_RESISTIVITY] = ON;
      }
      else if ((stLAS.iRES != -1)  || (stLAS.iRMED != -1) ||
               (stLAS.iRDEP != -1) || (stLAS.iRSHAL != -1))
      {
        iLogType[_RESISTIVITY] = ON;
      }
      else if ((stLAS.iLN != -1) || (stLAS.iSN != -1))
      {
        iLogType[_RESISTIVITY] = ON;
      }
    }
  }

  /** Method setTrackType()
   * <p> This method will determine defalut image track type for Resistivity
   *     and porosity Logs.
   * @param stLAS = the LAS File Data Structure
   */

  private void setTrackType( lasFileDataStruct stLAS )
  {
	if (stLAS != null)
	{
	  if (stLAS.checkData( las.lasStandardTools._ILD ))
	    iOHM = las.lasStandardTools._ILD;
	  else if (stLAS.checkData( las.lasStandardTools._MNOR ))
	    iOHM = las.lasStandardTools._MNOR;
	  else if (stLAS.checkData( las.lasStandardTools._RDEP ))
	    iOHM = las.lasStandardTools._RDEP;
	  else if (stLAS.checkData( las.lasStandardTools._AHT90 ))
	    iOHM = las.lasStandardTools._AHT90;
	  else if (stLAS.checkData( las.lasStandardTools._LL ))
	    iOHM = las.lasStandardTools._LL;
	  else if (stLAS.checkData( las.lasStandardTools._LN ))
	    iOHM = las.lasStandardTools._LN;

	  if (stLAS.checkData( las.lasStandardTools._NPHI ))
	  {
	    iPHI  = las.lasStandardTools._NPHI;
	    iTHIN = iqstrat.iqstratTracksStruct._THIN_NPHI;
	  }
	  else if (stLAS.checkData( las.lasStandardTools._DPHI ))
	  {
	    iPHI  = las.lasStandardTools._DPHI;
	    iTHIN = iqstrat.iqstratTracksStruct._THIN_DPHI;
	  }
	  else if (stLAS.checkData( las.lasStandardTools._SPHI ))
	  {
	    iPHI  = las.lasStandardTools._SPHI;
	    iTHIN = iqstrat.iqstratTracksStruct._THIN_SPHI;
	  }
    }
  }

  /* --------------------------------------------------------------------- *
   * ---------------------- SET BY GROUP METHODS ------------------------- *
   * --------------------------------------------------------------------- */

  /** Method setByGroup()
   * <p> This method will set the tracks by the Action and data present.
   * @param stLAS      = LAS File Data Structure
   * @param stTops     = Stratigraphic Units Data List Structure
   * @param stBio      = Bio-stratigraphy Data List Structure
   * @param stColumn   = Rock Column Lithology Data List Structure
   * @param stPHI      = Porosity Type Data List Structure
   * @param stFossil   = Fossils Data List Structure
   * @param stSed      = Sedimentary Structure Data List Structure
   * @param stColor    = Rock Color Data List Structure
   * @param stDesc     = Rock Description Data List Structure
   */

  public void setByGroup( lasFileDataStruct       stLAS,
                          stratListStruct         stTops,
                          brineListStruct         stBrine,
                          rockDataListStruct      stMeasured,
                          rockImagesListStruct    stImage,
                          bioStratListStruct      stBio,
                          rockColumnListStruct    stColumn,
                          phiListStruct           stPHI,
                          fossilListStruct        stFossil,
                          sedimentaryListStruct   stSed,
                          rockColorListStruct     stColor,
                          iqstratRemarkListStruct stDesc )
  {
	for (int i=0; i<TOTAL_TRACKS; i++)
	{
      if (i != _STRAT_UNITS_A)
	    rb[i].setSelected( false );
	}

    if ((rb1st[_DEFAULT].isSelected()) || (rb1st[_COLORLITH].isSelected()))
    {
	  setByDefault( stLAS );

	  if (iDataType[0] == ON) { cb[0].setSelected(true); }
	  if (iDataType[1] == ON) { cb[1].setSelected(true); }
	  if (iDataType[2] == ON) { cb[2].setSelected(true); }

      if (stBrine    != null) { cb[0].setEnabled(true); }
      if (stMeasured != null) { cb[1].setEnabled(true); }
      if (stImage    != null) { cb[2].setEnabled(true); }

	  if (rb1st[_COLORLITH].isSelected())
	  {
  	    cb[0].setSelected(false);
	    cb[1].setSelected(false);
	    cb[2].setSelected(false);

  	    cb[0].setEnabled(false);
  	    cb[1].setEnabled(false);
  	    cb[2].setEnabled(false);
	  }
	}

    if (rb1st[_LOG_ONLY].isSelected())
    {
	  setByLog( stLAS );
	  cb[0].setSelected(false);
	  cb[1].setSelected(false);
	  cb[2].setSelected(false);

  	  cb[0].setEnabled(false);
  	  cb[1].setEnabled(false);
  	  cb[2].setEnabled(false);
	}

	if ((rb1st[_DEFAULT].isSelected()) || (rb1st[_GEOREPORT].isSelected()))
	{
      setByGeoreport( stColumn, stPHI, stFossil, stBio, stSed, stColor, stDesc );

	  if (iDataType[0] == ON) { cb[0].setSelected(true); }
	  if (iDataType[1] == ON) { cb[1].setSelected(true); }
	  if (iDataType[2] == ON) { cb[2].setSelected(true); }

      if (stBrine    != null) { cb[0].setEnabled(true); }
      if (stMeasured != null) { cb[1].setEnabled(true); }
      if (stImage    != null) { cb[2].setEnabled(true); }
    }

    if (cb[0].isSelected())
    {
	  setADDBrineButtons( stBrine );
	}

    if (cb[1].isSelected())
    {
	  setADDCoreButtons( stMeasured );
	}

    if (cb[2].isSelected())
    {
	  setADDImageButtons( stImage );
	}
  }

  /** Method setByDefault()
   * <p> This method will turn off and disable any LAS Plot Tracks that do not
   *     have the appropriate log curves for that track.
   * @param st = the LAS File Data Structure
   */

  public void setByDefault( lasFileDataStruct st )
  {
	int iValue = -1;

	for (int i=0; i<6; i++)
	{
	  if (rb2nd[i].isSelected())
	    iValue = i;
	}

    if ((st.iGR > -1) || (st.iCGR > -1) || (st.iSP > -1) || (st.iCAL > -1))
    {
      rb[_LITHOLOGY_GR].setSelected(true);
      rb[_LAS_REFERENCE].setSelected(true);
	}

    switch (iValue)
    {
      case _LITHO_DENSITY:
        rb[_LAS_LITHO_DENSITY].setSelected(true);

        if (st.iPE > -1)
        {
          rb[_CLRLITH_RU].setSelected(true);
          rb[_ROCK_COLUMN].setSelected(true);
		  }
        else
        {
          rb[_CLRLITH_RN].setSelected(true);
          rb[_ROCK_COLUMN_PD].setSelected(true);
  	    }

        iPHI  = las.lasStandardTools._NPHI;
	    iTHIN = iqstrat.iqstratTracksStruct._THIN_NPHI;

        rb[_THIN_PHI].setSelected(true);
        rb[_POROSITY_IMAGER].setSelected(true);
        rb[_POROSITY_IMAGER_N].setSelected(true);
        break;
      case _RESISTIVITY:
        if ((st.iILD > -1)  || (st.iILM > -1) ||
            (st.iSFLU > -1) || (st.iLL8 > -1))
        {
          rb[_LAS_INDUCTION].setSelected(true);
          iOHM = las.lasStandardTools._ILD;
        }
        else if ((st.iMNOR > -1) || (st.iMSFL > -1) || (st.iMINV > -1))
        {
          rb[_LAS_MICRO_RESISTIVITY].setSelected(true);
          iOHM = las.lasStandardTools._MNOR;
        }
        else if ((st.iRES > -1)  || (st.iRMED > -1) ||
                 (st.iRDEP > -1) || (st.iRSHAL > -1))
        {
          rb[_LAS_RESISTIVITY].setSelected(true);
          iOHM = las.lasStandardTools._RDEP;
        }
        else if ((st.iAHT10 > -1) || (st.iAHT20 > -1) || (st.iAHT30 > -1) ||
                 (st.iAHT60 > -1) || (st.iAHT90 > -1))
        {
          rb[_LAS_AHT].setSelected(true);
          iOHM = las.lasStandardTools._AHT90;
        }
        else if ((st.iLL > -1) || (st.iMLL > -1) || (st.iLL8 > -1))
        {
          rb[_LAS_LATERLOG].setSelected(true);
          iOHM = las.lasStandardTools._LL;
        }
        else if ((st.iLN  > -1) || (st.iSN > -1))
        {
          rb[_LAS_NORMAL].setSelected(true);
          iOHM = las.lasStandardTools._LN;
		}

        rb[_RESISTIVITY_IMAGER].setSelected(true);
        rb[_RESISTIVITY_IMAGER_N].setSelected(true);
        break;
      case _SONIC:
        rb[_LAS_SONIC].setSelected(true);

        if ((st.iRHOB > -1) || (st.iDPHI > -1))
        {
          rb[_CLRLITH_RT].setSelected(true);
          rb[_ROCK_COLUMN_RT].setSelected(true);
		}

        iPHI  = las.lasStandardTools._SPHI;
	    iTHIN = iqstrat.iqstratTracksStruct._THIN_SPHI;

        rb[_THIN_PHI].setSelected(true);
        rb[_POROSITY_IMAGER].setSelected(true);
        rb[_POROSITY_IMAGER_N].setSelected(true);
        break;
      case _SPECTRAL_GR:
        rb[_LAS_SPECTRAL_GR].setSelected(true);
        rb[_LAS_SPECTRAL_RATIO].setSelected(true);
        rb[_CLRLITH_SPGR].setSelected(true);
        rb[_CLRLITH_HALL].setSelected(true);
        break;
      case _GAMMA_RAY:
        break;
	}
  }

  /** Method setByLog()
   * <p> This method will turn off and disable any LAS Plot Tracks that do not
   *     have the appropriate log curves for that track.
   * @param st = the LAS File Data Structure
   */

  public void setByLog( lasFileDataStruct st )
  {
	int iValue = -1;

	for (int i=0; i<6; i++)
	{
	  if (rb2nd[i].isSelected())
	    iValue = i;
	}

    rb[_LAS_REFERENCE].setSelected(true);

    switch (iValue)
    {
      case _LITHO_DENSITY:
        rb[_LAS_LITHO_DENSITY].setSelected(true);
        break;
      case _RESISTIVITY:
        if ((st.iILD > -1)  || (st.iILM > -1) ||
            (st.iSFLU > -1) || (st.iLL8 > -1))
        {
          rb[_LAS_INDUCTION].setSelected(true);
        }
        else if ((st.iMNOR > -1) || (st.iMSFL > -1) || (st.iMINV > -1))
        {
          rb[_LAS_MICRO_RESISTIVITY].setSelected(true);
        }
        else if ((st.iRES > -1)  || (st.iRMED > -1) ||
                 (st.iRDEP > -1) || (st.iRSHAL > -1))
        {
          rb[_LAS_RESISTIVITY].setSelected(true);
        }
        else if ((st.iAHT10 > -1) || (st.iAHT20 > -1) || (st.iAHT30 > -1) ||
                 (st.iAHT60 > -1) || (st.iAHT90 > -1))
        {
          rb[_LAS_AHT].setSelected(true);
        }
        else if ((st.iLL > -1) || (st.iMLL > -1) || (st.iLL8 > -1))
        {
          rb[_LAS_LATERLOG].setSelected(true);
        }
        else if ((st.iLN  > -1) || (st.iSN > -1))
        {
          rb[_LAS_NORMAL].setSelected(true);
		}
        break;
      case _SONIC:
        rb[_LAS_SONIC].setSelected(true);
        break;
      case _SPECTRAL_GR:
        rb[_LAS_SPECTRAL_GR].setSelected(true);
        rb[_LAS_SPECTRAL_RATIO].setSelected(true);
        break;
      case _GAMMA_RAY:
        break;
	}
  }

  /** Method setByGeoreport()
   * <p> This method will set the tracks by the Action and data present.
   * @param stColumn   = Rock Column Lithology Data List Structure
   * @param stPHI      = Porosity Type Data List Structure
   * @param stFossil   = Fossils Data List Structure
   * @param stBio      = Bio-stratigraphy Data List Structure
   * @param stSed      = Sedimentary Structure Data List Structure
   * @param stColor    = Rock Color Data List Structure
   * @param st         = Rock Description Data List Structure
   */

  public void setByGeoreport( rockColumnListStruct    stColumn,
                              phiListStruct           stPHI,
                              fossilListStruct        stFossil,
                              bioStratListStruct      stBio,
                              sedimentaryListStruct   stSed,
                              rockColorListStruct     stColor,
	                          iqstratRemarkListStruct st )
  {
	int iPHI = 0;

	if (st != null)
	{
      if (stColumn != null)
      {
        rb[_ROCK_MEASURED_SECTION].setSelected(true);
        rb[_ROCK_GRAIN].setSelected(true);
	  }

      if (stPHI != null)
      {
	    if (stPHI.iCount > 0)
	      iPHI = stPHI.iCount;
	  }

      if (iPHI > 0)
        rb[_ROCK_THIN_PHI].setSelected(true);

      if (iPHI > 0)
        rb[_ROCK_POROSITY].setSelected(true);

      if (stSed != null)
      {
		if (stSed.iCount > 0)
          rb[_SED_STRUCTURE].setSelected(true);
	  }

      if (stFossil != null)
      {
		if (stFossil.iCount > 0)
          rb[_ROCK_FOSSILS].setSelected(true);
	  }

      if (stBio != null)
      {
		if (stBio.iCount > 0)
          rb[_BIO_STRATIGRAPHY].setSelected(true);
	  }

      if (stColor != null)
        rb[_ROCK_COLOR].setSelected(true);

      rb[_REMARKS].setSelected(true);
	}
  }

  /** Method setADDCoreButtons()
   * <p> This method will turn off and disable any Rock Plot Tracks that do not
   *     have the appropriate measured rock data curves for that track.
   * @param st = the Rock Data List Structure
   */

  public void setADDCoreButtons( rockDataListStruct st )
  {
    if (st != null)
    {
      if ((st._GMCC > -1) || (st._PCORE > -1) || (st._PPLUG > -1) ||
          (st._P800 > -1) || (st._PINSI > -1))
      {
        rb[_ROCK_LAS_CORE_PHI].setSelected(true);
      }

      if ((st._RHOD > -1) || (st._RHOW > -1) || (st._PEFF > -1))
      {
        rb[_ROCK_LAS_OUTCROP].setSelected(true);
      }

      if ((st._KMAX > -1) || (st._K90 > -1) || (st._KVRT > -1))
      {
        rb[_ROCK_LAS_CORE_K].setSelected(true);
      }

      if ((st._KPLG > -1)  || (st._KKL > -1) || (st._KINSI > -1) ||
          (st._KKLIN > -1) || (st._KPVRT > -1))
      {
        rb[_ROCK_LAS_PLUG_K].setSelected(true);
      }

      if ((st._SOIL > -1) || (st._SW > -1))
      {
        rb[_ROCK_LAS_SATURATION].setSelected(true);
      }

      if ((st._MAMB > -1) || (st._MINSI > -1) ||
          (st._NAMB > -1) || (st._NINSI > -1))
      {
        rb[_ROCK_LAS_ARCHIE].setSelected(true);
      }

      if ((st._GR > -1) || (st._CGR > -1))
      {
        rb[_ROCK_LAS_GR].setSelected(true);
      }

      if ((st._TH > -1) || (st._U > -1) || (st._K > -1))
      {
        rb[_ROCK_LAS_SPGR].setSelected(true);
      }

      if ((st._LIN_1 > -1) || (st._LIN_2 > -1) || (st._LIN_3 > -1) || (st._LIN_4 > -1))
      {
        rb[_ROCK_LAS_LINEAR].setSelected(true);
      }

      if ((st._LOG_1 > -1) || (st._LOG_2 > -1) || (st._LOG_3 > -1) || (st._LOG_4 > -1))
      {
        rb[_ROCK_LAS_LOG].setSelected(true);
      }
	}
  }

  /** Method setADDBrineButtons()
   * <p> This method will turn off and disable any Brine Plot Tracks that do not
   *     have the appropriate brine data curves for that track.
   * @param st = the Brine Data List Structure
   */

  public void setADDBrineButtons( brineListStruct st )
  {
    if (st != null)
    {
      rb[_BRINE_STIFF].setSelected(true);
      rb[_BRINE_COLLINS].setSelected(true);
      rb[_BRINE_PIPER].setSelected(true);
      rb[_BRINE_LAS_CATIONS].setSelected(true);
      rb[_BRINE_LAS_ANIONS].setSelected(true);
	}
  }

  /** Method setADDImageButtons()
   * <p> This method will turn off and disable any Rock Image Plot Tracks that
   *     do not have the appropriate rock images for that track.
   * @param st = the Rock Image List Structure
   */

  public void setADDImageButtons( rockImagesListStruct st )
  {
	if (st != null)
	{
      rb[_ROCK_BOX].setSelected(true);
      rb[_ROCK_SLAB].setSelected(true);
	}
  }

  /* ===================================================================== *
   * -------------------------- GET METHODS ------------------------------ *
   * ===================================================================== */

  /** Method getTrack()
   * <p> This method will retrieve the last track that was modified
   * @return iTrack = the track number modified
   */

  public int getTrack() { return (iTrack); }

  /** Method getSelected()
   * <p> This method will retrieve the tracks that were selected.
   * @return iSelected = Array of selected tracks
   */

  public int[] getSelected()
  {
    int i      = 0;
    int iCount = 0;

    for (i=0; i<iqstrat.iqstratTracksStruct.TOTAL_TRACKS; i++)
    {
      if (rb[i].isSelected())
      {
        iCount++;
      }
    }

    iSelected = new int[iCount];
    iSelect   = 0;
    for (i=0; i<iqstrat.iqstratTracksStruct.TOTAL_TRACKS; i++)
    {
      if (rb[i].isSelected())
      {
        iSelected[iSelect] = i;
        iSelect++;
      }
    }

    return (iSelected);
  }

  /** Method getType()
   * <p> This method will determine the primary type of LAS Plot
   * @return iType = the primary log type
   */

  private int getType()
  {
    int iContinue = 0;
    int iType     = -1;

    for (int i=0; i<6; i++)
    {
      if (iContinue == 0)
      {
        if (iLogType[i] == ON)
        {
          iContinue = 1;
          iType = i;
        }
      }
    }

    return (iType);
  }

  /** Method getOHMCurve()
   * <p> This method will retrieve the default Resistivity Curve to
   *     plot the conductivity image track.
   */

  public int getOHMCurve() { return (iOHM); }

  /** Method getPHICurve()
   * <p> This method will retrieve the default Porosity Curve to
   *     plot the porosity image track.
   */

  public int getPHICurve() { return (iPHI); }

  /** Method getThinCurve()
   * <p> This method will retrieve the default Porosity Thin Track setting.
   */

  public int getThinCurve() { return (iTHIN); }


  /** Method getLASTrackSize()
   * <p> This method will return the LAS Track Size
   * @return iLAS = LAS Track Size
   */

  public int getLASTrackSize() { return (iLAS); }

  /* ===================================================================== *
   * ---------------------------- ACTIONS -------------------------------- *
   * ===================================================================== */

  /** Method close()
   * <p> This method will set the global variables to null in order to force
   *     JAVA to free the memory allocated for this panel.
   */

  public void close()
  {
    int i=0;

    iSelected = null; // Tracks selected for view

    panel     = null;

    rbS       = null;
    rbD       = null;

    for (i=0; i<ilbl; i++)
    {
      pnl[i] = null;
      lbl[i] = null;
    }

    for (i=0; i<irb; i++)
      rb[i]    = null;

    rb1st = null;
    rb2nd = null;
    cb    = null;
  }

  /** METHOD actionPerformed()
   *  <p> This Method will handle all the actions within the Frame.
   *  @param event - Action Event
   */

  public void actionPerformed(ActionEvent event)
  {
	int i=0;
    String sEventArgument = event.getActionCommand();

    if (event.getSource() == rbS)
    {
      iLAS = _SINGLE;
      notifier.notifyObservers(new String("Get LAS Track Size"));
    }
    if (event.getSource() == rbD)
    {
      iLAS = _DOUBLE;
      notifier.notifyObservers(new String("Get LAS Track Size"));
    }

    for (i=0; i<s1st.length; i++)
    {
      if ((event.getSource() == rb1st[_DEFAULT]) || (event.getSource() == rb1st[_COLORLITH]))
      {
        notifier.notifyObservers(new String("Available Track Panel - Group Changed"));
	  }
	  else if ((event.getSource() == rb1st[_LOG_ONLY]) || (event.getSource() == rb1st[_GEOREPORT]))
	  {
        notifier.notifyObservers(new String("Available Track Panel - Data Changed"));
	  }
	}

    for (i=0; i<s2nd.length; i++)
    {
      if (event.getSource() == rb2nd[i])
      {
        notifier.notifyObservers(new String("Available Track Panel - Group Changed"));
	  }
	}

    for (i=0; i<3; i++)
    {
      if (event.getSource() == cb[i])
      {
		iDataType[i] = OFF;
		if (cb[i].isSelected()) { iDataType[i] = ON; }
        notifier.notifyObservers(new String("Available Track Panel - Data Changed"));
	  }
	}

    for (i=0; i<iqstrat.iqstratTracksStruct.TOTAL_TRACKS; i++)
    {
      if (event.getSource() == rb[i])
      {
        iTrack = i;
        notifier.notifyObservers(new String("Available Track Panel Changed"));

//        setButtonColors();
      }
    }
  }
}


/*
 *  @version 1.1 09/04/2007
 *  @author  John Victorine
 */
