/*
 * @stratStruct.java Version 1.1 10/17/2008
 *
 * Copyright (c) 2008 Kansas Geological Survey
 * 1930 Constant Avenue, Lawrence, Kansas, 66047, U.S.A.
 * All Rights Reserved.
 */

package horizon.strat;

import java.awt.*;
import java.awt.geom.*;

/** CLASS stratStruct
 *  <p> This Structure holds the stratigraphic units Structure.
 *
 *  @version 1.1 10/17/2008
 *  @author  John R. Victorine
 */

public class stratStruct
{
  // Static Constants for RANK

  public static final int _NONE        = 0;
  public static final int _EON         = 1;
  public static final int _ERA         = 2;
  public static final int _SYSTEM      = 3;
  public static final int _SERIES      = 4;
  public static final int _SUBSYSTEM   = 5;
  public static final int _SUBSERIES   = 6;
  public static final int _STAGE       = 7;
  public static final int _SUPER_GROUP = 8;
  public static final int _GROUP       = 9;
  public static final int _SUBGROUP    = 10;
  public static final int _FORMATION   = 11;
  public static final int _MEMBER      = 12;
  public static final int _BED         = 13;
  public static final int  _TOTAL_RANK = 14;

  public static final String RANK[] = {
    "Unknown", "EON", "ERA", "SYSTEM", "SERIES", "SUBSYSTEM", "SUBSERIES", "STAGE",  // ISC
    "SUPERGROUP", "GROUP", "SUBGROUP", "FORMATION", "MEMBER", "BED" }; // State

  // Static Constants for Level of Confidence

  public static final int   _EXCELLENT   = 0;  // Gold   - Excellent
  public static final int   _GOOD        = 1;  // Silver - Good
  public static final int   _FAIR        = 2;  // Copper - Fair
  public static final int   _POOR        = 3;  // Lead   - Poor
  public static final int  _TOTAL_LEVEL  = 4;

  public static final String LEVEL[] = { "Excellent", "Good", "Fair", "Poor" };

  // -- Color for Confidence Level

  public static final Color cAu  = new Color( 217, 217,  25 );  // Gold
  public static final Color cAg  = new Color( 230, 232, 250 );  // Silver
  public static final Color cCu  = new Color( 217, 135,  25 );  // Copper
  public static final Color cPb  = new Color( 100, 100, 100 );  // Lead

  public static final Color COLORS[] = { cAu, cAg, cCu, cPb };

  // Cross Section Plot Variables

  public static final int  OFF = 0;  // Do not display stratigraphic unit
  public static final int  ON  = 1;  // dispaly stratigraphic unit

  public String sID          = "";    // Plot ID for stratigraphic Unit
  public int    iStatus      = OFF;   // Turn on or off the stratigraphic Unit

  // Stratigraphic Units Variables

  public String sKID         = "0";   // KGS Primary KEY of Record
  public String stratKEY     = "0";   // unique KEY of Record
  public String sKEY         = "0";   // unique KEY of Record
  public String sid          = "0";   // unique order id
//  public int    id           = 0;     // unique order id
  public int    iLevel       = _POOR; // Confidence level of selection
  public int    iRank        = _NONE; // Rank ID
  public String sName        = "";    // Name of Stratigraphic Unit
  public String sName2       = "";    // Informal Name of Stratigraphic Unit

  public String source       = "";    // Source Name of data

  // Age of Stratigraphic Unit

  public double dAgeStart    = 0.0;   // Starting Age (Ma).
  public double dStartCorr   = 0.0;   // +/- of Starting Age
  public double dAgeEnd      = 0.0;   // Ending Age (Ma).
  public double dEndCorr     = 0.0;   // +/- of Ending Age

  // Depth of Stratigraphic Unit

  public double depthStart   = 0.0;   // Starting Depth
  public double depthEnd     = 0.0;   // Ending Depth

  // Time Unit of Stratigraphic Unit

  public double dTimeStart   = 0.0;   // Starting Time
  public double dTimeEnd     = 0.0;   // Ending Time

  // RGB Background color of stratigraphic unit defined by International
  // Commission on Stratigraphy

  public int    iRed         = -1;
  public int    iGreen       = -1;
  public int    iBlue        = -1;

  // Stratigraphic Units Names

  // ISC Stratigraphic Unit Names

  public String sEon         = "";  // Eon Stratigraphic Unit Names
  public String sEra         = "";  // Era Stratigraphic Unit Names
  public String system       = "";  // System Stratigraphic Unit Names
  public String series       = "";  // Series Stratigraphic Unit Names
  public String subSystem    = "";  // Substage Stratigraphic Unit Names
  public String subSeries    = "";  // Subseries Stratigraphic Unit Names

  // States Stratigraphic Unit Names

  public String stage        = "";  // Stage Stratigraphic Unit Names
  public String sprGroup     = "";  // Super Group Stratigraphic Unit Names
  public String sGroup       = "";  // Group Stratigraphic Unit Names
  public String subGroup     = "";  // Subgroup Stratigraphic Unit Names
  public String sFormation   = "";  // Formation Stratigraphic Unit Names

  /** Method delete()
   * <p> This method will force set the Objects to null and force Java to
   *     free unwanted memory
   */

  public void delete()
  {
    sID        = null;    // Plot ID for stratigraphic Unit
    sKID       = null;    // Primary KEY of Record
    stratKEY   = null;    // Strat KEY of Record
    sid        = null;    // unique order id
    sKEY       = null;    // User defined primary key
    sName      = null;    // Name of Stratigraphic Unit
    sName2     = null;    // Informal Name of Stratigraphic Unit

    // ISC Stratigraphic Unit Names

    sEon       = null;  // Eon Stratigraphic Unit Names
    sEra       = null;  // Era Stratigraphic Unit Names
    system     = null;  // System Stratigraphic Unit Names
    series     = null;  // Series Stratigraphic Unit Names
    subSystem  = null;  // Substage Stratigraphic Unit Names
    subSeries  = null;  // Subseries Stratigraphic Unit Names

    // States Stratigraphic Unit Names

    stage      = null;  // Stage Stratigraphic Unit Names
    sprGroup   = null;  // Super Group Stratigraphic Unit Names
    sGroup     = null;  // Group Stratigraphic Unit Names
    subGroup   = null;  // Subgroup Stratigraphic Unit Names
    sFormation = null;  // Formation Stratigraphic Unit Names
  }
}