/*
 * @stratProjectStruct.java Version 1.1 04/08/2009
 *
 * Copyright (c) 2009 Kansas Geological Survey
 * 1930 Constant Avenue, Lawrence, Kansas, 66047, U.S.A.
 * All Rights Reserved.
 */

package horizon.strat;

/** CLASS stratProjectStruct
 *  <p> This Class holds the Project Information.
 *
 *  @version 1.1 04/08/2009
 *  @author  John R. Victorine
 */

public class stratProjectStruct
{
  // Identifier for access to data

  public static final int USER_ONLY   = 0;
  public static final int GROUP_READ  = 1;
  public static final int GROUP_WRITE = 2;

  public int    iAccess      = USER_ONLY; // Access to data

  public String sKID         = "0"; // Project KID - Created on KGS DB
  public String sKEY         = "0"; // Project KEY - Created from Data & Time
  public String sUserKID     = "0"; // User KID    - DB Primary Key of Owner

  public String sProject     = "";  // Project Name
  public String sDescription = "";  // Description of Project

  public String sCreated     = "";  // Project Created

  public String sError       = "";  // Error String

  /** Method delete()
   * <p> This method will set objects to null  to force Java to deallocate
   *     memory
   */

  public void delete()
  {
    sKID         = null;  // Project KID - Created on KGS DB
    sKEY         = null;  // Project KEY - Created from Data & Time
    sUserKID     = null;  // User KID - Primary Key of Owner

    sProject     = null;  // Project Name
    sDescription = null;  // Description of Project

    sCreated     = null;  // Project Created
    sError       = null;  // Error String
  }
}
