/*
 * @stratListStruct.java Version 1.1 10/17/2008
 *
 * Copyright (c) 2008 Kansas Geological Survey
 * 1930 Constant Avenue, Lawrence, Kansas, 66047, U.S.A.
 * All Rights Reserved.
 */

package horizon.strat;

import horizon.strat.stratStruct;

/** CLASS stratListStruct
 *  <p> This Structure holds a list of stratigraphic units Structures.
 *
 *  @version 1.1 10/17/2008
 *  @author  John R. Victorine
 */

public class stratListStruct
{
  public int    iSource    = las3.las3Constants._SOURCE_NONE;

  // Stratigraphic Headers Data Information

  public String sKID       = "0";  // Primary Key of the Well
  public String sKEY       = "";   // Primary Key created on user's PC
  public int    iType      = iqstrat.iqstratHeadersStruct.WELL; // Type of Data
  public String sAPI       = "";   // API-Number OR UWI
  public String sName      = "";   // Well Name or Outcrop Name
  public String status     = iqstrat.iqstratStatusStruct.STATUS[0][0]; // Status
  public double dLatitude  = 0.0;  // Latitude of Location
  public double dLongitude = 0.0;  // Longitude of Location
  public double depth      = 0.0;  // Total Depth of Well or Height of Outcrop
  public double dGL        = 0.0;  // Ground Level

  public String sKGS       = "NO"; // KGS Saved Data Indicator

  // LAS 3 Required Fields

  public String sTOPS      = "";   // Formation Source
  public String sTOPDR     = "";   // Tops Depth Reference

  // Other Core Parameters that are not in the Required List

  public int    iParamRows  = 0;      // Total number of rows
  public int    iParamCols  = las3.las3Struct._TOTAL; // Total number of columns
  public String sParams[][] = null;   // Array holding the Parameter Definitions

  // Stratigraphic Units Data

  public int         iCount = 0; // Total Number of Records
  public stratStruct stItem[];   // Array of stratigraphic units Structures

  /** Method delete()
   * <p> This method will force set the Objects to null and force Java to
   *     free unwanted memory
   */

  public void delete()
  {
    sKID      = null; // Primary Key of the Well
    sKEY      = null; // Primary Key created on user's PC
    sAPI      = null; // API-Number OR UWI
    sName     = null; // Well Name or Outcrop Name
    status    = null; // Status

    sKGS      = null;   // Profile Saved Data Indicator

    // LAS 3 Required Fields

    sTOPS     = null;   // Formation Source
    sTOPDR    = null;   // Tops Depth Reference

    for (int i=0; i<iCount; i++)
    {
      if (stItem[i] != null)
        stItem[i].delete();
      stItem[i] = null;
    }

    iCount = 0;
  }
}