/*
 * @stratPlotStatePanel.java Version 1.1 10/28/2008
 *
 * Copyright (c) 2008 Kansas Geological Survey
 * 1930 Constant Avenue, Lawrence, Kansas, 66047, U.S.A.
 * All Rights Reserved.
 */

package horizon.strat.gui;

import java.awt.*;
import java.awt.image.*;
import java.util.Observable;
import javax.swing.*;

import horizon.strat.stratListStruct;
import horizon.strat.stratStruct;
import horizon.strat.plot.stratPlotState;

/** Class stratPlotStatePanel
 *  <p> This Class will display the iCS stratigraphic units available
 *
 *  @version 1.1 10/28/2008
 *  @author  John R. Victorine
 */

public class stratPlotStatePanel extends JPanel
{
  private JFrame          parent   = null; // Frame callint this panel
  private Observable      notifier = null; // Observable Object
  private stratListStruct stStrat  = null; // State Stratigraphic Units
  private stratListStruct stICS    = null; // ICS Stratigraphic Units

  private stratPlotState  plot = null;     // State Strat Units Plot Package

  private int        iWidth  = 0;          // Width of the plot panel
  private int        iHeight = 0;          // Height of the plot panel

  private ScrollPane scroll = new ScrollPane(); // Scroll Pane
  private JPanel     panel  = new JPanel();     // Panel containing plot

  /** Constructor stratPlotStatePanel()
   *  <p> This is the Constructor for this class.
   *  @param parent   = the frame calling this panel
   *  @param notifier = Observable
   *  @param stICS    = ICS Stratigraphic Units List Data Structure
   *  @param stStrat  = the stratigraphic unit list Structure for the State
   *                    stratigraphic chart
   */

  public stratPlotStatePanel( JFrame parent,
                              Observable notifier,
                              stratListStruct stICS,
                              stratListStruct stStrat )
  {
    try
    {
      this.parent   = parent;
      this.notifier = notifier;
      this.stICS    = stICS;
      this.stStrat  = stStrat;

      jbInit();
    }
    catch(Exception ex)
    {
      ex.printStackTrace();
    }
  }

  /** METHOD jbInit()
   *  <p> This Method will create the Panel for this class.
   *  @throws Exception
   */

  private void jbInit() throws Exception
  {
    Panel pnlCenter       = new Panel();

    this.setLayout(new BorderLayout());
    pnlCenter.setLayout(new BorderLayout());

    plot    = new stratPlotState( notifier, stICS, stStrat );
    iWidth  = plot.getPlotWidth();
    iHeight = plot.getPlotHeight();

    panel.setLayout(new BorderLayout());
    panel.setPreferredSize(new Dimension(iWidth, iHeight));
    panel.setBackground(Color.white);

    // Attach Widgets to Panel

    this.add(pnlCenter,   BorderLayout.CENTER);
    pnlCenter.add(scroll, BorderLayout.CENTER);
    scroll.add(panel,     null);
    panel.add(plot,       BorderLayout.CENTER);
  }

  /** Method close()
   * <p> This method will close all dialogs that are opened by this class.
   */

  public void close()
  {
    notifier = null;
    stICS    = null;
    stStrat  = null;

    scroll   = null;
    panel    = null;

    if (plot != null)
      plot.close();
    plot    = null;
  }

  /* =============================================================== *
   * ------------------------- GET METHODS ------------------------- *
   * =============================================================== */

  /** Method getData()
   * <p> This method will get the State stratigraphic units structure selected
   * @return st = the Stratigraphic unit selected.
   */

  public stratStruct getData()
  {
    stratStruct st = null;

    if (plot != null) st = plot.getData();

    return (st);
  }

  /* ===================================================================== *
   * -------------------------- SET METHODS ------------------------------ *
   * ===================================================================== */

  /** Method setSystem(int iRank, String sName)
   * <p> This method will set the depth range by system
   * @param iRank = Rank of Strat unit
   * @param sName = name of strat unit
   */

  public void setSystem(int iRank, String sName)
  {
    if (plot != null)
    {
      plot.setSystem(iRank, sName);
      int iWidth  = plot.getPlotWidth();
      int iHeight = plot.getPlotHeight();
      panel.setPreferredSize(new Dimension(iWidth, iHeight));
    }

    scroll.doLayout();
    panel.doLayout();
    panel.updateUI();
  }

  /** Method setScale(int iScale, double dMaximum, double dMinimum)
   * <p> This method will set the Plot scale in the
   *     Cross Plot Data List Structure
   * @param iScale   = The Depth Track Scale identifier
   */

  public void setScale(int iScale)
  {
    if (plot != null)
    {
      plot.setScale(iScale);
      int iWidth  = plot.getPlotWidth();
      int iHeight = plot.getPlotHeight();
      panel.setPreferredSize(new Dimension(iWidth, iHeight));
    }

    scroll.doLayout();
    panel.doLayout();
    panel.updateUI();
  }

  /** Method setTextFields()
   * <p> This method will set the textfields for the mouse motion listener
   * @param txtRank = the Rank text field
   * @param txtName = the startigraphic name text field
   */

  public void setTextFields( JTextField txtRank, JTextField txtName )
  {
    if (plot != null)
    {
      plot.setTextFields( txtRank, txtName );
    }
  }

}

/*
 *  @version 1.1 10/28/2008
 *  @author  John Victorine
 */
