/*
 * @stratPlotICSPanel.java Version 1.1 10/27/2008
 *
 * Copyright (c) 2008 Kansas Geological Survey
 * 1930 Constant Avenue, Lawrence, Kansas, 66047, U.S.A.
 * All Rights Reserved.
 */

package horizon.strat.gui;

import java.awt.*;
import java.awt.image.*;
import java.util.Observable;
import javax.swing.*;

import horizon.strat.plot.stratPlotICS;
import horizon.strat.stratListStruct;

/** Class stratPlotICSPanel
 *  <p> This Class will display the iCS stratigraphic units available
 *
 *  @version 1.1 10/27/2008
 *  @author  John R. Victorine
 */

public class stratPlotICSPanel extends Panel
{
  private JFrame     parent   = null;        // Frame callint this panel
  private Observable notifier = null;        // Observable Object

  private int        iWidth  = 0;            // Width of the plot panel
  private int        iHeight = 0;            // Height of the plot panel

  private stratPlotICS    plot = null;       // ICS Strat Units Plot Package
  private stratListStruct st   = null;       // Stratigraphic Units List Struct

  private ScrollPane scroll = new ScrollPane(); // Scroll Pane
  private JPanel     panel  = new JPanel();     // Panel containing plot

  /** Constructor stratPlotICSPanel()
   *  <p> This is the Constructor for this class.
   *  @param parent   = the frame calling this panel
   *  @param notifier = Observable
   *  @param st       = ICS Stratigraphic Units List Data Structure
   */

  public stratPlotICSPanel( JFrame parent,
                            Observable notifier,
                            stratListStruct st )
  {
    try
    {
      this.parent   = parent;
      this.notifier = notifier;
      this.st       = st;

      jbInit();
    }
    catch(Exception e)
    {
      e.printStackTrace();
    }
  }

  /** METHOD jbInit()
   *  <p> This Method will create the Panel for this class.
   *  @throws Exception
   */

  private void jbInit() throws Exception
  {
    Panel pnlCenter       = new Panel();

    this.setLayout(new BorderLayout());
    pnlCenter.setLayout(new BorderLayout());

    plot    = new stratPlotICS( notifier, st );
    iWidth  = plot.getPlotWidth();
    iHeight = plot.getPlotHeight();

    panel.setLayout(new BorderLayout());
    panel.setPreferredSize(new Dimension(iWidth, iHeight));
    panel.setBackground(Color.white);

    // Attach Widgets to Panel

    this.add(pnlCenter,   BorderLayout.CENTER);
    pnlCenter.add(scroll, BorderLayout.CENTER);
    scroll.add(panel,     null);
    panel.add(plot,       BorderLayout.CENTER);
  }

  /** Method close()
   * <p> This method will close all dialogs that are opened by this class.
   */

  public void close()
  {
//    parent  = null;
    st      = null;

    scroll  = null;
    panel   = null;

    if (plot != null)
      plot.close();
    plot    = null;
  }

  /* =============================================================== *
   * ------------------------- GET METHODS ------------------------- *
   * =============================================================== */

  /** Method getData()
   * <p> This method will get the iCS stratigraphic units structure selected
   */

  public String getData()
  {
    String s = "0";

    if (plot != null) s = new String( plot.getData() );

    return (s);
  }
}


/*
 *  @version 1.1 10/27/2008
 *  @author  John Victorine
 */
