/*
 * @stratPlotICSFrame.java Version 1.1 09/18/2008
 *
 * Copyright (c) 2008 Kansas Geological Survey
 * 1930 Constant Avenue, Lawrence, Kansas, 66047, U.S.A.
 * All Rights Reserved.
 */

package horizon.strat.gui;

import java.util.Observable;
import java.awt.*;
import java.awt.image.*;
import java.awt.event.*;

import javax.swing.*;
import javax.swing.event.*;

import horizon.strat.gui.stratPlotICSPanel;
import horizon.strat.stratListStruct;

/** Class stratPlotICSFrame
 *  <p> This Class will display the ICS Stratigraphic Units available
 *
 *  @version 1.1 09/18/2008
 *  @author  John R. Victorine
 */

public class stratPlotICSFrame extends JFrame implements ActionListener
{
  private Observable        notifier = null; // Observable Object
  private stratPlotICSPanel plot     = null;
  private stratListStruct   st       = null; // ICS Strat Units List Struct

  private JButton btnClose = new JButton();

  // Dialog Position & Size

  private int iXStart = 0;
  private int iYStart = 0;
  private int iWidth  = 0;
  private int iHeight = 0;

  /** Constructor stratPlotICSFrame()
   *  <p> This is the Constructor for this class.
   */

  public stratPlotICSFrame()
  {
    try
    {
      jbInit();
    }
    catch(Exception e)
    {
      e.printStackTrace();
    }
  }

  /** Constructor stratPlotICSFrame()
   *  <p> This is the Constructor for this class.
   *  @param notifier = Observable
   *  @param iXStart = the x-coordinate of Data entry dialog
   *  @param iYStart = the y-coordinate of Data entry dialog
   *  @param iWidth  = the width of Data entry dialog
   *  @param iHeight = the height of Data entry dialog
   *  @param st      = ICS Stratigraphic Units List Data Structure
   */

  public stratPlotICSFrame( Observable notifier,
                               int iXStart, int iYStart,
                               int iWidth,  int iHeight,
                               stratListStruct st )
  {
    try
    {
      this.notifier = notifier;
      this.iXStart  = iXStart;
      this.iYStart  = iYStart;
      this.iWidth   = iWidth;
      this.iHeight  = iHeight;
      this.st       = st;

      jbInit();
    }
    catch(Exception e)
    {
      e.printStackTrace();
    }
  }

  /** METHOD jbInit()
   *  <p> This Method will create the Frame for this class.
   *  @throws Exception
   */

  private void jbInit() throws Exception
  {
    JPanel pnlNorth = new JPanel();

    this.setTitle("International Stratigraphic Chart");
    this.getContentPane().setLayout(new BorderLayout());

    // Header Button Panel

    pnlNorth.setLayout(new BorderLayout());

    btnClose.setText("Close");
    btnClose.addActionListener(this);

    // Create Fossil Plot Panel

    plot = new stratPlotICSPanel( this, notifier, st );

    // Attach Widgets to Frame

    if (notifier == null)
    {
      this.getContentPane().add(pnlNorth, BorderLayout.SOUTH);
      pnlNorth.add(btnClose, BorderLayout.EAST);
    }

    this.getContentPane().add(plot, BorderLayout.CENTER);

    // Display the Frame

//    this.setSize(new Dimension(450, 670));
    this.setSize(new Dimension(810, 720));
    Dimension d = Toolkit.getDefaultToolkit().getScreenSize();

    int iXPos = (d.width  - this.getSize().width) / 2;
    if (iWidth > 0) iXPos = iXStart + iWidth;
    this.setLocation(iXPos, (d.height - this.getSize().height) / 2);

//    this.setResizable(false);
    this.setVisible(true);
  }

  /* =============================================================== *
   * ------------------------- GET METHODS ------------------------- *
   * =============================================================== */

  /** Method getData()
   * <p> This method will get the selected stratigraphic unit
   * @return s = ICS Stratigraphic Units id
   */

  public String getData()
  {
    String s = "";

    if (plot != null) s = plot.getData();

    return (s);
  }

  /* ===================================================================== *
   * ---------------------------- ACTIONS -------------------------------- *
   * ===================================================================== */

  /** Method close()
   * <p> This method will close all dialogs that are opened by this class.
   */

  public void close()
  {
    notifier = null;  // Observable Object

    if (plot != null)
      plot.close();
    plot = null;

    btnClose = null;

    dispose();
  }

  /** METHOD actionPerformed()
   *  <p> This Method will handle all the actions within the Frame.
   *  @param event - Action Event
   */

  public void actionPerformed(ActionEvent event)
  {
    if (event.getSource() == btnClose)  { close(); }
  }
}


/*
 *  @version 1.1 09/18/2008
 *  @author  John Victorine
 */
