/*
 * @stratListTable.java Version 1.1 10/30/2008
 *
 * Copyright (c) 2008 Kansas Geological Survey
 * 1930 Constant Avenue, Lawrence, Kansas, 66047, U.S.A.
 * All Rights Reserved.
 */

package horizon.strat.gui;

import java.awt.*;
import java.lang.*;
import javax.swing.*;
import javax.swing.table.*;

import gui.guiTable;

import horizon.strat.stratListStruct;
import horizon.strat.stratStruct;

/** Class stratListTable
 *  <p> This Class will display the Formation Tops.
 *
 *  @version 1.1 10/30/2008
 *  @author  John R. Victorine
 */

public class stratListTable
{
  private int      iRows     = 0;
  private int      iColumns  = 14;
  private String   sColumn[] = { "Top",
                                 "Base",
                                 "Name",
                                 "Level",
                                 "Eon",
                                 "Era",
                                 "System",
                                 "Series",
                                 "SubSystem",
                                 "SubSeries",
                                 "Stage",
                                 "Group",
                                 "Subgroup",
                                 "Formation" };

  private int     iColLength[] = { 8, // System Name
                                   8,
                                  24,
                                   7,
                                  14,
                                  14,
                                  14,
                                  12,
                                  14,
                                  12,
                                  14,
                                  14,
                                  14,
                                  14 };

  private Object   oData[][] = null;
  private guiTable pTable    = null;

  private stratListStruct st      = null;
  private int             iChange = 0;

  /** Constructor stratListTable()
   *  <p> This is the Constructor for this class.
   */

  public stratListTable()
  {
    pTable = new guiTable(0, iColumns, sColumn);

    resetColumnWidths();
    pTable.showHorScroll(true);
  }

  /** Constructor stratListTable()
   *  <p> This is the Constructor for this class.
   * @param st     = The Regions List Data Structure
   */

  public stratListTable(stratListStruct st)
  {
    this.st = st;

    populateList();

    if (iRows > 0)
      pTable = new guiTable(0, iRows, iColumns, sColumn, oData);
    else
      pTable = new guiTable(0, iColumns, sColumn);

    resetColumnWidths();
    pTable.showHorScroll(true);

    if (iChange == 0)
      iRows = 0;

    if (iRows > 0)
      pTable.setSelectedRow(0);
  }

  /** Method close()
   * <p> This method will cancel the Rock Color Dialog
   */

  public void close()
  {
    sColumn    = null;
    iColLength = null;
    oData      = null;
    pTable     = null;
    st         = null;
  }

  /** Method resetColumnWidths()
   *  <p> This method will reset the column widths to a specific size.
   */

  private void resetColumnWidths()
  {
    for (int i=0; i<iColumns; i++)
    {
      pTable.resizeColumn(i, iColLength[i]);
    }
  }

  /* ===================================================================== *
   * -------------------------- SET METHODS ------------------------------ *
   * ===================================================================== */

  /** Method populateList()
   *  <p> This method will populate the Region List data.
   */

  private void populateList()
  {
    int i      = 0;
    int iCount = 0;

    iChange = 0;
    iRows   = 1;

    oData = new String[1][iColumns];
    for (i=0; i<iColumns; i++)
    {
      oData[0][i] = new String("");
    }

    if (st != null)
    {
      if (st.iCount > 0)
      {
        iChange = 1;
        oData   = new Object[st.iCount][iColumns];
        iCount  = 0;
      }

      st = horizon.strat.stratUtility.bubbleSort(st);

      for (i=0; i<st.iCount; i++)
      {
        oData[iCount][0] = new Double(st.stItem[i].depthStart);
        oData[iCount][1] = new Double(st.stItem[i].depthEnd);
        oData[iCount][2] = new String(st.stItem[i].sName);
        oData[iCount][3] = new String(
            horizon.strat.stratStruct.LEVEL[st.stItem[i].iLevel]);

        oData[iCount][4] = new String(st.stItem[i].sEon);
        oData[iCount][5] = new String(st.stItem[i].sEra);
        oData[iCount][6] = new String(st.stItem[i].system);
        oData[iCount][7] = new String(st.stItem[i].series);
        oData[iCount][8] = new String(st.stItem[i].subSystem);
        oData[iCount][9] = new String(st.stItem[i].subSeries);
        oData[iCount][10] = new String(st.stItem[i].stage);
        oData[iCount][11] = new String(st.stItem[i].sGroup);
        oData[iCount][12] = new String(st.stItem[i].subGroup);
        oData[iCount][13] = new String(st.stItem[i].sFormation);

        iCount++;
      }

      iRows = iCount;
    }
  }

  /** Method repopulateList()
   *  <p> This method will reload the Region List after adding, deleting from
   *      the formation name list.
   * @param st     = The Regions List Data Structure
   */

  public void repopulateList(stratListStruct st)
  {
    this.st = st;

    populateList();

    pTable.reload(iRows, oData);

    if (iChange == 0)
      iRows = 0;

    if (iRows > 0)
      pTable.setSelectedRow(0);
  }

  /* ===================================================================== *
   * -------------------------- GET METHODS ------------------------------ *
   * ===================================================================== */

  /** Method getTotalRows()
   *  <p> This method will return the total rows in the table.
   *  @return Total Number of Rows.
   */

  public int getTotalRows() { return (iRows); }

  /** Method getRow()
   *  <p> This method will return the selected data id in the table.
   *  @return selected data id.
   */

  public int getRow() { return (pTable.getSelectedRow()); }

  /** Method getRowData()
   *  <p> This method will return the Region Data Structure of the
   *      selected row.
   *  @return stData = Region Data Structure.
   */

  public stratStruct getRowData()
  {
    stratStruct stData = null;

    stData = st.stItem[pTable.getSelectedRow()];

    return (stData);
  }

  /** Method getAllData()
   *  <p> This method will returns the Region List Data Structure.
   *  @return st = Region List Data Structure.
   */

  public stratListStruct getAllData() { return (st); }

  /** Method getScrollPane()
   *  <p> This method will return the scroll pane.
   *  @return jScrollPane - Scroll Pane containing the Table.
   */

  public JScrollPane getScrollPane() { return (pTable.getScrollPane()); }
}


/*
 *  @version 1.1 10/30/2008
 *  @author  John Victorine
 */
