/*
 * @seqTypesStruct.java Version 1.1 06/04/2008
 *
 * Copyright (c) 2008 Kansas Geological Survey
 * 1930 Constant Avenue, Lawrence, Kansas, 66047, U.S.A.
 * All Rights Reserved.
 */

package horizon.seq;

/** Class seqTypesStruct
 *  <p> This Class holds the Sequence Stratigraphy Plot Colors Data.
 *
 *  @version 1.1 06/04/2008
 *  @author  John R. Victorine
 */

public class seqTypesStruct
{
  public static final int _NONE = 0;

  // Systems Tracts

  public static final int _HST = 1;   // Highstand systems tract
  public static final int _TST = 2;   // Transgressive systems tract
  public static final int _LST = 3;   // Lowstand systems tract

  // Deep Water Fan System

  public static final int _DWF = 4;   // Deep water fan system
  public static final int _LCC = 5;   // Leveed channel complex
  public static final int _DF  = 6;   // Debris flows/slumps
  public static final int _BFF = 7;   // Basin floor fan complex

  // Miscellaneous Depositional Elements

  public static final int _CST = 8;   // Condensed systems tract
  public static final int _IVF = 9;   // Incised valley fill
  public static final int _FRW = 10;   // Forced regressive shoreface wedge
  public static final int _LW  = 11;  // Lowstand wedge

  // Surfaces

  public static final int _SB  = 12;  // Sequence boundary
  public static final int _MFS = 13;  // Maximum flooding surface
  public static final int _TS  = 14;  // Transgressive surfaces
  public static final int _FS  = 15;  // Flooding surfaces
  public static final int _TSE = 16;  // Transgressive surface of erosion
  public static final int _RSE = 17;  // Regressive surface of erosion

  public static final int _TOTAL = 18; // Total number

  public static final String NAME[][] =
  { // Name/Description                      Abbreviation      Mnemonic
    {"NONE",                                     "",            "None" },
    // Systems Tracts
    {"Highstand systems tract",                  "HST",         "HST" },
    {"Transgressive systems tract",              "TST",         "TST" },
    {"Lowstand systems tract",                   "LST",         "LST" },
    // Deep Water Fan System
    {"Deep water fan system (undifferentiated)", "DWF",         "DWF" },
    {"Leveed channel complex",                   "LCC",         "LCC" },
    {"Debris flows/slumps",                      "DF",          "DF"  },
    {"Basin floor fan complex",                  "BFF",         "BFF" },
    // Miscellaneous Depositional Elements
    {"Condensed systems tract (condensation horizons)", "CST",  "CST" },
    {"Incised valley fill",                      "IVF",         "IVF" },
    {"Forced regressive shoreface wedge",        "FRW",         "FRW" },
    {"Lowstand wedge",                           "LW",          "LW"  },
    // Surfaces
    {"Sequence boundary",                        "SB",          "SB", },
    {"Maximum flooding surface",                 "MFS",         "MFS" },
    {"Transgressive surface",                    "TS",          "TS"  },
    {"Flooding surface",                         "FS",          "FS"  },
    {"Transgressive surface of erosion",         "TSE",         "TSE" },
    {"Regressive surface of erosion",            "RSE",         "RSE" }
  };

  public static final int _COLORS[] =
  {
    lith.lithColorsStruct._WHITE,         // None
    // Systems Tracts
    lith.lithColorsStruct._ORANGE,        // Highstand systems tract
    lith.lithColorsStruct._LIGHT_GREEN,   // Transgressive systems tract
    lith.lithColorsStruct._YELLOW,        // Lowstand systems tract
    // Deep Water Fan System
    lith.lithColorsStruct._MIDDLE_YELLOW, // Deep water fan system
    lith.lithColorsStruct._SIENNA,        // Leveed channel complex
    lith.lithColorsStruct._DARK_ORANGE,   // Debris flows/slumps
    lith.lithColorsStruct._BURLYWOOD,     // Basin floor fan complex
    // Miscellaneous Depositional Elements
    lith.lithColorsStruct._GREEN,         // Condensed systems tract
    lith.lithColorsStruct._GREY,          // Incised valley fill
    lith.lithColorsStruct._DEEP_SKY_BLUE_2, // Forced regressive shoreface wedge
    lith.lithColorsStruct._HOT_PINK,      // Lowstand wedge
    // Surfaces
    lith.lithColorsStruct._WHITE,         // Sequence boundary
    lith.lithColorsStruct._WHITE,         // Maximum flooding surface
    lith.lithColorsStruct._WHITE,         // Transgressive surfaces
    lith.lithColorsStruct._WHITE,         // Flooding surfaces
    lith.lithColorsStruct._WHITE,         // Transgressive surface of erosion
    lith.lithColorsStruct._WHITE          // Regressive surface of erosion
  };

  public static final int _FORECOLORS[] =
  {
    lith.lithColorsStruct._BLACK,         // None
    // Systems Tracts
    lith.lithColorsStruct._BLACK,         // Highstand systems tract
    lith.lithColorsStruct._BLACK,         // Transgressive systems tract
    lith.lithColorsStruct._BLACK,         // Lowstand systems tract
    // Deep Water Fan System
    lith.lithColorsStruct._BLACK,         // Deep water fan system
    lith.lithColorsStruct._BLACK,         // Leveed channel complex
    lith.lithColorsStruct._BLACK,         // Debris flows/slumps
    lith.lithColorsStruct._BLACK,         // Basin floor fan complex
    // Miscellaneous Depositional Elements
    lith.lithColorsStruct._BLACK,         // Condensed systems tract
    lith.lithColorsStruct._BLACK,         // Incised valley fill
    lith.lithColorsStruct._BLACK,         // Forced regressive shoreface wedge
    lith.lithColorsStruct._BLACK,         // Lowstand wedge
    // Surfaces
    lith.lithColorsStruct._RED,           // Sequence boundary
    lith.lithColorsStruct._OLIVE_DRAB,    // Maximum flooding surface
    lith.lithColorsStruct._CYAN,          // Transgressive surfaces
    lith.lithColorsStruct._MIDDLE_CYAN,   // Flooding surfaces
    lith.lithColorsStruct._BLUE,          // Transgressive surface of erosion
    lith.lithColorsStruct._DARK_VIOLET    // Regressive surface of erosion
  };

  /** Method getColors()
   * <p> This method will return the RGB color value of the lithology
   * @param  iLith  = The lithology color to return
   * @return Integer value of Red
   */

  public static int[] getColors(int iLith)
  {
    int iColor[] = { 255, 255, 255 };

    iColor[0] = getR(_COLORS[iLith]);
    iColor[1] = getG(_COLORS[iLith]);
    iColor[2] = getB(_COLORS[iLith]);

    return (iColor);
  }

  /** Method getColors()
   * <p> This method will return the RGB color value of the lithology
   * @param  iLith  = The lithology color to return
   * @return Integer value of Red
   */

  public static int[] getForeColors(int iLith)
  {
    int iColor[] = { 255, 255, 255 };

    iColor[0] = getR(_FORECOLORS[iLith]);
    iColor[1] = getG(_FORECOLORS[iLith]);
    iColor[2] = getB(_FORECOLORS[iLith]);

    return (iColor);
  }

  /** Method getR()
   * <p> This method will return the Integer value of Red
   * @param  iLith  = The lithology color to return
   * @return Integer value of Red
   */

  public static int getR(int iLith) { return (lith.lithColorsStruct.getR(iLith)); }

  /** Method getG()
   * <p> This method will return the Integer value of Green
   * @param  iLith  = The lithology color to return
   * @return Integer value of Green
   */

  public static int getG(int iLith) { return (lith.lithColorsStruct.getG(iLith)); }

  /** Method getB()
   * <p> This method will return the Integer value of Blue
   * @param  iLith  = The lithology color to return
   * @return Integer value of Blue
   */

  public static int getB(int iLith) { return (lith.lithColorsStruct.getB(iLith)); }
}