/*
 * @seqStandardTools.java Version 1.1 04/12/2010
 *
 * Copyright (c) 2010 Kansas Geological Survey
 * 1930 Constant Avenue, Lawrence, Kansas, 66047, U.S.A.
 * All Rights Reserved.
 */

package horizon.seq;

/** Class seqStandardTools
 *  <p> This Class holds the standard tool information to map the Sequence
 *      Stratigraphy LAS File curves to standard names.
 */

public class seqStandardTools
{
  public static final int _SEQFT   = 0;  // Sequence Stratigraphy Top Depth
  public static final int _SEQFB   = 1;  // Sequence Stratigraphy Bottom Depth
  public static final int _SEQMNEM = 2;  // Sequence Stratigraphy Mnemonic
  public static final int _SEQDES  = 3;  // Sequence Stratigraphy Description
  public static final int TOTAL    = 4;  // Total

  public static final int _C_ID   = 0;
  public static final int _C_MNEM = 1;
  public static final int _C_NAME = 2;
  public static final int _C_UNIT = 3;
  public static final int _C_FORM = 4;

  public static final String CURVES[][] =
  {
    // ID     MNEMONIC  CURVE NAME                              UNIT  FORMAT
    { "1100", "SEQFT",   "Sequence Stratigraphy Top Depth",      "F", "F"  },
    { "1200", "SEQFB",   "Sequence Stratigraphy Bottom Depth",   "F", "F"  },
    { "1300", "SEQMNEM", "Sequence Stratigraphy Mnemonic",       "",  "S"  },
    { "1400", "SEQDES",  "Sequence Stratigraphy Description",    "",  "S"  },
  };

  /** Method isCurve()
   * <p> This method will determine if the curve is part of the standard
   *     stratigraphic units curves from the LAS File.
   * @param  iColumn = The column number
   * @param  str     = the string being compared.
   * @return bValue  = true it is a valid curve, false it is not
   */

  public static boolean isCurve( int iColumn, String str )
  {
    boolean bValue = false;

    if (iColumn==1) str = new String( str.toUpperCase() );

    for (int i=0; i<TOTAL; i++)
    {
      if (str.equals(CURVES[i][iColumn]))
      {
        bValue = true;
      }
    }

    return (bValue);
  }

  /** Method getRow()
   * <p> This method will return the row number of the Stratigraphic Unit Curve
   * @param  iColumn = The column number
   * @param  str     = the string being compared.
   * @return iRow = row number
   */

  public static int getRow( int iColumn, String str )
  {
    int iRow = -1;

    if (iColumn==1) str = new String( str.toUpperCase() );

    for (int i=0; i<TOTAL; i++)
    {
      if (str.equals(CURVES[i][iColumn]))
      {
        iRow = i;
      }
    }

    return (iRow);
  }
}