/*
 * @seqListStruct.java Version 1.1 06/04/2008
 *
 * Copyright (c) 2008 Kansas Geological Survey
 * 1930 Constant Avenue, Lawrence, Kansas, 66047, U.S.A.
 * All Rights Reserved.
 */

package horizon.seq;

import horizon.seq.seqStruct;

/** CLASS seqListStruct
 *  <p> This Structure holds a list of Regions Structures.
 *
 *  @version 1.1 06/04/2008
 *  @author  John R. Victorine
 */

public class seqListStruct
{
  public int    iSource    = las3.las3Constants._SOURCE_NONE;

  // Stratigraphic Headers Data Information

  public String sKID       = "0";  // Primary Key of the Well
  public String sKEY       = "";   // Primary Key created on user's PC
  public int    iType      = iqstrat.iqstratHeadersStruct.WELL; // Type of Data
  public String sAPI       = "";   // API-Number OR UWI
  public String sName      = "";   // Well Name or Outcrop Name
  public String status     = iqstrat.iqstratStatusStruct.STATUS[0][0]; // Status
  public double dLatitude  = 0.0;  // Latitude of Location
  public double dLongitude = 0.0;  // Longitude of Location
  public double depth      = 0.0;  // Total Depth of Well or Height of Outcrop
  public double dGL        = 0.0;  // Ground Level

  // LAS 3 Dependent Variable

  public String sKGS     = "YES"; // KGS Saved Data Indicator
  public String source   = "";    // Source of Data
  public String sCreated = "";    // Created Date

  // Data

  public int       iCount = 0; // Total Number of Records
  public seqStruct stItem[];   // Array of Sequence Structures

  /** Method delete()
   * <p> This method will force set the Objects to null and force Java to
   *     free unwanted memory
   */

  public void delete()
  {
    sKID      = null; // Primary Key of the Well
    sKEY      = null; // Primary Key created on user's PC
    sAPI      = null; // API-Number OR UWI
    sName     = null; // Well Name or Outcrop Name
    status    = null; // Status

    sKGS      = null; // KGS Saved Data Indicator
    source    = null;    // Source of Data
    sCreated  = null;    // Created Date

    for (int i=0; i<iCount; i++)
    {
      if (stItem[i] != null)
        stItem[i].delete();
      stItem[i] = null;
    }

    iCount = 0;
  }
}
