/*
 * @seqPanel.java Version 1.1 06/04/2008
 *
 * Copyright (c) 2008 Kansas Geological Survey
 * 1930 Constant Avenue, Lawrence, Kansas, 66047, U.S.A.
 * All Rights Reserved.
 */

package horizon.seq.gui;

import java.awt.*;
import java.awt.event.*;
import java.util.Observable;
import javax.swing.*;
import javax.swing.event.*;

import horizon.seq.seqListStruct;
import horizon.seq.seqStruct;
import horizon.seq.gui.seqTable;

/** Class seqPanel
 *  <p> This Class will allow the user to enter the sequence stratigraphy
 *      data into the profile program
 *
 *  @version 1.1 06/04/2008
 *  @author  John R. Victorine
 */

public class seqPanel extends JPanel implements ActionListener
{
  // Input Variables

  private Observable notifier = null;

  // Global Variables

  // Action Variables

  public static final int _ADD    = 0;
  public static final int _MODIFY = 1;

  private int iAction = _ADD;

  // Selected Sequence Identifier

  private int iSequence = horizon.seq.seqTypesStruct._NONE;

  // Modify Depth Range

  private JTextField txtStart = null;  // Starting Depth
  private JTextField txtEnd   = null;  // Ending Depth

  // Depth range variables

  private double dStart       = 0.0;
  private double dEnd         = 0.0;

  // Sequence List Table

  private seqTable   pTable   = null;

  // Sequence Structures

  private seqListStruct stList   = null;
  private seqStruct     stModify = null;

  // Global Frame Widges

  // Global Panel Buttons

  private JButton btnAdd       = new JButton();
  private JButton btnSelected  = new JButton();
  private JButton btnClear     = new JButton();

  private JButton btnModify    = new JButton();
  private JButton btnRemove    = new JButton();
  private JButton btnRemoveAll = new JButton();

  // Sequence Stratigraphy Button Widgets

  private JButton btn[]   = null;

  /** Constructor horizonEnterDataFrame()
   *  <p> This is the Constructor for this class.
   *  @param notifier = Observable
   */

  public seqPanel(Observable notifier)
  {
    try
    {
      this.notifier = notifier;

      jbInit();
    }
    catch(Exception ex)
    {
      ex.printStackTrace();
    }
  }

  /** METHOD jbInit()
   *  <p> This Method will create the Panel for this class.
   *  @throws Exception
   */

  void jbInit() throws Exception
  {
    JPanel pnlList        = new JPanel();
    JPanel pnlColors      = new JPanel();
    JPanel pnlSeqButtons  = new JPanel();
    JPanel pnlListButtons = new JPanel();

    JScrollPane scrollList = new JScrollPane();

    this.setLayout(new BorderLayout());

    // Global Buttons Panel

    pnlSeqButtons.setLayout(new BorderLayout());

    btnAdd.setFont(new java.awt.Font("Dialog", 1, 11));
    btnAdd.setText("Add Data to List");
    btnAdd.addActionListener(this);

    btnSelected.setBackground(new Color(255, 255, 255));
    btnSelected.setFont(new java.awt.Font("Dialog", 1, 11));
    btnSelected.setText("None");
    btnSelected.addActionListener(this);

    btnClear.setFont(new java.awt.Font("Dialog", 1, 11));
    btnClear.setText("Clear");
    btnClear.addActionListener(this);

    pnlColors = panelSequenceColor();

    // List Panel

    pnlList.setPreferredSize(new Dimension(10, 150));
    pnlList.setLayout(new BorderLayout());

    pTable     = new seqTable();
    scrollList = pTable.getScrollPane();

    // -- List Buttons Panel

    pnlListButtons.setLayout(new GridLayout());

    btnModify.setFont(new java.awt.Font("Dialog", 1, 11));
    btnModify.setText("Modify");
    btnModify.addActionListener(this);

    btnRemove.setFont(new java.awt.Font("Dialog", 1, 11));
    btnRemove.setText("Remove");
    btnRemove.addActionListener(this);

    btnRemoveAll.setFont(new java.awt.Font("Dialog", 1, 11));
    btnRemoveAll.setText("Remove All");
    btnRemoveAll.addActionListener(this);

    // Attach Widgets to Panel

    this.add(pnlSeqButtons,          BorderLayout.NORTH);
    pnlSeqButtons.add(btnAdd,        BorderLayout.WEST);
    pnlSeqButtons.add(btnSelected,   BorderLayout.CENTER);
    pnlSeqButtons.add(btnClear,      BorderLayout.EAST);

    this.add(pnlList,                BorderLayout.SOUTH);
    pnlList.add(scrollList,          BorderLayout.CENTER);

    pnlList.add(pnlListButtons,      BorderLayout.SOUTH);
    pnlListButtons.add(btnModify,    null);
    pnlListButtons.add(btnRemove,    null);
    pnlListButtons.add(btnRemoveAll, null);

    this.add(pnlColors,              BorderLayout.CENTER);
  }

  /** Method panelSequenceColor()
   * <p> This method will build the Sequence Color button panel
   * @return panel the Sequence Color button panel
   */

  private JPanel panelSequenceColor()
  {
    int i=0;
    int j=0;
    int iColor[]       = { 0, 0, 0 };
    int iTotal         = horizon.seq.seqTypesStruct._TOTAL + 4;
    int iCount         = 0;
    int iCnt           = 0;
    JPanel panel       = new JPanel();       // Top Level Panel
    JPanel pnl         = new JPanel();       // Holds Lithology Buttons
    JPanel pnlLayer[]  = null;               // Array of Panels for Lithotypes
    JLabel lbl[]       = null;
    JLabel lblA[]      = null;
    JLabel lblTitle[]  = null;
    JScrollPane scroll = new JScrollPane();  // Scroll Pane holding pnl

    panel.setPreferredSize(new Dimension(340, iTotal*15));
    panel.setLayout(new BorderLayout());

    pnl.setLayout(new GridLayout(iTotal, 1));

    pnlLayer = new JPanel[iTotal];
    btn      = new JButton[horizon.seq.seqTypesStruct._TOTAL];
    lbl      = new JLabel[horizon.seq.seqTypesStruct._TOTAL];
    lblA     = new JLabel[horizon.seq.seqTypesStruct._TOTAL];

    lblTitle = new JLabel[10];

    pnlLayer[iCount] = new JPanel();
    pnlLayer[iCount].setBorder(BorderFactory.createEtchedBorder());

    lblTitle[iCnt] = new JLabel();
    lblTitle[iCnt].setFont(new java.awt.Font("Dialog", 1, 12));
    lblTitle[iCnt].setText("Systems Tract");

    pnl.add(pnlLayer[iCount],   null);
    pnlLayer[iCount].add(lblTitle[iCnt], BorderLayout.CENTER);
    iCnt++;
    iCount++;

    for (i=1; i<horizon.seq.seqTypesStruct._DWF; i++)
    {
      pnlLayer[iCount] = new JPanel();
      pnlLayer[iCount].setLayout(new BorderLayout());
      pnlLayer[iCount].setBorder(BorderFactory.createEtchedBorder());

      btn[i] = new JButton();
      btn[i].setPreferredSize(new Dimension(30, 15));
      iColor = horizon.seq.seqTypesStruct.getColors(i);
      btn[i].setBackground( new Color(iColor[0], iColor[1], iColor[2]) );
      btn[i].addActionListener(this);

      lbl[i] = new JLabel();
      lbl[i].setFont(new java.awt.Font("Dialog", 1, 11));
      lbl[i].setText("    "+horizon.seq.seqTypesStruct.NAME[i][0]);

      lblA[i] = new JLabel();
      lblA[i].setFont(new java.awt.Font("Dialog", 1, 11));
      lblA[i].setText("    "+horizon.seq.seqTypesStruct.NAME[i][1]);

      pnl.add(pnlLayer[iCount],     null);
      pnlLayer[iCount].add(btn[i],  BorderLayout.WEST);
      pnlLayer[iCount].add(lbl[i],  BorderLayout.CENTER);
      pnlLayer[iCount].add(lblA[i], BorderLayout.EAST);
      iCount++;
    }

    pnlLayer[iCount] = new JPanel();
    pnlLayer[iCount].setBorder(BorderFactory.createEtchedBorder());

    lblTitle[iCnt] = new JLabel();
    lblTitle[iCnt].setFont(new java.awt.Font("Dialog", 1, 12));
    lblTitle[iCnt].setText("Deep Water Fan System");

    pnl.add(pnlLayer[iCount],   null);
    pnlLayer[iCount].add(lblTitle[iCnt], BorderLayout.CENTER);
    iCnt++;
    iCount++;

    for (i=horizon.seq.seqTypesStruct._DWF; i<horizon.seq.seqTypesStruct._CST; i++)
    {
      {
        pnlLayer[iCount] = new JPanel();
        pnlLayer[iCount].setLayout(new BorderLayout());
        pnlLayer[iCount].setBorder(BorderFactory.createEtchedBorder());

        btn[i] = new JButton();
        btn[i].setPreferredSize(new Dimension(30, 15));
        iColor = horizon.seq.seqTypesStruct.getColors(i);
        btn[i].setBackground(new Color(iColor[0], iColor[1], iColor[2]));
        btn[i].addActionListener(this);

        lbl[i] = new JLabel();
        lbl[i].setFont(new java.awt.Font("Dialog", 1, 11));
        lbl[i].setText("    " + horizon.seq.seqTypesStruct.NAME[i][0]);

        lblA[i] = new JLabel();
        lblA[i].setFont(new java.awt.Font("Dialog", 1, 11));
        lblA[i].setText("    " + horizon.seq.seqTypesStruct.NAME[i][1]);

        pnl.add(pnlLayer[iCount], null);
        pnlLayer[iCount].add(btn[i], BorderLayout.WEST);
        pnlLayer[iCount].add(lbl[i], BorderLayout.CENTER);
        pnlLayer[iCount].add(lblA[i], BorderLayout.EAST);
        iCount++;
      }
    }

    pnlLayer[iCount] = new JPanel();
    pnlLayer[iCount].setBorder(BorderFactory.createEtchedBorder());

    lblTitle[iCnt] = new JLabel();
    lblTitle[iCnt].setFont(new java.awt.Font("Dialog", 1, 12));
    lblTitle[iCnt].setText("Miscellaneous Depositional Elements");

    pnl.add(pnlLayer[iCount],   null);
    pnlLayer[iCount].add(lblTitle[iCnt], BorderLayout.CENTER);
    iCnt++;
    iCount++;

    for (i=horizon.seq.seqTypesStruct._CST; i<horizon.seq.seqTypesStruct._SB; i++)
    {
      pnlLayer[iCount] = new JPanel();
      pnlLayer[iCount].setLayout(new BorderLayout());
      pnlLayer[iCount].setBorder(BorderFactory.createEtchedBorder());

      btn[i] = new JButton();
      btn[i].setPreferredSize(new Dimension(30, 15));
      iColor = horizon.seq.seqTypesStruct.getColors(i);
      btn[i].setBackground(new Color(iColor[0], iColor[1], iColor[2]));
      btn[i].addActionListener(this);

      lbl[i] = new JLabel();
      lbl[i].setFont(new java.awt.Font("Dialog", 1, 11));
      lbl[i].setText("    " + horizon.seq.seqTypesStruct.NAME[i][0]);

      lblA[i] = new JLabel();
      lblA[i].setFont(new java.awt.Font("Dialog", 1, 11));
      lblA[i].setText("    " + horizon.seq.seqTypesStruct.NAME[i][1]);

      pnl.add(pnlLayer[iCount], null);
      pnlLayer[iCount].add(btn[i],  BorderLayout.WEST);
      pnlLayer[iCount].add(lbl[i],  BorderLayout.CENTER);
      pnlLayer[iCount].add(lblA[i], BorderLayout.EAST);
      iCount++;
    }

    pnlLayer[iCount] = new JPanel();
    pnlLayer[iCount].setBorder(BorderFactory.createEtchedBorder());

    lblTitle[iCnt] = new JLabel();
    lblTitle[iCnt].setFont(new java.awt.Font("Dialog", 1, 12));
    lblTitle[iCnt].setText("Surfaces");

    lblA[i] = new JLabel();
    lblA[i].setFont(new java.awt.Font("Dialog", 1, 11));
    lblA[i].setText("    "+horizon.seq.seqTypesStruct.NAME[i][1]);

    pnl.add(pnlLayer[iCount],   null);
    pnlLayer[iCount].add(lblTitle[iCnt], BorderLayout.CENTER);
    iCnt++;
    iCount++;

    for (i=horizon.seq.seqTypesStruct._SB; i<horizon.seq.seqTypesStruct._TOTAL; i++)
    {
        pnlLayer[iCount] = new JPanel();
        pnlLayer[iCount].setLayout(new BorderLayout());
        pnlLayer[iCount].setBorder(BorderFactory.createEtchedBorder());

        btn[i] = new JButton();
        btn[i].setPreferredSize(new Dimension(30, 15));
        btn[i].setFont(new java.awt.Font("Dialog", 1, 11));
        btn[i].setText("_____");
        iColor = horizon.seq.seqTypesStruct.getColors(i);
        btn[i].setBackground(new Color(iColor[0], iColor[1], iColor[2]));
        iColor = horizon.seq.seqTypesStruct.getForeColors(i);
        btn[i].setForeground(new Color(iColor[0], iColor[1], iColor[2]));
        btn[i].addActionListener(this);

        lbl[i] = new JLabel();
        lbl[i].setFont(new java.awt.Font("Dialog", 1, 11));
        lbl[i].setText("    " + horizon.seq.seqTypesStruct.NAME[i][0]);

        lblA[i] = new JLabel();
        lblA[i].setFont(new java.awt.Font("Dialog", 1, 11));
        lblA[i].setText("    " + horizon.seq.seqTypesStruct.NAME[i][1]);

        pnl.add(pnlLayer[iCount], null);
        pnlLayer[iCount].add(btn[i], BorderLayout.WEST);
        pnlLayer[iCount].add(lbl[i], BorderLayout.CENTER);
        pnlLayer[iCount].add(lblA[i], BorderLayout.EAST);
        iCount++;
    }

    // Attach Widgets to Panel

    panel.add(scroll, BorderLayout.CENTER);
    scroll.getViewport().add(pnl,  null);

    return (panel);
  }

  /* ===================================================================== *
   * -------------------------- GET METHODS ------------------------------ *
   * ===================================================================== */

  /** Method getData()
   * <p> This method will retrieve the Sequence to be added to the list
   * @return st = Sequence Data Structure
   */

  public seqStruct getData()
  {
    seqStruct st = new seqStruct();

    if (iAction == _ADD) st.sKEY = new String(cmn.cmnString.UniqueName());
    else st.sKEY = new String(stModify.sKEY);

    st.depthStart = dStart;
    st.depthEnd   = dEnd;

    st.sequence   = new String(horizon.seq.seqTypesStruct.NAME[iSequence][0]);;
    st.abbrev     = new String(horizon.seq.seqTypesStruct.NAME[iSequence][1]);;
    st.sMnemonic  = new String(horizon.seq.seqTypesStruct.NAME[iSequence][2]);

    return (st);
  }

  /** Method getList()
   * <p> This method will retrieve the Sequence list data structure
   * @return st = Sequence Data List Structure
   */

  public seqListStruct getList() { return (stList); }

  /* ===================================================================== *
   * -------------------------- SET METHODS ------------------------------ *
   * ===================================================================== */

  /** Method setDepthRange(double depthStart, double depthEnd)
   * <p> This method will set the depth range of the data
   * @param depthStart = the starting depth
   * @param depthEnd   = the ending depth
   */

  public void setDepthRange(double depthStart, double depthEnd)
  {
    this.dStart = depthStart;
    this.dEnd   = depthEnd;

    setButtons();
  }

  /** Method setStartText()
   * <p> This method will set the Starting Depth textfield
   * @param txtStart = The Starting Depth Textfield
   */

  public void setStartText(JTextField txtStart) { this.txtStart = txtStart; }

  /** Method setEndText()
   * <p> This method will set the Ending Depth textfield
   * @param txtEnd = The Ending Depth Textfield
   */

  public void setEndText(JTextField txtEnd) { this.txtEnd = txtEnd; }

  /** Method setData()
   * <p> This method will set sequence List Data Structure
   * @param st = the sequence List Data Structure
   */

  public void setData(seqListStruct st)
  {
    this.stList = st;
    pTable.repopulateList( st );
  }

  /** Method setAction()
   * <p> This method will set the Action variables
   * @param iAction = The Action to be set
   */

  public void setAction(int iAction)
  {
    this.iAction = iAction;

    switch (iAction)
    {
      case _ADD:
        btnAdd.setText("Add Data to List");
        break;

      case _MODIFY:
        btnAdd.setText("Modify Data in List");
        break;
    }

    setButtons();
  }

  /** Method setSelectedColor()
   * <p> This method will set the sequence color to the selected sequence
   *     stratigraphy button
   * @param iSequence = The selected sequence identifier
   */

  private void setSelectedColor(int iSequence)
  {
    int iColor[]   = null;

    this.iSequence = iSequence;

    iColor = horizon.seq.seqTypesStruct.getColors(iSequence);
    btnSelected.setBackground(new Color(iColor[0], iColor[1], iColor[2]));

    iColor = horizon.seq.seqTypesStruct.getForeColors(iSequence);
    btnSelected.setForeground(new Color(iColor[0], iColor[1], iColor[2]));

    btnSelected.setText(horizon.seq.seqTypesStruct.NAME[iSequence][0]);
  }

  /** Method setButtons()
   * <p> This method will enable or disable buttons depending on data
   */

  private void setButtons()
  {
    btnAdd.setEnabled(true);

    btnModify.setEnabled(false);
    btnRemove.setEnabled(false);
    btnRemoveAll.setEnabled(false);
/*
    if (dStart != dEnd)
    {
      btnAdd.setEnabled(true);
    }
*/
    if (pTable.getTotalRows() > 0)
    {
      btnModify.setEnabled(true);
      btnRemove.setEnabled(true);
      btnRemoveAll.setEnabled(true);
    }
  }

  /* ===================================================================== *
   * ---------------------------- ACTIONS -------------------------------- *
   * ===================================================================== */

  /** Method add()
   * <p> This method will add the selection and depth to the sequence
   *     stratigraphy List and plot it on the profile plot in the
   *     sequence stratigraphy track.
   */

  private void add()
  {
    seqStruct st = getData();

    if (iAction == _MODIFY)
      stList = horizon.seq.seqUtility.modify( st.sKEY, st, stList );
    else
      stList = horizon.seq.seqUtility.add( st, stList);

    stList = horizon.seq.seqUtility.bubbleSort(stList);

    setData(stList);

    notifier.notifyObservers(new String("Sequence Stratigraphy Changed"));

    setAction( _ADD );
    clear();
  }

  /** Method modify()
   * <p> This method will modify the data
   */

  private void modify()
  {
    String sTemp  = "";

    setAction( _MODIFY );

    stModify    = horizon.seq.seqUtility.copy(pTable.getRowData());
    this.dStart = stModify.depthStart;
    this.dEnd   = stModify.depthEnd;

    if (txtStart != null)
      txtStart.setText("" + this.dStart);

    if (txtEnd  != null)
      txtEnd.setText("" + this.dEnd);

    sTemp = new String(stModify.sMnemonic);

    for (int i=0; i<horizon.seq.seqTypesStruct._TOTAL; i++)
    {
      if (sTemp.equals(horizon.seq.seqTypesStruct.NAME[i][2]))
      {
        setSelectedColor(i);
      }
    }
  }

  /** Method removeItem()
   * <p> This method will remove a record from the list
   */

  private void removeItem()
  {
    seqStruct st = horizon.seq.seqUtility.copy(pTable.getRowData());
    stList       = horizon.seq.seqUtility.remove( st.sKEY, stList );

    setData(stList);

    notifier.notifyObservers(new String("Sequence Stratigraphy Changed"));
  }

  /** Method removeAllRows()
   * <p> This method will remove all records from the list
   */

  private void removeAllRows()
  {
    if (stList != null)
      stList.delete();
    stList = null;

    setData(stList);

    notifier.notifyObservers(new String("Sequence Stratigraphy Changed"));
  }

  /** Method clear()
   * <p> This method will clear the Rock Color color to none
   */

  public void clear() { setSelectedColor(horizon.seq.seqTypesStruct._NONE); }

  /** Method close()
   * <p> This method will cancel the Rock Color Dialog
   */

  public void close()
  {
    for (int i=0; i<horizon.seq.seqTypesStruct._TOTAL; i++)
    {
      btn[i] = null;
    }
  }

  /** METHOD actionPerformed()
   *  <p> This Method will handle all the actions within the Frame.
   *  @param event - Action Event
   */

  public void actionPerformed(ActionEvent event)
  {
    // Global Panel Buttons

    if (event.getSource() == btnAdd)   { add(); }
    if (event.getSource() == btnClear) { clear(); }

    // Data List Buttons

    if (event.getSource() == btnModify)    { modify(); }        // Modify Row
    if (event.getSource() == btnRemove)    { removeItem(); }    // Remove Row
    if (event.getSource() == btnRemoveAll) { removeAllRows(); } // Remove All Rows

    // Sequence Color Buttons

    for (int i=0; i<horizon.seq.seqTypesStruct._TOTAL; i++)
    {
      if (event.getSource() == btn[i])
      {
        setSelectedColor(i);
      }
    }

    setButtons();
  }
}

/*
 *  @version 1.1 06/04/2008
 *  @author  John Victorine
 */
