/*
 * @regionsStruct.java Version 1.0 02/16/2004
 *
 * Copyright (c) 2003 Kansas Geological Survey
 * 1930 Constant Avenue, Lawrence, Kansas, 66047, U.S.A.
 * All Rights Reserved.
 */

package horizon.regions;

/** CLASS regionsStruct
 *  <p> This Structure holds the Regions Data.
 *
 *  @version 1.1 02/16/2004
 *  @author  John R. Victorine
 */

public class regionsStruct
{
  public static final int    _TOPS        = 0;
  public static final int    _PERFORATION = 1;
  public static final int    _DST         = 2;

  public static final String TOPS         = "TOPS";
  public static final String PERFORATION  = "PERF";
  public static final String DST          = "DST";

  // Static Constants for RANK

  public static final int _NONE        = 0;
  public static final int _SYSTEM      = 1;
  public static final int _SERIES      = 2;
  public static final int _STAGE       = 3;
  public static final int _SUPER_GROUP = 4;
  public static final int _GROUP       = 5;
  public static final int _FORMATION   = 6;
  public static final int _MEMBER      = 7;
  public static final int _BED         = 8;
  public static final int  _TOTAL_RANK = 9;

  public static final String RANK[] = {
    "Unknown", "SYSTEM", "SERIES", "STAGE", "SUPERGROUP",
      "GROUP", "FORMATION", "MEMBER", "BED" };

  // Static Constants for Level of Confidence

  public static final int   _EXCELLENT   = 0;  // Gold
  public static final int   _GOOD        = 1;  // Silver
  public static final int   _FAIR        = 2;  // Copper
  public static final int   _POOR        = 3;  // Lead
  public static final int  _TOTAL_LEVEL  = 4;

  public static final String LEVEL[] = { "Excellent", "Good", "Fair", "Poor" };

  // Formation Tops Variables

  public String sKID       = "0";   // Primary KEY of Record
  public String sKEY       = "0";   // User defined Primary KEY of Record
  public String sID        = TOPS;  // ID of the Regions
  public int    id         = _TOPS; // The Numeric equivalent to the Region Text
  public int    iLevel     = _POOR; // Confidence level of selection

  public String sEon       = "";    // Eon this formation belongs too
  public String sEra       = "";    // Era this formation belongs too
  public String system     = "";    // System id this Formation belongs too
  public String systemName = "";    // System Name of the Formation
  public String series     = "";    // Series id this Formation belongs too
  public String seriesName = "";    // Series Name this Formation belongs too

  public String sequence   = "0";   // Sequence Number from Stratigraphic Unit
  public String sRank      = RANK[0]; // Stratigraphic Unit Rank
  public String sName      = "";    // Region Name
  public String sName2     = "";    // Alternate Region Name

  public String source     = "";    // Source Name

  public double depth_top  = 0.0;   // Starting Depth.
  public double depth_base = 0.0;   // Ending Depth.

  public double dTime_top  = 0.0;   // Starting Time.
  public double dTime_base = 0.0;   // Ending Time.

  public int    shots      = 0;     // Number of shots / foot

  /** Method delete()
   * <p> This method will force set the Objects to null and force Java to
   *     free unwanted memory
   */

  public void delete()
  {
    sKID       = null;    // Primary KEY of Record
    sKEY       = null;    // User defined primary key
    sID        = null;    // ID of the Regions
    sequence   = null;    // Sequence Number from Stratigraphic Unit

    sEon       = null;    // Eon this formation belongs too
    sEra       = null;    // Era this formation belongs too
    system     = null;    // System this Formation belongs too
    systemName = null;    // System Name of the Formation
    series     = null;    // Series id this Formation belongs too
    seriesName = null;    // Series Name this Formation belongs too

    sRank      = null;    // Stratigraphic Unit Rank
    sName      = null;    // Region Name
    sName2     = null;    // Alternate Region Name
    source     = null;    // Source Name
  }
}
