/*
 * @regionsStandardTools.java Version 1.1 02/12/2010
 *
 * Copyright (c) 2010 Kansas Geological Survey
 * 1930 Constant Avenue, Lawrence, Kansas, 66047, U.S.A.
 * All Rights Reserved.
 */

package horizon.regions;

/** Class regionsStandardTools
 *  <p> This Class holds the standard tool information to map the Stratigraphic
 *      LAS File curves to standard names.
 */

public class regionsStandardTools
{
  public static final int _PERFT  = 0;  // Perforation Top Depth    {F}
  public static final int _PERFB  = 1;  // Perforation Bottom Depth {F}
  public static final int _PERFD  = 2;  // Shot density per foot    {F}
  public static final int TOTAL   = 3;  // Total

  public static final int _C_ID   = 0;
  public static final int _C_MNEM = 1;
  public static final int _C_NAME = 2;
  public static final int _C_UNIT = 3;

  public static final String CURVES[][] =
  {
    // ID     MNEMONIC  CURVE NAME                      UNIT
    { "1100", "PERFT", "Perforation Top Depth",                "F" },
    { "1200", "PERFB", "Perforation Bottom Depth",             "F" },
    { "1300", "PERFD", "Shot density per foot",                "SHOTS/FT" },
  };

  /** Method isCurve()
   * <p> This method will determine if the curve is part of the standard
   *     stratigraphic units curves from the LAS File.
   * @param  iColumn = The column number
   * @param  str     = the string being compared.
   * @return bValue  = true it is a valid curve, false it is not
   */

  public static boolean isCurve( int iColumn, String str )
  {
    boolean bValue = false;

    if (iColumn==1) str = new String( str.toUpperCase() );

    for (int i=0; i<TOTAL; i++)
    {
      if (str.equals(CURVES[i][iColumn]))
      {
        bValue = true;
      }
    }

    return (bValue);
  }

  /** Method getRow()
   * <p> This method will return the row number of the Stratigraphic Unit Curve
   * @param  iColumn = The column number
   * @param  str     = the string being compared.
   * @return iRow = row number
   */

  public static int getRow( int iColumn, String str )
  {
    int iRow = -1;

    if (iColumn==1) str = new String( str.toUpperCase() );

    for (int i=0; i<TOTAL; i++)
    {
      if (str.equals(CURVES[i][iColumn]))
      {
        iRow = i;
      }
    }

    return (iRow);
  }
}