/*
 * @regionsListStruct.java Version 1.1 11/02/2007
 *
 * Copyright (c) 2003 Kansas Geological Survey
 * 1930 Constant Avenue, Lawrence, Kansas, 66047, U.S.A.
 * All Rights Reserved.
 */

package horizon.regions;

import horizon.regions.regionsStruct;

/** CLASS regionsListStruct
 *  <p> This Structure holds a list of Regions Structures.
 *
 *  @version 1.1 11/02/2007
 *  @author  John R. Victorine
 */

public class regionsListStruct
{
  public int    iSource    = las3.las3Constants._SOURCE_NONE;

  // Stratigraphic Headers Data Information

  public String sKID       = "0";  // Primary Key of the Well
  public String sKEY       = "";   // Primary Key created on user's PC
  public int    iType      = iqstrat.iqstratHeadersStruct.WELL; // Type of Data
  public String sAPI       = "";   // API-Number OR UWI
  public String sName      = "";   // Well Name or Outcrop Name
  public String status     = iqstrat.iqstratStatusStruct.STATUS[0][0]; // Status
  public double dLatitude  = 0.0;  // Latitude of Location
  public double dLongitude = 0.0;  // Longitude of Location
  public double depth      = 0.0;  // Total Depth of Well or Height of Outcrop
  public double dGL        = 0.0;  // Ground Level

  public String sKGS       = "NO"; // KGS Saved Data Indicator

  // LAS 3 Dependent Variable

  public String sPERFTYPE  = "";  // Perforation Charge Type

  // Other Tops Parameters that are not in the Required List

  public int    iParamRows  = 0;      // Total number of rows
  public int    iParamCols  = las3.las3Struct._TOTAL; // Total number of columns
  public String sParams[][] = null;   // Array holding the Parameter Definitions

  // Regions Data

  public int           iCount = 0; // Total Number of Records
  public regionsStruct stItem[];   // Array of Regions Structures

  /** Method delete()
   * <p> This method will force set the Objects to null and force Java to
   *     free unwanted memory
   */

  public void delete()
  {
    sKID      = null; // Primary Key of the Well
    sKEY      = null; // Primary Key created on user's PC
    sAPI      = null; // API-Number OR UWI
    sName     = null; // Well Name or Outcrop Name
    status    = null; // Status

    sKGS      = null; // KGS Saved Data Indicator

    // LAS 3 Dependent Variable

    sPERFTYPE = null; // Perforation Charge Type

    // LAS 3 File Parameters

    iParamRows = 0;    // Total number of rows
    iParamCols = 0;    // Total number of columns
    sParams    = null; // Array holding the Parameter Definitions

    for (int i=0; i<iCount; i++)
    {
      if (stItem[i] != null)
        stItem[i].delete();
      stItem[i] = null;
    }

    iCount = 0;
  }
}
