/*
 * @regionsPerfTable.java Version 1.1 03/16/2011
 *
 * Copyright (c) 2011 Kansas Geological Survey
 * 1930 Constant Avenue, Lawrence, Kansas, 66047, U.S.A.
 * All Rights Reserved.
 */

package horizon.regions.gui;

import java.awt.*;
import java.lang.*;
import javax.swing.*;
import javax.swing.table.*;

import gui.guiTable;

import horizon.regions.regionsListStruct;
import horizon.regions.regionsStruct;

/** Class regionsPerfTable
 *  <p> This Class will display the Formation Tops.
 *
 *  @version 1.1 03/16/2011
 *  @author  John R. Victorine
 */

public class regionsPerfTable
{
  private int      iRows     = 0;
  private int      iColumns  = 3;
  private String   sColumn[] = {"Start", "End", "Shots"};
  private Object   oData[][] = null;
  private guiTable pTable    = null;

  private regionsListStruct st      = null;
  private int               iChange = 0;

  /** Constructor regionsPerfTable()
   *  <p> This is the Constructor for this class.
   */

  public regionsPerfTable()
  {
    pTable = new guiTable(0, iColumns, sColumn);
  }

  /** Constructor regionsPerfTable()
   *  <p> This is the Constructor for this class.
   * @param st     = The Regions List Data Structure
   */

  public regionsPerfTable(regionsListStruct st)
  {
    this.st = horizon.regions.regionsUtility.bubbleSort(st);

    populateList();

    if (iRows > 0)
      pTable = new guiTable(0, iRows, iColumns, sColumn, oData);
    else
      pTable = new guiTable(0, iColumns, sColumn);

    if (iChange == 0)
      iRows = 0;

    if (iRows > 0)
      pTable.setSelectedRow(0);
  }

  /** Method close()
   * <p> This method will cancel the Rock Color Dialog
   */

  public void close()
  {
    sColumn    = null;
    oData      = null;

    if (pTable != null)
      pTable.close();
    pTable     = null;

    st         = null;
  }

  /* ===================================================================== *
   * -------------------------- SET METHODS ------------------------------ *
   * ===================================================================== */

  /** Method populateList()
   *  <p> This method will populate the Region List data.
   */

  private void populateList()
  {
    int i      = 0;
    int iCount = 0;

    iRows   = 0;
    iChange = 0;

    if (st != null)
    {
	  if (st.iCount > 0)
	  {
        oData = new Object[st.iCount][iColumns];

        for (i=0; i<st.iCount; i++)
        {
	      iChange = 1;

          oData[iCount][0] = new Double( st.stItem[i].depth_top );
          oData[iCount][1] = new Double( st.stItem[i].depth_base );
          oData[iCount][2] = new Integer( st.stItem[i].shots );

          iCount++;
	    }

	    iRows = iCount;
      }
    }

    if (iRows == 0)
    {
	  iRows = 1;
      oData = new String[1][iColumns];
      for (i=0; i<iColumns; i++)
      {
        oData[0][i] = new String("");
      }
	}
  }

  /* ===================================================================== *
   * -------------------------- SET METHODS ------------------------------ *
   * ===================================================================== */

  /** Method setData()
   *  <p> This method will reload the Region List after adding, deleting from
   *      the formation name list.
   * @param st     = The Regions List Data Structure
   */

  public void setData( regionsListStruct st )
  {
    this.st = horizon.regions.regionsUtility.bubbleSort(st);

    populateList();

    pTable.reload(iRows, oData);

    if (iChange == 0)
      iRows = 0;

    if (iRows > 0)
      pTable.setSelectedRow(0);
  }

  /* ===================================================================== *
   * -------------------------- GET METHODS ------------------------------ *
   * ===================================================================== */

  /** Method getTotalRows()
   *  <p> This method will return the total rows in the table.
   *  @return Total Number of Rows.
   */

  public int getTotalRows() { return (iRows); }

  /** Method getRow()
   *  <p> This method will return the selected data id in the table.
   *  @return selected data id.
   */

  public int getRow() { return ( pTable.getSelectedRow() ); }

  /** Method getRowData()
   *  <p> This method will return the Region Data Structure of the
   *      selected row.
   *  @return stData = Region Data Structure.
   */

  public regionsStruct getRowData()
  {
    regionsStruct stData = null;

    stData = horizon.regions.regionsUtility.copy(st.stItem[pTable.getSelectedRow()]);

    return (stData);
  }

  /** Method getData()
   *  <p> This method will returns the Region List Data Structure.
   *  @return st = Region List Data Structure.
   */

  public regionsListStruct getData() { return (st); }

  /** Method getScrollPane()
   *  <p> This method will return the scroll pane.
   *  @return jScrollPane - Scroll Pane containing the Table.
   */

  public JScrollPane getScrollPane() { return (pTable.getScrollPane()); }
}

/*
 *  @version 1.1 03/16/2011
 *  @author  John R. Victorine
 */
