/*
 * @envMatrixTable.java Version 1.1 01/11/2012
 *
 * Copyright (c) 2012 Kansas Geological Survey
 * 1930 Constant Avenue, Lawrence, Kansas, 66047, U.S.A.
 * All Rights Reserved.
 */

package horizon.env.gui;

import java.awt.*;
import java.lang.*;
import javax.swing.*;
import javax.swing.table.*;

import gui.guiTable;

import horizon.env.envMatrixStruct;

/** Class envMatrixTable
 *  <p> This Class will display the Formation Tops.
 *
 *  @version 1.1 01/11/2012
 *  @author  John R. Victorine
 */

public class envMatrixTable
{
  private int      iRows     = 0;
  private int      iColumns  = 18;
  private String   sColumn[] = {"Type", "Group", "Subgroup", "Environment",
                                "0", "1", "2", "3", "4", "5", "6", "7", "8", "9", "A", "B", "C", "D"};
  private int      iColLength[] = { 18,   // Type
                                    18,   // Group
                                    18,   // Subgroup
                                    20,   // Environment
                                     2,
                                     2,
                                     2,
                                     2,
                                     2,
                                     2,
                                     2,
                                     2,
                                     2,
                                     2,
                                     2,
                                     2,
                                     2,
                                     2 };

  private Object   oData[][] = null;
  private int      iData[]   = null;
  private guiTable pTable    = null;
  private int      iChange   = 0;

  // Data Panel Type

  public static final int    _CONTI  = 0;
  public static final int    _TRANS  = 1;
  public static final int    _MARINE = 2;
  public static final String TYPE[]  = { "Continental", "Transitional", "Marine" };

  private int      iType     = _CONTI;

  /** Constructor envMatrixTable()
   *  <p> This is the Constructor for this class.
   */

  public envMatrixTable()
  {
    populateList();

    if (iRows > 0)
      pTable = new guiTable(0, iRows, iColumns, sColumn, oData);
    else
      pTable = new guiTable(0, iColumns, sColumn);

    resetColumnWidths();
    pTable.showHorScroll(true);

    if (iChange == 0)
      iRows = 0;

    if (iRows > 0)
      pTable.setSelectedRow(0);
  }

  /** Method close()
   * <p> This method will close the this tabe
   */

  public void close()
  {
    sColumn    = null;
    iColLength = null;
    oData      = null;
    pTable     = null;
  }

  /** Method resetColumnWidths()
   *  <p> This method will reset the column widths to a specific size.
   */

  private void resetColumnWidths()
  {
    for (int i=0; i<iColumns; i++)
    {
      pTable.resizeColumn(i, iColLength[i]);
    }
  }

  /* ===================================================================== *
   * -------------------------- SET METHODS ------------------------------ *
   * ===================================================================== */

  /** Method populateList()
   *  <p> This method will populate the Environment List data.
   */

  private void populateList()
  {
    int  i, j, k;
    int  iCount = 0;
    char c[]    = null;

    iRows   = 0;

    for (i=0; i<horizon.env.envMatrixStruct.ENV.length; i++)
    {
	  if (TYPE[iType].equals(horizon.env.envMatrixStruct.ENV[i][0]))
	    iCount++;
	}

    iChange = 1;
    oData   = new Object[iCount][iColumns];
    iData   = new int[iCount];
    iCount  = 0;

    for (i=0; i<horizon.env.envMatrixStruct.ENV.length; i++)
    {
	  if (TYPE[iType].equals(horizon.env.envMatrixStruct.ENV[i][0]))
	  {
        oData[iCount][0] = new String(horizon.env.envMatrixStruct.ENV[i][1]);
        oData[iCount][1] = new String(horizon.env.envMatrixStruct.ENV[i][2]);
        oData[iCount][2] = new String(horizon.env.envMatrixStruct.ENV[i][3]);
        oData[iCount][3] = new String(horizon.env.envMatrixStruct.ENV[i][4]);

        c = horizon.env.envMatrixStruct.ENV[i][5].toCharArray();
        k = 4;
        for (j=0; j<14; j++)
        {
          oData[iCount][k] = new String("" + c[j]);
          k++;
	    }

        iData[iCount] = i;

        iCount++;
      }
    }

    iRows = iCount;
  }

  /* ===================================================================== *
   * -------------------------- SET METHODS ------------------------------ *
   * ===================================================================== */

  /** Method setData()
   *  <p> This method will reload the Environment List after adding, deleting from
   *      the formation name list.
   * @param iType  = The Depositional Environment Type
   */

  public void setData(int iType)
  {
    this.iType = iType;

    populateList();

    pTable.reload(iRows, oData);

    if (iChange == 0)
      iRows = 0;

    if (iRows > 0)
      pTable.setSelectedRow(0);
  }

  /* ===================================================================== *
   * -------------------------- GET METHODS ------------------------------ *
   * ===================================================================== */

  /** Method getTotalRows()
   *  <p> This method will return the total rows in the table.
   *  @return Total Number of Rows.
   */

  public int getTotalRows() { return (iRows); }

  /** Method getRow()
   *  <p> This method will return the selected data id in the table.
   *  @return selected data id.
   */

  public int getRow() { return (iData[pTable.getSelectedRow()]); }

  /** Method getScrollPane()
   *  <p> This method will return the scroll pane.
   *  @return jScrollPane - Scroll Pane containing the Table.
   */

  public JScrollPane getScrollPane() { return (pTable.getScrollPane()); }
}

/*
 *  @version 1.1 01/11/2012
 *  @author  John Victorine
 */
