/*
 * @envStruct.java Version 1.0 11/02/2011
 *
 * Copyright (c) 2011 Kansas Geological Survey
 * 1930 Constant Avenue, Lawrence, Kansas, 66047, U.S.A.
 * All Rights Reserved.
 */

package horizon.env;

/** CLASS envStruct
 *  <p> This Structure holds the Depositional Environment Data.
 *
 *  @version 1.1 11/02/2011
 *  @author  John R. Victorine
 */

public class envStruct
{
  public static final double dNULL = -999.95; // Null Value for an empty data set

  public static final int _NONE = -1;

  public static final int _CONTINENTAL =  0;  // Continental
                                              // Coastal
  public static final int _COASTAL     =  1;  // -- Upper
  public static final int _COASTAL_F   =  2;  // .. Fresh Water
  public static final int _COASTAL_B   =  3;  // .. Brackish Water
  public static final int _COASTAL_H   =  4;  // .. Hyper saline Water
                                              // Neritic
                                              // -- Inner
  public static final int _NERITIC_I_0 =  5;  // .. Shoreface (upper and lower)
  public static final int _NERITIC_I_1 =  6;  // .. Offshore transition
  public static final int _NERITIC_I_2 =  7;  // .. Offshore
  public static final int _NERITIC_M   =  8;  // -- Middle
  public static final int _NERITIC_O   =  9;  // -- Outer
                                              // Bathyal
  public static final int _BATHYAL_U   = 10;  // -- Upper
  public static final int _BATHYAL_M   = 11;  // -- Middle
  public static final int _BATHYAL_L   = 12;  // -- Lower
  public static final int _ABYSSAL     = 13;  // Abyssal

  public static final int _MAXIMUM     = 14;  // Maximum Constant

  public static final String _ENV[] = {
	  "continental",
	  "coastal",
	  "coastal: fresh water",
	  "coastal: brackish water",
	  "coastal: hyper saline water",
	  "neritic-inner: shoreface",
	  "neritic-inner: offshore transition",
	  "neritic-inner: offshore",
	  "neritic-middle",
	  "neritic-outer",
	  "bathyal-upper",
	  "bathyal-middle",
	  "bathyal-lower",
	  "abyssal"
  };

  // Unique Key for Record

  public String sKEY       = "0";

  // Depth Range

  public double depthStart = dNULL; // Starting Depth
  public double depthEnd   = dNULL; // Ending Depth
  public double dBed       = dNULL; // Bed Thickness

  // Level to represent a method of sea depth

//  public int    iFrom      = -4; // Beginning Level (NOT USED)
//  public int    iTo        = -4; // Ending Level    (NOT USED)

  public int    icontl     = 0;  // Continental
  public int    icstl      = 0;  // Coastal
  public int    ifrsh      = 0;  // Fresh Water
  public int    ibrcksh    = 0;  // Brackish Water
  public int    ihyper     = 0;  // Brackish Water
  public int    ishore     = 0;  // Shoreface
  public int    ioff_tran  = 0;  // Off shore trasition
  public int    ioffshr    = 0;  // Off Shore
  public int    ishlf_m    = 0;  // Middle Neritic
  public int    ishlf_o    = 0;  // Outer Neritic
  public int    ibthyl_u   = 0;  // Upper Bathyal
  public int    ibthyl_m   = 0;  // Middle Bathyal
  public int    ibthyl_l   = 0;  // Lower Bathyal
  public int    iabyssl    = 0;  // Abyssal

  // Set the Background Color

//  public int    iRGB[]     = { 0, 0, 0 };   // (NOT USED)

  // Depositional Environment selected for the depth range

  public int    iType      = _NONE; // Depositional Environment Type Identifier
  public String sType      = ""; // Depositional Environment Type
  public String sGroup     = ""; // 1st Group: Type of Depositional Environment
  public String sGroup2    = ""; // 2nd Group:
  public String sGroup3    = ""; // 3rd Group:

//  public String sLabel     = ""; // Label of Depth Range
  public String sDepEnv    = ""; // Depositional Environment Phrase
  public String sDescrip   = ""; // Depositional Environment Descriptions
//  public String abbrev     = ""; // Abbreviation (NOT USED)

  /* ------------------------------------------------------------------------- *
   * This Section is used to hold the Parse Depositional Environment List Data
   *
   * Parse list to find environment
   * Lt = Unique Lithologies that can determine environment type by themselves
   * L  = Lithology present for specific environment
   * C  = Color of the sedimentary rock for a specific environment
   * Gt = Diagnostic form of Fossil Genus to determine environment
   * G  = Possible Fossil Genera in environment
   *
   * Find environment Identifiers
   * The iData Array is set for each environment in the Lookup list
   * If -1 is detected then ignore data type
   * If 0 is detected then there were none of that data type found
   * If more than 0 then there were data type found
   *
   * For each environment with data types greater than -1 there must
   * be at least 1 item in each valid data type or the check fails
   * ------------------------------------------------------------------------- */

  public static final int _Lt = 0;  // Total number of Unique Lithologies found
  public static final int _L  = 1;  // Total number of Lithologies found
  public static final int _C  = 2;  // Total number of Colors found
  public static final int _F  = 3;  // Total number of Generic Fossils Types found
  public static final int _Gt = 4;  // Total number of Unique Genera found
  public static final int _G  = 5;  // Total number of Genera found

                           //  Lt   L   C   F  Gt   G
  public int    iData[]    = { -1, -1, -1, -1, -1, -1 };

  public int    iLith_T    = 0; // Lt - Total number of Unique Lithologies found
  public int    iLith      = 0; // L  - Total number of Lithologies found
  public int    iColor     = 0; // C  - Total number of Colors found
  public int    iFossil    = 0; // F  - Total number of Generic Fossils Types found
  public int    iGenus_T   = 0; // Gt - Total number of Unique Genera found
  public int    iGenus     = 0; // G  - Total number of Genera found

  public String sLith_T[]  = null; // List of Unique Lithologies (Lt)
  public String sLith[]    = null; // List of Lithologies (L)
  public String sColor[]   = null; // List of Colors (C)
  public String sFossil[]  = null; // List of Generic Fossil Types (F)
  public String sGenus_T[] = null; // List of Unique Genera (Gt)
  public String sGenus[]   = null; // List of Genera (G)

  /** Method delete()
   * <p> This method will force set the Objects to null and force Java to
   *     free unwanted memory
   */

  public void delete()
  {
    // Unique Key for Record

    sKEY       = null;

    // Depositional Environment selected for the depth range

    sType      = null;
//    sLabel     = null;
    sDepEnv    = null;
    sDescrip   = null;
//    abbrev     = null;
    sGroup     = null;
    sGroup2    = null;
    sGroup3    = null;

    // Background Color

//    iRGB       = null;

    iData      = null;

    sLith_T    = null; // List of Unique Lithologies
    sLith      = null; // List of Lithologies
    sColor     = null; // List of Colors
    sFossil    = null; // List of Generic Fossil Types
    sGenus_T   = null; // List of Unique Genera
    sGenus     = null; // List of Genera
  }
}

/*
 *  @version 1.1 11/02/2011
 *  @author  John Victorine
 */
