/*
 * @envStandardTools.java Version 1.1 11/03/2011
 *
 * Copyright (c) 2011 Kansas Geological Survey
 * 1930 Constant Avenue, Lawrence, Kansas, 66047, U.S.A.
 * All Rights Reserved.
 */

package horizon.env;

/** Class envStandardTools
 *  <p> This Class holds the standard tool information to map the
 *      depositional environment curves to standard names for plotting.
 */

public class envStandardTools
{
  public static final int _KEY   = 0;  // Primary KEY
  public static final int _STRT  = 1;  // Starting Depth
  public static final int _END   = 2;  // Ending Depth
  public static final int _THICK = 3;  // Bed Thickness
  public static final int _ENV   = 4;  // Depositional Environment Term
  public static final int _MODEL = 5;  // Depositional Environment Model
  public static final int _TYPE  = 6;  // Depositional Environment Type
  public static final int _GRP   = 7;  // Depositional Environment Group
  public static final int _SGRP  = 8;  // Depositional Environment Subgroup
  public static final int _DESC  = 9;  // Description (original text)
  public static final int _LEVEL = 10; // Sea Level identifer

  public static final int TOTAL  = 11; // TOTAL

  // Curve Column Numbers

  public static final int _C_ID     = 0;
  public static final int _C_MNEM   = 1;
  public static final int _C_NAME   = 2;
  public static final int _C_UNIT   = 3;

  public static final String CURVES[][] =
  {
    // KEY          Mnemonic     Description                   Units
    { "E_KEY",      "KEY",       "Primary Key",                "" },
    { "E_STRT",     "STRT",      "Starting Depth",             "F" },
    { "E_END",      "END",       "Ending Depth",               "F" },
    { "E_THK",      "THICK",     "Bed Thickness",              "F" },
    { "E_ENV",      "ENV",       "Dep Environment Terms",      "" },
    { "E_MODEL",    "MODEL",     "Sedimentary Model",          "" },
    { "E_TYPE",     "TYPE",      "Environment Type",           "" },
    { "E_GRP",      "GRP",       "Environment Group",          "" },
    { "E_SGRP",     "SGRP",      "Environment Subgroup",       "" },
    { "E_DESC",     "DESC",      "Description",                "" },
    { "E_LEVEL",    "LEVEL",     "Sea Level identifer",        "" },
  };

  /** Method isCurve()
   * <p> This method will determine if the curve is part of the standard
   *     Environment curves from the LAS File.
   * @param  iColumn = The column number
   * @param  str     = the string being compared.
   * @return bValue  = true it is a valid curve, false it is not
   */

  public static boolean isCurve( int iColumn, String str )
  {
    boolean bValue = false;

    if (iColumn==1) str = new String( str.toUpperCase() );

    for (int i=0; i<TOTAL; i++)
    {
      if (str.equals(CURVES[i][iColumn]))
      {
        bValue = true;
      }
    }

    return (bValue);
  }

  /** Method getRow()
   * <p> This method will return the row number of the
   *     Environment Curve
   * @param  iColumn = The column number
   * @param  str     = the string being compared.
   * @return iRow = row number
   */

  public static int getRow( int iColumn, String str )
  {
    int iRow = -1;

    if (iColumn==1) str = new String( str.toUpperCase() );

    for (int i=0; i<TOTAL; i++)
    {
      if (str.equals(CURVES[i][iColumn]))
      {
        iRow = i;
      }
    }

    return (iRow);
  }
}

/*
 *  @version 1.1 11/03/2011
 *  @author  John Victorine
 */
