/*
 * @envMatrixStruct.java Version X.0 01/11/2012
 *
 * Copyright (c) 2012 Kansas Geological Survey
 * 1930 Constant Avenue, Lawrence, Kansas, 66047, U.S.A.
 * All Rights Reserved.
 */

package horizon.env;

/** CLASS envStruct
 *  <p> This Structure holds the Depositional Environment Models.
 *
 *  Reference: Oil Standard Legend 1995,  4.5 Depositional Environment, 4.5.3 Facies Terminology,
 *             Shell International Exploration and Production B.V., The Hague,
 *             (http://www.gotds.com/ShellSTANDLEG.pdf)
 *
 *  @version X.X 01/11/2012
 *  @author  John R. Victorine
 */

public class envMatrixStruct
{
  public static final String ENV[][] = {
    // Type,           Group 1,  group 2,              group 3,          value,       Level 0123456789abcd
    { "Continental", "Alluvial", "",                   "",               "",               "X............." },
    { "Continental", "Alluvial", "Alluvial Fans",      "",               "",               "X............." },
    { "Continental", "Alluvial", "Alluvial Fans",      "Stream Flows",   "",               "X............." },
    { "Continental", "Alluvial", "Alluvial Fans",      "Stream Flows",   "Channels",       "X............." },
    { "Continental", "Alluvial", "Alluvial Fans",      "Stream Flows",   "Sheetfloods",    "X............." },
    { "Continental", "Alluvial", "Alluvial Fans",      "Stream Flows",   "Sieve Deposits", "X............." },
    { "Continental", "Alluvial", "Alluvial Fans",      "Viscous Flows",  "",               "X............." },
    { "Continental", "Alluvial", "Alluvial Fans",      "Viscous Flows",  "Debris Flows",   "X............." },
    { "Continental", "Alluvial", "Alluvial Fans",      "Viscous Flows",  "Mudflows",       "X............." },

    { "Continental", "Alluvial", "Braided Streams",    "",               "",               "X............." },
    { "Continental", "Alluvial", "Braided Streams",    "",               "Channels",       "X............." },
    { "Continental", "Alluvial", "Braided Streams",    "Bars",           "",               "X............." },
    { "Continental", "Alluvial", "Braided Streams",    "Bars",           "Longitudinal",   "X............." },
    { "Continental", "Alluvial", "Braided Streams",    "Bars",           "Transverse",     "X............." },

    { "Continental", "Alluvial", "Meandering Streams", "",               "",               "X............." },
    { "Continental", "Alluvial", "Meandering Streams", "Meander Belts",  "",               "X............." },
    { "Continental", "Alluvial", "Meandering Streams", "Meander Belts",  "Channels",       "X............." },
    { "Continental", "Alluvial", "Meandering Streams", "Meander Belts",  "Natural Levees", "X............." },
    { "Continental", "Alluvial", "Meandering Streams", "Meander Belts",  "Point Bars",     "X............." },
    { "Continental", "Alluvial", "Meandering Streams", "Floodbasins",    "",               "X............." },
    { "Continental", "Alluvial", "Meandering Streams", "Floodbasins",    "Streams",        "X............." },
    { "Continental", "Alluvial", "Meandering Streams", "Floodbasins",    "Lakes",          "X............." },
    { "Continental", "Alluvial", "Meandering Streams", "Floodbasins",    "Swamps",         "X............." },

    { "Continental", "Eolian",   "",                   "",               "",               "X............." },
    { "Continental", "Eolian",   "Dunes",              "",               "",               "X............." },
    { "Continental", "Eolian",   "Dunes",              "Desert Dunes",   "",               "X............." },
    { "Continental", "Eolian",   "Dunes",              "Desert Dunes",   "Transverse",     "X............." },
    { "Continental", "Eolian",   "Dunes",              "Desert Dunes",   "Longitudinal",   "X............." },
    { "Continental", "Eolian",   "Dunes",              "Desert Dunes",   "Barchan",        "X............." },
    { "Continental", "Eolian",   "Dunes",              "Desert Dunes",   "Parabolic",      "X............." },
    { "Continental", "Eolian",   "Dunes",              "Desert Dunes",   "Dome-Shaped",    "X............." },

    { "Continental", "Eolian",   "Dunes",              "Other Dunes",    "",               "X............." },
    { "Continental", "Eolian",   "Dunes",              "Other Dunes",    "Transverse",     "X............." },
    { "Continental", "Eolian",   "Dunes",              "Other Dunes",    "Longitudinal",   "X............." },
    { "Continental", "Eolian",   "Dunes",              "Other Dunes",    "Barchan",        "X............." },
    { "Continental", "Eolian",   "Dunes",              "Other Dunes",    "Parabolic",      "X............." },
    { "Continental", "Eolian",   "Dunes",              "Other Dunes",    "Dome-Shaped",    "X............." },

    { "Continental", "Eolian",   "Dunes",              "Coastal Dunes",  "",               ".X............" },
    { "Continental", "Eolian",   "Dunes",              "Coastal Dunes",  "Transverse",     ".X............" },
    { "Continental", "Eolian",   "Dunes",              "Coastal Dunes",  "Longitudinal",   ".X............" },
    { "Continental", "Eolian",   "Dunes",              "Coastal Dunes",  "Barchan",        ".X............" },
    { "Continental", "Eolian",   "Dunes",              "Coastal Dunes",  "Parabolic",      ".X............" },
    { "Continental", "Eolian",   "Dunes",              "Coastal Dunes",  "Dome-Shaped",    ".X............" },

    { "Transitional", "Deltaic", "",                    "",              "",               ".X............" },
    { "Transitional", "Deltaic", "Upper Deltaic Plain", "",              "",               ".X............" },
    { "Transitional", "Deltaic", "Upper Deltaic Plain", "Meander Belts", "",               ".X............" },
    { "Transitional", "Deltaic", "Upper Deltaic Plain", "Meander Belts", "Channels",       ".X............" },
    { "Transitional", "Deltaic", "Upper Deltaic Plain", "Meander Belts", "Natural Levees", ".X............" },
    { "Transitional", "Deltaic", "Upper Deltaic Plain", "Meander Belts", "Point Bars",     ".X............" },

    { "Transitional", "Deltaic", "Upper Deltaic Plain", "Floodbasins",   "",               "..X..........." },
    { "Transitional", "Deltaic", "Upper Deltaic Plain", "Floodbasins",   "Streams",        "..X..........." },
    { "Transitional", "Deltaic", "Upper Deltaic Plain", "Floodbasins",   "Lakes",          "..X..........." },
    { "Transitional", "Deltaic", "Upper Deltaic Plain", "Floodbasins",   "Swamps",         "..X..........." },

    { "Transitional", "Deltaic", "Lower Deltaic Plain", "",                      "",                ".X............" },
    { "Transitional", "Deltaic", "Lower Deltaic Plain", "Distributary Channels", "",                ".X............" },
    { "Transitional", "Deltaic", "Lower Deltaic Plain", "Distributary Channels", "Channels",        ".X............" },
    { "Transitional", "Deltaic", "Lower Deltaic Plain", "Distributary Channels", "Natural Levees",  ".X............" },

    { "Transitional", "Deltaic", "Lower Deltaic Plain", "Interdistributary Area", "",               ".X............" },
    { "Transitional", "Deltaic", "Lower Deltaic Plain", "Interdistributary Area", "Lakes",          "..X..........." },
    { "Transitional", "Deltaic", "Lower Deltaic Plain", "Interdistributary Area", "Marsh",          "..X..........." },
    { "Transitional", "Deltaic", "Lower Deltaic Plain", "Interdistributary Area", "Salt Marsh",     "...X.........." },
    { "Transitional", "Deltaic", "Lower Deltaic Plain", "Interdistributary Area", "Tidal Channels", ".X............" },
    { "Transitional", "Deltaic", "Lower Deltaic Plain", "Interdistributary Area", "Tidal Flats",    ".X............" },

    { "Transitional", "Deltaic", "Fringe",              "",              "",                 ".X............" },
    { "Transitional", "Deltaic", "Fringe",              "Inner",         "",                 ".X............" },
    { "Transitional", "Deltaic", "Fringe",              "Inner",         "River-Mouth Bars", ".X............" },
    { "Transitional", "Deltaic", "Fringe",              "Inner",         "Beaches",          ".X............" },
    { "Transitional", "Deltaic", "Fringe",              "Inner",         "Beach Ridges",     ".X............" },
    { "Transitional", "Deltaic", "Fringe",              "Inner",         "Tidal Flats",      ".X............" },
    { "Transitional", "Deltaic", "Fringe",              "Outer",         "",                 ".X............" },

    { "Transitional", "Deltaic", "Prodelta",            "",              "",                 ".X............" },
    { "Transitional", "Deltaic", "Prodelta",            "Proximal",      "",                 ".X............" },
    { "Transitional", "Deltaic", "Prodelta",            "Distal",        "",                 ".X............" },

    { "Transitional", "Coastal Interdeltaic", "",               "",                 "",              ".X............" },
    { "Transitional", "Coastal Interdeltaic", "Coastal Plain",  "",                 "",              ".X............" },
    { "Transitional", "Coastal Interdeltaic", "Coastal Plain",  "Barrier Islands",  "",              ".X............" },
    { "Transitional", "Coastal Interdeltaic", "Coastal Plain",  "Barrier Islands",  "Back Bar",      ".X............" },
    { "Transitional", "Coastal Interdeltaic", "Coastal Plain",  "Barrier Islands",  "Barrier",       ".X............" },
    { "Transitional", "Coastal Interdeltaic", "Coastal Plain",  "Barrier Islands",  "Beach",         ".X............" },
    { "Transitional", "Coastal Interdeltaic", "Coastal Plain",  "Barrier Islands",  "Barrier Face",  ".X............" },
    { "Transitional", "Coastal Interdeltaic", "Coastal Plain",  "Barrier Islands",  "Spits & Flats", ".X............" },
    { "Transitional", "Coastal Interdeltaic", "Coastal Plain",  "Barrier Islands",  "Washover Fans", ".X............" },

    { "Transitional", "Coastal Interdeltaic", "Coastal Plain",  "Chenier Plains",   "",              ".X............" },
    { "Transitional", "Coastal Interdeltaic", "Coastal Plain",  "Chenier Plains",   "Beach & Ridges",".X............" },
    { "Transitional", "Coastal Interdeltaic", "Coastal Plain",  "Chenier Plains",   "Back Shore",    ".X............" },
    { "Transitional", "Coastal Interdeltaic", "Coastal Plain",  "Chenier Plains",   "Fore Shore",    ".X............" },
    { "Transitional", "Coastal Interdeltaic", "Coastal Plain",  "Chenier Plains",   "Tidal Flats",   ".X............" },

    { "Transitional", "Coastal Interdeltaic", "Coastal Plain",  "Tidal",            "",              ".X............" },
    { "Transitional", "Coastal Interdeltaic", "Coastal Plain",  "Tidal",            "Tidal Flats",   ".X............" },
    { "Transitional", "Coastal Interdeltaic", "Coastal Plain",  "Tidal",            "Tidal Deltas",  ".X............" },
    { "Transitional", "Coastal Interdeltaic", "Coastal Plain",  "Tidal",            "Supratidal",    ".X............" },
    { "Transitional", "Coastal Interdeltaic", "Coastal Plain",  "Tidal",            "Sabhka",        ".X............" },

    { "Transitional", "Coastal Interdeltaic", "Subaqueous",     "",                 "",               "..XX.........." },
    { "Transitional", "Coastal Interdeltaic", "Subaqueous",     "Swamp",            "",               "..XX.........." },
    { "Transitional", "Coastal Interdeltaic", "Subaqueous",     "Swamp",            "Fresh Water",    "..X..........." },
    { "Transitional", "Coastal Interdeltaic", "Subaqueous",     "Swamp",            "Brackish Water", "...X.........." },
    { "Transitional", "Coastal Interdeltaic", "Subaqueous",     "Lagoons",          "",               "..XX.........." },
    { "Transitional", "Coastal Interdeltaic", "Subaqueous",     "Lagoons",          "Fresh Water",    "..X..........." },
    { "Transitional", "Coastal Interdeltaic", "Subaqueous",     "Lagoons",          "Brackish Water", "...X.........." },
    { "Transitional", "Coastal Interdeltaic", "Subaqueous",     "Lagoons",          "Shoals",         ".X............" },
    { "Transitional", "Coastal Interdeltaic", "Subaqueous",     "Tidal Channels",   "",               ".X............" },
    { "Transitional", "Coastal Interdeltaic", "Subaqueous",     "Estuaries",        "",               "..XX.........." },
    { "Transitional", "Coastal Interdeltaic", "Subaqueous",     "Estuaries",        "Fresh Water",    "..X..........." },
    { "Transitional", "Coastal Interdeltaic", "Subaqueous",     "Estuaries",        "Brackish Water", "...X.........." },
    { "Transitional", "Coastal Interdeltaic", "Subaqueous",     "Estuaries",        "Tidal",          "...X.........." },
    { "Transitional", "Coastal Interdeltaic", "Subaqueous",     "Estuaries",        "Fluvial",        ".X............" },
    { "Transitional", "Coastal Interdeltaic", "Subaqueous",     "Estuaries",        "Bay-head delta", ".X............" },
    { "Transitional", "Coastal Interdeltaic", "Subaqueous",     "Estuaries",        "Central Basin",  ".X............" },
    { "Transitional", "Coastal Interdeltaic", "Subaqueous",     "Estuaries",        "Marine Sand Plug", ".X............" },
    { "Transitional", "Coastal Interdeltaic", "Subaqueous",     "Salt Marsh",       "",               "...X.........." },

    { "Marine",       "Shallow Marine",       "",               "",                 "",                     ".....XXX......" },
    { "Marine",       "Shallow Marine",       "Inner Neritic",  "",                 "",                     ".....XXX......" },
    { "Marine",       "Shallow Marine",       "Inner Neritic",  "Tidal",            "Intertidal",           ".....X........" },
    { "Marine",       "Shallow Marine",       "Inner Neritic",  "Tidal",            "High Tide",            ".....X........" },
    { "Marine",       "Shallow Marine",       "Inner Neritic",  "Tidal",            "Low Tide",             ".....X........" },

    { "Marine",       "Shallow Marine",       "Inner Neritic",  "Shoreface",        "",                     ".....X........" },
    { "Marine",       "Shallow Marine",       "Inner Neritic",  "Shoreface",        "Upper Shoreface",      ".....X........" },
    { "Marine",       "Shallow Marine",       "Inner Neritic",  "Shoreface",        "Lower Shoreface",      ".....X........" },

    { "Marine",       "Shallow Marine",       "Inner Neritic",  "Nearshore",        "",                     ".....XX......." },
    { "Marine",       "Shallow Marine",       "Inner Neritic",  "Nearshore",        "Fairweather Wavebase", "......X......." },

    { "Marine",       "Shallow Marine",       "Inner Neritic",  "Offshore",         "",                     ".......X......" },
    { "Marine",       "Shallow Marine",       "Inner Neritic",  "Offshore",         "Offshore-Transition",  "......X......." },
    { "Marine",       "Shallow Marine",       "Inner Neritic",  "Offshore",         "Storm wavebase",       ".......X......" },

    { "Marine",       "Shallow Marine",       "Inner Neritic",  "Reefs/Mounds",     "",                     ".....XXX......" },
    { "Marine",       "Shallow Marine",       "Inner Neritic",  "Reefs/Mounds",     "Reef Flat",            ".....X........" },
    { "Marine",       "Shallow Marine",       "Inner Neritic",  "Reefs/Mounds",     "Back Reef",            ".....XX......." },
    { "Marine",       "Shallow Marine",       "Inner Neritic",  "Reefs/Mounds",     "Reef Bench",           "......X......." },
    { "Marine",       "Shallow Marine",       "Inner Neritic",  "Reefs/Mounds",     "Fore Reef",            "......XX......" },
    { "Marine",       "Shallow Marine",       "Inner Neritic",  "Reefs/Mounds",     "Reef Slope",           ".......X......" },
    { "Marine",       "Shallow Marine",       "Inner Neritic",  "Reefs/Mounds",     "Deep Fore Reef",       ".......XX....." },

    { "Marine",       "Middle Marine",        "",               "",                 "",                     "........XX...." },
    { "Marine",       "Middle Marine",        "Middle Neritic", "",                 "",                     "........X....." },
    { "Marine",       "Middle Marine",        "Middle Neritic", "Slopes",           "",                     "........X....." },
    { "Marine",       "Middle Marine",        "Middle Neritic", "Slopes",           "Upper Slope",          "........X....." },
    { "Marine",       "Middle Marine",        "Middle Neritic", "Slopes",           "Lower Slope",          "........X....." },
    { "Marine",       "Middle Marine",        "Middle Neritic", "Slopes",           "Gravity Slide",        "........X....." },
    { "Marine",       "Middle Marine",        "Middle Neritic", "Slopes",           "Debris Flow",          "........X....." },

    { "Marine",       "Middle Marine",        "Middle Neritic", "Fans",             "",                     "........X....." },
    { "Marine",       "Middle Marine",        "Middle Neritic", "Fans",             "Submarine Fan",        "........X....." },

    { "Marine",       "Middle Marine",        "Outer Neritic",  "",                 "",                     ".........X...." },
    { "Marine",       "Middle Marine",        "Outer Neritic",  "Slopes",           "",                     ".........X...." },
    { "Marine",       "Middle Marine",        "Outer Neritic",  "Slopes",           "Upper Slope",          ".........X...." },
    { "Marine",       "Middle Marine",        "Outer Neritic",  "Slopes",           "Lower Slope",          ".........X...." },
    { "Marine",       "Middle Marine",        "Outer Neritic",  "Slopes",           "Gravity Slide",        ".........X...." },
    { "Marine",       "Middle Marine",        "Outer Neritic",  "Slopes",           "Debris Flow",          ".........X...." },

    { "Marine",       "Middle Marine",        "Outer Neritic",  "Fans",             "",                     ".........X...." },
    { "Marine",       "Middle Marine",        "Outer Neritic",  "Fans",             "Submarine Fan",        ".........X...." },


    { "Marine",       "Deep Marine",          "",               "",                 "",                     "..........XXXX" },
    { "Marine",       "Deep Marine",          "Upper Bathyal",  "",                 "",                     "..........X..." },
    { "Marine",       "Deep Marine",          "Upper Bathyal",  "Slopes",           "",                     "..........X..." },
    { "Marine",       "Deep Marine",          "Upper Bathyal",  "Slopes",           "Upper Slope",          "..........X..." },
    { "Marine",       "Deep Marine",          "Upper Bathyal",  "Slopes",           "Lower Slope",          "..........X..." },
    { "Marine",       "Deep Marine",          "Upper Bathyal",  "Slopes",           "Gravity Slide",        "..........X..." },
    { "Marine",       "Deep Marine",          "Upper Bathyal",  "Slopes",           "Debris Flow",          "..........X..." },

    { "Marine",       "Deep Marine",          "Upper Bathyal",  "Fans",             "",                     "..........X..." },
    { "Marine",       "Deep Marine",          "Upper Bathyal",  "Fans",             "Submarine Fan",        "..........X..." },

    { "Marine",       "Deep Marine",          "Upper Bathyal",  "Turbidite",        "",                     "..........X..." },
    { "Marine",       "Deep Marine",          "Upper Bathyal",  "Basin Plain",      "",                     "..........X..." },
    { "Marine",       "Deep Marine",          "Upper Bathyal",  "Seamount",         "",                     "..........X..." },

    { "Marine",       "Deep Marine",          "Middle Bathyal", "",                 "",                     "...........X.." },
    { "Marine",       "Deep Marine",          "Middle Bathyal", "Slopes",           "",                     "...........X.." },
    { "Marine",       "Deep Marine",          "Middle Bathyal", "Slopes",           "Upper Slope",          "...........X.." },
    { "Marine",       "Deep Marine",          "Middle Bathyal", "Slopes",           "Lower Slope",          "...........X.." },
    { "Marine",       "Deep Marine",          "Middle Bathyal", "Slopes",           "Gravity Slide",        "...........X.." },
    { "Marine",       "Deep Marine",          "Middle Bathyal", "Slopes",           "Debris Flow",          "...........X.." },

    { "Marine",       "Deep Marine",          "Middle Bathyal", "Fans",             "",                     "...........X.." },
    { "Marine",       "Deep Marine",          "Middle Bathyal", "Fans",             "Submarine Fan",        "...........X.." },

    { "Marine",       "Deep Marine",          "Middle Bathyal", "Turbidite",        "",                     "...........X.." },
    { "Marine",       "Deep Marine",          "Middle Bathyal", "Basin Plain",      "",                     "...........X.." },
    { "Marine",       "Deep Marine",          "Middle Bathyal", "Seamount",         "",                     "...........X.." },

    { "Marine",       "Deep Marine",          "Lower Bathyal",  "",                 "",                     "............X." },
    { "Marine",       "Deep Marine",          "Lower Bathyal",  "Slopes",           "",                     "............X." },
    { "Marine",       "Deep Marine",          "Lower Bathyal",  "Slopes",           "Upper Slope",          "............X." },
    { "Marine",       "Deep Marine",          "Lower Bathyal",  "Slopes",           "Lower Slope",          "............X." },
    { "Marine",       "Deep Marine",          "Lower Bathyal",  "Slopes",           "Gravity Slide",        "............X." },
    { "Marine",       "Deep Marine",          "Lower Bathyal",  "Slopes",           "Debris Flow",          "............X." },

    { "Marine",       "Deep Marine",          "Lower Bathyal",  "Fans",             "",                     "............X." },
    { "Marine",       "Deep Marine",          "Lower Bathyal",  "Fans",             "Submarine Fan",        "............X." },

    { "Marine",       "Deep Marine",          "Lower Bathyal",  "Turbidite",        "",                     "............X." },
    { "Marine",       "Deep Marine",          "Lower Bathyal",  "Basin Plain",      "",                     "............X." },
    { "Marine",       "Deep Marine",          "Lower Bathyal",  "Seamount",         "",                     "............X." },


    { "Marine",       "Deep Marine",          "Abyssal",        "",                 "",                     ".............X" },
    { "Marine",       "Deep Marine",          "Abyssal",        "Slopes",           "",                     ".............X" },
    { "Marine",       "Deep Marine",          "Abyssal",        "Slopes",           "Upper Slope",          ".............X" },
    { "Marine",       "Deep Marine",          "Abyssal",        "Slopes",           "Lower Slope",          ".............X" },
    { "Marine",       "Deep Marine",          "Abyssal",        "Slopes",           "Gravity Slide",        ".............X" },
    { "Marine",       "Deep Marine",          "Abyssal",        "Slopes",           "Debris Flow",          ".............X" },

    { "Marine",       "Deep Marine",          "Abyssal",        "Fans",             "",                     ".............X" },
    { "Marine",       "Deep Marine",          "Abyssal",        "Fans",             "Submarine Fan",        ".............X" },

    { "Marine",       "Deep Marine",          "Abyssal",        "Turbidite",        "",                     ".............X" },
    { "Marine",       "Deep Marine",          "Abyssal",        "Basin Plain",      "",                     ".............X" },
    { "Marine",       "Deep Marine",          "Abyssal",        "Seamount",         "",                     ".............X" },
  };

}

/*
 *  @version X.X 01/11/2012
 *  @author  John Victorine
 */
