/*
 * @envListStruct.java Version 1.1 11/02/2011
 *
 * Copyright (c) 2011 Kansas Geological Survey
 * 1930 Constant Avenue, Lawrence, Kansas, 66047, U.S.A.
 * All Rights Reserved.
 */

package horizon.env;

import horizon.env.envStruct;

/** CLASS envListStruct
 *  <p> This Structure holds a list of Depositional Environment Structures.
 *
 *  @version 1.1 11/02/2011
 *  @author  John R. Victorine
 */

public class envListStruct
{
  public int    iSource    = las3.las3Constants._SOURCE_NONE;

  // Stratigraphic Headers Data Information

  public String sKID       = "0";  // Primary Key of the Well
  public String sKEY       = "";   // Primary Key created on user's PC
  public int    iType      = iqstrat.iqstratHeadersStruct.WELL; // Type of Data
  public String sAPI       = "";   // API-Number OR UWI
  public String sName      = "";   // Well Name or Outcrop Name
  public String status     = iqstrat.iqstratStatusStruct.STATUS[0][0]; // Status
  public double dLatitude  = 0.0;  // Latitude of Location
  public double dLongitude = 0.0;  // Longitude of Location
  public double depth      = 0.0;  // Total Depth of Well or Height of Outcrop
  public double dGL        = 0.0;  // Ground Level

  // LAS 3 Dependent Variable

  public String sKGS       = "YES"; // KGS Saved Data Indicator
  public String source     = "";    // Source of Data
  public String sReference = "";    // Depth Reference

  // Regions Data

  public int       iCount   = 0;     // Total Number of Records
  public envStruct stItem[] = null;  // Array of Depositional Environment Structures

  /** Method delete()
   * <p> This method will force set the Objects to null and force Java to
   *     free unwanted memory
   */

  public void delete()
  {
    sKID       = null; // Primary Key of the Well
    sKEY       = null; // Primary Key created on user's PC
    sAPI       = null; // API-Number OR UWI
    sName      = null; // Well Name or Outcrop Name
    status     = null; // Status

    sKGS       = null; // KGS Saved Data Indicator
    source     = null;    // Source of Data
    sReference = null;    // Created Date

    for (int i=0; i<iCount; i++)
    {
      if (stItem[i] != null)
        stItem[i].delete();
      stItem[i] = null;
    }

    iCount = 0;
  }
}

/*
 *  @version 1.1 11/02/2011
 *  @author  John Victorine
 */
