/*
 * @bioFossilsTable.java Version 1.1 11/18/2011
 *
 * Copyright (c) 2011 Kansas Geological Survey
 * 1930 Constant Avenue, Lawrence, Kansas, 66047, U.S.A.
 * All Rights Reserved.
 */

package horizon.bio.gui;

import java.awt.*;
import java.lang.*;
import javax.swing.*;
import javax.swing.table.*;

import gui.guiTable;

import mask.maskSymbolsListStruct;
import mask.maskSymbolsStruct;

/** Class bioFossilsTable
 *  <p> This Class will display the Lookup General Fossils List.
 *
 *  @version 1.1 11/18/2011
 *  @author  John R. Victorine
 */

public class bioFossilsTable
{
  private int      iRows     = 0;
  private int      iColumns  = 2;
  private String   sColumn[] = {"ID", "General Fossil"};
  private Object   oData[][] = null;
  private guiTable pTable    = null;

  private maskSymbolsListStruct st      = null; // Fossil
  private int                   iChange = 0;

  /** Constructor bioFossilsTable()
   *  <p> This is the Constructor for this class.
   */

  public bioFossilsTable()
  {
    pTable = new guiTable(0, iColumns, sColumn);

    pTable.resizeColumn(0, 15);
  }

  /** Constructor bioFossilsTable()
   *  <p> This is the Constructor for this class.
   * @param st     = The Bio Stratigraphy List Data Structure
   */

  public bioFossilsTable(maskSymbolsListStruct st)
  {
    this.st = st;

    populateList();

    if (iRows > 0)
      pTable = new guiTable(0, iRows, iColumns, sColumn, oData);
    else
      pTable = new guiTable(0, iColumns, sColumn);

    pTable.resizeColumn(0, 15);

    if (iChange == 0)
      iRows = 0;

    if (iRows > 0)
      pTable.setSelectedRow(0);
  }

  /** Method close()
   * <p> This method will cancel the Rock Color Dialog
   */

  public void close()
  {
    sColumn    = null;
    oData      = null;
    pTable     = null;
    st         = null;
  }

  /* ===================================================================== *
   * -------------------------- SET METHODS ------------------------------ *
   * ===================================================================== */

  /** Method populateList()
   *  <p> This method will populate the Bio Stratigraphy List data structure.
   */

  private void populateList()
  {
    int i      = 0;
    int iCount = 0;

    iChange = 0;
    iRows   = 1;

    oData = new String[1][iColumns];
    for (i=0; i<iColumns; i++)
    {
      oData[0][i] = new String("");
    }

    if (st != null)
    {
      if (st.iCount > 0)
      {
        iChange = 1;
        oData   = new Object[st.iCount][iColumns];
        iCount  = 0;
      }

      for (i=0; i<st.iCount; i++)
      {
        oData[iCount][0] = new String(st.stItem[i].sID);
        oData[iCount][1] = new String(st.stItem[i].sName);

        iCount++;
      }

      iRows = iCount;
    }
  }

  /** Method setData()
   *  <p> This method will reload the Bio Stratigraphy List Data Structure
   * @param st  = The Bio Stratigraphy List Data Structure
   */

  public void setData(maskSymbolsListStruct st)
  {
    this.st = st;

    populateList();

    pTable.reload(iRows, oData);

    if (iChange == 0)
      iRows = 0;

    if (iRows > 0)
      pTable.setSelectedRow(0);
  }

  /* ===================================================================== *
   * -------------------------- GET METHODS ------------------------------ *
   * ===================================================================== */

  /** Method getTotalRows()
   *  <p> This method will return the total rows in the table.
   *  @return Total Number of Rows.
   */

  public int getTotalRows() { return (iRows); }

  /** Method getRow()
   *  <p> This method will return the selected data id in the table.
   *  @return selected data id.
   */

  public int getRow() { return (pTable.getSelectedRow()); }

  /** Method getRowData()
   *  <p> This method will return the Bio Stratigraphy Data Structure of the
   *      selected row.
   *  @return stData = Bio Stratigraphy Data Structure.
   */

  public maskSymbolsStruct getRowData() { return (st.stItem[pTable.getSelectedRow()]); }

  /** Method getData()
   *  <p> This method will returns the Bio Stratigraphy List Data Structure.
   *  @return st = Bio Stratigraphy List Data Structure.
   */

  public maskSymbolsListStruct getData() { return (st); }

  /** Method getScrollPane()
   *  <p> This method will return the scroll pane.
   *  @return jScrollPane - Scroll Pane containing the Table.
   */

  public JScrollPane getScrollPane() { return (pTable.getScrollPane()); }
}

/*
 *  @version 1.1 11/18/2011
 *  @author  John Victorine
 */
