/*
 * @bioFossilsFrame.java Version 1.1 11/18/2011
 *
 * Copyright (c) 2011 Kansas Geological Survey
 * 1930 Constant Avenue, Lawrence, Kansas, 66047, U.S.A.
 * All Rights Reserved.
 */

package horizon.bio.gui;

import java.awt.*;
import java.awt.event.*;
import java.util.Observable;
import javax.swing.*;
import javax.swing.event.*;

import horizon.bio.gui.bioFossilsTable;
import mask.maskSymbolsListStruct;

/** Class bioFossilsFrame
 *  <p> This Class will allow the user to select the status of the data
 *
 *  @version 1.1 11/18/2011
 *  @author  John R. Victorine
 */

public class bioFossilsFrame extends JFrame implements ActionListener
{
  private Observable      notifier = null;  // Observable notifier
  private maskSymbolsListStruct st = null;  // General Fossil Symbols List Structure
  private bioFossilsTable pTable   = null;  // General Fossils Table

  private String sID   = "";
  private String sName = "";

  private JButton btnSelect = new JButton();
  private JButton btnCancel = new JButton();

  /** Constructor bioFossilsFrame()
   *  <p> This is the Constructor for this class.
   *  @param notifier = Observable notifier
   *  @param st       = Fossil Symbols List Structure
   */

  public bioFossilsFrame(Observable notifier, maskSymbolsListStruct st )
  {
    try
    {
      this.notifier = notifier;
      this.st       = st;

      jbInit();
    }
    catch(Exception e)
    {
      e.printStackTrace();
    }
  }

  /** METHOD jbInit()
   *  <p> This Method will create the Frame for this class.
   *  @throws Exception
   */

  private void jbInit() throws Exception
  {
    JPanel pnlButtons  = new JPanel();
    JPanel pnl         = new JPanel();
    JScrollPane scroll = new JScrollPane();

    this.setTitle("Select a General Fossil Group");
    this.getContentPane().setLayout(new BorderLayout());

    pnlButtons.setBorder(BorderFactory.createEtchedBorder());

    btnSelect.setFont(new java.awt.Font("Dialog", 1, 11));
    btnSelect.setText("Select");
    btnSelect.addActionListener(this);

    btnCancel.setFont(new java.awt.Font("Dialog", 1, 11));
    btnCancel.setText("Cancel");
    btnCancel.addActionListener(this);

    pnl.setLayout(new BorderLayout());

    pTable = new bioFossilsTable(st);
    scroll = pTable.getScrollPane();

    // Attach Widgets to frame

    this.getContentPane().add(pnlButtons, BorderLayout.SOUTH);
    pnlButtons.add(btnSelect,      null);
    pnlButtons.add(btnCancel,      null);

    this.getContentPane().add(pnl, BorderLayout.CENTER);
    pnl.add(scroll,                BorderLayout.CENTER);

    // Display the Frame

    Dimension d = Toolkit.getDefaultToolkit().getScreenSize();
    this.setSize(new Dimension(400, d.height-50)); //750));
    this.setLocation((d.width - this.getSize().width) / 2, 10);
//                     (d.height - this.getSize().height) / 2);

    this.setResizable(false);
    this.setVisible(true);
  }

  /* ===================================================================== *
   * -------------------------- GET METHODS ------------------------------ *
   * ===================================================================== */

  /** Method getID()
   * <p> This method will return the Fossil Group ID
   * @return sID = the Fossil Group ID
   */

  public String getID() { return (sID); }

  /** Method getName()
   * <p> This method will return the Fossil Group Name
   * @return sName = the Fossil Group Name
   */

  public String getName() { return (sName); }

  /* ===================================================================== *
   * ---------------------------- ACTIONS -------------------------------- *
   * ===================================================================== */

  /** Method select()
   * <p> This method will close this dialog and all other dialogs opened by
   *     this dialog
   */

  private void select()
  {
	int iRow = -1;

	if (st != null)
	{
	  iRow  = pTable.getRow();
	  sID   = new String( st.stItem[iRow].sID );
	  sName = new String( st.stItem[iRow].sName );
	}

    notifier.notifyObservers(new String("Fossil Selected"));
  }

  /** Method close()
   * <p> This method will close this dialog and all other dialogs opened by
   *     this dialog
   */

  public void close()
  {
    notifier  = null;
    st        = null;
    pTable    = null;
    sID       = null;
    sName     = null;
    btnSelect = null;
    btnCancel = null;

    dispose();
  }

  /** METHOD actionPerformed()
   *  <p> This Method will handle all the actions within the Frame.
   *  @param event - Action Event
   */

  public void actionPerformed(ActionEvent event)
  {
    if (event.getSource() == btnSelect) { select(); }
    if (event.getSource() == btnCancel) { close(); }
  }
}

/*
 *  @version 1.1 11/18/2011
 *  @author  John Victorine
 */
