/*
 * @bioDepthTable.java Version 1.1 11/16/2011
 *
 * Copyright (c) 2011 Kansas Geological Survey
 * 1930 Constant Avenue, Lawrence, Kansas, 66047, U.S.A.
 * All Rights Reserved.
 */

package horizon.bio.gui;

import java.awt.*;
import java.lang.*;
import javax.swing.*;
import javax.swing.table.*;

import gui.guiTable;

import horizon.bio.bioStratStruct;

/** Class bioDepthTable
 *  <p> This Class will display the Formation Tops.
 *
 *  @version 1.1 11/16/2011
 *  @author  John R. Victorine
 */

public class bioDepthTable
{
  private int      iRows     = 0;
  private int      iColumns  = 3;
  private String   sColumn[] = {"Start", "End", "Abundance"};
  private Object   oData[][] = null;
  private guiTable pTable    = null;

  private bioStratStruct st      = null;
  private int            iChange = 0;

  /** Constructor bioDepthTable()
   *  <p> This is the Constructor for this class.
   */

  public bioDepthTable()
  {
    pTable = new guiTable(0, iColumns, sColumn);
  }

  /** Constructor bioDepthTable()
   *  <p> This is the Constructor for this class.
   * @param st = Bio Stratigraphy Data Structure
   */

  public bioDepthTable(bioStratStruct st)
  {
    this.st = st;

    populateList();

    if (iRows > 0)
      pTable = new guiTable(0, iRows, iColumns, sColumn, oData);
    else
      pTable = new guiTable(0, iColumns, sColumn);

    if (iChange == 0)
      iRows = 0;

    if (iRows > 0)
      pTable.setSelectedRow(0);
  }

  /** Method close()
   * <p> This method will force Java to clear memory
   */

  public void close()
  {
    sColumn    = null;
    oData      = null;
    pTable     = null;
    st         = null;
  }

  /* ===================================================================== *
   * -------------------------- SET METHODS ------------------------------ *
   * ===================================================================== */

  /** Method populateList()
   *  <p> This method will populate the Region List data.
   */

  private void populateList()
  {
    int i      = 0;
    int iCount = 0;

    iChange = 0;
    iRows   = 1;

    oData = new String[1][iColumns];
    for (i=0; i<iColumns; i++)
    {
      oData[0][i] = new String("");
    }

    if (st != null)
    {
      if (st.iRows > 0)
      {
        iChange = 1;
        oData   = new Object[st.iRows][iColumns];
        iCount  = 0;
      }

      for (i=0; i<st.iRows; i++)
      {
        oData[iCount][0] = new Double(st.depthStart[i]);
        oData[iCount][1] = new Double(st.depthEnd[i]);
        oData[iCount][2] = new String(
			horizon.bio.bioStratStruct.sAbundance[st.iAbundance[i]]);

        iCount++;
      }

      iRows = iCount;
    }
  }

  /** Method setData()
   *  <p> This method will reload the Bio Stratigraphy Data Structure
   * @param st = The Bio Stratigraphy Data Structure
   */

  public void setData(bioStratStruct st)
  {
    this.st = st;

    populateList();

    pTable.reload(iRows, oData);

    if (iChange == 0)
      iRows = 0;

    if (iRows > 0)
      pTable.setSelectedRow(0);
  }

  /* ===================================================================== *
   * -------------------------- GET METHODS ------------------------------ *
   * ===================================================================== */

  /** Method getTotalRows()
   *  <p> This method will return the total rows in the table.
   *  @return Total Number of Rows.
   */

  public int getTotalRows() { return (iRows); }

  /** Method getRow()
   *  <p> This method will return the selected data id in the table.
   *  @return selected data id.
   */

  public int getRow() { return (pTable.getSelectedRow()); }

  /** Method getData()
   *  <p> This method will returns the Bio Stratigraphy Data Structure.
   *  @return st = Bio Stratigraphy Data Structure.
   */

  public bioStratStruct getData() { return (st); }

  /** Method getScrollPane()
   *  <p> This method will return the scroll pane.
   *  @return jScrollPane - Scroll Pane containing the Table.
   */

  public JScrollPane getScrollPane() { return (pTable.getScrollPane()); }
}

/*
 *  @version 1.1 11/16/2011
 *  @author  John Victorine
 */
