/*
 * @bioStratStruct.java Version 1.1 11/05/2011
 *
 * Copyright (c) 2011 Kansas Geological Survey
 * 1930 Constant Avenue, Lawrence, Kansas, 66047, U.S.A.
 * All Rights Reserved.
 */

package horizon.bio;

/** Class bioStratStruct
 *  <p> This Class holds the Fossil genera Data.
 *
 *  @version 1.1 11/05/2011
 *  @author  John R. Victorine
 */

public class bioStratStruct
{
  // No Fossils
  public static final int _NONE     = 0;
  // (s) Sparse. Applies to fossils very poorly represented in the rock.
  public static final int _SPARSE   = 1;
  // No modifier the fossils are represented in the rock.
  public static final int _PRESENT  = 2;
  // (c) Common. Refers to fossils that are numerous but not abundant
  //         enough to be immediately conspicuous in the sample.
  public static final int _COMMON   = 3;
  // (a) Abundant. Refers to fossils that are numerous enough to be readily
  //               seen either on an etched surface or in a washed sample.
  public static final int _ABUNDANT = 4;
  // (p) Profuse. Applies to fossils that are a major constituent of the rock.
  public static final int _PROFUSE  = 5;

  public static final String sAbundance[] = {
	  "none", "sparse", "present", "common", "abundant", "profuse"
  };
  public static final int _PIXELS[] = { 0, 3, 5, 7, 9, 11 };

  // Unique Fossil Entry

  public String sKID         = "0";   // Not Used
  public String sKEY         = "0";   // Unique Identifier for Entry

  public String sName        = "";    // Name (Genus species) Name of Fossil
  public int    iRows        = 0;     // Total number of depth ranges for species
  public String sKEYa[]      = null;  // Array of Unique Key for each Depth Sample
  public int    iAbundance[] = null;  // Array of Abundance indicators
  public double depthStart[] = null;  // Array of Starting Depths
  public double depthEnd[]   = null;  // Array if Ending Depths

  // Fossil Scientific Name

  public String species      = "";    // Species

  public String sGenus       = "";    // Genus
  public String sTribe       = "";    // Tribe

  public String subfamily    = "";    // Sub family
  public String sFamily      = "";    // Family
  public String superfamily  = "";    // Super family

  public String sInfraorder  = "";    // Infra Order
  public String suborder     = "";    // Sub Order
  public String sOrder       = "";    // Order
  public String superorder   = "";    // Super Order

  public String subclass     = "";    // Class
  public String sClass       = "";    // Sub Class
  public String superclass   = "";    // Super Class

  public String subphylum    = "";    // Sub Phylum
  public String sPhylum      = "";    // Phylum
  public String superphylum  = "";    // Super Phylum

  public String subkingdom   = "";    // Sub Kingdom
  public String sKingdom     = "";    // Kingdom

  public String sAuthor      = "";    // Author Credited

  // Generic Rock Fossil Identifier

  public String sFossilID    = "10.2.1";       // Fossil identifier
  public String sFossil      = "macrofossils"; // Generic Fossil Name,
                                               //  i.e. Crinoids, Brachiopods, etc.

  // Stratigraphic Unit Range
  // The fossil book that was used only gives the range of time for a fossil
  // in terms of system/series combination, i.e. upper mississippian.  The
  // earliest stands for the most recent and the latest represents futher back
  // in time, e.g. Mississippian through the Permian, the earlest is the Permian
  // and the latest is the Mississippian.

  // -- Earliest geological time

  public double dFrom        = 0.0; // From Age in Ma
  public String sKey_e       = "";  // Stratigraphic Unit Unique KEY
  public String system_e     = "";  // System Stratigraphic Unit Names
  public String series_e     = "";  // Series Stratigraphic Unit Names
  public String subSystem_e  = "";  // Substage Stratigraphic Unit Names
  public String subSeries_e  = "";  // Subseries Stratigraphic Unit Names

  // -- Latest geological time

  public double dTo          = 0.0; // To Age in Ma
  public String sKey_l       = "";  // Stratigraphic Unit Unique KEY
  public String system_l     = "";  // System Stratigraphic Unit Names
  public String series_l     = "";  // Series Stratigraphic Unit Names
  public String subSystem_l  = "";  // Substage Stratigraphic Unit Names
  public String subSeries_l  = "";  // Subseries Stratigraphic Unit Names

  /** Method delete()
   * <p> This method will set the arrays to null in order to get Java to
   *     deallocate memory for the object.
   */

  public void delete()
  {
	sKID        = null;
    sKEY        = null;
    sName       = null;

    sKEYa       = null;
    iAbundance  = null;
    depthStart  = null;
    depthEnd    = null;

    // Fossil Scientific Name

    species     = null;
    sGenus      = null;
    sTribe      = null;
    subfamily   = null;
    sFamily     = null;
    superfamily = null;
    sInfraorder = null;
    suborder    = null;
    sOrder      = null;
    superorder  = null;
    subclass    = null;
    sClass      = null;
    superclass  = null;
    subphylum   = null;
    sPhylum     = null;
    superphylum = null;
    subkingdom  = null;
    sKingdom    = null;
    sAuthor     = null;

    // Generic Rock Fossil Identifier

    sFossilID   = null;
    sFossil     = null;

    // Stratigraphic Unit Range
    // The fossil book that was used only gives the range of time for a fossil
    // in terms of system/series combination, i.e. upper mississippian.  The
    // earliest stands for the most recent and the latest represents futher back
    // in time, e.g. Mississippian through the Permian, the earlest is the Permian
    // and the latest is the Mississippian.

    // -- Earliest geological time

    sKey_e      = null;  // Stratigraphic Unit Unique KEY
    system_e    = null;  // System Stratigraphic Unit Names
    series_e    = null;  // Series Stratigraphic Unit Names
    subSystem_e = null;  // Substage Stratigraphic Unit Names
    subSeries_e = null;  // Subseries Stratigraphic Unit Names

    // -- Latest geological time

    sKey_l      = null;  // Stratigraphic Unit Unique KEY
    system_l    = null;  // System Stratigraphic Unit Names
    series_l    = null;  // Series Stratigraphic Unit Names
    subSystem_l = null;  // Substage Stratigraphic Unit Names
    subSeries_l = null;  // Subseries Stratigraphic Unit Names
  }
}

/*
 *  @version 1.1 11/05/2011
 *  @author  John Victorine
 */
