/*
 * @bioStratListStruct.java Version 1.1 11/05/2011
 *
 * Copyright (c) 2011 Kansas Geological Survey
 * 1930 Constant Avenue, Lawrence, Kansas, 66047, U.S.A.
 * All Rights Reserved.
 */

package horizon.bio;

import horizon.bio.bioStratStruct;

/** Class bioStratListStruct
 *  <p> This Class holds the Fossil genera List Data.
 *
 *  @version 1.1 11/05/2011
 *  @author  John R. Victorine
 */

public class bioStratListStruct
{
  public int    iSource    = las3.las3Constants._SOURCE_NONE;

  // LAS 3 Dependent Variable

  public String sKGS       = "YES"; // KGS Saved Data Indicator
  public String source     = "";    // Source of Data
  public String sReference = "";    // Depth Reference

  // List of Fossil Genera

  public int            iCount   = 0;    // Total Number of Records
  public bioStratStruct stItem[] = null; // Fossil genera Records


  /** Method delete()
   * <p> This method will set the arrays to null in order to get Java to
   *     deallocate memory for the object.
   */

  public void delete()
  {
    sKGS       = null; // KGS Saved Data Indicator
    source     = null; // Source of Data
    sReference = null; // Depth Reference

    for (int i=0; i<iCount; i++)
    {
      if (stItem[i] != null)
        stItem[i].delete();
      stItem[i] = null;
    }

    iCount = 0;
  }
}

/*
 *  @version 1.1 11/05/2011
 *  @author  John Victorine
 */
