/*
 * @guiTable.java Version 1.1 06/15/2001
 *
 * Copyright (c) John R. Victorine
 * All Rights Reserved.
 */

package gui;

import java.awt.*;
import java.awt.event.*;
import java.lang.*;
import javax.swing.*;
import javax.swing.border.*;
import javax.swing.event.*;
import javax.swing.table.*;
import java.util.Observable;

/** Class guiTable
 *  <p> This Class is the base class for all the Tables that are used in Gemini.
 *
 *  @version 1.1 06/15/2001
 *  @author  John R. Victorine
 */

public class guiTable
{
  private String      sMessage        = null;
  private boolean     bEditable       = false;
  private int         iSelect         = -1;
  private int         iEmptyList      = 1;
  private int         iSelectedRow    = 0;
  private int         iSelectedColumn = 0;
  private int         iRows           = 0;
  private int         iColumns        = 0;
  private String      sColumn[]       = null;
  private boolean     bColumn[]       = null;
  private Object      oData[][]       = null;
  private Object      oSelected       = null;
  private TableModel  dataModel       = null;
  private JTable      pTable          = null;
  private JScrollPane pScroll         = null;

  public static final int _SINGLE_SELECTION = 0;
  public  static final int _MULTI_SELECTION = 1;

  private int         iMode           = _SINGLE_SELECTION;
  private int         iSelectedRows[] = null;
  private Observable  notifier        = null; // Observable Object

  /** Constructor guiTable()
   *  <p> This is the Constructor for this class.
   *  @param iSelect  - The Column that will be used for selection
   *  @param iColumns - Total number of Columns
   *  @param sColumn  - Array of Strings
   */

  public guiTable(int iSelect, int iColumns, String sColumn[])
  {
    this.bEditable = false;
    this.iSelect   = iSelect;

    if (iColumns > 0)
    {
      this.iColumns = iColumns;
      this.sColumn  = new String[iColumns];
      this.oData    = new Object[1][iColumns];
      for (int i=0; i<iColumns; i++)
      {
        this.sColumn[i]  = new String(sColumn[i]);
        this.oData[0][i] = new String("");
        this.iEmptyList  = 1;
      }
    }
    else
    {
      sMessage =
         new String("guiTable(): You must have at least one column.");
      JOptionPane.showMessageDialog((Component) null, sMessage,"ERROR",
                                     JOptionPane.ERROR_MESSAGE);
    }

    createTableModel();
  }

  /** Constructor guiTable()
   *  <p> This is the Constructor for this class.
   *  @param bColumn   - Array of Editable Columns
   *  @param iSelect   - The Column that will be used for selection
   *  @param iColumns  - Total number of Columns
   *  @param sColumn   - Array of Strings
   */

  public guiTable(boolean bColumn[],
                  int iSelect,
                  int iColumns,
                  String sColumn[])
  {
    this.bEditable = true;
    this.bColumn   = bColumn;
    this.iSelect   = iSelect;

    if (iColumns > 0)
    {
      this.iColumns = iColumns;
      this.sColumn  = new String[iColumns];
      this.oData    = new Object[1][iColumns];
      for (int i=0; i<iColumns; i++)
      {
        this.sColumn[i]  = new String(sColumn[i]);
        this.oData[0][i] = new String("");
        this.iEmptyList  = 1;
      }
    }
    else
    {
      sMessage =
         new String("guiTable(): You must have at least one column.");
      JOptionPane.showMessageDialog((Component) null, sMessage,"ERROR",
                                     JOptionPane.ERROR_MESSAGE);
    }

    createTableModel();
  }

  /** Constructor guiTable()
   *  <p> This is the Constructor for this class.
   *  @param iSelect   - The Column that will be used for selection
   *  @param iRows     - Total number of Rows;
   *  @param iColumns  - Total number of Columns;
   *  @param sColumn   - Array of Column Strings
   *  @param oData     - Double Array of Data
   */

  public guiTable(int iSelect,
                  int iRows,
                  int iColumns,
                  String sColumn[],
                  Object oData[][])
  {
    this.bEditable = false;
    this.iSelect   = iSelect;

    if (iColumns > 0)
    {
      this.iColumns = iColumns;
      this.sColumn = new String[iColumns];
      for (int i=0; i<iColumns; i++)
        this.sColumn[i]  = new String(sColumn[i]);
    }
    else
    {
      sMessage =
         new String("guiTable(): You must have at least one column.");
      JOptionPane.showMessageDialog((Component) null, sMessage,"ERROR",
                                     JOptionPane.ERROR_MESSAGE);
    }

    if (iRows > 0)
    {
      this.iRows      = iRows;
      this.oData      = oData;
      this.iEmptyList = 0;
    }
    else
    {
      sMessage =
         new String("guiTable(): You must have at least one row.");
      JOptionPane.showMessageDialog((Component) null, sMessage,"ERROR",
                                     JOptionPane.ERROR_MESSAGE);
    }

    createTableModel();
  }

  /** Constructor guiTable()
   *  <p> This is the Constructor for this class.
   *  @param bColumn   - The Gui Table is Editable
   *  @param iSelect   - The Column that will be used for selection
   *  @param iRows     - Total number of Rows;
   *  @param iColumns  - Total number of Columns;
   *  @param sColumn   - Array of Column Strings
   *  @param oData     - Double Array of Data
   */

  public guiTable(boolean bColumn[],
                  int iSelect,
                  int iRows,
                  int iColumns,
                  String sColumn[],
                  Object oData[][])
  {
    this.bEditable = true;
    this.bColumn   = bColumn;
    this.iSelect   = iSelect;

    if (iColumns > 0)
    {
      this.iColumns = iColumns;
      this.sColumn = new String[iColumns];
      for (int i=0; i<iColumns; i++)
        this.sColumn[i]  = new String(sColumn[i]);
    }
    else
    {
      sMessage =
         new String("guiTable(): You must have at least one column.");
      JOptionPane.showMessageDialog((Component) null, sMessage,"ERROR",
                                     JOptionPane.ERROR_MESSAGE);
    }

    if (iRows > 0)
    {
      this.iRows      = iRows;
      this.oData      = oData;
      this.iEmptyList = 0;
    }
    else
    {
      sMessage =
         new String("guiTable(): You must have at least one row.");
      JOptionPane.showMessageDialog((Component) null, sMessage,"ERROR",
                                     JOptionPane.ERROR_MESSAGE);
    }

    createTableModel();
  }

  /** Constructor guiTable()
   *  <p> This is the Constructor for this class.
   *  @param iSelect  - The Column that will be used for selection
   *  @param iColumns - Total number of Columns
   *  @param sColumn  - Array of Strings
   *  @param iMode    - Selection Mode
   */

  public guiTable( int iSelect, int iColumns, String sColumn[], int iMode )
  {
    this.bEditable = false;
    this.iSelect   = iSelect;
    this.iMode     = iMode;

    if (iColumns > 0)
    {
      this.iColumns = iColumns;
      this.sColumn  = new String[iColumns];
      this.oData    = new Object[1][iColumns];
      for (int i=0; i<iColumns; i++)
      {
        this.sColumn[i]  = new String(sColumn[i]);
        this.oData[0][i] = new String("");
        this.iEmptyList  = 1;
      }
    }
    else
    {
      sMessage =
         new String("guiTable(): You must have at least one column.");
      JOptionPane.showMessageDialog((Component) null, sMessage,"ERROR",
                                     JOptionPane.ERROR_MESSAGE);
    }

    createTableModel();
  }

  /** Constructor guiTable()
   *  <p> This is the Constructor for this class.
   *  @param iSelect   - The Column that will be used for selection
   *  @param iRows     - Total number of Rows;
   *  @param iColumns  - Total number of Columns;
   *  @param sColumn   - Array of Column Strings
   *  @param oData     - Double Array of Data
   *  @param iMode     - Selection Mode
   */

  public guiTable( int iSelect,
                   int iRows,
                   int iColumns,
                   String sColumn[],
                   Object oData[][],
                   int iMode )
  {
    this.bEditable = false;
    this.iSelect   = iSelect;
    this.iMode     = iMode;

    if (iColumns > 0)
    {
      this.iColumns = iColumns;
      this.sColumn = new String[iColumns];
      for (int i=0; i<iColumns; i++)
        this.sColumn[i]  = new String(sColumn[i]);
    }
    else
    {
      sMessage =
         new String("guiTable(): You must have at least one column.");
      JOptionPane.showMessageDialog((Component) null, sMessage,"ERROR",
                                     JOptionPane.ERROR_MESSAGE);
    }

    if (iRows > 0)
    {
      this.iRows      = iRows;
      this.oData      = oData;
      this.iEmptyList = 0;
    }
    else
    {
      sMessage =
         new String("guiTable(): You must have at least one row.");
      JOptionPane.showMessageDialog((Component) null, sMessage,"ERROR",
                                     JOptionPane.ERROR_MESSAGE);
    }

    createTableModel();
  }

  /** Constructor guiTable()
   *  <p> This is the Constructor for this class.
   *  @param iSelect  - The Column that will be used for selection
   *  @param iColumns - Total number of Columns
   *  @param sColumn  - Array of Strings
   *  @param iMode    - Selection Mode
   */

  public guiTable( int iSelect, int iColumns, String sColumn[], int iMode, Observable notifier )
  {
    this.bEditable = false;
    this.iSelect   = iSelect;
    this.iMode     = iMode;
    this.notifier  = notifier;

    if (iColumns > 0)
    {
      this.iColumns = iColumns;
      this.sColumn  = new String[iColumns];
      this.oData    = new Object[1][iColumns];
      for (int i=0; i<iColumns; i++)
      {
        this.sColumn[i]  = new String(sColumn[i]);
        this.oData[0][i] = new String("");
        this.iEmptyList  = 1;
      }
    }
    else
    {
      sMessage =
         new String("guiTable(): You must have at least one column.");
      JOptionPane.showMessageDialog((Component) null, sMessage,"ERROR",
                                     JOptionPane.ERROR_MESSAGE);
    }

    createTableModel();
  }

  /** Constructor guiTable()
   *  <p> This is the Constructor for this class.
   *  @param iSelect   - The Column that will be used for selection
   *  @param iRows     - Total number of Rows;
   *  @param iColumns  - Total number of Columns;
   *  @param sColumn   - Array of Column Strings
   *  @param oData     - Double Array of Data
   *  @param iMode     - Selection Mode
   */

  public guiTable( int iSelect,
                   int iRows,
                   int iColumns,
                   String sColumn[],
                   Object oData[][],
                   int iMode,
                   Observable notifier )
  {
    this.bEditable = false;
    this.iSelect   = iSelect;
    this.iMode     = iMode;
    this.notifier  = notifier;

    if (iColumns > 0)
    {
      this.iColumns = iColumns;
      this.sColumn = new String[iColumns];
      for (int i=0; i<iColumns; i++)
        this.sColumn[i]  = new String(sColumn[i]);
    }
    else
    {
      sMessage =
         new String("guiTable(): You must have at least one column.");
      JOptionPane.showMessageDialog((Component) null, sMessage,"ERROR",
                                     JOptionPane.ERROR_MESSAGE);
    }

    if (iRows > 0)
    {
      this.iRows      = iRows;
      this.oData      = oData;
      this.iEmptyList = 0;
    }
    else
    {
      sMessage =
         new String("guiTable(): You must have at least one row.");
      JOptionPane.showMessageDialog((Component) null, sMessage,"ERROR",
                                     JOptionPane.ERROR_MESSAGE);
    }

    createTableModel();
  }

  /** Method close()
   * <p> This method will force JAVA to release Memory by setting variables
   *     to null;
   */

  public void close()
  {
    sColumn   = null;
    iSelectedRows = null;
    bColumn   = null;
    oData     = null;
    oSelected = null;
    sMessage  = null;

    notifier  = null;

    dataModel = null;
    pScroll   = null;
    pTable    = null;
  }

  /** createTableModel()
   *  <p> This method will create the Generic List Table Model.
   */

  public void createTableModel()
  {
    if (bEditable)
    {
      dataModel = new AbstractTableModel()
      {
        /*
         * These methods always need to be implemented.
         */

        public int getColumnCount()
        {
          int cnt = 0;
          if (sColumn != null) cnt = sColumn.length;
          return (cnt);
        }

        public int getRowCount()
        {
          int cnt = 0;
          if (oData != null) cnt = oData.length;
          return (cnt);
        }

        public Object getValueAt(int row, int col) { return oData[row][col]; }

        /*
         * The default implementations of these methods in
         * AbstractTableModel would work, but we can refine them.
         */

        public String getColumnName(int column) { return sColumn[column]; }
        public Class getColumnClass(int c) {return getValueAt(0, c).getClass();}

        /*
         * Methods needed if the Table is to be editable.  These methods are
         * presently for String like editing only.
         */

        public boolean isCellEditable(int row, int col)
        {
          boolean bValue = true;

          if (bColumn != null)
            bValue = bColumn[col];

          return (bValue);
        }

        public void setValueAt(Object value, int row, int col)
        {
          oData[row][col] = value;
        }
      };
    }
    else
    {
      dataModel = new AbstractTableModel()
      {
        /*
         * These methods always need to be implemented.
         */

        public int getColumnCount()
        {
          int cnt = 0;
          if (sColumn != null) cnt = sColumn.length;
          return (cnt);
        }

        public int getRowCount()
        {
          int cnt = 0;
          if (oData != null) cnt = oData.length;
          return (cnt);
        }

        public Object getValueAt(int row, int col) { return oData[row][col]; }

        /*
         * The default implementations of these methods in
         * AbstractTableModel would work, but we can refine them.
         */

        public String getColumnName(int column) { return sColumn[column]; }
        public Class getColumnClass(int c) {return getValueAt(0, c).getClass();}
      };
    }

    pTable = new JTable( dataModel );
    pTable.setCellSelectionEnabled( false );
    pTable.setRowSelectionInterval(0, 0);
    pTable.setShowHorizontalLines( true );

    if (iMode == _SINGLE_SELECTION)
      pTable.setSelectionMode( ListSelectionModel.SINGLE_SELECTION );
    else
      pTable.setSelectionMode(ListSelectionModel.MULTIPLE_INTERVAL_SELECTION);

    pTable.setColumnSelectionAllowed( false );
    pTable.setRowSelectionAllowed( true );
//    pTable.setBackground(Color.gray);
//    pTable.setForeground(Color.white);
    pTable.setBackground(Color.white);
    pTable.setForeground(Color.black);
    pTable.setSelectionBackground(Color.yellow);
    pTable.setSelectionForeground(Color.black);
    ListSelectionModel selectionModel = pTable.getSelectionModel();
    if (iMode == _SINGLE_SELECTION)
      selectionModel.addListSelectionListener( new guiListListener() );
    else
      selectionModel.addListSelectionListener(new RowListener());

    pScroll = new JScrollPane( pTable );
  }

  /* ================================================================= *
   * ------------------------- TABLE METHODS ------------------------- *
   * ================================================================= */

  /** METHOD isEmptyList()
   *  <p> This method will check to see if List is an empty list
   *  @return List State - true or false
   */

  public boolean isEmptyList()
  {
    if (iEmptyList == 1)
      return (true);
    else
      return (false);
  }

  /** METHOD refresh
   *  <p> This method will simply redraw the Table.
   */

  public void refresh() { pTable.updateUI(); }

  /* ================================================================= *
   * ------------------------- LIST LISTENER ------------------------- *
   * ================================================================= */

  /** CLASS guiListListener
   *  <p> This Method will listen for selection on the gui Table.
   */

  class guiListListener implements ListSelectionListener
  {
    public void valueChanged( ListSelectionEvent event)
    {
      iSelectedRow    = pTable.getSelectedRow();
      iSelectedColumn = pTable.getSelectedColumn();
      oSelected       = pTable.getValueAt(iSelectedRow, iSelect);

      if (notifier != null)
        notifier.notifyObservers(new String("Single Selection"));
    }
  }

  private class RowListener implements ListSelectionListener
  {
    public void valueChanged(ListSelectionEvent event)
    {
      if (event.getValueIsAdjusting()) { return; }
      iSelectedRows = pTable.getSelectedRows();

      if (notifier != null)
        notifier.notifyObservers(new String("Multiple Selection"));
    }
  }

  /* ================================================================= *
   * ---------------------- Modify Table Methods --------------------- *
   * ================================================================= */

  /** Method resizeColumns()
   *  <p> This method will resize the width of the columns, this assumes that
   *      the number of columns will correspond to the column width array.
   * @param iColumn      = the column to be resized
   * @param iColumnWidth = The Width of the column
   */

  public void resizeColumn(int iColumn, int iColumnWidth)
  {
    TableColumn pColumn = pTable.getColumnModel().getColumn(iColumn);
    pColumn.setMinWidth(iColumnWidth * 8);
    pColumn.setMaxWidth(iColumnWidth * 8);
    pTable.sizeColumnsToFit(0);
    pTable.updateUI();
  }

  /** Method showHorScroll()
   *  <p> This method shows the horizontal scroll bar when required
   *  @param show = To show or not to show, that is the question.
   */

  public void showHorScroll(boolean show)
  {
    if (show)
      pTable.setAutoResizeMode(JTable.AUTO_RESIZE_OFF);
    else
      pTable.setAutoResizeMode(JTable.AUTO_RESIZE_SUBSEQUENT_COLUMNS);
  }

  /* ================================================================= *
   * ------------------- Add, Modify or Delete Rows ------------------ *
   * ================================================================= */

  /** Method addRow()
   * <p> This method will add a blank row to the end of list
   */

  public void addRow()
  {
    int i=0;
    int j=0;
    int iCount=0;
    Object oTemp[][];

    oTemp = new Object[iRows+1][iColumns];
    for (i=0; i<iRows; i++)
    {
      for (j=0; j<iColumns; j++)
      {
        oTemp[iCount][j] = oData[i][j];
      }
      iCount++;
    }

    for (j=0; j<iColumns; j++)
    {
      oTemp[iCount][j] = new String("");
    }
    iCount++;

    oData = new Object[iCount][iColumns];
    iRows = iCount;
    for (i=0; i<iCount; i++)
    {
      for (j=0; j<iColumns; j++)
      {
        oData[i][j] = oTemp[i][j];
      }
    }

    reload(iRows, oData);
  }

  /** Method modifyCell()
   * <p> This method will modify the data in a specific cell in the table
   * @param row = The location of the cell within the row
   * @param col = The location of the cell within the column
   * @param val = The new value.
   */

  public void modifyCell(int row, int col, Object val)
  {
    if ((iRows > 0) && (row < iRows) && (col < iColumns))
    {
      oData[row][col] = val;
      reload(iRows, oData);
    }
  }

  /** Method modifyRow()
   * <p> This method will modify the data in a row in the table
   * @param row = The location of the cell within the row
   * @param val = The Row data to be modified.
   */

  public void modifyRow(int row, Object val[])
  {
    if ((iRows > 0) && (row < iRows))
    {
      for (int j=0; j<iColumns; j++)
      {
        oData[row][j] = val[j];
      }
      reload(iRows, oData);
    }
  }

  /** Method deleteRow()
   * <p> This method will delete a row from the list
   * @param row = The row that is being deleted from the table
   */

  public void deleteRow(int row)
  {
    int i=0;
    int j=0;
    int iCount=0;
    Object oTemp[][];

    if ((iRows > 0) && (row < iRows))
    {
      oTemp = new Object[iRows-1][iColumns];
      for (i=0; i<iRows; i++)
      {
        if (i != row)
        {
          for (j=0; j<iColumns; j++)
          {
            oTemp[iCount][j] = oData[i][j];
          }

          iCount++;
        }
      }

      oData = new Object[iCount][iColumns];
      iRows = iCount;

      for (i=0; i<iCount; i++)
      {
        for (j=0; j<iColumns; j++)
        {
          oData[i][j] = oTemp[i][j];
        }
      }

      reload(iRows, oData);
    }
  }

  /* ================================================================= *
   * -------------------------- SET METHODS -------------------------- *
   * ================================================================= */

  /** Method setSelectedRow()
   *  <p> This method will set the selected row.
   *  @param iSelectedRow - Selected Row.
   */

  public void setSelectedRow(int iSelectedRow)
  {
    this.iSelectedRow = iSelectedRow;
    pTable.setRowSelectionInterval(iSelectedRow, iSelectedRow);
    pTable.updateUI();
  }

  /** METHOD reload()
   *  <p> This method will reload the data in the List Table.  This assumes that
   *      the number of columns will remain the same.
   *  @param iRows - Total number of Rows;
   *  @param oData - Double Array of Data
   */

  public void reload(int iRows, Object oData[][])
  {
    if (iRows > 0)
    {
      this.iRows = iRows;
      this.oData = oData;
      iEmptyList = 0;
    }
    else
    {
      oData = new Object[1][iColumns];
      for (int i=0; i<iColumns; i++)
        oData[0][i] = new String("");
    }

    pTable.updateUI();
  }

  /** Method clear()
   * <p> This method will clear the select settings for multi-select
   */

  public void clear() { pTable.clearSelection(); }

  /* ================================================================= *
   * -------------------------- GET METHODS -------------------------- *
   * ================================================================= */

  /** Method getRowCount()
   * <p> This method will return the number of rows in the table.
   * @return iRows = The total number of rows.
   */

  public int getRowCount() { return (iRows); }

  /** Method getColumnCount()
   *  <p> This method will return the total number of rows in Table.
   *  @return iColumns = Total Number of Columns in Table.
   */

  public int getColumnCount() { return (iColumns); }

  /** Method getSelectedRow()
   *  <p> This method will return the selected row.
   *  @return iSelectedRow - Selected Row.
   */

  public int getSelectedRow() { return (iSelectedRow); }

  /** Method getSelectedRows()
   *  <p> This method will return all the selected rows.
   *  @return iSelectedRows - All the Selected Rows.
   */

  public int[] getSelectedRows() { return ( iSelectedRows ); }

  /** Method getSelectedObject()
   *  <p> This method will return the selected row.
   *  @return oSelected - Selected Object.
   */

  public Object getSelectedObject() { return (oSelected); }

  /** Method getData()
   * <p> This method will return the Object for row and column
   * @return oData  = The cell to be returned
   */

  public Object[][] getData() { return (oData); }

  /** Method getScrollPane()
   *  <p> This method will return the scroll pane.
   *  @return pScroll - Scroll Pane containing the Table.
   */

  public JScrollPane getScrollPane() { return (pScroll); }

  /** Method getTable()
   *  <p> This method will return the Table.
   *  @return pTable - The Gui List Table.
   */

  public JTable getTable() { return (pTable); }
}
