/*
 * @guiMemoryFrame.java Version 1.1 05/03/2010
 *
 * Copyright (c) 2010 Kansas Geological Survey
 * 1930 Constant Avenue, Lawrence, Kansas, 66047, U.S.A.
 * All Rights Reserved.
 */

package gui;

import java.awt.*;
import java.awt.event.*;

import javax.swing.*;
import javax.swing.border.*;
import javax.swing.event.*;

/** Class guiMemoryFrame
 *  <p> This Class will display the memory usage.
 *
 *  @version 1.1 05/03/2010
 *  @author  John R. Victorine
 */

public class guiMemoryFrame extends JFrame implements ActionListener
{
  // Memory Progress Bars

  private JProgressBar pbUSE = null;
  private JProgressBar pbPC  = null;

  // File Button Menu

  private JMenuItem mExit  = null;

  /** Constructor guiMemoryFrame()
   *  <p> This is the Constructor for this class.
   */

  public guiMemoryFrame()
  {
    try
    {
      jbInit();
    }
    catch(Exception e)
    {
      e.printStackTrace();
    }
  }

  /** METHOD jbInit()
   *  <p> This Method will create the Frame for this class.
   *  @throws Exception
   */

  private void jbInit() throws Exception
  {
    JPanel pnlFreeMemory = new JPanel();
    JPanel pnlPCMemory   = new JPanel();

    // Textfield Panel Borders

    TitledBorder titledBorderUsage = new TitledBorder(
        BorderFactory.createEtchedBorder(Color.white,new Color(165, 163, 151)),
        "Memory Usage:");
    titledBorderUsage.setTitleFont(new java.awt.Font("Dialog", 1, 11));

    TitledBorder titledBorderTotal = new TitledBorder(
        BorderFactory.createEtchedBorder(Color.white,new Color(165, 163, 151)),
        "Memory Usage - PC Total Available Memory");
    titledBorderTotal.setTitleFont(new java.awt.Font("Dialog", 1, 11));

    // Menu Bar

    JMenuBar menuBar    = new JMenuBar();
    JMenu    menuFile   = new JMenu("Close Dialog");

    mExit = new JMenuItem("Exit");
    mExit.addActionListener(this);

    menuFile.add(mExit);
    menuBar.add(menuFile);
    this.setJMenuBar(menuBar);

    // Build Frame

    this.getContentPane().setLayout(new BorderLayout());
    this.setTitle("Available Memory");

    // Free Memory Panel

    pnlFreeMemory.setLayout(new BorderLayout());
    pnlFreeMemory.setBorder(titledBorderUsage);

    pbUSE = new JProgressBar(0, 100);
    pbUSE.setValue( util.utilMemory.getFreeUsage() );
    pbUSE.setStringPainted( true );

    // PC Memory Panel

    pnlPCMemory.setLayout(new BorderLayout());
    pnlPCMemory.setBorder(titledBorderTotal);

    pbPC = new JProgressBar(0, 100);
    pbPC.setValue( util.utilMemory.getPCUsage() );
    pbPC.setStringPainted( true );

    this.getContentPane().add(pnlFreeMemory, BorderLayout.NORTH);
    pnlFreeMemory.add(pbUSE,             BorderLayout.CENTER);

    this.getContentPane().add(pnlPCMemory, BorderLayout.SOUTH);
    pnlPCMemory.add(pbPC,                BorderLayout.CENTER);

    // Display the Frame

    this.setSize(new Dimension(300, 150));
    Dimension d = Toolkit.getDefaultToolkit().getScreenSize();
    this.setLocation(d.width - this.getSize().width - 10, 10);

    this.setResizable(false);
    this.setVisible(true);
  }

  /** Method setMemory
   * <p> This method will show the memory usage after forcing the Java program
   *     to free memory and do garbage collection.
   */

  public void freeMemory()
  {
    util.utilMemory.free();
    if (pbPC != null) pbPC.setValue( util.utilMemory.getPCUsage() );
    if (pbUSE != null) pbUSE.setValue( util.utilMemory.getFreeUsage() );
  }

  /** Method setMemory
   * <p> This method will show the memory usage after forcing the Java program
   *     to free memory and do garbage collection.
   */

  public void setMemory()
  {
    if (pbPC != null) pbPC.setValue( util.utilMemory.getPCUsage() );
    if (pbUSE != null) pbUSE.setValue( util.utilMemory.getFreeUsage() );
  }

  /** Method close()
   * <p> This method will close all dialogs that are opened by this class.
   */

  public void close()
  {
    // Memory Progress Bars

    pbUSE = null;
    pbPC  = null;

    // File Button Menu

    mExit = null;

    dispose();
  }

  /** METHOD actionPerformed()
   *  <p> This Method will handle all the actions within the Frame.
   *  @param event - Action Event
   */

  public void actionPerformed(ActionEvent event)
  {
    if (event.getSource() == mExit) { close(); }
  }
}

/*
 *  @version 1.1 05/03/2010
 *  @author  John Victorine
 */
