/*
 * @geminiIOHeaders.java Version 1.0 10/18/2013
 *
 * Copyright (c) 2013 Kansas Geological Survey
 * 1930 Constant Avenue, Lawrence, Kansas, 66047, U.S.A.
 * All Rights Reserved.
 */

package gemini.io;

import java.io.*;
import java.awt.*;
import javax.swing.*;

import iqstrat.iqstratHeadersStruct;
import iqstrat.iqstratHeadersListStruct;
import iqstrat.io.ReadHeadersXMLFile;
import iqstrat.io.WriteHeadersXMLFile;
import iqstrat.io.ReadErrorXMLFile;

/** Class geminiIOHeaders
 *  <p> This class will manage the headers Information Data
 *
 *  @version 1.1 10/18/2013
 *  @author  John R. Victorine
 */

public class geminiIOHeaders
{
  public static final String HEADERS_XML = "headers.xml";

  public static final String PLOT        = "Profile.html";
  public static final String PLOT_PNG    = "Profile.png";

  // Identifier for modifying data in Headers database table

  public static final int NO  = 0;
  public static final int YES = 1;

  // Identifier for access to data

  public static final int USER_ONLY   = 0;
  public static final int GROUP_READ  = 1;
  public static final int GROUP_WRITE = 2;

  // Identifiers for saving IQSTRAT Data

  public static final int IGNORE  = -1;
  public static final int USER_PC = 0;
  public static final int KGS_DB  = 1;
  public static final int BOTH    = 2;

  /*========================================================================*
   * ------------------------- DIRECTORY METHODS ---------------------------*
   *========================================================================*/

  /** Method exists()
   * <p> This method will check to see if the headers Information XML File exists.
   * @return bValue = true if file exists and false if it does not
   */

  public static boolean exists()
  {
    boolean bValue = false;

    try
    {
      File p = new File( gemini.io.geminiIO.read() );

      if (p.exists())
      {
        try
        {
          File pNew = new File(p, HEADERS_XML);
          if (pNew.exists())
          {
            bValue = true;
          }
        }
        catch (Exception e)
        {
          e.printStackTrace();
          String sError = new String("gemini.io.geminiIOHeaders().exists-2\n " +
                                     e.toString());
          JOptionPane.showMessageDialog(
              (Component) null, sError, "ERROR", JOptionPane.ERROR_MESSAGE);
        }
      }
    }
    catch (Exception e)
    {
      e.printStackTrace();
      String sError = new String("gemini.io.geminiIOHeaders().exists\n " + e.toString());
      JOptionPane.showMessageDialog(
          (Component) null, sError, "ERROR", JOptionPane.ERROR_MESSAGE);
    }

    return (bValue);
  }

  /*========================================================================*
   * ---------------------------- GET METHODS ------------------------------*
   *========================================================================*/

  /** Method getPath()
   * <p> This method will check to see if the headers Information XML File exists.
   * @param  sKEY  = Primary Key of data defined by user
   * @return sPath = The path to the Header Record
   */

  public static String getPath(String sKEY)
  {
    String sPath = "";

    if (sKEY != null)
    {
      try
      {
        File p = new File(gemini.io.geminiIO.read());

        if (p.exists())
        {
          if (!sKEY.equals("0"))
          {
            try
            {
              File pNew = new File(p, sKEY);
              if (pNew.exists())
              {
                sPath = new String( pNew.getCanonicalPath() );
              }
            }
            catch (Exception e)
            {
              e.printStackTrace();
              String sError = new String("gemini.io.geminiIOHeaders().getPath-2\n " +
                                         e.toString());
              JOptionPane.showMessageDialog(
                  (Component) null, sError, "ERROR", JOptionPane.ERROR_MESSAGE);
            }
          }
        }
      }
      catch (Exception e)
      {
        e.printStackTrace();
        String sError = new String("gemini.io.geminiIOHeaders().getPath\n " +
                                   e.toString());
        JOptionPane.showMessageDialog(
            (Component) null, sError, "ERROR", JOptionPane.ERROR_MESSAGE);
      }
    }

    return (sPath);
  }

  /** Method getData()
   * <p> This method will read the User information xml data
   * @param  iMethod = The Method used in retrieving the XML
   * @param  sPath   = The url or File Path to use
   * @return stUser  = The User Data Structure
   */

  public static iqstratHeadersListStruct getData(int iMethod, String sPath)
  {
    iqstratHeadersListStruct st = null; // headers Information Data Structure

    ReadHeadersXMLFile pRead = new ReadHeadersXMLFile(iMethod);
    st = pRead.Process(sPath);

    String sError = pRead.GetError();
    if (sError.length() > 0)
      JOptionPane.showMessageDialog( (Component)null,
                                     sError,
                                     "ERROR",
                                     JOptionPane.ERROR_MESSAGE );

    return (st);
  }

  /*========================================================================*
   * --------------------------- READ METHODS ------------------------------*
   *========================================================================*/

  /** Method read()
   * <p> This method will read the Headers Information XML File that is on
   *     the User's PC.
   * @return st = The Headers Information List Data Structure
   */

  public static iqstratHeadersListStruct read()
  {
    iqstratHeadersListStruct st = null; // User Data Structure

    String sDir  = gemini.io.geminiIO.read();  // Retrieve the Home Directory
    String sPath = sDir+"\\"+HEADERS_XML;      // Build Path to Login XML

    if (exists())
      st = getData(iqstrat.io.ReadHeadersXMLFile.FILE, sPath);

    return (st);
  }

  /*========================================================================*
   * --------------------------- WRITE METHODS -----------------------------*
   *========================================================================*/

  /** Method save()
   * <p> This method will force a creation of the IQSTRAT Directory & XML
   * @param  st     = The headers Information Data Structure
   * @return st     = The headers Information Data Structure
   */

  public static iqstratHeadersStruct save( iqstratHeadersStruct st)
  {
    String sKEY = "0";
    iqstratHeadersListStruct stList = read();

    sKEY = iqstrat.iqstratHeadersUtility.exists( stList, st.sKEY, st.sAPI, st.sKID, st.sName );

    gemini.io.geminiIO.save(); // Create GEMINI Data Directory & XML

//System.out.println(st.sKEY + " " + sKEY);

    // Add Headers Data Struct to Headers List if it does not exist

    if (sKEY.equals("0"))
      stList = iqstrat.iqstratHeadersUtility.add( stList, st );
    else
    {
	  st.sKEY = new String( sKEY );
      stList  = iqstrat.iqstratHeadersUtility.modify( stList, st );
    }

    write(stList); // Write the Headers List to the User PC as XML

    return (st);
  }

  /** Method write()
   * <p> This method will write the headers Info XML File to the User's PC at
   *     the top level IQSTRAT_DATA Directory.
   * @param st = The headers Information List Data Structure
   */

  public static void write(iqstratHeadersListStruct st)
  {
    String sDir = gemini.io.geminiIO.read();  // Retrieve the Data Directory

    if (st != null)
    {
      WriteHeadersXMLFile pXML = new WriteHeadersXMLFile();
      pXML.write(sDir, HEADERS_XML, pXML.buildXML(st));
    }
  }

  /*========================================================================*
   * --------------------------- DELETE METHODS ----------------------------*
   *========================================================================*/

  /** Method deleteDir()
   * <p> This method will delete the Data Directory in the user home
   *     directory.
   * @param  sKEY  = Primary Key of data defined by user
   */

  public static void deleteDir( String sKEY )
  {
    try
    {
      File p = new File( gemini.io.geminiIO.read() );

      if (p.exists())
      {
        if (!sKEY.equals("0"))
        {
          try
          {
            File pNew = new File(p, sKEY);
            if (pNew.exists())
            {
              pNew.delete();
            }
          }
          catch (Exception e)
          {
            e.printStackTrace();
            String sError = new String("gemini.io.geminiIOHeaders.deleteDir()-2\n " +
                                       e.toString());
            JOptionPane.showMessageDialog(
                (Component) null, sError, "ERROR", JOptionPane.ERROR_MESSAGE);
          }
        }
      }
    }
    catch (Exception e)
    {
      e.printStackTrace();
      String sError = new String("gemini.io.geminiIOHeaders.deleteDir()\n " + e.toString());
      JOptionPane.showMessageDialog(
          (Component) null, sError, "ERROR", JOptionPane.ERROR_MESSAGE);
    }
  }

  /** Method deletePC()
   * <p> This method will check to see if the headers Information XML File exists.
   *     and delete the file if it does
   */

  public static void deletePC()
  {
    try
    {
      File p = new File( gemini.io.geminiIO.read() );

      if (p.exists())
      {
        try
        {
          File pNew = new File(p, HEADERS_XML);
          if (pNew.exists())
          {
            pNew.delete();
          }
        }
        catch (Exception e)
        {
          e.printStackTrace();
          String sError = new String("gemini.io.geminiIOHeaders.deletePC()-2\n " +
                                     e.toString());
          JOptionPane.showMessageDialog(
              (Component) null, sError, "ERROR", JOptionPane.ERROR_MESSAGE);
        }
      }
    }
    catch (Exception e)
    {
      e.printStackTrace();
      String sError = new String("gemini.io.geminiIOHeaders.deletePC()\n " + e.toString());
      JOptionPane.showMessageDialog(
          (Component) null, sError, "ERROR", JOptionPane.ERROR_MESSAGE);
    }
  }

  /** Method deletePC()
   * <p> This method will check to see if the headers Information XML File exists
   *     and remove the file if it does.
   * @param  sKEY  = Primary Key of data defined by user
   */

  public static void deletePC(String sKEY)
  {
    try
    {
      File p = new File( gemini.io.geminiIOHeaders.getPath(sKEY) );

      if (p.exists())
      {
        try
        {
          File pNew = new File(p, HEADERS_XML);
          if (pNew.exists())
          {
            pNew.delete();
          }
        }
        catch (Exception e)
        {
          e.printStackTrace();
          String sError = new String("gemini.io.geminiIOHeaders.deletePC()-2\n " +
                                     e.toString());
          JOptionPane.showMessageDialog(
              (Component) null, sError, "ERROR", JOptionPane.ERROR_MESSAGE);
        }
      }
    }
    catch (Exception e)
    {
      e.printStackTrace();
      String sError = new String("gemini.io.geminiIOHeaders.deletePC()\n " + e.toString());
      JOptionPane.showMessageDialog(
          (Component) null, sError, "ERROR", JOptionPane.ERROR_MESSAGE);
    }
  }
}

/*
 *  @version 1.1 10/18/2013
 *  @author  John Victorine
 */
