/*
 * @geminiIO.java Version 1.0 10/14/2013
 *
 * Copyright (c) 2013 Kansas Geological Survey
 * 1930 Constant Avenue, Lawrence, Kansas, 66047, U.S.A.
 * All Rights Reserved.
 */

package gemini.io;

import java.io.*;
import java.awt.*;
import javax.swing.*;

import gemini.io.ReadGEMINIXMLFile;
import gemini.io.WriteGEMINIXMLFile;

/** Class geminiIO
 *  <p> This class will manage the gemini data file location, which is set
 *      to the user's directory.
 *
 *  @version 1.1 10/14/2013
 *  @author  John R. Victorine
 */

public class geminiIO
{
  public static final String GEMINI_XML  = "GEMINI_DATA.xml";
  public static final String GEMINI_DATA = "GEMINI_DATA";

  /*========================================================================*
   *------------------- GEMINI DATA DIRECTORY METHODS ----------------------*
   *========================================================================*/

  /** Method getHomeDir()
   * <p> This method will retrieve the User's Home Directory
   * @return sDirectory = The User Home Directory
   */

  public static String getHomeDir()
  {
    String sDir = "";    // User Home Directory
    File   pDir = null;  // User Home Directory File Object

    try
    {
      pDir = new File( System.getProperty( "user.home" ) );
      sDir = new String( pDir.getCanonicalPath() );
    }
    catch (Exception e)
    {
      e.printStackTrace();
      String sError = new String("gemini.geminiIO.getHomeDir()\n "+e.toString());
      JOptionPane.showMessageDialog(
        (Component) null, sError, "ERROR", JOptionPane.ERROR_MESSAGE);
    }

    return (sDir);
  }

  /** Method exists()
   * <p> This method will check to see if the GEMINI XML File exists.
   * @return bValue = true if file exists and false if it does not
   */

  public static boolean exists()
  {
    boolean bValue = false;

    try
    {
      File p = new File( getHomeDir() );

      if (p.exists())
      {
        try
        {
          File pNew = new File(p, GEMINI_XML);
          if (pNew.exists())
          {
            bValue = true;
          }
        }
        catch (Exception e)
        {
          e.printStackTrace();
          String sError = new String("gemini.geminiIO().exists-2\n " + e.toString());
          JOptionPane.showMessageDialog(
              (Component) null, sError, "ERROR", JOptionPane.ERROR_MESSAGE);
        }
      }
    }
    catch (Exception e)
    {
      e.printStackTrace();
      String sError = new String("gemini.geminiIO().exists\n " +  e.toString());
      JOptionPane.showMessageDialog(
          (Component) null, sError, "ERROR", JOptionPane.ERROR_MESSAGE);
    }

    return (bValue);
  }

  /** Method mkDir()
   * <p> This method will make the GEMINI Data Directory in the user home
   *     directory and create a xml file of the location.
   */

  public static void mkDir()
  {
    try
    {
      File p = new File( getHomeDir() );

      if (p.exists())
      {
        try
        {
          File pNew = new File(p, GEMINI_DATA);

          if (!pNew.exists())
          {
            pNew.mkdir();
            write( pNew.getCanonicalPath() );
          }
        }
        catch (Exception e)
        {
          e.printStackTrace();
          String sError = new String("gemini.geminiIO().mkDir-2\n " + e.toString());
          JOptionPane.showMessageDialog(
              (Component) null, sError, "ERROR", JOptionPane.ERROR_MESSAGE);
        }
      }
    }
    catch (Exception e)
    {
      e.printStackTrace();
      String sError = new String("gemini.geminiIO().mkDir\n " +  e.toString());
      JOptionPane.showMessageDialog(
          (Component) null, sError, "ERROR", JOptionPane.ERROR_MESSAGE);
    }
  }

  /*========================================================================*
   *--------------------- GENERAL DIRECTORY METHODS ------------------------*
   *========================================================================*/

  /** Method exists()
   * <p> This method will check to see if the directory path exists.
   * @path   sPath  = The directory path to be checked
   * @return bValue = true if file exists and false if it does not
   */

  public static boolean exists(String sPath)
  {
    boolean bValue = false;

    try
    {
      File p = new File( sPath );

      if (p.exists())
      {
        bValue = true;
      }
    }
    catch (Exception e)
    {
      e.printStackTrace();
      String sError = new String("gemini.geminiIO().exists(sPath)\n " +  e.toString());
      JOptionPane.showMessageDialog(
          (Component) null, sError, "ERROR", JOptionPane.ERROR_MESSAGE);
    }

    return (bValue);
  }

  /** Method mkDir()
   * <p> This method will create a directory if the Path does not exists.
   * @path   sPath  = The directory path to be checked or created
   */

  public static void mkDir(String sPath)
  {
    try
    {
      File p = new File( sPath );

      if (!p.exists())
      {
        try
        {
          p.mkdir();
        }
        catch (Exception e)
        {
          e.printStackTrace();
          String sError = new String("gemini.geminiIO().mkDir(sPath)-2\n " + e.toString());
          JOptionPane.showMessageDialog(
              (Component) null, sError, "ERROR", JOptionPane.ERROR_MESSAGE);
        }
      }
    }
    catch (Exception e)
    {
      e.printStackTrace();
      String sError = new String("gemini.geminiIO().mkDir(sPath)\n " +  e.toString());
      JOptionPane.showMessageDialog(
          (Component) null, sError, "ERROR", JOptionPane.ERROR_MESSAGE);
    }
  }

  /*========================================================================*
   *----------------------------- GET METHODS ------------------------------*
   *========================================================================*/

  /** Method getPath()
   * <p> This method will return the default GEMINI Data Directory Path.
   * @return sPath = The path to the GEMINI Data Directory
   */

  public static String getPath()
  {
    String sPath = getHomeDir() + "\\" + GEMINI_DATA;

    return (sPath);
  }

  /*========================================================================*
   *------------------------------ IO METHODS ------------------------------*
   *========================================================================*/

  /** Method save()
   * <p> This method will force a creation of the GEMINI Directory & XML
   */

  public static void save() { mkDir(); }

  /** Method read()
   * <p> This method will read the GEMINI XML File that is on the User's
   *     PC for the GEMINI Data Directory Path (work area).
   * @return sData = The GEMINI Data Path
   */

  public static String read()
  {
    String sData = "";                   // GEMINI Data Path
    String sDir  = getHomeDir();         // Get the Home Directory Path
    String sPath = sDir+"\\"+GEMINI_XML; // Build Path to GEMINI XML

    if (exists())
    {
      ReadGEMINIXMLFile pRead =
          new ReadGEMINIXMLFile(gemini.io.ReadGEMINIXMLFile.FILE);
      sData = pRead.Process(sPath);
    }

    return (sData);
  }

  /** Method write()
   * <p> This method will write the GEMINI Data XML File to the User's PC
   *     with the path to the GEMINI Data Directory.
   * @param sPath = The gemini data directory path
   */

  public static void write(String sPath)
  {
    WriteGEMINIXMLFile pXML =
        new WriteGEMINIXMLFile( getHomeDir(), GEMINI_XML, sPath);

    if (pXML.GetErrorID() != util.utilFileIO.NOERROR)
    {
      JOptionPane.showMessageDialog(
          (Component) null, pXML.GetError(), "ERROR", JOptionPane.ERROR_MESSAGE);
	}
  }
}

/*
 *  @version 1.1 10/14/2013
 *  @author  John Victorine
 */
