/*
 * @WriteGEMINIXMLFile.java Version 1.0 10/14/2013
 *
 * Copyright (c) 2013 Kansas Geological Survey
 * 1930 Constant Avenue, Lawrence, Kansas, 66047, U.S.A.
 * All Rights Reserved.
 */

package gemini.io;

import java.io.*;
import java.awt.*;

import util.utilFileIO;

/** Class WriteGEMINIXMLFile
 *  <p> This class will create a XML File.
 *
 *  @version 1.1 10/14/2013
 *  @author  John R. Victorine
 */

public class WriteGEMINIXMLFile
{
   private int    iError = util.utilFileIO.NOERROR;
   private String sError = new String("");;
   private String DTD = new String(
     "<?xml version=\"1.0\"?>\n " +
     "<!DOCTYPE gemini [\n " +
     "<!ELEMENT gemini (data*)>\n " +
     "<!ELEMENT data  EMPTY>\n " +
     "<!ATTLIST data path CDATA #REQUIRED>]>\n ");

  /** Constructor WriteGEMINIXMLFile()
   *  <p> This is the constructor for this class
   *  @param sPath     = The Directory Path for the XML File
   *  @param sFilename = The Filename of the XML File.
   *  @param sURL      = The Path to the gemini data directory
   */

  public WriteGEMINIXMLFile( String sPath,
                             String sFilename,
                             String sURL )
  {
    String     sXML = new String(DTD);
    utilFileIO pIO  = new utilFileIO();

    pIO.Open(util.utilFileIO.DIRECTORY,
             util.utilFileIO.WRITE,
             sPath,
             sFilename);

    // Build the XML Block

    if (sPath != null)
    {
      sXML = new String(sXML + "<gemini>\n");
      sXML = new String(sXML + "  <data path=\""  + sURL + "\"/> \n");
      sXML = new String(sXML + "</gemini>");
    }

    // Write the XML Block to the File

    pIO.Write(sXML);
    iError = pIO.getErrorID();
    sError = pIO.getError();

    // Close the File

    if (iError == util.utilFileIO.NOERROR)
      pIO.Close();
  }

  /* --------------------------------------------------------------- *
   * ------------------- ERROR HANDLING METHODS -------------------- *
   * --------------------------------------------------------------- */

  /** METHOD GetErrorID()
   *  <p> This method will return the error number.
   * @return iError = The Error Identifier
   */

  public int GetErrorID() { return (iError); }

  /** METHOD GetError()
   *  <p> This method will return the error string.
   * @return sError = The Error Text
   */

  public String GetError() { return (sError); }
}

/*
 *  @version 1.1 10/14/2013
 *  @author  John Victorine
 */
