/*
 * @geminiFindPath.java Version 1.1 10/16/2013
 *
 * Copyright (c) 2013 Kansas Geological Survey
 * 1930 Constant Avenue, Lawrence, Kansas, 66047, U.S.A.
 * All Rights Reserved.
 */

package gemini.gui;

import java.io.*;
import java.util.Observable;
import java.awt.*;
import java.awt.event.*;

import javax.swing.*;
import javax.swing.event.*;
import javax.swing.border.*;

/** Class geminiFindPath
 *  <p> This Class will create a Directory Search Frame to allow
 *      the user to find a path to save/read a file to/from.
 *
 *  @version 1.1 10/16/2013
 *  @author  John R. Victorine
 */

public class geminiFindPath extends JFrame implements ActionListener
{
  // Input Variables

  private Observable   notifier     = null; // Observable

  // Global Variables

  private String       sPath        = "";   // Directory Path
  private String       sFile        = "Well.las";
  private String       sKEY         = "0";
  private String       sType        = ".las";

  // Global Frame Widgets

  private JTextArea    txtArea      = new JTextArea();

  private JRadioButton rbNO         = new JRadioButton();
  private JRadioButton rbYES        = new JRadioButton();

  private JTextField   txtDirectory = new JTextField();
  private JTextField   txtFilename  = new JTextField();

  private JButton      btnContinue  = new JButton();
  private JButton      btnCancel    = new JButton();
  private JButton      btnFind      = new JButton();

  /** Constructor geminiFindPath()
   *  <p> This is the Constructor for this class.
   *  @param notifier = Observable
   */

  public geminiFindPath( Observable notifier )
  {
    try
    {
      this.notifier = notifier;

      sPath = gemini.io.geminiIO.getHomeDir();

      jbInit();

      addWindowListener( new geminiFindPath_WindowListener() );
    }
    catch(Exception e)
    {
      e.printStackTrace();
    }
  }

  /** METHOD jbInit()
   *  <p> This Method will create the Frame for this class.
   *  @throws Exception
   */

  private void jbInit() throws Exception
  {
	JPanel pnlTop       = new JPanel();
	JPanel pnlArea      = new JPanel();
	JPanel pnlTopButton = new JPanel();

    JPanel pnlFiles     = new JPanel();
    JPanel pnlDirectory = new JPanel();
    JPanel pnlDirText   = new JPanel();
    JPanel pnlDirButton = new JPanel();
    JPanel pnlFilename  = new JPanel();

    JPanel pnlButtons   = new JPanel();

    ButtonGroup group   = new ButtonGroup();

    TitledBorder titledBorderDir = new TitledBorder(
        BorderFactory.createEtchedBorder(Color.white,new Color(165, 163, 151)),
        "Enter Directory Path:");

    TitledBorder titledBorderFile = new TitledBorder(
        BorderFactory.createEtchedBorder(Color.white,new Color(165, 163, 151)),
        "Enter Filename:");

    titledBorderDir.setTitleFont(new java.awt.Font("Dialog", 1, 11));
    titledBorderFile.setTitleFont(new java.awt.Font("Dialog", 1, 11));

    this.getContentPane().setLayout(new BorderLayout());
    this.setTitle("Enter Directory Path & Filename");

    // Top Panel

    pnlTop.setLayout(new BorderLayout());
    pnlTop.setPreferredSize(new Dimension(10, 75));

    // -- Question Save to GEMINI Data Directory? Panel

    pnlArea.setLayout(new BorderLayout());

    txtArea.setText("Do you wish to save this data so it can be shared with othter GEMINI Tools?" );
	txtArea.setFont(new java.awt.Font("Dialog", 1, 14));
    txtArea.setEditable(false);
    txtArea.setRows(2);
    txtArea.setLineWrap(true);
	txtArea.setWrapStyleWord(true);

    // -- Answer Save to GEMINI Data Directory? Panel

    rbNO.setFont(new java.awt.Font("Dialog", 1, 13));
    rbNO.setHorizontalAlignment(SwingConstants.CENTER);
    rbNO.setSelected(true);
    rbNO.setText( "NO" );
    rbNO.addActionListener(this);

    rbYES.setFont(new java.awt.Font("Dialog", 1, 13));
    rbYES.setHorizontalAlignment(SwingConstants.CENTER);
    rbYES.setText( "YES" );
    rbYES.addActionListener(this);

    // Directory & Filename Panel

    pnlFiles.setLayout(new GridLayout(2,1));

    // -- Directory Panel

    pnlDirectory.setBorder(titledBorderDir);
    pnlDirectory.setLayout(new BorderLayout());

    // .. Directory Text Panel

    pnlDirText.setLayout(new BorderLayout());

    txtDirectory.setText( sPath );
    txtDirectory.setFont(new java.awt.Font("Dialog", 1, 13));

    // .. Directory Search Button Panel

    pnlDirButton.setLayout(new BorderLayout());

    btnFind.setFont(new java.awt.Font("Dialog", 1, 13));
    btnFind.setText("Search");
    btnFind.addActionListener(this);

    // -- Filename Panel

    pnlFilename.setBorder(titledBorderFile);
    pnlFilename.setLayout(new BorderLayout());

    txtFilename.setText( sFile );
    txtFilename.setFont(new java.awt.Font("Dialog", 1, 13));

    // Buttons Panel

    pnlButtons.setBorder(BorderFactory.createEtchedBorder());

    btnContinue.setFont(new java.awt.Font("Dialog", 1, 13));
    btnContinue.setText("Continue");
    btnContinue.addActionListener(this);

    btnCancel.setFont(new java.awt.Font("Dialog", 1, 13));
    btnCancel.setText("Cancel");
    btnCancel.addActionListener(this);

//    this.getContentPane().add(pnlTop,     BorderLayout.NORTH);
    pnlTop.add(pnlArea,                   BorderLayout.NORTH);
    pnlArea.add(txtArea,                  BorderLayout.CENTER);

    pnlTop.add(pnlTopButton,              BorderLayout.SOUTH);
    pnlTopButton.add(rbNO,                null);
    pnlTopButton.add(rbYES,               null);

    group.add(rbNO);
    group.add(rbYES);

    this.getContentPane().add(pnlFiles,   BorderLayout.CENTER);
    pnlFiles.add(pnlDirectory,            null);
    pnlDirectory.add(pnlDirButton,        BorderLayout.EAST);
    pnlDirButton.add(btnFind,             BorderLayout.SOUTH);

    pnlDirectory.add(pnlDirText,          BorderLayout.CENTER);
    pnlDirText.add(txtDirectory,          BorderLayout.CENTER);

    pnlFiles.add(pnlFilename,             null);
    pnlFilename.add(txtFilename,          BorderLayout.CENTER);

    this.getContentPane().add(pnlButtons, BorderLayout.SOUTH);
    pnlButtons.add(btnContinue,           null);
    pnlButtons.add(btnCancel,             null);

    // Display the Frame

//    this.setSize(new Dimension(450, 275));
    this.setSize(new Dimension(450, 200));
    Dimension d = Toolkit.getDefaultToolkit().getScreenSize();
    this.setLocation((d.width - this.getSize().width) / 2,
                     (d.height - this.getSize().height) / 2);

    this.setResizable(true);
    this.setVisible(true);
  }

  /** METHOD geminiFindPath_WindowListener()
   *  <p> This Class will handle Frame Close Action using the X Button on Frame
   */

  public class geminiFindPath_WindowListener extends WindowAdapter
  {
    public void windowClosing(WindowEvent e)
    {
      close();
    }
  }

  /** Method close()
   * <p> This method will close all dialogs that are opened by this class.
   */

  public void close()
  {
    notifier     = null;

    sPath        = null;
    sFile        = null;
    sKEY         = null;
    sType        = null;

    // Global Frame Widgets

    txtArea      = null;

    rbNO         = null;
    rbYES        = null;

    btnContinue  = null;
    btnCancel    = null;
    btnFind      = null;

    txtDirectory = null;
    txtFilename  = null;

    dispose();
  }

  /* ===================================================================== *
   * -------------------------- GET METHODS ------------------------------ *
   * ===================================================================== */

  /** Method getDirectory()
   * <p> This method will return the Directory Path
   * @return the Directory Path
   */

  public String getDirectory() { return (txtDirectory.getText()); }

  /** Method getFilename()
   * <p> This method will return the Filename
   * @return the Filename
   */

  public String getFilename()  { return (txtFilename.getText()); }

  /** Method getGemini()
   *  <p> This method will return the result to save as part of GEMINI Data
   *      or NOT.
   */

  public boolean getGEMINI()
  {
	boolean bValue = false;

	if (rbYES.isSelected())
	  bValue = true;

	return (bValue);
  }

  /* ===================================================================== *
   * -------------------------- SET METHODS ------------------------------ *
   * ===================================================================== */

  /** Method setPath()
   *  <p> This method will set the Path depending on the GEMINI Data Buttons
   */

  public void setPath()
  {
	if (rbYES.isSelected())
	{
	  txtDirectory.setText( gemini.io.geminiIO.read() + "\\" + sKEY );
	  txtDirectory.setEditable(false);
	  if (sType.equals(".las"))
	    txtFilename.setText( sKEY + sType );
	  txtFilename.setEditable(false);
	  btnFind.setEnabled(false);
	}
	else
	{
	  txtDirectory.setText( gemini.io.geminiIO.getHomeDir() );
	  txtDirectory.setEditable(true);
	  txtFilename.setText( sFile );
	  txtFilename.setEditable(false);
	  btnFind.setEnabled(true);
	}
  }

  /** Method setKEY()
   *  <p> This method will set the KEY for the data
   *  @param sKEY = The User Defined KEY for this data
   */

  public void setKEY(String sKEY)
  {
	this.sKEY = sKEY;
  }


  /** Method setFilename()
   *  <p> This method will set the default filename
   *  @param sFile = The default Filename
   */

  public void setFilename(String sFile)
  {
	this.sFile = sFile;
    txtFilename.setText( sFile );
  }

  /** Method setTextType()
   *  <p> This method will set the default text type
   *  @param sType = appending text, i.e. ".las", ".csv"
   */

  public void setTextType(String sType)
  {
	this.sType = sType;
  }

  /* ===================================================================== *
   * ---------------------------- ACTIONS -------------------------------- *
   * ===================================================================== */

  /** Method find()
   * <p> This method will search for the PC Directory Path to place LAS File
   */

  private void find()
  {
    String         sPath = gemini.io.geminiIO.getHomeDir();
    JFileChooser   fc    = new JFileChooser();
    int            iVal  = -1;

    fc.setFileSelectionMode( JFileChooser.DIRECTORIES_ONLY );
    fc.setCurrentDirectory(new File( sPath ) );

    iVal = fc.showOpenDialog( this );
    if (iVal == JFileChooser.APPROVE_OPTION)
    {
      sPath = fc.getSelectedFile().getPath();
      txtDirectory.setText( sPath );
    }
  }

  /** Method select()
   * <p> This method will send a message to retrieve the Directory & Filename.
   */

  private void select()
  {
    if (notifier != null)
      notifier.notifyObservers(new String("Get Directory & Filename"));
  }

  /** METHOD actionPerformed()
   *  <p> This Method will handle all the actions within the Frame.
   *  @param event - Action Event
   */

  public void actionPerformed(ActionEvent event)
  {
    if (event.getSource() == rbYES)       { setPath(); }
    if (event.getSource() == rbNO)        { setPath(); }

    if (event.getSource() == btnFind)     { find(); }
    if (event.getSource() == btnContinue) { select(); }
    if (event.getSource() == btnCancel)   { close(); }
  }
}

/*
 *  @version 1.1 10/16/2013
 *  @author  John Victorine
 */
