/*
 * @dstStruct.java Version 1.1 03/16/2012
 *
 * Copyright (c) 2012 Kansas Geological Survey
 * 1930 Constant Avenue, Lawrence, Kansas, 66047, U.S.A.
 * All Rights Reserved.
 */

package dst;

/** Class dstStruct
 *  <p> This Class holds Drill Stem Test Report Data
 *
 *  @version 1.1 03/16/2012
 *  @author  John R. Victorine
 */

public class dstStruct
{
  // Constants

  public static final int _NO  = 0;
  public static final int _YES = 1;

  // Pressure Summary Table Constants
  // -- Row ID for Summary Array Table

  public static final int _INITIAL_HYDRO = 0; // Initial Hydrostatic
  public static final int _FLOW_1        = 1; // Open to Flow 1
  public static final int _SHUT_IN_1     = 2; // Shut-in 1
  public static final int _END_SHUT_IN_1 = 3; // End Shut-in 1
  public static final int _FLOW_2        = 4; // Open to Flow 2
  public static final int _SHUT_IN_2     = 5; // Shut-in 2
  public static final int _END_SHUT_IN_2 = 6; // End Shut-in 2
  public static final int _FINAL_HYDRO   = 7; // Final Hydrostatic
  public static final int _ROWS          = 8;

  public static final String ANNOTATION[] =
  {
	"Initial Hydrostatic",
	"Open to Flow 1     ",
	"Shut-in 1          ",
	"End Shut-in 1      ",
	"Open to Flow 2     ",
	"Shut-in 2          ",
	"End Shut-in 2      ",
	"Final Hydrostatic  "
  };

  // -- Column ID for Summary Array Table

  public static final int _TIME          = 0; // Time
  public static final int _PRESSURE      = 1; // Pressure
  public static final int _TEMPERATURE   = 2; // Temperature
  public static final int _COLUMNS       = 3;

  // Time Units

  public static final int _SEC           = 0; // Seconds
  public static final int _MIN           = 1; // Minutes
  public static final int _HR            = 2; // Hours

  // Pressure Units

  public static final int _PASCAL        = 0; // Pascal                 (Pa)   [ N/m2 ]
  public static final int _BAR           = 1; // Bar                    (bar)  [ dyne/cm2 ]
  public static final int _ATM_TECH      = 2; // Technical Atmosphere   (at)   [ kp/cm2 ]
  public static final int _ATM           = 3; // Standard Atmosphere    (atm)
  public static final int _TORR          = 4; // Torr                   (Torr) [ mmHg ]
  public static final int _PSI           = 5; // Pounds per square inch (psi)  [ lbF/in2 ]

  public static final String PRESSURE_UNITS[] = { "Pa", "bar", "at", "atm", "Torr", "psi" };

  /* ------------------------------------------------------------------------------------------------ *
   *  											Pressure units
   *    				   Wikipedia-Pressure (http://en.wikipedia.org/wiki/Pressure)
   * ------------------------------------------------------------------------------------------------ *
   *     kp = 1 kilopond == unit of force = 1 kg of mass in 9.80665 m/s2 gravitational field
   *     lbF = 1 lbm * 32.174049 ft/s2 or 1 lbF = 4.4482216152605 N (exact)
   *         l lbF = 1 slug * 1 ft/s2
   *     stp = standard temperature and pressure ( 273.15 K of 100 kPa (14.504 psi, 0.986 atm, 1 bar)
   *     1 dyne = 1 gm cm/s
   * ------------------------------------------------------------------------------------------------ *
   * 								  technical	   standard			 	      pound per
   *   pascal   		bar     	  atmosphere   atmosphere    torr   	  square inch
   *   Pa (N/m2)		bar(dyne/cm2) at (kp/cm2)  atm  		 Torr (mmHg)  psi (lbF/in2)
   *   --------------   ------------- ------------ ------------  ------------ -------------
   */

  public static final double _PRESSURE_CONVERSION[][] =
  {
  //    Pa                  bar         at           atm           torr         psi
	{   1.0,             0.00001,    0.000010197, 0.0000098692,   0.0075006,  0.00014504  }, // 1 Pa
	{ 105.0,           106.0,        1.0197,      0.98692,      750.06,      14.5037744 },   // 1 bar
	{   0.00000980665,   0.980665,   1.0,         0.96784,      735.56,      14.223 },       // 1 at
	{   0.0000101325,    1.01325,    1.0332,      1.0,          760.0,       14.696 },       // 1 atm
	{ 133.322,           0.001332,   0.0013595,   0.0013158,      1.0,        0.019337 },    // 1 Torr
	{   0.006895,        0.068948,   0.070307,    0.068046,      51.715,      1.0 }          // 1 psi
  };

 // Temperature Units

 public static final int _DEG_F          = 0;  // Fahrenheit
 public static final int _DEG_C          = 1;  // Celsius
 public static final int _DEG_K          = 2;  // Kelvin

 /* ------------------------------------------------------------------------------------------------ *
  * 											Temperature units
   * ------------------------------------------------------------------------------------------------ *
  *	From  				To Fahrenheit  				To Celsius  		To Kelvin
  *	Fahrenheit (F) 			F  						(F - 32) * 5/9  	(F - 32) * 5/9 + 273.15
  *	Celsius (C or deg) 	(C * 9/5) + 32  				C  				C + 273.15
  *	Kelvin (K) 			(K - 273.15) * 9/5 + 32  	K - 273.15  			K
  * ------------------------------------------------------------------------------------------------ *
  *  Temperature Conversion Table  (http://www.allmeasures.com/temperature.html)
  * ------------------------------------------------------------------------------------------------ */

  // -- Units

  public int iTime_Unit = _MIN;   // Time Default Unit (minutes)
  public int iPres_Unit = _PSI;   // Pressure Default Unit (pounds / square inch)
  public int iTemp_Unit = _DEG_F; // Temperature Default Unit (degree Fahrenheit)

  // DST Data Identifiers

  public String sKEY        = "0"; // Unique KEY
  public String sID         = "";  // DST Report ID or Number - TAB ID

  // DST General Information

  public double depthStart  = 0.0; // Start Interval Depth (ft)
  public double depthEnd    = 0.0; // End Interval Depth   (ft)
  public String sFormation  = "";  // Formation
  public int    iDeviated   = _NO; // Hole Deviated
  public double dWhipstock  = 0.0; // Whipstock (ft)

  // Pressure Readings

  public String serialNo    = "";   // Serial Number
  public String sReading    = "Inside";  // Inside / Outside
  public double dPressure   = 0.0; // Formation Pressure
  public double depth       = 0.0; // @depth
  public double dCapacity   = 0.0; // Pressure Capacity

  public String sDateStart  = "";  // Starting Date-Time (MM/DD/YYYY-HHMMSS
  public String sDateEnd    = "";  // Ending Date-Time (MM/DD/YYYY-HHMMSS

  public String sDateCalib  = "";  // Last Calibration Data (MM/DD/YYYY)
  public String sTimeOnBtm  = "";  // Time on Bottom
  public String sTimeOffBtm = "";  // Time off Bottom

  public String sTestRemark = "";  // Test Remarks

  // DST Company Information

  public String sCompany    = "Trilobite";  // DST Company
  public String sTestType   = "Conventional Bottom Hole";  // Test Type
  public String sTester     = "";  // Tester
  public String sUnitNo     = "";  // Unit Number

  // Hole Information

  public double diameter_hole   = 7.88; // Hole diameter
  public String sCondition_hole = "";  // Hole Condition

  // Pressure Summary Table Array

  public double dSummary[][] =
  {
  //  Time Pres Temp
	{ 0.0, 0.0, 0.0 }, // Initial Hydrostatic
	{ 0.0, 0.0, 0.0 }, // Open to Flow 1
	{ 0.0, 0.0, 0.0 }, // Shut-in 1
	{ 0.0, 0.0, 0.0 }, // End Shut-in 1
	{ 0.0, 0.0, 0.0 }, // Open to Flow 2
	{ 0.0, 0.0, 0.0 }, // Shut-in 2
	{ 0.0, 0.0, 0.0 }, // End Shut-in 2
	{ 0.0, 0.0, 0.0 }, // Final Hydrostatic
  };

  // Mud and Cushion Information

  public String sMudType        = "";  // Mud Type
  public double dMudWeight      = 0.0; // Mud Weight (lb/gal)
  public double dViscosity      = 0.0; // Viscosity  (sec/qt)
  public double dWaterLoss      = 0.0; // Water Loss (cubic inches)
  public double dOHM_M          = 0.0; // Resistivity (ohm-m)
  public double dSalinity       = 0.0; // Salinity (ppm)
  public double dFilterCake     = 0.0; // Filter Cake (inches)

  public String sCushionType    = "";  // Cushion Type
  public double dCushionLength  = 0.0; // Cushion Length (ft)
  public double dCushionVolume  = 0.0; // Cushion Volume (bbl)

  public String sGasCushionType = "";  // Gas Cushion Type
  public double dGasCushionPres = 0.0; // Gas Cushion Pressuer (psi)

  public double dOil_API        = 0.0; // Oil API (deg API)
  public double dWaterSalinity  = 0.0; // Water Salinity (ppm)

  // Recovery Table Array

  public int    iRecovery     = 0;     // Rows
  public int    jRecovery     = 3;     // Columns
  public String sRecovery[][] = null;  // Recovery

  public double dLength       = 0.0;   // Total Length
  public double dVolume       = 0.0;   // Total Volume
  public String sComments     = "";    // Recovery Comments

  // Gas Rates

  // -- Columns

  public static final int _FLOW_PERIOD  = 0;  // Flow Period
  public static final int _TIME_MIN     = 1;  // Elapsed Time (min)
  public static final int _CHOKE_IN     = 2;  // Choke (inches)
  public static final int _PRESSURE_GAS = 3;  // Pressure (psi)
  public static final int _GAS_RATE     = 4;  // Gas Rate (Mcf/day)

  public int    iGasRates     = 0;     // Rows
  public int    jGasRates     = 5;     // Columns

  public double dGasRates[][] = null;  // Gas Rates

//  public double dTemp         = 0.0;   // Formation Temperature
//  public double density       = 0.0;   // Formation density
//  public double dZ            = 0.0;   // Gas Deviation Factor ( Compressibility Factor )

  // Type of DST - Fluid or gas

  public static final int _FLUID_DST = 0;
  public static final int _GAS_DST   = 1;
  public static final int _TEMP_DST  = 2;

  public int    iDSTType       = _FLUID_DST;
  public int    iDSTTypeFlow   = _TEMP_DST;

  // Shut In Pressure Data
  // -- Column 1 - Time
  // -- Column 2 - Pressure
  // -- Column 3 - Temperature

  public int    iShut_In_1     = 0;
  public int    iShut_In_2     = 0;

  public double dShut_In_1[][] = null;  // Shut In 1 Data
  public double dShut_In_2[][] = null;  // Shut In 2 Data

  public int    iFlow_1        = 0;
  public int    iFlow_2        = 0;

  public double dFlow_1[][]    = null;  // Flow 1 Data
  public double dFlow_2[][]    = null;  // Flow 2 Data

  public int    iData          = 0;

  public double data[][]       = null;  // Time Pressure Temperature Data

  // Computed Values

  // -- Horner Plot Result Variables

  // .. Horner Plot Parameters

  // .... Titles

  public String sTitle1     = "";  // The First Line of the Title
  public String sTitle2     = "";  // The Second Line of the Title
  public String sTitle3     = "";  // The Third Line of the Title

  // .... X-Axis Values.

  public int    iXCycles    = 1;   // Number of Cycles
  public double dXMaximum   = 0.0; // Maximum X-Axis
  public double dXMinimum   = 0.0; // Minimum X-Axis
  public String sXAxis      = "";  // X-Axis Label.

  // .... Y-Axis Values.

  public double dYMaximum   = 0.0; // Maximum Y-Axis
  public double dYMinimum   = 0.0; // Minimum Y-Axis
  public double dYIncrement = 0.0; // Increment along the Y-Axis
  public String sYAxis      = "";  // Y-Axis Label.

  // .. Shut In 1 Time Pressure Variables

  public int    lpt1 = 0;   // Number of points excluded below (shut in 1)
  public int    upt1 = 0;   // Number of points excluded above (shut in 1)

  public double P1   = 0.0; // Intercept Pressure for Shut In 1
  public double m1   = 0.0; // Horner Plot Slope of Shut In 1

  // .. Shut In 2 Time Pressure Variables

  public int    lpt2 = 0;   // Number of points excluded below (shut in 2)
  public int    upt2 = 0;   // Number of points excluded above (shut in 2)

  public double P2   = 0.0; // Intercept Pressure for Shut In 2
  public double m2   = 0.0; // Horner Plot Slope of Shut In 2

  // .. Open Flow 1 Time Pressure Variables

  public int    lpt1f = 0;   // Number of points excluded below (shut in 1)
  public int    upt1f = 0;   // Number of points excluded above (shut in 1)

  public double P1f   = 0.0; // Intercept Pressure for Shut In 1
  public double m1f   = 0.0; // Horner Plot Slope of Shut In 1

  // .. Open Flow 2 Time Pressure Variables

  public int    lpt2f = 0;   // Number of points excluded below (shut in 2)
  public int    upt2f = 0;   // Number of points excluded above (shut in 2)

  public double P2f   = 0.0; // Intercept Pressure for Shut In 2
  public double m2f   = 0.0; // Horner Plot Slope of Shut In 2

  // -- Input for Computed Variables

  public double mu   = 0.0; // Fluid or Gas Viscosity   [cp]
  public double beta = 0.0; // Formation Volume Factor  [RB]/[STB]
  public double h    = 0.0; // Vertical thickness of continuous porosity [ft]

  public double Tf   = 0.0; // Flow Time
  public double phi  = 0.0; // Porosity
  public double c    = 0.0; // Compressibilty [vol]/[vol]/[psi]

  public double rw   = 0.0; // Well Bore Radius  [ft]
  public double re   = 0.0; // Effective Radius  [ft]

  // .. Gas Variables

  public double Z    = 0.0; // Gas Deviation Factor (compressibility factor)
  public double degF = 0.0; // Formation Temperature [deg F]
  public double G    = 0.0; // Specific Gravity of Gas

  // -- Computed Variables

  public double q    = 0.0; // Flow Rate [Barrels]/[Day] or [Mcf]/[Day]
  public double K    = 0.0; // Average Effective Permeability

  public double KHU  = 0.0; // Transmissibility
  public double KH   = 0.0; // Permeability Thickness

  public double DR   = 0.0; // Damage Ratio
  public double EDR  = 0.0; // Estimated Damage Ratio
  public double S    = 0.0; // Skin Factor
  public double PI   = 0.0; // Productivity Index (Prediction for stable flow rates)
  public double RI   = 0.0; // Radius of Investigation

  public double qs   = 0.0; // Settled Production Rate [Barrels]/[Day]
  public double qAOF = 0.0; // Absolute Open Flow [Mcf]/[Day]

  public double Pwfc = 0.0; // Flow Pressure corrected for turbulence [psi]
  public double dPt  = 0.0; // Pressure Drop due to Turbulence
  public double dPs  = 0.0; // Pressure Drop due to Skin Factor

  /** Method delete()
   * <p> This method will set the arrays to null in order to get Java to
   *     deallocate memory for the object.
   */

  public void delete()
  {
    // DST Data Identifiers

    sKEY       = null; // Unique KEY
    sID        = null;  // DST Report ID or Number

    // DST General Information

    sFormation = null;  // Formation

    // Pressure Readings

    serialNo    = null;  // Serial Number
    sReading    = null;  // Inside / Outside
    sDateStart  = null;  // Starting Date-Time (MM/DD/YYYY-HHMMSS
    sDateEnd    = null;  // Ending Date-Time (MM/DD/YYYY-HHMMSS

    sDateCalib  = null;  // Last Calibration Data (MM/DD/YYYY)
    sTimeOnBtm  = null;  // Time on Bottom
    sTimeOffBtm = null;  // Time off Bottom

    sTestRemark = null;  // Test Remarks

    // DST Company Information

    sCompany    = null;  // DST Company
    sTestType   = null;  // Test Type
    sTester     = null;  // Tester
    sUnitNo     = null;  // Unit Number

    // Hole Information

    sCondition_hole = null;  // Hole Condition

    // Pressure Summary Table Array

    dSummary   = null;

    // Mud and Cushion Information

    sMudType        = null;  // Mud Type
    sCushionType    = null;  // Cushion Type
    sGasCushionType = null;  // Gas Cushion Type

    // Recovery Table Array

    sRecovery  = null;
    sComments  = null;  // Recovery Comments

    // Gas Rates

    dGasRates  = null;  // Gas Rate Table

    // Shut In Pressure Data

    dShut_In_1 = null;  // Shut In 1 Data
    dShut_In_2 = null;  // Shut In 2 Data

    dFlow_1    = null;  // Flow 1 Data
    dFlow_2    = null;  // Flow 2 Data

    data       = null;  // Time Pressure Temperature Data

    sTitle1    = null;  // The First Line of the Title
    sTitle2    = null;  // The Second Line of the Title
    sTitle3    = null;  // The Third Line of the Title
    sXAxis     = null;  // X-Axis Label.
    sYAxis     = null;  // Y-Axis Label.
  }
}

