/*
 * @dstStandardTools.java Version 1.1 04/25/2012
 *
 * Copyright (c) 2012 Kansas Geological Survey
 * 1930 Constant Avenue, Lawrence, Kansas, 66047, U.S.A.
 * All Rights Reserved.
 */

package dst;

/** Class dstStandardTools
 *  <p> This Class holds the standard tool information to map the
 *      DST LAS File curves to standard names.
 */

public class dstStandardTools
{
  public static final int _T_TYPE  = 0;  // Type- Summary, Recovery, etc
  public static final int _T_ID    = 1;  // Period
  public static final int _T_TIME  = 2;  // Time
  public static final int _T_PRES  = 3;  // Pressure
  public static final int _T_TEMP  = 4;  // Temperature
  public static final int _T_RATE  = 5;  // Rate
  public static final int _T_CHOKE = 6;  // Choke
  public static final int _T_LEN   = 7;  // Length
  public static final int _T_VOL   = 8;  // Volume
  public static final int _T_DESC  = 9;  // Description

  public static final int TOTAL    = 10;  // Total

  public static final int _C_ID   = 0;
  public static final int _C_MNEM = 1;
  public static final int _C_NAME = 2;
  public static final int _C_UNIT = 3;
  public static final int _C_FORM = 4;

  public static final String DATA_TYPE[] =
  {
	"Summary",
	"Recovery",
	"Gas Rates",
	"Shut In 1",
	"Shut In 2",
	"Data"
  };

  public static final String PERIOD[] = { "1", "2" };

  public static final String CURVES[][] =
  {
    // ID     MNEMONIC    CURVE NAME      UNIT       FORMAT
    { "1100", "_T_TYPE",  "Type of Data", "",        "S"  },
    { "1200", "_T_ID",    "Period",       "",        "S"  },
    { "1300", "_T_TIME",  "Time",         "MIN",     "F"  },
    { "1400", "_T_PRES",  "Pressure",     "PSI",     "F"  },
    { "1500", "_T_TEMP",  "Temperature",  "DEG F",   "F"  },
    { "1600", "_T_RATE",  "Gas Rate",     "MCF/DAY", "F"  },
    { "1700", "_T_CHOKE", "Choke",        "IN",      "F"  },
    { "1800", "_T_LEN",   "Length",       "FT",      "F"  },
    { "1900", "_T_VOL",   "Volume",       "BBL",     "F"  },
    { "2000", "_T_DESC",  "Description",  "",        "S"  },
  };

  /** Method isCurve()
   * <p> This method will determine if the curve is part of the standard
   *     stratigraphic units curves from the LAS File.
   * @param  iColumn = The column number
   * @param  str     = the string being compared.
   * @return bValue  = true it is a valid curve, false it is not
   */

  public static boolean isCurve( int iColumn, String str )
  {
    boolean bValue = false;

    if (iColumn==1) str = new String( str.toUpperCase() );

    for (int i=0; i<TOTAL; i++)
    {
      if (str.equals(CURVES[i][iColumn]))
      {
        bValue = true;
      }
    }

    return (bValue);
  }

  /** Method getRow()
   * <p> This method will return the row number of the Stratigraphic Unit Curve
   * @param  iColumn = The column number
   * @param  str     = the string being compared.
   * @return iRow = row number
   */

  public static int getRow( int iColumn, String str )
  {
    int iRow = -1;

    if (iColumn==1) str = new String( str.toUpperCase() );

    for (int i=0; i<TOTAL; i++)
    {
      if (str.equals(CURVES[i][iColumn]))
      {
        iRow = i;
      }
    }

    return (iRow);
  }
}