/*
 * @cmnStruct.java Version 1.1 06/26/2006
 *
 * Copyright (c) 2006 Kansas Geological Survey
 * 1930 Constant Avenue, Lawrence, Kansas, 66047, U.S.A.
 * All Rights Reserved.
 */

package cmn;

import java.net.*;
import java.awt.*;
import java.applet.*;
import javax.swing.*;

//import kgs.kgsUserStruct;

/** CLASS cmnStruct
 *  <p> This Class holds the global gui data structure data.
 *      NOTE: This version is designed for the LASFileReader and will not work
 *            with other web apps.
 *  @version 1.1 06/26/2006
 *  @author  John R. Victorine
 *  @modified 07/12/2007 for LAS File Reader
 *  @modified 11/06/2018 Gagnon changed http://chasm to https://chasm
 */

public class cmnStruct
{
  // Kansas Geological Survey Home Web Addresses

  public static final String KGS      = "http://www.kgs.ku.edu";
//  public static final String ABYSS    = "https://chasm.kgs.ku.edu";
  public static final String CO2      = "http://www.kgs.ku.edu/PRS/Ozark/";
  public static final String STRAT    = "http://www.kgs.ku.edu/stratigraphic/";

//  public static final String ABYSS    = "http://abyss.kgs.ku.edu";

  /* ======================================================================= *
   * ------------ Web Applications XML Mnemonics & ICON IMAGES ------------- *
   * ======================================================================= */

  public static final String GEMINI = "http://www.kgs.ku.edu/software/gemini";
  public static final String DATA   = GEMINI + "/data";
  public static final String IMAGES = GEMINI + "/images";

  // DOE CO2 LAS 3.0 Files URL Path

  public static final String DOE_CO2      = "http://www.kgs.ku.edu/PRS/Ozark/";
  public static final String DOE_CO2_DATA = DOE_CO2 + "GXSection/data/";
  public static final String DOE_CO2_LAS3 = DOE_CO2 + "file_data/LAS3/";

  // .. Stratigraphic Units XML Files

  public static final String ISC_XML                = DATA + "/ISC.xml";
  public static final String KANSAS_XML             = DATA + "/kansas.xml";

  // .. Lithology Symbols & Thesaurus XML Files

  public static final String ROCK_LITHOLOGY_XML     = DATA + "/rock_lithology.xml";
  public static final String LITHOLOGY_XML          = DATA + "/lithology.xml";
  public static final String MINERALS_XML           = DATA + "/minerals.xml";
  public static final String TEXTURES_XML           = DATA + "/textures.xml";

  // .. Color Thesaurus XML Files

  public static final String COLORS_XML             = DATA + "/colors.xml";
  public static final String ROCK_COLOR_CATALOG_XML = DATA + "/rock_color_catalog.xml";
  public static final String SOIL_COLOR_CATALOG_XML = DATA + "/soil_color_catalog.xml";

  // .. Kansas Environment XML File

  public static final String KANSAS_ENV_XML         = DATA + "/kansas_env.xml";

  // .. Porosity Symbols & Thesaurus XML Files

  public static final String POROSITY_TYPES_XML     = DATA + "/porosity_types.xml";
  public static final String POROSITY_XML           = DATA + "/porosity.xml";

  // .. Fossil Symbols & Thesaurus XML Files

  public static final String FOSSILS_XML            = DATA + "/fossils.xml";
  public static final String FOSSILS_TH_XML         = DATA + "/fossils_th.xml";
  public static final String FOSSILS_BIO_XML        = DATA + "/fossils_bio.xml";
  public static final String KANSAS_BIO_XML         = DATA + "/kansas_bio.xml";

  // .. Sedimentary Structures Symbols & Thesaurus XML FIles

  public static final String SED_STRUCTURE_XML      = DATA + "/sed_structure.xml";
  public static final String SED_STRUCTURES_XML     = DATA + "/sed_structures.xml";

  // .. KGS LAS Standard Tools Thesaurus XML Files

  public static final String TOOLS_HIERARCHY_XML    = DATA + "/tools_hierarchy.xml";
  public static final String LAS_STANDARD_TOOLS_XML = DATA + "/las_standard_tools.xml";

  // .. Well Symbol Thesaurus XML Files

  public static final String WELL_SYMBOLS_XML       = DATA + "/WellSymbols.xml";

  /* ======================================================================= *
   * --------------------- Web Applications Mnemonics ---------------------- *
   * ======================================================================= */

  // BASE URL to the ABYSS PLSQL Stored procedure base path.

//  public static final String ABYSS_PLSQL = "http://abyss.kgs.ku.edu/pls/abyss/";

//  public static final String PLSQL       = "https://chasm.kgs.ku.edu/pls/abyss/";
//  public static final String PLSQL_USER  = "https://chasm.kgs.ku.edu/pls/abyss/iqstrat.";
  public static final String PLSQL       = "https://chasm.kgs.ku.edu/ords/";
  public static final String PLSQL_USER  = "https://chasm.kgs.ku.edu/ords/iqstrat.";

  // PROFILE URL Path

  public static final String PROFILE    = STRAT  + "PROFILE/";
  public static final String HELP       = PROFILE + "HELP/";
  public static final String DATA_ENTRY = HELP + "DATA_ENTRY/";

  public static final String XSECTION   = STRAT  + "CROSS_SECTION/";
  public static final String XHELP      = XSECTION + "HELP/";

  public static final String PC_TOPS    = HELP + "PC/tops/";
  public static final String PC_CORE    = HELP + "PC/core/";
  public static final String PC_GEO     = HELP + "PC/geo_reports/";

  public static final String TOPS       = HELP + "DATA_ENTRY/tops/";
  public static final String SEQ_STRAT  = HELP + "DATA_ENTRY/seq_strat/";

  // BASE DIRECTORY of IQSTRAT

  public static final String IQSTRAT_BASE = STRAT + "IQSTRAT/";

  // User Login

  public static final String  KGS_USER = PLSQL_USER + "iqstrat.iqstrat_users_pkg.getXML?";

  // Headers Information URL's

  public static final String  KGS_HEADERS_READ_LIST = PLSQL_USER + "user_headers_pkg.getXML?";
  public static final String  KGS_HEADERS_READ      = PLSQL_USER + "headers_pkg.getXML?";
  public static final String  KGS_HEADERS_WRITE     = PLSQL_USER + "headers_pkg.saveXML?";
  public static final String  KGS_WELL_HEADERS_READ = PLSQL_USER + "kgs_well_headers_pkg.getXML?";

  // User Headers Information URL's

  public static final String KGS_USER_HEADERS_DELETE = PLSQL_USER + "user_headers_pkg.delete_data?";

  // User Files Information URL's;

  public static final String KGS_USER_FILES_WRITE  = PLSQL_USER + "user_files_pkg.save_data?";
  public static final String KGS_USER_FILES_READ   = PLSQL_USER + "user_files_pkg.getXML?";

  // KGS Well Data URL's

  // Core Data XML - Input: API-Number of Well (sAPI)

  public static final String  KGS_CORE_DATA   = PLSQL_USER + "kgs_core_data_pkg.getXML?";

  // Core Image Data XML - Input: API-Number of Well (sAPI)

  public static final String  KGS_CORE_IMAGES = PLSQL_USER + "kgs_core_images_pkg.getXML?";

  // Display Core image from KGS Web page

  public static final String DISPLAY_CORE =  PLSQL_USER + "rock_catalog_image_pkg.build_web_page?iKID=";

  // KGS Brine Data

  public static final String BRINE_DEFINITON    = STRAT + "PROFILE/BrineDefinitions.html";
  public static final String KGS_BRINE          = PLSQL_USER + "brine_data_pkg.getXML?";
  public static final String KGS_BRINE_COUNTIES = PLSQL_USER + "brine_data_pkg.getCounties?";

  // KGS Measured Sections (Outcrops)

  public static final String KGS_OUTCROP_LOCATION = PLSQL_USER + "kgs_outcrop_loc_pkg.getXML?";
  public static final String KGS_OUTCROP_COUNTIES = PLSQL_USER + "kgs_outcrop_loc_pkg.getCounties?";
  public static final String KGS_OUTCROP_DATA     = PLSQL_USER + "kgs_outcrop_data_pkg.getXML?";

  // LAS Files XML - Input: API-Number of Well (sAPI)

  public static final String KGS_LAS_FILES = PLSQL_USER + "kgs_las_files_pkg.getXML?";

  // LAS File Curves XML - Input: API-Number of Well (sLASKID)

  public static final String KGS_LAS_FILE_CURVES = PLSQL_USER + "kgs_las_curves_pkg.getXML?";

  // DST & Perforations XML - Input: API-Number of Well (sAPI)

  public static final String KGS_DST_PERFS = PLSQL_USER + "kgs_perfs_dst_pkg.getXML?";

  // Regions XML - Input: API-Number of Well (sAPI)

  public static final String KGS_REGIONS = PLSQL_USER + "kgs_regions_pkg.getXML?";

  // KGS Stratigraphic Units

  public static final String KGS_STRAT_UNITS = PLSQL_USER + "ks_strat_pkg.getXML";

  // -- BY Well - Input: API-Number (sAPI) & KID (sKID)

  public static final String KGS_WELL_STRAT_UNITS = PLSQL_USER + "kgs_well_tops_pkg.getXML?";

  // Latitude & Longitude from TRS

  public static final String KGS_TRS2LL = PLSQL_USER + "TRS2LL_pkg.getXML?";

  /* ----------------------------------------------------------------------- *
   * ---------------------- KGS DST Stored Procedures ---------------------- *
   * ----------------------------------------------------------------------- *
   * DST_WELL_HEADERS_READ - Well Header Information                         *
   * DST_TEST_READ         - DST Test Data                                   *
   * DST_SEARCH_READ       - Search for DST Records by API-Number & Well KID *
   * GET_COUNTIES          - Get Counties with Trilobite DB Records in KGS   *
   * ----------------------------------------------------------------------- */

  public static final String DST_WELL_HEADERS_READ = PLSQL_USER + "dst_well_headers_pkg.getXML?";
  public static final String DST_TEST_READ         = PLSQL_USER + "dst_test_pkg.getXML?";

  public static final String DST_SEARCH_READ       = PLSQL_USER + "dst_search_pkg.getXML?";
  public static final String GET_COUNTIES          = PLSQL_USER + "dst_well_headers_pkg.getCounties";

  /* ======================================================================= *
   * ----------------------------- Mouse Icons ----------------------------- *
   * ======================================================================= */

  public static final String      MOUSE   = "/images/mouse.gif";

  /* ======================================================================= *
   * ----------------------------- TRACK Icons ----------------------------- *
   * ======================================================================= */

  public static final String      ALL_TRACKS   = "/images/all.png";
  public static final String      LAS_TRACKS   = "/images/las.png";
  public static final String      ROCK_TRACKS  = "/images/rock.png";
  public static final String      TOPS_TRACKS  = "/images/horizon.png";
  public static final String      Pf_TRACKS    = "/images/Pf.png";
  public static final String      GEO_TRACKS   = "/images/geo.png";

  /* ======================================================================= *
   * ------------------------------ EDIT Icons ----------------------------- *
   * ======================================================================= */

  public static final String      OPEN     = "/images/select.png";
  public static final String      NEW      = "/images/new.png";
  public static final String      MODIFY   = "/images/modify.png";
  public static final String      DELETE   = "/images/remove.png";
  public static final String      SAVE     = "/images/save.png";
  public static final String      CSV      = "/images/save_csv.png";
  public static final String      PDF      = "/images/save_pdf.png";
  public static final String      CLOSE    = "/images/close.png";

  /* ======================================================================= *
   * ---------------------------- KIMELEON Icons --------------------------- *
   * ======================================================================= */

  public static final String KAMELEON   = "/images/kameleon/kameleon.png";
  public static final String KUT        = "/images/kameleon/KUTh.png";
  public static final String PHI        = "/images/kameleon/phi.png";
  public static final String OHM        = "/images/kameleon/ohm.png";
  public static final String RU         = "/images/kameleon/RU.png";
  public static final String PD         = "/images/kameleon/PHIdiff.png";
  public static final String RN         = "/images/kameleon/RN.png";
  public static final String GR         = "/images/kameleon/GR.png";
  public static final String STRAT_ICON = "/images/kameleon/horizon.png";

  /* ======================================================================= *
   * ----------------------------- pFEFFER Icons --------------------------- *
   * ======================================================================= */

  public static final String      LAS_PLOT = "/images/depth.png";
  public static final String      PICKETT  = "/images/pickett.png";
  public static final String      PHI_2ND  = "/images/2ndporosity.png";
  public static final String      MOVABLE  = "/images/movable.png";
  public static final String      ZONATION = "/images/zonation.png";
  public static final String      BY_TOPS  = "/images/flow.png";

  public static final String      PHI_M    = "/images/phi_M.png";
  public static final String      PHI_Rt   = "/images/phi_Rt.png";

  /* ======================================================================= *
   * ------------------------- 2D/3D CROSS PLOT Icons ---------------------- *
   * ======================================================================= */

  public static final int    _XYPLOT    = 0;
  public static final int    _RHO_TMAA  = 1;
  public static final int    _MNPLOT    = 2;
  public static final int    _RHO_UMAA  = 3;
  public static final int    _RHO_NPHI  = 4;
  public static final int    _PHI_DIFF  = 5;
  public static final int    _TH_K      = 6;
  public static final int    _TH_U      = 7;
  public static final int    _SP_GR     = 8;

  public static final String XYPLOT    = "/images/XYPlot.png";
  public static final String RHO_TMAA  = "/images/Rhotmaa.png";
  public static final String MNPLOT    = "/images/MNPlot.png";
  public static final String RHO_UMAA  = "/images/RhoUmaa.png";
  public static final String RHO_NPHI  = "/images/RhoNPHI.png";
  public static final String PHI_DIFF  = "/images/PhiDiff.png";
  public static final String TH_K      = "/images/ThK.png";
  public static final String TH_U      = "/images/UK.png";
  public static final String SP_GR     = "/images/SpGR.png";

  /* ======================================================================= *
   * ---------------------------- KGS Logo Icon ---------------------------- *
   * ======================================================================= */

  public static final String      ICON   = "images/kgsSm.png";
  public static final String      ICON2  = "images/kgsSm2.png";

  /* ======================================================================= *
   * ----------------------------- Image Icons ----------------------------- *
   * ======================================================================= */

  public static final int    _KGS        = 0; // KGS Data
  public static final int    _PC         = 1; // PC Data

  public static final int    _LAS        = 2; // LAS File Data Entry & Viewer
  public static final int    _TOPS       = 3; // Horizons Data Entry & Viewer
  public static final int    _CORE       = 4; // Core Data Data Entry & Viewer
  public static final int    _ROCK       = 5; // Geologist Report Data & Viewer
  public static final int    _LAS3       = 6; // LAS 3.0 File Viewer
  public static final int    _Pf         = 7; // PfEFFER Data Viewer

  public static final String WEB_APP     = "/images/webapp.png";
  public static final String PF_APP      = "/images/webapp-pf.png";
  public static final String PROFILE_APP = "/images/webapp-profile.png";
  public static final String DST_APP     = "/images/webapp-dst.png";
  public static final String SS_APP      = "/images/webapp-ss.png";
  public static final String WEB_APP_2D  = "/images/webapp-2D.png";
  public static final String WEB_APP_3D  = "/images/webapp-3D.png";
  public static final String WEB_BRINE   = "/images/webapp-brine.png";
  public static final String WAVELET_APP = "/images/webapp-wave.png";

  public static final String KGS_DATA    = "/images/kgsSm2.png";
  public static final String PC_DATA     = "/images/PC.png";

  public static final String WELL_INFO   = "/images/WellInfo.png";
  public static final String DST_DATA    = "/images/dst-icon.png";
  public static final String DIGITIZER   = "/images/digitizer.png";

  public static final String WELL_DATA   = "/images/WellData.png";
  public static final String BRINE_DATA  = "/images/brine_plot.png";
  public static final String MEAS_DATA   = "/images/iqstrat.png";

  public static final String LAS_FILE    = "/images/las-file.png";
  public static final String HORIZONS    = "/images/tops.png";
  public static final String ROCK_DATA   = "/images/rock-data.png";
  public static final String ROCK_TEXT   = "/images/profile.png";

  public static final String LAS3_FILE   = "/images/iqstrat-complete.png";
  public static final String GEMINI_DATA = "/images/gemini.png";

  /* ======================================================================= *
   * ------------------------------ Constants ------------------------------ *
   * ======================================================================= */

  public static final int _NO    = 0;
  public static final int _YES   = 1;

  public static final int OFF    = 0;
  public static final int ON     = 1;

  public static final int ALL    = 0;
  public static final int SELECT = 1;
  public static final int NONE   = 2;

  public static final int CORE_BOX   = 0;
  public static final int CORE_SLAB  = 1;
  public static final int CORE_THIN  = 2;
  public static final int CORE_SEM   = 3;
  public static final int ROCK_IMAGE = 4;

  public static final String  CORE_IMAGES[] = { "IMAGE: CORE",
                                                "IMAGE: SLAB",
                                                "IMAGE: THIN SECTION",
                                                "IMAGE: SEM",
                                                "IMAGE: ROCK" };

  public static final int STIFF   = 0;
  public static final int COLLINS = 1;
  public static final int PIPER   = 2;

  /* ======================================================================= *
   * --------------------------- Global Variables -------------------------- *
   * ======================================================================= */

  public int           iServerUsed;     // Server that will be used.
  public boolean       bStandalone;     // Application is Stand alone
  public URL           urlDirCodeBase;  // Base URL of Applet.
  public AppletContext appletContext;   // Applet Context
  public String        sPath;           // Path to retrieve data from JAR File
  public String        sImagePath;      // Path to retrieve images from JAR File
  public String        sGEMINI;         // Path to the GEMINI Data Directory work space
  public ClassLoader   cl;
  public Image         pIcon  = null;
  public Image         pIcon2 = null;

//  public kgsUserStruct stUser;
}
