/*
 * @cmnString.java Version 1.0 11/24/2003
 *
 * Copyright (c) 2001 Kansas Geological Survey
 * 1930 Constant Avenue, Lawrence, Kansas, 66047, U.S.A.
 * All Rights Reserved.
 */

package cmn;

import java.text.*;
import java.util.*;
import java.lang.*;
import java.awt.*;
import javax.swing.*;

/** Class cmnString
 *  <p> This class is a general String class to convert Strings to numbers and
 *      some validations.
 *
 *  @version 1.0 11/24/2003
 *  @author  John R. Victorine
 */

public class cmnString
{
  /** Constructor cmnString()
   *  <p> This is the constructor for this class
   */

  public cmnString() { }

  /** Method stringToInt()
   *  <p> This method will convert a String to a int
   *  @param  sText  = The String to be converted to int
   *  @return iValue = The int value of the String.
   */

  public static int stringToInt(String sText)
  {
    int iValue = 0;
    Integer intValue;

    try
    {
      intValue = new Integer(sText);
      iValue = intValue.parseInt(sText);
    }
    catch (NumberFormatException nfe)
    {
      nfe.printStackTrace();
    }

    return (iValue);
  }

  /** Method stringToDouble()
   *  <p> This method will convert a String to a double
   *  @param  sText  = The String to be converted to double
   *  @return dValue = The double value of the String.
   */

  public static double stringToDouble(String sText)
  {
    double dValue = 0.0;
    Double doubleValue;

    try
    {
      doubleValue = new Double(sText);
      dValue       = doubleValue.parseDouble(sText);
    }
    catch (NumberFormatException nfe)
    {
      nfe.printStackTrace();
    }

    return (dValue);
  }

  /** Method isNumeric()
   *  <p> This method will determine if the string is Numeric
   *  Originally part of StringCheck written by
   *    Author  : Gagnon
   *    Org     : Kansas Geological Survey
   *    Date    : 05/08/2001
   *  @param  str          = The String to be check
   *  @return decimalpoint = The double value of the String.
   */

  public static boolean isNumeric(String str)
  {
    boolean decimalpoint = false;
    boolean retval       = true;
    char[] source        = str.toCharArray();

    if (source.length > 0)
    {
      for (int i=0; i<source.length; i++)
      {
        if (Character.isDigit(source[i]) == false)
        {
          // allow 1st element negative symbol
          if ((i == 0) && (source[i] == '-'))
          {
            retval = true;
          }
          else
          {
            // allow one decimal point
            if (source[i] == '.')
            {
              if (decimalpoint)
              {
                retval = false;
              }
              else
              {
                decimalpoint = true;
                if ( source.length == 1) retval = false;
              }
            }
            // For Scientific Notation
            else if (((source[i] == 'E') || (source[i] == 'e')) &&
                     (i<source.length-2))
            {
              if ((source[i+1] == '+') || (source[i+1] == '-') ||
                  (source[i+1] == '0') || (source[i+1] == '1') ||
                  (source[i+1] == '2') || (source[i+1] == '3') ||
                  (source[i+1] == '4') || (source[i+1] == '5') ||
                  (source[i+1] == '6') || (source[i+1] == '7') ||
                  (source[i+1] == '8') || (source[i+1] == '9'))
              {
                retval = true;
              }
            }
            // Not an allowed Numeric Character
            else
            {
              retval = false;
            }
          }
        }
      }
    }
    else
    {
      retval = false;
    }

    return (retval);
  }

  /** Method convertToAnd()
   * <p> This method will convert the "&" to " And ".
   * @param  sOld = The string to be converted
   * @return sNew = The text being converted
   */

  public static String convertToAnd(String sOld)
  {
    String sNew = new String("");
    char   c[];

    if (sOld != null)
    {
      c = sOld.toCharArray();

      for (int i=0; i<c.length; i++)
      {
        if (c[i]=='&')
        {
          sNew = new String(sNew + "aand");
        }
      }
    }

    return (sNew);
  }

  /** Method replaceSpecialCharsToCH()
   * <p> This method will convert certain character types to a ch999 format.
   *     '"' ch034
   *     '&' ch038
   *     '<' ch060
   *     '>' ch062
   *     '/' ch047
   * @param  sOld = The string to be converted
   * @return sNew = The text being converted
   */

  public static String replaceSpecialCharsToCH(String sOld)
  {
    String sNew = new String("");
    char   c[];

    if (sOld != null)
    {
      c = sOld.toCharArray();

      for (int i=0; i<c.length; i++)
      {
        if ( (Character.isUnicodeIdentifierPart(c[i])) ||
             (Character.isWhitespace(c[i])) ||
             ((Character.getType(c[i]) >= 20) &&
              (Character.getType(c[i]) <= 24)) )
        {
        if (c[i]=='&')
        {
          sNew = new String(sNew + "ch038");
        }
        else if (c[i]=='"')
        {
          sNew = new String(sNew + "ch034");
        }
        else if (c[i]=='<')
        {
          sNew = new String(sNew + "ch060");
        }
        else if (c[i]=='>')
        {
          sNew = new String(sNew + "ch062");
        }
        else if (c[i]=='/')
        {
          sNew = new String(sNew + "ch047");
        }
        else
        {
          sNew = new String(sNew + c[i]);
        }
        }
      }
    }

    return (sNew);
  }

  /** Method replaceCHToSpecialChars()
   * <p> This method will convert certain character types from a ch999 format.
   *     '"' ch034
   *     '&' ch038
   *     '<' ch060
   *     '>' ch062
   *     '/' ch047
   * @param  sOld = The string to be converted
   * @return sNew = The text being converted
   */

  public static String replaceCHToSpecialChars(String sOld)
  {
    String sNew = new String("");

    sNew = new String(sOld.replaceAll("ch034", "\""));
    sNew = new String(sOld.replaceAll("ch038", "&"));
    sNew = new String(sOld.replaceAll("ch060", "<"));
    sNew = new String(sOld.replaceAll("ch062", ">"));
    sNew = new String(sOld.replaceAll("ch047", "/"));

    return (sNew);
  }

  /** Method convertCharsToHTMLChars()
   * <p> This method will convert certain character types to HTML character
   *     types.  A XML or HTML Document will not accept certain characters
   *     such as "&" or """ so they have to be substituted by special strings
   *     substitutions.
   *     & = &amp;
   *     & = &quot;
   * @param  sOld = The string to be converted
   * @return sNew = The text being converted
   */

  public static String convertCharsToHTMLChars(String sOld)
  {
    String sNew = new String("");
    char   c[];

    if (sOld != null)
    {
      c = sOld.toCharArray();

      for (int i=0; i<c.length; i++)
      {
        if ( (Character.isUnicodeIdentifierPart(c[i])) ||
             (Character.isWhitespace(c[i])) ||
             ((Character.getType(c[i]) >= 20) &&
              (Character.getType(c[i]) <= 24)) )
        {
          if (c[i]=='&')
          {
            sNew = new String(sNew + "&amp;");
          }
          else if (c[i]=='"')
          {
            sNew = new String(sNew + "&quot;");
          }
          else if (c[i]=='<')
          {
            sNew = new String(sNew + "&lt;");
          }
          else if (c[i]=='>')
          {
            sNew = new String(sNew + "&gt;");
          }
          else if (c[i]=='/')
          {
            sNew = new String(sNew + "&#47;");
          }
          else if (c[i]=='#')
          {
            sNew = new String(sNew + "&#35;");
          }
          else
          {
            sNew = new String(sNew + c[i]);
          }
        }
      }
    }

    return (sNew);
  }

  /** Method convertCharsToDBHTMLChars()
   * <p> This method will convert certain character types to HTML character
   *     types.  A XML or HTML Document will not accept certain characters
   *     such as "&" or """ so they have to be substituted by special strings
   *     substitutions.
   *     & = &amp;
   *     & = &quot;
   * @param  sOld = The string to be converted
   * @return sNew = The text being converted
   */

  public static String convertCharsToDBHTMLChars(String sOld)
  {
    String sNew = new String("");
    char   c[];

    if (sOld != null)
    {
      c = sOld.toCharArray();

      for (int i=0; i<c.length; i++)
      {
        if ( (Character.isUnicodeIdentifierPart(c[i])) ||
             (Character.isWhitespace(c[i])) ||
             ((Character.getType(c[i]) >= 20) &&
              (Character.getType(c[i]) <= 24)) )
        {
          if (c[i]=='&')
          {
//            sNew = new String(sNew + "&amp;");
            sNew = new String(sNew + "aand");
          }
          else if (c[i]==' ')
          {
            sNew = new String(sNew + "%20");
          }
          else if (c[i]=='"')
          {
            sNew = new String(sNew + ".quot.");
          }
          else if (c[i]=='<')
          {
            sNew = new String(sNew + ".lt.");
          }
          else if (c[i]=='>')
          {
            sNew = new String(sNew + ".gt.");
          }
          else if (c[i]=='/')
          {
            sNew = new String(sNew + ".fsl.");
          }
          else if (c[i]=='#')
          {
            sNew = new String(sNew + ".no.");
          }
          else
          {
            sNew = new String(sNew + c[i]);
          }
        }
      }
    }

    return (sNew);
  }

  /** Method convertAMPandQUOTEToHTMLChars()
   * <p> This method will convert certain character types to HTML character
   *     types.  A XML or HTML Document will not accept certain characters
   *     such as "&" or """ so they have to be substituted by special strings
   *     substitutions.
   *     & = &amp;
   *     & = &quot;
   * @param  sOld = The string to be converted
   * @return sNew = The text being converted
   */

  public static String convertAMPandQUOTEToHTMLChars(String sOld)
  {
    String sNew = new String("");
    char   c[];

    if (sOld != null)
    {
      c = sOld.toCharArray();

      for (int i=0; i<c.length; i++)
      {
        if (c[i]=='&')
        {
          sNew = new String(sNew + "&amp;");
        }
        else if (c[i]=='"')
        {
          sNew = new String(sNew + "&quot;");
        }
        else
        {
          sNew = new String(sNew + c[i]);
        }
      }
    }

    return (sNew);
  }

  /** Method convertSingleQuoteToDB()
   * <p> This method will convert single quote character to two single quotes
   *     so the SQL will not break.
   * @param  sOld = The string to be converted
   * @return sNew = The text being converted
   */

  public static String convertSingleQuoteToDB(String sOld)
  {
    String sNew = new String("");
    char   c[];

    if (sOld != null)
    {
      c = sOld.toCharArray();

      for (int i=0; i<c.length; i++)
      {
        if (c[i]=='\'')
        {
          sNew = new String(sNew + "\'\'");
        }
        else
        {
          sNew = new String(sNew + c[i]);
        }
      }
    }

    return (sNew);
  }

  /** Method convertToValidFilenameChars()
   * <p> This method will convert a filename to a valid set of characters to
   *     ensure the filename is valid.
   * @param  sOld = The string to be converted
   * @return sNew = The text being converted
   */

  public static String convertToValidFilenameChars(String sOld)
  {
    String sNew = new String("");
    char   c[];

    if (sOld != null)
    {
      c = sOld.toCharArray();

      for (int i=0; i<c.length; i++)
      {
        if ((c[i] >= '0' && c[i] <= '9') ||
            (c[i] >= 'a' && c[i] <= 'z') ||
            (c[i] >= 'A' && c[i] <= 'Z') ||
            (c[i] == '_') || (c[i] == '.') || (c[i] == '-'))
        {
          sNew = new String(sNew + c[i]);
        }
        else
        {
          sNew = new String(sNew + "_");
        }
      }
    }

    return (sNew);
  }

  /** Method convertNewLineToHTML_BR()
   * <p> This method will convert a '\n' to <BR> String.
   * @param  sOld = The string to be converted
   * @return sNew = The text being converted
   */

  public static String convertNewLineToHTML_BR(String sOld)
  {
    String sNew = new String("");
    char   c[];

    if (sOld != null)
    {
      c = sOld.toCharArray();

      for (int i=0; i<c.length; i++)
      {
        int i1 = i+4;

        if ((c[i] == '\n') && (i1<c.length))
        {
          sNew = new String(sNew + "<BR>");
        }
        else
        {
          sNew = new String(sNew + c[i]);
        }
      }
    }

    return (sNew);
  }

  /** Method convertBlankTo_Chars()
   * <p> This method will convert the ' ' to '_'
   * @param  sOld = The string to be converted
   * @return sNew = The text being converted
   */

  public static String convertBlankTo_Chars(String sOld)
  {
    String sNew = new String("");
    char c[];

    if (sOld != null)
    {
      c = sOld.toCharArray();

      for (int i=0; i<c.length; i++)
      {
        if (c[i] == ' ')
        {
          sNew = new String(sNew + "%20");
        }
        else
        {
          sNew = new String(sNew + c[i]);
        }
      }
    }

    return (sNew);
  }

  /** Method convertHTMLSpace()
   * <p> This method will convert all %20 HTML Characters to a ' '.
   * @param  sOld   = The string to be converted
   * @return sNew = The text being converted
   */

  public static String convertHTMLSpace(String sOld)
  {
    String sNew = "";
//    char   c[];

    sNew = new String(sOld.replaceAll("%20", " "));
/*
    if (sOld != null)
    {
      c = sOld.toCharArray();

      for (int i=0; i<c.length; i++)
      {
        if (c[i] == '%')
        {
          if (c[i+1] == '2')
          {
            if (c[i+2] == '0')
            {
              sNew = new String(sNew + ' ');
              i++;
              i++;
            }
          }
        }
        else
        {
          sNew = new String(sNew + c[i]);
        }
      }
    }
*/
    return sNew;
  }

  /** Method convertCharsToHTMLChars()
   * <p> This method will convert certain character types to HTML character
   *     types.  A XML or HTML Document will not accept certain characters
   *     such as "&" or """ so they have to be substituted by special strings
   *     substitutions.
   *     & = &amp;
   *     & = &quot;
   * @param  sOld = The string to be converted
   * @return sNew = The text being converted
   */

  public static String convertCharsToSafeChars(String sOld)
  {
    String sNew = new String("");
    char   c[];

    if (sOld != null)
    {
      c = sOld.toCharArray();

      for (int i=0; i<c.length; i++)
      {
        if (c[i]=='&')
        {
          sNew = new String(sNew + "and");
        }
        else if (c[i]==' ')
        {
          sNew = new String(sNew + "%20");
        }
        else
        {
          sNew = new String(sNew + c[i]);
        }
      }
    }

    return (sNew);
  }

  /** Method UniqueName()
   *  <p> This method will create a Unique Name based on the date and time.
   *  @return sTime = A unique name based on the date and time,
   *                  i.e., YYMMDDhhmmssAM or YYMMDDhhmmssPM
   *                  where YY is the Year
   *                        MM is the Month Number
   *                        DD is the Day
   *                        hh is the Hour
   *                        mm is the Minute
   *                        ss is the Second
   *                        AM is the Morning
   *                        PM is the Evening
   */

  public static String UniqueName()
  {
    String sDirectory = new String("");

    StringTokenizer      stToken;
    String               sText;
    String               sMonth;
    String               sDay;
    String               sYear;
    String               sTime;
    String               sAMPM;
    String               sHour;
    String               sMinute;
    String               second;

    DateFormat newDate = DateFormat.getDateInstance(DateFormat.SHORT);
    DateFormat newTime = DateFormat.getTimeInstance(DateFormat.MEDIUM);

    sText     = newDate.format(new Date());
    stToken   = new StringTokenizer(sText, "/");

    sMonth    = stToken.nextToken();
    if (sMonth.length() < 2)
      sMonth  = new String("0"+sMonth);

    sDay      = stToken.nextToken();
    if (sDay.length() < 2)
      sDay    = new String("0"+sDay);

    sYear     = stToken.nextToken();
    if (sYear.length() < 2)
      sYear   = new String("0"+sYear);

    sText     = newTime.format(new Date());
    stToken   = new StringTokenizer(sText, " ");
    sTime     = stToken.nextToken();
    sAMPM     = stToken.nextToken();

    stToken   = new StringTokenizer(sTime, ":");

    sHour     = stToken.nextToken();
    if (sAMPM.equals("PM"))
    {
      int ihour = 12+stringToInt(sHour);
      sHour   = new String(""+ihour);
    }
    if (sHour.length() < 2)
      sHour   = new String("0"+sHour);

    sMinute   = stToken.nextToken();
    if (sMinute.length() < 2)
      sMinute = new String("0"+sMinute);

    second    = stToken.nextToken();
    if (second.length() < 2)
      second  = new String("0"+second);

    /*
     *  Build the Directory Name from the Data and Time
     *  FROM DATE:
     *    sYear   = Year Number  (YY) 2 Digits
     *    sMonth  = Month Number (MM) 2 Digits
     *    sDay    = Day Number   (DD) 2 Digits
     *  FROM TIME:
     *    sHour   = Hour         (hh) 2 Digits based on 0 to 24 hours
     *    sMinute = Minutes      (mm) 2 Digits
     *    second  = Seconds      (ss) 2 Digits
     *  i.e., 020921022423 - YYMMDDhhmmss or YYMMDDhhmmss
     */

    sDirectory = new String(
        sYear + sMonth + sDay + sHour + sMinute + second);

    return (sDirectory);
  }

  /** Method getDate()
   *  <p> This method will the date.
   *  @return sDate = the date
   */

  public static String getDate()
  {
    String sDate = new String("");

    DateFormat newDate = DateFormat.getDateInstance(DateFormat.MEDIUM);

    sDate     = newDate.format(new Date());

    return (sDate);
  }

  /** Method isAPILike()
   * <p> This method tests is the string an API format string
   *     tests for numbers and dashes xx-xxx-xxxxx-xxxx
   *     NOTE: This method was created by Glen Gagnon.
   * @param  str    = API Number String
   * @return retval = True or False
   */

  public static boolean isAPILike(String str)
  {
    boolean retval = true;
    char[] source = str.toCharArray();
    if (source.length > 0)
    {
      for (int i = 0; i < source.length; i++)
      {
        if (retval == true)
        {
          switch (i)
          {
            case 0:
            case 1:
              if (Character.isDigit(source[i]) == false)
              {
                retval = false;
              }
              break;
            case 2:
              {
                if (source[i] != '-')
                {
                  retval = false;
                }
                break;
              }
            case 3:
            case 4:
            case 5:
              {
                if (Character.isDigit(source[i]) == false)
                {
                  retval = false;
                }
                break;
              }
            case 6:
              {
                if (source[i] != '-')
                {
                  retval = false;
                }
                break;
              }
            case 7:
            case 8:
            case 9:
            case 10:
            case 11:
              {
                if (Character.isDigit(source[i]) == false)
                {
                  retval = false;
                }
                break;
              }
            case 12:
              {
                if (source[i] != '-')
                {
                  retval = false;
                }
                break;
              }
            case 13:
            case 14:
            case 15:
            case 16:
             {
                if (Character.isDigit(source[i]) == false)
                {
                  retval = false;
                }
                break;
              }
            default:
              {
                retval = false;
              }
           } // end switch
        }   // end if retval true
      }    // end for loop
    }     // end not blank
    else
    {
      retval = true;   // allow a blank API number
    }
    return (retval);
  }

  /** Method convertToAPI()
   *  <p> This method will convert a non KGS-API Like API-Number String to a
   *      KGS-API Like Number String.
   * @param  sAPI = The String to be converted.
   * @return sAPI = The converted API String
   */

  public static String convertToAPI(String sAPI)
  {
    String sTemp = new String("");
    int    iLength = 0;

    if ((!isAPILike(sAPI)) && (sAPI.length() > 5))
    {
      iLength = sAPI.length();
      sTemp = new String(sAPI.substring(0,2) + "-" +
                         sAPI.substring(2,5) + "-" +
                         sAPI.substring(5,iLength));
      sAPI = new String(sTemp);
    }

    if (sAPI.length() > 12)
      sAPI = new String( sAPI.substring(0, 12) );

    return (sAPI);
  }

  /** Method removeSpaces()
   * <p> This method will remove all spaces from a text field
   * @param  str  = original string field
   * @return sNew = new string field without spaces
   */

  public static String removeSpaces(String str)
  {
    StringTokenizer st   = new StringTokenizer(str, " ", false);
    String          sNew = "";
    while (st.hasMoreElements()) sNew += st.nextElement();
    return sNew;
  }

  /** Method padWithSpaces()
   * <p> This method will add spaces to fill a specific length
   * @param  str    = original string field
   * @param  iSpace = Number of Spaces
   * @return sNew   = new string field without spaces
   */

  public static String padWithSpaces(String str, int iSpace)
  {
    String sNew  = new String( str );
    String space = " ";
    int    len   = str.length();

    for (int i=0; i<iSpace-len; i++)
    {
      sNew = new String( sNew + space );
    }

    return sNew;
  }

  /** Method convertDate()
   * <p> This method will convert the date to a LAS 3 Standard date and time
   *     format of "D/M/YYYY hh:mm:ss".
   * @param  str  = the Date to be converted
   * @return sNew = the LAS 3 Valid date format
   */

  public static String[] convertDate( String str )
  {
    int i,j;
    String sNew[]              = { "", "D/M/YYY" };
    char c[]                   = null;
                               // --- Date ---   Time
                               // ' ', '-', '/', ':'
    int    ichar[]             = { 0, 0, 0, 0 };
    String sDelim[]            = { " ", "-", "/", ":" };
    StringTokenizer stToken    = null;
    String          sText      = "";
    String          sText1     = "";
    String          tokens[]   = null;
    String          tokens1[]  = null;
    String          spaceDelim = new String("[ ]+");
    String          slashDelim = new String("[/]+");
    String          colonDelim = new String("[:]+");
    int             iType      = -1; // -1 = unknown
                                     //  0 = Date & Time
                                     //  1 = Date Only
                                     //  2 = Time Only
    String          sTemp      = "";

    if (str != null)
    {
      str = new String( removeChar( str, ',' ) );

      if (str.length() > 0)
      {
        sNew[0] = new String( str );
        c       = sNew[0].toCharArray();

        for (i=0; i<c.length; i++)
        {
          if (c[i]==' ')
          {
            ichar[0]++;
          }
          else if (c[i]=='-')
          {
            ichar[1]++;
          }
          else if (c[i]=='/')
          {
            ichar[2]++;
          }
          else if (c[i]==':')
          {
            ichar[3]++;
          }
        }

        if (ichar[0] > 0)
        {
          sNew[0] = changetoSlash( sNew[0], ' ' );
          iType = 1;
        }
        else if (ichar[1] > 0)
        {
          sNew[0] = changetoSlash( sNew[0], '-' );
          iType = 1;
        }
        else if (ichar[2] > 0)
          iType = 1;

        if (ichar[3] > 0)
        {
          if (iType == -1)
            iType = 3;
          if (iType == 1)
            iType = 0;
        }

        sText   = new String( sNew[0].trim() );

        if (iType != 3)
        {
          tokens = sText.split( spaceDelim );

          for (i=0; i<tokens.length; i++)
          {
            if (i==0)
            {
              sText1  = new String( tokens[0] );
              tokens1 = sText1.split( slashDelim );
              if (tokens1.length > 2)
              {
                if ((!isNumeric(tokens1[0])) && (isNumeric(tokens1[1])))
                {
                  sTemp     = new String( tokens1[0] );
                  tokens1[0] = new String( tokens1[1] );
                  tokens1[1] = new String( sTemp );
                }
              }

              for (j=0; j<tokens1.length; j++)
              {
                if (j==0)
                {
                  if      (tokens1[0].length() == 1) sNew[1] = new String("D");
                  else if (tokens1[0].length() > 1)  sNew[1] = new String("DD");
                }

                if (j==1)
                {
                  if (tokens1[1].length() > 3)
                    sNew[1] = new String(sNew[1] + "/MMMM");
                  else if (tokens1[1].length() > 2)
                    sNew[1] = new String(sNew[1] + "/MMM");
                  else if (tokens1[1].length() > 1)
                    sNew[1] = new String(sNew[1] + "/MM");
                  else
                    sNew[1] = new String(sNew[1] + "/M");
                }

                if (tokens1.length >1)
                  sNew[0] = new String( tokens1[0] + "/" + tokens1[1] );

                if (j==2)
                {
                  if (tokens1[2].length() == 2)
                  {
                    tokens1[2] = new String( "19"+tokens1[2] );
                  }

                  sNew[1] = new String(sNew[1] + "/YYYY");
                }

                if (tokens1.length >2)
                  sNew[0] = new String( sNew[0] + "/" + tokens1[2] );
              }
            }
            else if (i == 1)
            {
              sText1  = new String( tokens[1] );
              tokens1 = sText1.split( colonDelim );

              if (tokens1.length > 2)
                sNew[1] = new String(sNew[1] + " hh:mm:ss");
              else if (tokens1.length > 1)
                sNew[1] = new String(sNew[1] + " hh:mm");
              else if (tokens1.length == 1)
                sNew[1] = new String(sNew[1] + " hh");

              if (tokens.length >1)
                sNew[0] = new String( sNew[0] + " " + tokens[1] );
            }
          }
        }
        else
        {
          tokens1 = sText.split( colonDelim );

          if (tokens1.length > 2)
            sNew[1] = new String(sNew[1] + " hh:mm:ss");
          else if (tokens1.length > 1)
            sNew[1] = new String(sNew[1] + " hh:mm");
          else if (tokens1.length == 1)
            sNew[1] = new String(sNew[1] + " hh");

          sNew[0] = new String( sText.trim() );
        }
      }
    }

    return (sNew);
  }

  /** Method changetoSlash()
   * <p> This method will remove a character from the String
   * @param  str  = The string to be converted
   * @param  ch   = the character to be removed from string
   * @return sNew = The text converted
   */

  public static String changetoSlash( String str, char ch )
  {
    String sNew = new String("");
    char   c[]  = null;

    if (str != null)
    {
      c = str.toCharArray();

      for (int i=0; i<c.length; i++)
      {
        if (c[i] != ch)
          sNew = new String(sNew + c[i]);
        else
          sNew = new String(sNew + '/');
      }
    }

    return (sNew);
  }

  /** Method removeChar()
   * <p> This method will remove a character from the String
   * @param  str  = The string to be converted
   * @param  ch   = the character to be removed from string
   * @return sNew = The text converted
   */

  public static String removeChar( String str, char ch )
  {
    String sNew = new String("");
    char   c[]  = null;

    if (str != null)
    {
      c = str.toCharArray();

      for (int i=0; i<c.length; i++)
      {
        if (c[i] != ch)
          sNew = new String(sNew + c[i]);
      }
    }

    return (sNew);
  }

  /** Method replaceChar()
   * <p> This method will replace a character with another character in the String
   * @param  str  = The string to be converted
   * @param  ch   = the character to be replace from string
   * @param  wch  = the character to replace ch
   * @return sNew = The text converted
   */

  public static String replaceChar( String str, char ch, char wch )
  {
    String sNew = new String("");
    char   c[]  = null;

    if (str != null)
    {
      c = str.toCharArray();

      for (int i=0; i<c.length; i++)
      {
        if (c[i] != ch)
          sNew = new String(sNew + c[i]);
        else
          sNew = new String(sNew + wch);
      }
    }

    return (sNew);
  }
}
