/*
 * @cmnLASToolsStruct.java Version 1.1 08/30/2004
 *
 * Copyright (c) 2004 Kansas Geological Survey
 * 1930 Constant Avenue, Lawrence, Kansas, 66047, U.S.A.
 * All Rights Reserved.
 */

package cmn;

/** Class cmnLASToolsStruct
 *  <p> This class will hold the Standard LAS Curve data.
 *
 *  @version 1.1 08/30/2004
 *  @author  John R. Victorine
 */

public class cmnLASToolsStruct
{
  public String sKEY       = "0";  // Primary Key for Standard Tool
  public String sMnemonic  = "";   // Standard Mnemonic for Tool
  public String sDesc      = "";   // Description of Standard Tool
  public String sUnit      = "";   // Standard Units used for plotting LAS
  public String sLogStand  = "";   // Standard Log Name
  public double dMinimum   = 0.0;  // Minimum Plot Value for this curve
  public double dMaximum   = 0.0;  // Maximum Plot Value for this curve
  public double dTrack     = 0.0;  // Suggested Track to plot Curve

  public int    iOther     = 0;    // Total Number of Other Mnemonics
  public String sOther[]   = null; // Array of Mnemonics that fit this curve type

  /** Method delete()
   * <p> This method will set the string variable to null and initialize all the
   *     other variables.
   */

  public void delete()
  {
    sKEY       = null;   // Primary Key for Standard Tool
    sMnemonic  = null;   // Standard Mnemonic for Tool
    sDesc      = null;   // Description of Standard Tool
    sUnit      = null;   // Standard Units used for plotting LAS
    sLogStand  = null;   // Standard Log Name
    dMinimum   = 0.0;    // Minimum Plot Value for this curve
    dMaximum   = 0.0;    // Maximum Plot Value for this curve
    dTrack     = 0.0;    // Suggested Track to plot Curve

    iOther     = 0;      // Total Number of Other Mnemonics
    sOther     = null;   // Array of Mnemonics that fit this curve type
  }
}
