/*
 * @cmnLASToolsListStruct.java Version 1.1 08/30/2004
 *
 * Copyright (c) 2004 Kansas Geological Survey
 * 1930 Constant Avenue, Lawrence, Kansas, 66047, U.S.A.
 * All Rights Reserved.
 */

package cmn;

import cmn.cmnLASToolsStruct;

/** Class cmnLASToolsListStruct
 *  <p> This class will hold the LAS Curve List data.
 *
 *  @version 1.1 08/30/2004
 *  @author  John R. Victorine
 */

public class cmnLASToolsListStruct
{
  public int               iCount;    // Total Number Curves in LAS File
  public cmnLASToolsStruct stItem[];  // Array of Standard LAS Data Structures.

  /** Method delete()
   * <p> This method will set the string variable to null and initialize all the
   *     other variables.
   */

  public void delete()
  {
    if (iCount > 0)
    {
      for (int i=0; i<iCount; i++)
      {
        if (stItem[i] != null)
          stItem[i].delete();
      }
    }

    iCount = 0;
    stItem = null;
  }
}
