/*
 * @cmnLASFileUtility.java Version 1.1 02/18/2011
 *
 * Copyright (c) 2011 Kansas Geological Survey
 * 1930 Constant Avenue, Lawrence, Kansas, 66047, U.S.A.
 * All Rights Reserved.
 */

package cmn;

import cmn.cmnLASFileListStruct;
import cmn.cmnLASFileStruct;

/** Class cmnLASFileUtility
 *  <p> This Class will provide basic utilities for
 *      the Common LAS File Data Structure
 *
 *  @version 1.1 02/18/2011
 *  @author  John R. Victorine
 */

public class cmnLASFileUtility
{
  /** Method copyList( las3ListStruct stOld )
   * <p> This method will copy one structure to another
   * @param  stOld = the Old List Structure
   * @return stNew = the New List structure
   */

  public static cmnLASFileListStruct copyList( cmnLASFileListStruct stOld )
  {
    cmnLASFileListStruct stNew = null;

    if (stOld != null)
    {
      if (stOld.iCount > 0)
      {
        stNew          = new cmnLASFileListStruct();
        stNew.iCount   = stOld.iCount;
        stNew.stItem   = new cmnLASFileStruct[stOld.iCount];

        for (int i=0; i<stOld.iCount; i++)
        {
          stNew.stItem[i] = copy(stOld.stItem[i]);
        }
      }
    }

    return (stNew);
  }

  /** Method transfer()
   * <p> This method will copy one structure to another
   * @param  stOld = the Old List Structure
   * @return stNew = the New List structure
   */

  public static cmnLASFileListStruct transfer(cmnLASFileListStruct stOld)
  {
    cmnLASFileListStruct stNew = null;

    if (stOld != null)
    {
	  stNew = copyList( stOld );

	  stOld.delete();
	  stOld = null;
	}

    return (stNew);
  }

  /** Method copy( cmnLASFileStruct stOld )
   * <p> This method will copy data from one structure to another
   * @param  stOld = The original Data Structure
   * @return stNew = The new Data Structure
   */

  public static cmnLASFileStruct copy( cmnLASFileStruct stOld )
  {
    cmnLASFileStruct stNew = new cmnLASFileStruct();

    if (stOld != null)
    {
      stNew.sKID       = new String( stOld.sKID );
      stNew.sWellKID   = new String( stOld.sWellKID );
      stNew.iType      = stOld.iType;
      stNew.sDirectory = new String( stOld.sDirectory );
      stNew.sFilename  = new String( stOld.sFilename );
      stNew.sVersion   = new String( stOld.sVersion );
      stNew.dNull      = stOld.dNull;
      stNew.depthStart = stOld.depthStart;
      stNew.depthEnd   = stOld.depthEnd;
      stNew.depthStep  = stOld.depthStep;
      stNew.iProprietary = stOld.iProprietary;

      if (stNew.iLog != null)
      {
	    stNew.iLog = new int[cmn.cmnLASFileStruct.TOTAL];
	    for (int i=0; i<stNew.iLog.length; i++)
	    {
		  if (i<cmn.cmnLASFileStruct.TOTAL)
            stNew.iLog[i] = stOld.iLog[i]; // Log Type
		}
      }
    }

    return (stNew);
  }

  /** Method print()
   * <p> This method will print the Common LAS Curve List Structure
   * @param st = the Common LAS Curve List Structure
   */

  public static void print( cmnLASFileListStruct st )
  {
    if (st != null)
    {
      for (int i=0; i<st.iCount; i++)
      {
        System.out.println(  st.stItem[i].iType      + " " +
                             st.stItem[i].sDirectory + " ." +
                             st.stItem[i].sFilename  + " : " +
                             st.stItem[i].sVersion   + " " +
                             st.stItem[i].dNull      + " " +
                             st.stItem[i].depthStart + " " +
                             st.stItem[i].depthEnd   + " " +
                             st.stItem[i].depthStep );
      }
    }
  }
}