/*
 * @cmnLASFileStruct.java Version 1.1 02/25/2004
 *
 * Copyright (c) 2004 Kansas Geological Survey
 * 1930 Constant Avenue, Lawrence, Kansas, 66047, U.S.A.
 * All Rights Reserved.
 */

package cmn;

/** Class cmnLASFileStruct
 *  <p> This class will hold the LAS Filename and location data.
 *
 *  @version 1.1 02/25/2004
 *  @author  John R. Victorine
 */

public class cmnLASFileStruct
{
  public static final int NONE        = -1;
  public static final int RESISTIVITY = 0;
  public static final int DENSITY     = 1;
  public static final int NEUTRON     = 2;
  public static final int SONIC       = 3;
  public static final int SP          = 4;
  public static final int GAMMA_RAY   = 5;
  public static final int CALIPER     = 6;
  public static final int PE          = 7;
  public static final int THORIUM     = 8;
  public static final int URANIUM     = 9;
  public static final int POTASSIUM   = 10;
  public static final int TOTAL       = 11;

  public String     sKID       = "0";  // LAS File KID Identifier
  public String     sWellKID   = "0";  // Well KID Identifier
  public int        iType      = 0;    // Type of LAS File Retrieval, FILE or URL
  public String     sDirectory = "";   // Directory Path to the LAS File
  public String     sFilename  = "";   // File name of LAS File
  public String     sVersion   = "";   // LAS Version Number
  public double     dNull      = 0.0;  // Null Value of Data
  public double     depthStart = 0.0;  // Start Depth of LAS Data
  public double     depthEnd   = 0.0;  // Ending Depth of LAS Data
  public double     depthStep  = 0.0;  // Depth Step of LAS DAta
  public int        iProprietary = 0;  // Proprietary Data Identfier
  public int        iLog[]     = null; // Log Type

  /** Method delete()
   * <p> This method will set the string variable to null and initialize all the
   *     other variables.
   */

  public void delete()
  {
    sKID       = null; // LAS File KID Identifier
    sWellKID   = null; // Well KID Identifier
    iType      = 0;    // Type of LAS File Retrieval, FILE or URL
    sDirectory = null; // Directory Path to the LAS File
    sFilename  = null; // File name of LAS File
    sVersion   = null; // LAS Version Number
    dNull      = 0.0;  // Null Value of Data
    depthStart = 0.0;  // Start Depth of LAS Data
    depthEnd   = 0.0;  // Ending Depth of LAS Data
    depthStep  = 0.0;  // Depth Step of LAS DAta
    iProprietary = 0;  // Proprietary Data Identfier
    iLog       = null; // Log Type
  }
}
