/*
 * @cmnLASCurveUtility.java Version 1.1 01/15/2010
 *
 * Copyright (c) 2010 Kansas Geological Survey
 * 1930 Constant Avenue, Lawrence, Kansas, 66047, U.S.A.
 * All Rights Reserved.
 */

package cmn;

import cmn.cmnLASCurveListStruct;
import cmn.cmnLASCurveStruct;

/** Class cmnLASCurveUtility
 *  <p> This Class will provide basic utilities for
 *      the Common LAS Curve Data Structure
 *
 *  @version 1.1 01/15/2010
 *  @author  John R. Victorine
 */

public class cmnLASCurveUtility
{
  /** Method copyList( las3ListStruct stOld )
   * <p> This method will copy one structure to another
   * @param  stOld = the Old List Structure
   * @return stNew = the New List structure
   */

  public static cmnLASCurveListStruct copyList( cmnLASCurveListStruct stOld )
  {
    cmnLASCurveListStruct stNew = null;

    if (stOld != null)
    {
      if (stOld.iCount > 0)
      {
        stNew          = new cmnLASCurveListStruct();
        stNew.iCount   = stOld.iCount;
        stNew.stItem   = new cmnLASCurveStruct[stOld.iCount];

        for (int i=0; i<stOld.iCount; i++)
        {
          stNew.stItem[i] = copy(stOld.stItem[i]);
        }
      }
    }

    return (stNew);
  }

  /** Method copy( cmnLASCurveStruct stOld )
   * <p> This method will copy data from one structure to another
   * @param  stOld = The original Data Structure
   * @return stNew = The new Data Structure
   */

  public static cmnLASCurveStruct copy( cmnLASCurveStruct stOld )
  {
    cmnLASCurveStruct stNew = new cmnLASCurveStruct();

    if (stOld != null)
    {
      // Primary KEY of LAS File
      stNew.sKID              = new String( stOld.sKID );
      // Primary KEY of Tool KID
      stNew.sToolKID          = new String( stOld.sToolKID );
      // Mnemonic Name of Curve
      stNew.sMnemonic         = new String( stOld.sMnemonic );
      // Curve Column Number in LAS File
      stNew.iCurveNumber      = stOld.iCurveNumber;
      // Curve Name
      stNew.sCurveName        = new String( stOld.sCurveName );
      // Curve Units
      stNew.sCurveUnits       = new String( stOld.sCurveUnits );
      // Description of the Curve
      stNew.sCurveDescription = new String( stOld.sCurveDescription );
      // Minimum Value of Curve
      stNew.dMinimumValue     = stOld.dMinimumValue;
      // Maximum Value of Curve
      stNew.dMaximumValue     = stOld.dMaximumValue;
      // Order of Curve (initial sorting)
      stNew.iOrder            = stOld.iOrder;
      // Track the Curve should reside
      stNew.iTrack            = stOld.iTrack;
      // Minimum Curve Tool Value
      stNew.dToolMinimumValue = stOld.dToolMinimumValue;
      // Maximum Curve Tool Value
      stNew.dToolMaximumValue = stOld.dToolMaximumValue;

      stNew.iAssoc            = stOld.iAssoc;    // Total Number of Associations
      stNew.sAssoc            = new String[stOld.iAssoc];
      for (int i=0; i<stOld.iAssoc; i++)
        stNew.sAssoc[i]       = stOld.sAssoc[i]; // Associations with Curve
    }

    return (stNew);
  }

  /** Method print()
   * <p> This method will print the Common LAS Curve List Structure
   * @param st = the Common LAS Curve List Structure
   */

  public static void print(cmnLASCurveListStruct st)
  {
    if (st != null)
    {
      for (int i=0; i<st.iCount; i++)
      {
        System.out.println(  st.stItem[i].sToolKID    + " " +
                             st.stItem[i].sMnemonic   + " ." +
                             st.stItem[i].sCurveUnits + " : " +
                             st.stItem[i].sCurveDescription );
      }
    }
  }
}